/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.track;

import com.tomitribe.snitch.asm.ClassVisitor;
import com.tomitribe.snitch.asm.Label;
import com.tomitribe.snitch.asm.MethodVisitor;
import com.tomitribe.snitch.asm.Opcodes;
import com.tomitribe.snitch.asm.Type;
import com.tomitribe.snitch.track.Tracker;
import com.tomitribe.snitch.util.AsmModifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Enhance {
    private static final boolean IS_WIN = System.getProperty("os.name").toLowerCase().contains("windows");

    private Enhance() {
    }

    public static void load(List<Type> invocationStack, MethodVisitor mv) {
        int slot = 0;
        for (Type type : invocationStack) {
            mv.visitVarInsn(type.getOpcode(21), slot);
            slot += Enhance.size(type);
        }
    }

    private static Object internalName(Type type) {
        if (Type.BYTE_TYPE.equals(type)) {
            return Opcodes.INTEGER;
        }
        if (Type.BOOLEAN_TYPE.equals(type)) {
            return Opcodes.INTEGER;
        }
        if (Type.CHAR_TYPE.equals(type)) {
            return Opcodes.INTEGER;
        }
        if (Type.SHORT_TYPE.equals(type)) {
            return Opcodes.INTEGER;
        }
        if (Type.INT_TYPE.equals(type)) {
            return Opcodes.INTEGER;
        }
        if (Type.LONG_TYPE.equals(type)) {
            return Opcodes.LONG;
        }
        if (Type.FLOAT_TYPE.equals(type)) {
            return Opcodes.FLOAT;
        }
        if (Type.DOUBLE_TYPE.equals(type)) {
            return Opcodes.DOUBLE;
        }
        return type.getInternalName();
    }

    public static int size(List<Type> types) {
        int size = 0;
        for (Type type : types) {
            size += Enhance.size(type);
        }
        return size;
    }

    public static int size(Type[] types) {
        int size = 0;
        for (Type type : types) {
            size += Enhance.size(type);
        }
        return size;
    }

    public static int size(Type type) {
        if (Type.VOID_TYPE.equals(type)) {
            return 0;
        }
        if (Type.LONG_TYPE.equals(type) || Type.DOUBLE_TYPE.equals(type)) {
            return 2;
        }
        return 1;
    }

    public static Object[] toInternalNames(List<Type> types) {
        ArrayList<Object> objects = new ArrayList<Object>(types.size());
        for (Type type : types) {
            if (Type.VOID_TYPE.equals(type)) continue;
            objects.add(Enhance.internalName(type));
        }
        return objects.toArray();
    }

    public static String target(String name) {
        return "track$" + name;
    }

    public static void enhance(ClassVisitor cw, String monitorName, String internalName, int version, int access, String name, String desc, String signature, String[] exceptions) {
        Enhance.enhance(cw, monitorName, internalName, version, access, name, desc, signature, exceptions, false);
    }

    public static void enhance(ClassVisitor cw, String monitorName, String internalName, int version, int access, String name, String desc, String signature, String[] exceptions, boolean track) {
        MethodVisitor mv = Enhance.visit(cw, monitorName, internalName, version, access, name, desc, signature, exceptions, track);
        mv.visitEnd();
    }

    public static MethodVisitor visit(ClassVisitor cw, String monitorName, String internalName, int version, int access, String name, String desc, String signature, String[] exceptions, boolean track) {
        if (AsmModifiers.isSynchronized(access)) {
            access -= 32;
        }
        MethodVisitor mv = cw.visitMethod(access, name, desc, signature, exceptions);
        mv.visitCode();
        VisitorMetaData vmd = new VisitorMetaData(monitorName, access, name, desc, track, mv, version, internalName);
        if (IS_WIN) {
            if (vmd.isVoid() && vmd.getArgumentTypes().length < 1) {
                return Enhance.getMethodVisitorVoid(vmd);
            }
            if (vmd.isStatic() && vmd.isVoid() && desc.contains("[B")) {
                System.out.println("static = " + name);
            }
            return Enhance.getMethodVisitor(vmd);
        }
        return Enhance.getMethodVisitor(vmd);
    }

    private static MethodVisitor getMethodVisitor(VisitorMetaData vmd) {
        List<String> exceptions = Arrays.asList("()V");
        MethodVisitor mv = vmd.getMv();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, null);
        Label l3 = new Label();
        if (!exceptions.contains(vmd.getDesc())) {
            mv.visitTryCatchBlock(l2, l3, l2, null);
        }
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "start", "()V", vmd.isInterface());
        }
        mv.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", vmd.isInterface());
        mv.visitVarInsn(55, vmd.getNanotimeVariable());
        mv.visitLabel(l0);
        Enhance.load(vmd.getInvocationStack(), mv);
        mv.visitMethodInsn(Enhance.invoke(vmd.getAccess()), vmd.getThisType().getInternalName(), Enhance.target(vmd.getName()), vmd.getDesc(), vmd.isInterface());
        if (!vmd.isVoid()) {
            mv.visitVarInsn(vmd.getReturnType().getOpcode(54), vmd.getReturnVariable());
        }
        mv.visitLabel(l1);
        Label l4 = null;
        mv.visitLdcInsn(vmd.getMonitorName());
        mv.visitVarInsn(22, vmd.getNanotimeVariable());
        mv.visitMethodInsn(184, Enhance.tracker(), "track", "(Ljava/lang/String;J)V", vmd.isInterface());
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "stop", "()V", vmd.isInterface());
        }
        if (vmd.isVoid()) {
            l4 = new Label();
            mv.visitJumpInsn(167, l4);
        } else {
            mv.visitVarInsn(vmd.getReturnType().getOpcode(21), vmd.getReturnVariable());
            mv.visitInsn(vmd.getReturnType().getOpcode(172));
        }
        mv.visitLabel(l2);
        if (vmd.isEnableFrames()) {
            ArrayList<Type> newLocals = new ArrayList<Type>(vmd.getLocals());
            newLocals.remove(newLocals.size() - 1);
            newLocals.remove(newLocals.size() - 1);
            Object[] objects = Enhance.toInternalNames(newLocals);
            mv.visitFrame(0, objects.length, objects, 1, new Object[]{"java/lang/Throwable"});
        }
        mv.visitVarInsn(58, vmd.getThrowableVariable());
        mv.visitLabel(l3);
        mv.visitLdcInsn(vmd.getMonitorName());
        mv.visitVarInsn(22, vmd.getNanotimeVariable());
        mv.visitMethodInsn(184, Enhance.tracker(), "track", "(Ljava/lang/String;J)V", vmd.isInterface());
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "stop", "()V", vmd.isInterface());
        }
        mv.visitVarInsn(25, vmd.getThrowableVariable());
        mv.visitInsn(191);
        if (vmd.isVoid()) {
            mv.visitLabel(l4);
            if (vmd.isEnableFrames()) {
                mv.visitFrame(3, 0, null, 0, null);
            }
            mv.visitInsn(177);
        }
        mv.visitMaxs(-1, -1);
        return mv;
    }

    private static MethodVisitor getMethodVisitorB(VisitorMetaData vmd) {
        MethodVisitor mv = vmd.getMv();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, null);
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "start", "()V", vmd.isInterface());
        }
        mv.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", vmd.isInterface());
        mv.visitVarInsn(55, vmd.getNanotimeVariable());
        mv.visitLabel(l0);
        Enhance.load(vmd.getInvocationStack(), mv);
        mv.visitMethodInsn(Enhance.invoke(vmd.getAccess()), vmd.getThisType().getInternalName(), Enhance.target(vmd.getName()), vmd.getDesc(), vmd.isInterface());
        if (!vmd.isVoid()) {
            mv.visitVarInsn(vmd.getReturnType().getOpcode(54), vmd.getReturnVariable());
        }
        mv.visitLabel(l1);
        Label l4 = null;
        mv.visitLdcInsn(vmd.getMonitorName());
        mv.visitVarInsn(22, vmd.getNanotimeVariable());
        mv.visitMethodInsn(184, Enhance.tracker(), "track", "(Ljava/lang/String;J)V", vmd.isInterface());
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "stop", "()V", vmd.isInterface());
        }
        if (vmd.isVoid()) {
            l4 = new Label();
            mv.visitJumpInsn(167, l4);
        } else {
            mv.visitVarInsn(vmd.getReturnType().getOpcode(21), vmd.getReturnVariable());
            mv.visitInsn(vmd.getReturnType().getOpcode(172));
        }
        mv.visitLabel(l2);
        if (vmd.isEnableFrames()) {
            ArrayList<Type> newLocals = new ArrayList<Type>(vmd.getLocals());
            newLocals.remove(newLocals.size() - 1);
            newLocals.remove(newLocals.size() - 1);
            Object[] objects = Enhance.toInternalNames(newLocals);
            mv.visitFrame(0, objects.length, objects, 1, new Object[]{"java/lang/Throwable"});
        }
        mv.visitVarInsn(58, vmd.getThrowableVariable());
        mv.visitLdcInsn(vmd.getMonitorName());
        mv.visitVarInsn(22, vmd.getNanotimeVariable());
        mv.visitMethodInsn(184, Enhance.tracker(), "track", "(Ljava/lang/String;J)V", vmd.isInterface());
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "stop", "()V", vmd.isInterface());
        }
        mv.visitVarInsn(25, vmd.getThrowableVariable());
        mv.visitInsn(191);
        if (vmd.isVoid()) {
            mv.visitLabel(l4);
            if (vmd.isEnableFrames()) {
                mv.visitFrame(3, 0, null, 0, null);
            }
            mv.visitInsn(177);
        }
        mv.visitMaxs(-1, -1);
        return mv;
    }

    private static MethodVisitor getMethodVisitorVoid(VisitorMetaData vmd) {
        MethodVisitor mv = vmd.getMv();
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, null);
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "start", "()V", vmd.isInterface());
        }
        mv.visitMethodInsn(184, "java/lang/System", "nanoTime", "()J", vmd.isInterface());
        mv.visitVarInsn(55, vmd.getNanotimeVariable());
        mv.visitLabel(l0);
        Enhance.load(vmd.getInvocationStack(), mv);
        mv.visitMethodInsn(Enhance.invoke(vmd.getAccess()), vmd.getThisType().getInternalName(), Enhance.target(vmd.getName()), vmd.getDesc(), vmd.isInterface());
        mv.visitLabel(l1);
        mv.visitLdcInsn(vmd.getMonitorName());
        mv.visitVarInsn(22, vmd.getNanotimeVariable());
        mv.visitMethodInsn(184, Enhance.tracker(), "track", "(Ljava/lang/String;J)V", vmd.isInterface());
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "stop", "()V", vmd.isInterface());
        }
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        if (vmd.isEnableFrames()) {
            ArrayList<Type> newLocals = new ArrayList<Type>(vmd.getLocals());
            newLocals.remove(newLocals.size() - 1);
            newLocals.remove(newLocals.size() - 1);
            Object[] objects = Enhance.toInternalNames(newLocals);
            mv.visitFrame(0, objects.length, objects, 1, new Object[]{"java/lang/Throwable"});
        }
        mv.visitVarInsn(58, vmd.getThrowableVariable());
        mv.visitLdcInsn(vmd.getMonitorName());
        mv.visitVarInsn(22, vmd.getNanotimeVariable());
        mv.visitMethodInsn(184, Enhance.tracker(), "track", "(Ljava/lang/String;J)V", vmd.isInterface());
        if (vmd.isTrack()) {
            mv.visitMethodInsn(184, Enhance.tracker(), "stop", "()V", vmd.isInterface());
        }
        mv.visitVarInsn(25, vmd.getThrowableVariable());
        mv.visitInsn(191);
        mv.visitLabel(l3);
        if (vmd.isEnableFrames()) {
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        return mv;
    }

    private static String tracker() {
        return Type.getType(Tracker.class).getInternalName();
    }

    private static boolean isJava6orHigher(int version) {
        return version >= 50;
    }

    private static int invoke(int access) {
        if (AsmModifiers.isStatic(access)) {
            return 184;
        }
        if (AsmModifiers.isPrivate(access)) {
            return 183;
        }
        return 182;
    }

    private static class VisitorMetaData {
        private final String monitorName;
        private final int access;
        private final String name;
        private final String desc;
        private final boolean track;
        private final boolean enableFrames;
        private final MethodVisitor mv;
        private final Type thisType;
        private final Type returnType;
        private final List<Type> locals;
        private final List<Type> invocationStack;
        private final boolean isInterface;
        private final boolean isVoid;
        private final int nanotimeVariable;
        private final int returnVariable;
        private final int throwableVariable;
        private final int variablesSize;
        private final Type throwableType;
        private final Type[] argumentTypes;
        private final boolean isStatic;

        private VisitorMetaData(String monitorName, int access, String name, String desc, boolean track, MethodVisitor mv, int version, String internalName) {
            this.monitorName = monitorName;
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.track = track;
            this.mv = mv;
            this.returnType = Type.getReturnType(desc);
            this.isVoid = Type.VOID_TYPE.equals(this.returnType);
            this.argumentTypes = Type.getArgumentTypes(desc);
            this.enableFrames = Enhance.isJava6orHigher(version);
            this.thisType = Type.getObjectType(internalName);
            this.throwableType = Type.getType(Throwable.class);
            this.locals = new ArrayList<Type>();
            this.invocationStack = new ArrayList<Type>();
            this.isStatic = 184 == Enhance.invoke(this.access);
            this.isInterface = AsmModifiers.isInterface(access);
            if (!this.isStatic) {
                this.locals.add(this.thisType);
            }
            this.locals.addAll(Arrays.asList(this.argumentTypes));
            this.invocationStack.addAll(this.locals);
            this.nanotimeVariable = Enhance.size(this.locals);
            this.locals.add(Type.LONG_TYPE);
            this.returnVariable = Enhance.size(this.locals);
            this.locals.add(this.returnType);
            this.throwableVariable = Enhance.size(this.locals);
            this.locals.add(this.throwableType);
            this.variablesSize = Enhance.size(this.locals);
        }

        public String getMonitorName() {
            return this.monitorName;
        }

        public int getAccess() {
            return this.access;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean isTrack() {
            return this.track;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public int getVariablesSize() {
            return this.variablesSize;
        }

        public Type getThrowableType() {
            return this.throwableType;
        }

        public Type[] getArgumentTypes() {
            return this.argumentTypes;
        }

        public boolean isEnableFrames() {
            return this.enableFrames;
        }

        public MethodVisitor getMv() {
            return this.mv;
        }

        public Type getThisType() {
            return this.thisType;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public List<Type> getLocals() {
            return this.locals;
        }

        public List<Type> getInvocationStack() {
            return this.invocationStack;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean isVoid() {
            return this.isVoid;
        }

        public int getNanotimeVariable() {
            return this.nanotimeVariable;
        }

        public int getReturnVariable() {
            return this.returnVariable;
        }

        public int getThrowableVariable() {
            return this.throwableVariable;
        }

        public String toString() {
            return "VisitorMetaData{access=" + this.access + ", name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + ", thisType=" + this.thisType + ", returnType=" + this.returnType + ", isInterface=" + this.isInterface + ", isVoid=" + this.isVoid + ", returnVariable=" + this.returnVariable + ", argumentTypes=" + Arrays.toString(this.argumentTypes) + ", isStatic=" + this.isStatic + '}';
        }
    }
}

