/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.track;

import com.tomitribe.snitch.util.Join;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Tracker {
    private static final Logger log = Logger.getLogger(Tracker.class.getName());
    private final Map<String, Operation> stats = new LinkedHashMap<String, Operation>();
    private static final ThreadLocal<Tracker> TRACKER_THREAD_LOCAL = new ThreadLocal();

    public static void start() {
        TRACKER_THREAD_LOCAL.set(new Tracker());
    }

    public static void stop() {
        Tracker.end();
    }

    public static Tracker end() {
        Tracker tracker = TRACKER_THREAD_LOCAL.get();
        if (tracker != null) {
            TRACKER_THREAD_LOCAL.remove();
            tracker.report();
        }
        return tracker;
    }

    public static Tracker peek() {
        return TRACKER_THREAD_LOCAL.get();
    }

    public static void track(String name, long start) {
        Tracker tracker = TRACKER_THREAD_LOCAL.get();
        if (tracker == null) {
            return;
        }
        tracker.operation(name).time(start);
    }

    public Collection<Operation> operations() {
        return this.stats.values();
    }

    public Operation operation(String name) {
        Operation operation = this.stats.get(name);
        if (operation != null) {
            return operation;
        }
        operation = new Operation(name);
        this.stats.put(name, operation);
        return operation;
    }

    private void report() {
        if (this.stats.size() > 0) {
            log.info("TRACK: " + Join.join(" - ", this.stats.values()));
        }
    }

    public final class Operation {
        private final String name;
        private long count;
        private long time;

        private Operation(String name) {
            this.name = name;
        }

        public void time(long start) {
            ++this.count;
            this.time += System.nanoTime() - start;
        }

        public String getName() {
            return this.name;
        }

        public long getCount() {
            return this.count;
        }

        public long getTime() {
            return this.time;
        }

        public String toString() {
            return this.name + "{count=" + this.count + ", time=" + this.time + '}';
        }
    }
}

