/*
 * Decompiled with CFR 0.152.
 */
package com.tomitribe.snitch.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class IO {
    private IO() {
    }

    public static Properties readProperties(URL resource) throws IOException {
        return IO.readProperties(resource, new Properties());
    }

    public static Properties readProperties(URL resource, Properties properties) throws IOException {
        return IO.readProperties(IO.read(resource), properties);
    }

    public static Properties readProperties(File resource) throws IOException {
        return IO.readProperties(resource, new Properties());
    }

    public static Properties readProperties(File resource, Properties properties) throws IOException {
        return IO.readProperties(IO.read(resource), properties);
    }

    public static Properties readProperties(InputStream in, Properties properties) throws IOException {
        if (in == null) {
            throw new NullPointerException("InputStream is null");
        }
        if (properties == null) {
            throw new NullPointerException("Properties is null");
        }
        try {
            properties.load(in);
        }
        finally {
            IO.close(in);
        }
        return properties;
    }

    public static void writeProperties(Properties properties, File dest) throws IOException {
        if (properties == null) {
            throw new NullPointerException("Properties is null");
        }
        OutputStream outputStream = IO.write(dest);
        try {
            properties.store(outputStream, "");
        }
        finally {
            IO.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String string = reader.readLine();
            return string;
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) throws IOException {
        FileReader in = new FileReader(file);
        try {
            BufferedReader reader = new BufferedReader(in);
            String string = reader.readLine();
            return string;
        }
        finally {
            IO.close(in);
        }
    }

    public static byte[] readBytes(File file) throws IOException {
        InputStream in = IO.read(file);
        try {
            byte[] byArray = IO.readBytes(in);
            return byArray;
        }
        finally {
            IO.close(in);
        }
    }

    public static byte[] readBytes(URL url) throws IOException {
        InputStream in = IO.read(url);
        try {
            byte[] byArray = IO.readBytes(in);
            return byArray;
        }
        finally {
            IO.close(in);
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static String slurp(File file) throws IOException {
        return IO.slurp(IO.read(file));
    }

    public static String slurp(URL url) throws IOException {
        return IO.slurp(url.openStream());
    }

    public static String slurp(InputStream in) throws IOException {
        return new String(IO.readBytes(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string) throws IOException {
        FileWriter out = new FileWriter(file);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(out);
            try {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            finally {
                IO.close(bufferedWriter);
            }
        }
        finally {
            IO.close(out);
        }
    }

    public static void copy(File from, File to) throws IOException {
        if (!from.isDirectory()) {
            FileOutputStream fos = new FileOutputStream(to);
            try {
                IO.copy(from, (OutputStream)fos);
            }
            finally {
                IO.close(fos);
            }
        } else {
            IO.copyDirectory(from, to);
        }
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        File[] srcFiles;
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcDir.exists()) {
            throw new FileNotFoundException("Source '" + srcDir + "' does not exist");
        }
        if (!srcDir.isDirectory()) {
            throw new IOException("Source '" + srcDir + "' exists but is not a directory");
        }
        if (srcDir.getCanonicalPath().equals(destDir.getCanonicalPath())) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are the same");
        }
        ArrayList<String> exclusionList = null;
        if (destDir.getCanonicalPath().startsWith(srcDir.getCanonicalPath()) && (srcFiles = srcDir.listFiles()) != null && srcFiles.length > 0) {
            exclusionList = new ArrayList<String>(srcFiles.length);
            for (File srcFile : srcFiles) {
                File copiedFile = new File(destDir, srcFile.getName());
                exclusionList.add(copiedFile.getCanonicalPath());
            }
        }
        IO.doCopyDirectory(srcDir, destDir, exclusionList);
    }

    private static void doCopyDirectory(File srcDir, File destDir, List<String> exclusionList) throws IOException {
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File file : files) {
            File copiedFile = new File(destDir, file.getName());
            if (exclusionList != null && exclusionList.contains(file.getCanonicalPath())) continue;
            if (file.isDirectory()) {
                IO.doCopyDirectory(file, copiedFile, exclusionList);
                continue;
            }
            IO.copy(file, copiedFile);
        }
    }

    public static void copy(File from, OutputStream to) throws IOException {
        InputStream read = IO.read(from);
        try {
            IO.copy(read, to);
        }
        finally {
            IO.close(read);
        }
    }

    public static void copy(URL from, OutputStream to) throws IOException {
        InputStream read = IO.read(from);
        try {
            IO.copy(read, to);
        }
        finally {
            IO.close(read);
        }
    }

    public static void copy(InputStream from, File to) throws IOException {
        OutputStream write = IO.write(to);
        try {
            IO.copy(from, write);
        }
        finally {
            IO.close(write);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream from, File to, boolean append) throws IOException {
        OutputStream write = IO.write(to, append);
        try {
            IO.copy(from, write);
        }
        finally {
            IO.close(write);
        }
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        while ((length = from.read(buffer)) != -1) {
            to.write(buffer, 0, length);
        }
        to.flush();
    }

    public static void copy(byte[] from, File to) throws IOException {
        IO.copy((InputStream)new ByteArrayInputStream(from), to);
    }

    public static void copy(byte[] from, OutputStream to) throws IOException {
        IO.copy((InputStream)new ByteArrayInputStream(from), to);
    }

    public static ZipOutputStream zip(File file) throws IOException {
        OutputStream write = IO.write(file);
        return new ZipOutputStream(write);
    }

    public static ZipInputStream unzip(File file) throws IOException {
        InputStream read = IO.read(file);
        return new ZipInputStream(read);
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            if (Flushable.class.isInstance(closeable)) {
                ((Flushable)((Object)closeable)).flush();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (!file.delete()) {
            Logger.getLogger(IO.class.getName()).log(Level.WARNING, "Delete failed on: " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static OutputStream write(File destination) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(destination), 32768);
    }

    public static OutputStream write(File destination, boolean append) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(destination, append), 32768);
    }

    public static PrintStream print(File destination, boolean append) throws FileNotFoundException {
        return IO.print(IO.write(destination, append));
    }

    public static PrintStream print(File destination) throws FileNotFoundException {
        return IO.print(IO.write(destination));
    }

    public static PrintStream print(OutputStream out) {
        return new PrintStream(out);
    }

    public static InputStream read(File source) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(source), 32768);
    }

    public static InputStream read(String content) {
        return IO.read(content.getBytes());
    }

    public static InputStream read(String content, String encoding) throws UnsupportedEncodingException {
        return IO.read(content.getBytes(encoding));
    }

    public static InputStream read(byte[] content) {
        return new ByteArrayInputStream(content);
    }

    public static InputStream read(URL url) throws IOException {
        return url.openStream();
    }

    public static Iterable<String> readLines(File file) throws FileNotFoundException {
        return IO.readLines(IO.read(file));
    }

    public static Iterable<String> readLines(InputStream inputStream) {
        return IO.readLines(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public static Iterable<String> readLines(BufferedReader reader) {
        return new BufferedReaderIterable(reader);
    }

    private static class BufferedReaderIterable
    implements Iterable<String> {
        private final BufferedReader reader;

        private BufferedReaderIterable(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public Iterator<String> iterator() {
            return new BufferedReaderIterator();
        }

        private class BufferedReaderIterator
        implements Iterator<String> {
            private String line;

            private BufferedReaderIterator() {
            }

            @Override
            public boolean hasNext() {
                try {
                    boolean hasNext;
                    this.line = BufferedReaderIterable.this.reader.readLine();
                    boolean bl = hasNext = this.line != null;
                    if (!hasNext) {
                        IO.close(BufferedReaderIterable.this.reader);
                    }
                    return hasNext;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public String next() {
                return this.line;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        }
    }
}

