/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.arthur;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geronimo.arthur.spi.ArthurExtension;
import org.apache.geronimo.arthur.spi.model.ClassReflectionModel;
import org.apache.geronimo.arthur.spi.model.DynamicProxyModel;
import org.apache.geronimo.arthur.spi.model.ResourceBundleModel;
import org.apache.geronimo.arthur.spi.model.ResourceModel;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.Editor;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.api.table.Table;
import org.tomitribe.crest.api.validation.Validation;
import org.tomitribe.crest.cmds.processors.Help;
import org.tomitribe.crest.table.Border;
import org.tomitribe.crest.table.TableInterceptor;

public class CrestExtension
implements ArthurExtension {
    public void execute(ArthurExtension.Context context) {
        boolean alreadyScanned = Boolean.parseBoolean(context.getProperty("tomitribe.crest.useInPlaceRegistrations"));
        if (alreadyScanned) {
            this.doRegisters(context, this.doLoadCrestTxt("crest-commands.txt"), this.doLoadCrestTxt("crest-editors.txt"));
            return;
        }
        Predicate extensionFilter = context.createIncludesExcludes("tomitribe.crest.command.", ArthurExtension.PredicateType.STARTS_WITH);
        Predicate editorsFilter = context.createIncludesExcludes("tomitribe.crest.editors.", ArthurExtension.PredicateType.STARTS_WITH);
        Collection commands = context.findAnnotatedMethods(Command.class);
        List<String> commandsAndInterceptors = this.toClasses(context, commands).filter(extensionFilter).collect(Collectors.toList());
        if (!commandsAndInterceptors.contains(TableInterceptor.class.getName())) {
            commandsAndInterceptors.add(TableInterceptor.class.getName());
        }
        if (!commandsAndInterceptors.contains(Help.class.getName())) {
            commandsAndInterceptors.add(Help.class.getName());
        }
        this.registerReflection(context, Collections.singletonList(Border.class.getName()));
        this.registerReflection(context, context.findAnnotatedMethods(Table.class).stream().flatMap(it -> this.extractTableType(it.getGenericReturnType())).flatMap(arg_0 -> ((ArthurExtension.Context)context).findHierarchy(arg_0)).distinct().map(Class::getName).collect(Collectors.toList()));
        List<String> editors = this.findEditors(context).filter(editorsFilter).collect(Collectors.toList());
        this.doRegisters(context, commandsAndInterceptors, editors);
        this.optionalJavaxBeanValidationRegistration(context);
    }

    private Stream<Class<?>> extractTableType(Type genericReturnType) {
        ParameterizedType pt;
        if (Class.class.isInstance(genericReturnType)) {
            Class type = (Class)Class.class.cast(genericReturnType);
            if (type.isPrimitive() || type == String.class) {
                return Stream.empty();
            }
            return Stream.of(type);
        }
        if (ParameterizedType.class.isInstance(genericReturnType) && (Stream.class == (pt = (ParameterizedType)ParameterizedType.class.cast(genericReturnType)).getRawType() || Collection.class == pt.getRawType() || Map.class == pt.getRawType() || Set.class == pt.getRawType() || List.class == pt.getRawType())) {
            return this.extractTableType(pt.getActualTypeArguments()[pt.getActualTypeArguments().length - 1]);
        }
        return Stream.empty();
    }

    private void optionalJavaxBeanValidationRegistration(ArthurExtension.Context context) {
        try {
            context.loadClass("javax.validation.Validation");
            ResourceBundleModel validationMessagesBundle = new ResourceBundleModel();
            validationMessagesBundle.setName("org.apache.bval.jsr.ValidationMessages");
            context.register(validationMessagesBundle);
            this.registerConstructorReflection(context, Collections.singletonList("org.apache.bval.jsr.ApacheValidatorFactory"));
            Class<Annotation> constraint = context.loadClass("javax.validation.Constraint").asSubclass(Annotation.class);
            Collection constraintAnnotations = context.findAnnotatedClasses(constraint);
            List<String> constraints = constraintAnnotations.stream().flatMap(it -> Stream.concat(Stream.of(it), this.extractConstraintValidatedBy((Class<?>)it, (Class<? extends Annotation>)constraint))).map(Class::getName).collect(Collectors.toList());
            this.registerReflection(context, constraints);
            this.registerAnnotationProxies(context, constraintAnnotations.stream().map(Class::getName).distinct().collect(Collectors.toList()));
            ClassReflectionModel typesFields = new ClassReflectionModel();
            typesFields.setName("org.apache.bval.jsr.ConstraintAnnotationAttributes$Types");
            typesFields.setAllDeclaredFields(Boolean.valueOf(true));
            context.register(typesFields);
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/apache/bval/jsr/DefaultConstraints.properties");){
                if (stream != null) {
                    Properties properties = new Properties();
                    properties.load(stream);
                    ResourceModel defaultConstraintsRegistry = new ResourceModel();
                    defaultConstraintsRegistry.setPattern("org/apache/bval/jsr/DefaultConstraints.properties");
                    context.register(defaultConstraintsRegistry);
                    List<String> defaultConstraints = properties.stringPropertyNames().stream().map(properties::getProperty).flatMap(it -> Stream.of(it.split(","))).map(String::trim).filter(it -> !it.isEmpty()).map(arg_0 -> ((ArthurExtension.Context)context).loadClass(arg_0)).map(Class::getName).collect(Collectors.toList());
                    this.registerReflection(context, defaultConstraints);
                    this.registerAnnotationProxies(context, properties.stringPropertyNames());
                }
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    private void registerAnnotationProxies(ArthurExtension.Context context, Collection<String> names) {
        names.forEach(name -> {
            DynamicProxyModel dynamicProxyModel = new DynamicProxyModel();
            dynamicProxyModel.setClasses(Collections.singletonList(name));
            context.register(dynamicProxyModel);
        });
    }

    private Stream<Class<?>> extractConstraintValidatedBy(Class<?> it, Class<? extends Annotation> constraint) {
        try {
            Annotation value = it.getAnnotation(constraint);
            return Stream.of((Class[])value.annotationType().getMethod("validatedBy", new Class[0]).invoke((Object)value, new Object[0]));
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    private void doRegisters(ArthurExtension.Context context, List<String> commandsAndInterceptors, List<String> editors) {
        this.registerReflection(context, commandsAndInterceptors);
        this.registerConstructorReflection(context, editors);
        if (!editors.isEmpty()) {
            this.registerEditorsLoader(context, editors);
            this.registerCommandsLoader(context, Stream.concat(Stream.of("org.tomitribe.crest.EditorLoader"), commandsAndInterceptors.stream()).collect(Collectors.toList()));
            context.register(this.toClassReflection("org.tomitribe.crest.EditorLoader"));
        } else {
            this.registerCommandsLoader(context, commandsAndInterceptors);
        }
    }

    private boolean isExplicitClass(String name) {
        return !TableInterceptor.class.getName().equals(name) && !Help.class.getName().equals(name);
    }

    private void registerEditorsLoader(ArthurExtension.Context context, List<String> keptClasses) {
        context.addNativeImageOption("-H:TomitribeCrestEditors=" + this.dump(Paths.get(Objects.requireNonNull(context.getProperty("workingDirectory"), "workingDirectory property"), new String[0]), "crest-editors.txt", String.join((CharSequence)"\n", keptClasses)));
    }

    private void registerCommandsLoader(ArthurExtension.Context context, List<String> keptClasses) {
        context.addNativeImageOption("-H:TomitribeCrestCommands=" + this.dump(Paths.get(Objects.requireNonNull(context.getProperty("workingDirectory"), "workingDirectory property"), new String[0]), "crest-commands.txt", keptClasses.stream().filter(this::isExplicitClass).collect(Collectors.joining("\n"))));
    }

    private void registerConstructorReflection(ArthurExtension.Context context, List<String> classes) {
        classes.stream().map(this::toConstructorModel).forEach(arg_0 -> ((ArthurExtension.Context)context).register(arg_0));
    }

    private void registerReflection(ArthurExtension.Context context, List<String> classes) {
        classes.stream().map(this::toModel).forEach(arg_0 -> ((ArthurExtension.Context)context).register(arg_0));
    }

    private String dump(Path workDir, String name, String value) {
        if (!Files.isDirectory(workDir, new LinkOption[0])) {
            try {
                Files.createDirectories(workDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        Path out = workDir.resolve(name);
        try {
            Files.write(out, value.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return out.toAbsolutePath().toString();
    }

    private Stream<String> findEditors(ArthurExtension.Context context) {
        return context.findAnnotatedClasses(Editor.class).stream().distinct().map(Class::getName).sorted();
    }

    private Stream<String> toClasses(ArthurExtension.Context context, Collection<Method> commands) {
        return commands.stream().flatMap(m -> Stream.concat(Stream.concat(this.findInterceptors(context, (Method)m), this.findValidators((Method)m)), Stream.of(m.getDeclaringClass()))).distinct().flatMap(arg_0 -> ((ArthurExtension.Context)context).findHierarchy(arg_0)).distinct().map(Class::getName).sorted();
    }

    private Stream<Class<?>> findInterceptors(ArthurExtension.Context context, Method method) {
        return Stream.concat(this.findBindingInterceptors(context, method), Stream.of(method.getAnnotation(Command.class).interceptedBy()));
    }

    private Stream<Class<?>> findBindingInterceptors(ArthurExtension.Context context, Method method) {
        return Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(it -> it.isAnnotationPresent(CrestInterceptor.class)).flatMap(marker -> context.findAnnotatedClasses(marker).stream().filter(it -> Stream.of(it.getMethods()).anyMatch(m -> m.isAnnotationPresent(CrestInterceptor.class))));
    }

    private Stream<Class<?>> findValidators(Method method) {
        return Stream.of(method.getParameters()).flatMap(it -> Stream.of(it.getAnnotations())).map(Annotation::annotationType).filter(it -> it.isAnnotationPresent(Validation.class)).map(it -> it.getAnnotation(Validation.class).value());
    }

    private ClassReflectionModel toClassReflection(String name) {
        ClassReflectionModel model = new ClassReflectionModel();
        model.setName(name);
        return model;
    }

    private ClassReflectionModel toConstructorModel(String name) {
        ClassReflectionModel model = new ClassReflectionModel();
        model.setName(name);
        model.setAllPublicConstructors(Boolean.valueOf(true));
        return model;
    }

    private ClassReflectionModel toModel(String name) {
        ClassReflectionModel model = new ClassReflectionModel();
        model.setName(name);
        model.setAllPublicMethods(Boolean.valueOf(true));
        model.setAllPublicConstructors(Boolean.valueOf(true));
        return model;
    }

    private List<String> doLoadCrestTxt(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Collections.list(loader.getResources(name)).stream().flatMap(url -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                    Stream stream = reader.lines().filter(it -> !it.isEmpty() && !it.startsWith("#")).map(it -> {
                        try {
                            return loader.loadClass((String)it).getName();
                        }
                        catch (Error | Exception e) {
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList()).stream();
                    return stream;
                }
                catch (IOException ioe) {
                    return Stream.empty();
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

