/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.arthur.feature;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.Stream;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class CrestFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Options.TomitribeCrestCommands.hasBeenSet()) {
            this.register((String)Options.TomitribeCrestCommands.getValue(), "crest-commands.txt");
        }
        if (Options.TomitribeCrestEditors.hasBeenSet()) {
            this.register((String)Options.TomitribeCrestEditors.getValue(), "crest-editors.txt");
        }
    }

    private void register(String path, String resource) {
        try (InputStream stream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            Resources.registerResource((String)resource, (InputStream)stream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class CrestOptions
    implements OptionDescriptors {
        public OptionDescriptor get(String value) {
            switch (value) {
                case "TomitribeCrestCommands": {
                    return OptionDescriptor.create((String)value, (OptionType)OptionType.User, String.class, (String)"Crest commands.", Options.class, (String)value, Options.TomitribeCrestCommands);
                }
                case "TomitribeCrestEditors": {
                    return OptionDescriptor.create((String)value, (OptionType)OptionType.User, String.class, (String)"Crest editors.", Options.class, (String)value, Options.TomitribeCrestEditors);
                }
            }
            return null;
        }

        public Iterator<OptionDescriptor> iterator() {
            return Stream.of("TomitribeCrestCommands", "TomitribeCrestEditors").map(this::get).iterator();
        }
    }

    public static final class Options {
        @Option(help={"Crest commands list file."}, type=OptionType.User)
        static final HostedOptionKey<String> TomitribeCrestCommands = new HostedOptionKey(null);
        @Option(help={"Crest editors list file."}, type=OptionType.User)
        static final HostedOptionKey<String> TomitribeCrestEditors = new HostedOptionKey(null);
    }
}

