/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class Java {
    private Java() {
    }

    public static Result java(String ... args) {
        try {
            ProcessBuilder java = Java.javaProcess();
            java.command().addAll(Arrays.asList(args));
            return new Result(java.start());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private static ProcessBuilder javaProcess() {
        File javaHome = new File(System.getenv("JAVA_HOME"));
        File java = new File(new File(javaHome, "bin"), "java");
        if (!java.exists()) {
            java = new File(new File(javaHome, "bin"), "java.exe");
        }
        if (!java.exists()) {
            throw new IllegalStateException("No java executable found");
        }
        if (!java.canExecute()) {
            throw new IllegalStateException("Not executable: " + java.getAbsolutePath());
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        List<String> command = builder.command();
        command.add(java.getAbsolutePath());
        return builder;
    }

    public static final class Pipe
    implements Runnable {
        private final InputStream in;
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final OutputStream[] cc;

        public Pipe(InputStream in, OutputStream ... copy) {
            this.in = in;
            this.cc = copy;
        }

        public static Future<Pipe> pipe(InputStream in, OutputStream ... copy) {
            Pipe target = new Pipe(in, copy);
            FutureTask<Pipe> task = new FutureTask<Pipe>(target, target);
            Thread thread = new Thread(task);
            thread.setDaemon(true);
            thread.start();
            return task;
        }

        public synchronized String asString() {
            return new String(this.out.toByteArray());
        }

        @Override
        public synchronized void run() {
            try {
                int i = -1;
                byte[] buf = new byte[1024];
                while ((i = this.in.read(buf)) != -1) {
                    this.out.write(buf, 0, i);
                    for (OutputStream stream : this.cc) {
                        stream.write(buf, 0, i);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class Result {
        private final String out;
        private final String err;
        private final int exitCode;

        public Result(Process process) throws InterruptedException, ExecutionException {
            Future<Pipe> stout = Pipe.pipe(process.getInputStream(), System.out);
            Future<Pipe> sterr = Pipe.pipe(process.getErrorStream(), System.err);
            this.exitCode = process.waitFor();
            this.out = stout.get().asString();
            this.err = sterr.get().asString();
        }

        public String getOut() {
            return this.out;
        }

        public String getErr() {
            return this.err;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

