/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.test;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.tomitribe.crest.test.Jars;
import org.tomitribe.crest.test.Java;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;
import org.tomitribe.util.Join;

public class Jar<T extends Jar<T>> {
    private final Map<String, String> manifest = new HashMap<String, String>();
    private final Map<String, Supplier<byte[]>> entries = new HashMap<String, Supplier<byte[]>>();

    public static Jar archive() {
        return new Jar();
    }

    public T manifest(String key, Object value) {
        this.manifest.put(key, value.toString());
        return (T)this;
    }

    public T manifest(String key, Class value) {
        this.manifest.put(key, value.getName());
        return (T)this;
    }

    public static Jar mainClass(Class value) {
        Jar jar = new Jar();
        jar.add(value);
        jar.manifest("Main-Class", value.getName());
        return jar;
    }

    public T add(String name, byte[] bytes) {
        this.entries.put(name, () -> bytes);
        return (T)this;
    }

    public T add(String name, Supplier<byte[]> content) {
        this.entries.put(name, content);
        return (T)this;
    }

    public T add(String name, String content) {
        return this.add(name, content::getBytes);
    }

    public T add(String name, File content) {
        return this.add(name, () -> Jar.readBytes(content));
    }

    public static byte[] readBytes(File content) {
        try {
            return IO.readBytes((File)content);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] readBytes(URL content) {
        try {
            return IO.readBytes((URL)content);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public T add(String name, URL content) throws IOException {
        return this.add(name, IO.readBytes((URL)content));
    }

    public T add(Class<?> clazz) {
        try {
            String name = clazz.getName().replace('.', '/') + ".class";
            URL resource = this.getClass().getClassLoader().getResource(name);
            if (resource == null) {
                throw new IllegalStateException("Cannot find class file for " + clazz.getName());
            }
            this.add(name, resource);
            if (!clazz.isAnonymousClass() && clazz.getDeclaringClass() != null) {
                this.add(clazz.getDeclaringClass());
            }
            Stream.of(clazz.getDeclaredClasses()).filter(Class::isAnonymousClass).forEach(this::add);
            return (T)this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public T addDir(File dir) {
        try {
            this.addDir(null, dir);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return (T)this;
    }

    private void addDir(String path, File dir) throws IOException {
        for (File file : dir.listFiles()) {
            String childPath;
            String string = childPath = path != null ? path + "/" + file.getName() : file.getName();
            if (file.isFile()) {
                this.entries.put(childPath, () -> Jar.readBytes(file));
                continue;
            }
            this.addDir(childPath, file);
        }
    }

    public T addJar(Class aClass) {
        return this.addJar(Jars.jarOf(aClass));
    }

    public T addJar(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                byte[] bytes = IO.readBytes((InputStream)jarFile.getInputStream(entry));
                this.entries.put(entry.getName(), () -> bytes);
            }
            return (T)this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Java.Result exec(String ... args) {
        File jar = this.asJar();
        ArrayList<String> list = new ArrayList<String>();
        list.add("-jar");
        list.add(jar.getAbsolutePath());
        list.addAll(Arrays.asList(args));
        return Java.java(list.toArray(new String[0]));
    }

    public File toJar() throws IOException {
        File file = File.createTempFile("archive-", ".jar");
        file.deleteOnExit();
        return this.toJar(file);
    }

    public File toJar(File file) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (Map.Entry<String, Supplier<byte[]>> entry : this.entries().entrySet()) {
            out.putNextEntry(new ZipEntry(entry.getKey()));
            out.write(entry.getValue().get());
        }
        out.close();
        return file;
    }

    public File asJar() {
        try {
            return this.toJar();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File toDir() throws IOException {
        File classpath = Files.tmpdir();
        this.toDir(classpath);
        return classpath;
    }

    public void toDir(File dir) throws IOException {
        Files.exists((File)dir);
        Files.dir((File)dir);
        Files.writable((File)dir);
        for (Map.Entry<String, Supplier<byte[]>> entry : this.entries().entrySet()) {
            String key = entry.getKey().replace('/', File.separatorChar);
            File file = new File(dir, key);
            Files.mkparent((File)file);
            try {
                IO.copy((byte[])entry.getValue().get(), (File)file);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot write entry " + entry.getKey(), e);
            }
        }
    }

    public File asDir() {
        try {
            return this.toDir();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HashMap<String, Supplier<byte[]>> entries() {
        HashMap<String, Supplier<byte[]>> entries = new HashMap<String, Supplier<byte[]>>(this.entries);
        entries.put("META-INF/MANIFEST.MF", this.buildManifest()::getBytes);
        return entries;
    }

    private String buildManifest() {
        String delimiter = "\r\n";
        return Join.join((String)"\r\n", entry -> (String)entry.getKey() + ": " + (String)entry.getValue(), this.manifest.entrySet()) + "\r\n";
    }
}

