/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.bootstrap;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.inject.Named;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.service.search.SearchEngine;

@Singleton
@Startup
@DependsOn(value={"SearchEngine"})
public class Provisioning {
    private static final Logger LOGGER = Logger.getLogger(Provisioning.class.getName());
    @EJB
    private Repository repository;
    @EJB
    private SearchEngine searchEngine;
    @Inject
    @Named(value="SwaggerObjectMapper")
    private ObjectMapper mapper;

    @PostConstruct
    public void init() {
        this.seedDatabase();
        this.searchEngine.waitForWrites();
    }

    private void seedDatabase() {
        URL res = Thread.currentThread().getContextClassLoader().getResource("seed-db");
        if (res == null) {
            LOGGER.log(Level.WARNING, "Cannot find seed-db resource in the classpath.");
            return;
        }
        if (!"file".equals(res.getProtocol())) {
            LOGGER.log(Level.WARNING, "Cannot load initial OpenAPI documents because seed-db is at {0}!", res);
            return;
        }
        File f = new File(res.getFile());
        Stream.of(f.listFiles((dir, name) -> name.endsWith(".json"))).forEach(arg_0 -> this.seedFile(arg_0));
    }

    private void seedFile(File swaggerFile) {
        LOGGER.info("Seeding " + swaggerFile.getName());
        try {
            Swagger swagger = (Swagger)this.mapper.readValue(swaggerFile, Swagger.class);
            if (this.repository.findApplicationByNameAndVersion(swagger.getInfo().getTitle(), swagger.getInfo().getVersion()) == null) {
                OpenApiDocument openApiDocument = this.repository.insert(swagger);
                LOGGER.log(Level.INFO, "Persisted application {0}-{1}", new Object[]{openApiDocument.getName(), openApiDocument.getVersion()});
            } else {
                LOGGER.log(Level.INFO, "Application {0}-{1} already available in DB ", new Object[]{swagger.getInfo().getTitle(), swagger.getInfo().getVersion()});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, () -> String.format("Seeding %s failed!", swaggerFile.getName()));
        }
        LOGGER.info("Memory = " + ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
    }
}

