/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.entities;

import io.swagger.models.Operation;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.envers.Audited;
import org.tomitribe.tribestream.registryng.entities.AbstractEntity;
import org.tomitribe.tribestream.registryng.entities.OpenAPIDocumentSerializer;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="UQ_VERB_PATH", columnNames={"verb", "path"})})
@NamedQueries(value={@NamedQuery(name="Endpoint.findAll", query="SELECT ep FROM Endpoint ep ORDER BY ep.application.name ASC, ep.application.version DESC, ep.path ASC, ep.verb ASC"), @NamedQuery(name="Endpoint.findAllWithApplication", query="SELECT ep FROM Endpoint ep JOIN FETCH ep.application  ORDER BY ep.application.name ASC, ep.application.version DESC, ep.path ASC, ep.verb ASC"), @NamedQuery(name="Endpoint.findByApplicationIdVerbAndPath", query="SELECT ep FROM Endpoint ep JOIN FETCH ep.application  WHERE (concat(ep.application.name, '-', ep.application.version) = :applicationId OR ep.application.id = :applicationId)        AND lower(ep.verb) = lower(:verb) AND ep.path = :path")})
@EntityListeners(value={OpenAPIDocumentSerializer.class})
@Audited
public class Endpoint
extends AbstractEntity {
    public static final String QRY_FIND_ALL = "Endpoint.findAll";
    public static final String QRY_FIND_BY_APPLICATIONID_VERB_AND_PATH = "Endpoint.findByApplicationIdVerbAndPath";
    public static final String QRY_FIND_ALL_WITH_APPLICATION = "Endpoint.findAllWithApplication";
    @ManyToOne(targetEntity=OpenApiDocument.class, optional=false)
    @JoinColumn(name="APPLICATION_ID", nullable=false)
    @ForeignKey(name="FK_ENDPOINT_APPLICATION_01")
    private OpenApiDocument application;
    @Column(name="PATH", nullable=false)
    private String path;
    @Column(name="VERB", nullable=false)
    private String verb;
    @Column(length=0x100000)
    @Lob
    private String document;
    private transient Operation operation;

    public OpenApiDocument getApplication() {
        return this.application;
    }

    public void setApplication(OpenApiDocument application) {
        this.application = application;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getDocument() {
        return this.document;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }
}

