/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.entities;

import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.envers.Audited;
import org.tomitribe.tribestream.registryng.entities.AbstractEntity;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenAPIDocumentSerializer;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="UQ_NAME_VERSION", columnNames={"name", "version"})})
@NamedQueries(value={@NamedQuery(name="OpenApiDocument.findByNameAndVersion", query="SELECT d FROM OpenApiDocument d WHERE d.name = :name AND d.version = :version"), @NamedQuery(name="OpenApiDocument.findByApplicationId", query="SELECT d FROM OpenApiDocument d WHERE d.id = :applicationId"), @NamedQuery(name="OpenApiDocument.findByApplicationIdWithEndpoints", query="SELECT DISTINCT d FROM OpenApiDocument d LEFT JOIN FETCH d.endpoints WHERE d.id = :applicationId"), @NamedQuery(name="OpenApiDocument.findByName", query="SELECT d FROM OpenApiDocument d WHERE d.name = :name ORDER BY d.version DESC"), @NamedQuery(name="OpenApiDocument.findAll", query="SELECT d FROM OpenApiDocument d ORDER BY d.name ASC, d.version DESC"), @NamedQuery(name="OpenApiDocument.findAllWithEndpoints", query="SELECT DISTINCT d FROM OpenApiDocument d JOIN FETCH d.endpoints ORDER BY d.name ASC, d.version DESC")})
@EntityListeners(value={OpenAPIDocumentSerializer.class})
@Audited
public class OpenApiDocument
extends AbstractEntity {
    public static final String QRY_FIND_BY_NAME_AND_VERSION = "OpenApiDocument.findByNameAndVersion";
    public static final String QRY_FIND_BY_NAME = "OpenApiDocument.findByName";
    public static final String QRY_FIND_ALL = "OpenApiDocument.findAll";
    public static final String QRY_FIND_ALL_WITH_ENDPOINTS = "OpenApiDocument.findAllWithEndpoints";
    public static final String QRY_FIND_BY_APPLICATIONID = "OpenApiDocument.findByApplicationId";
    public static final String QRY_FIND_BY_APPLICATIONID_WITH_ENDPOINTS = "OpenApiDocument.findByApplicationIdWithEndpoints";
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private String version;
    @Column(length=0x100000)
    @Lob
    private String document;
    @OneToMany(targetEntity=Endpoint.class, mappedBy="application", cascade={CascadeType.REMOVE})
    private Collection<Endpoint> endpoints = new ArrayList();
    private transient Swagger swagger;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDocument() {
        return this.document;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public void setSwagger(Swagger swagger) {
        this.swagger = swagger;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Collection<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Collection<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }
}

