/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.lucene;

import java.io.ByteArrayOutputStream;
import java.util.Optional;
import javax.enterprise.inject.Vetoed;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.tomitribe.tribestream.registryng.lucene.File;

@Entity
@Table(name="lucene_index")
@NamedQueries(value={@NamedQuery(name="File.findAll", query="select i from File i")})
@Vetoed
public class File {
    @EmbeddedId
    private IndexId id;
    private long fileLength;
    private int filePointer;
    @Lob
    @Column(length=491520)
    private byte[] content;
    @Version
    private long revision;
    @Transient
    private ByteArrayOutputStream inMemoryBuffer;

    @PreUpdate
    @PrePersist
    public void flush() {
        if (this.inMemoryBuffer != null) {
            byte[] appended = this.inMemoryBuffer.toByteArray();
            int newLength = Optional.ofNullable(this.content).map(c -> ((byte[])c).length).orElse(0) + appended.length;
            byte[] newInstance = new byte[newLength];
            if (this.content != null && this.content.length > 0) {
                System.arraycopy(this.content, 0, newInstance, 0, this.content.length);
                System.arraycopy(appended, 0, newInstance, this.content.length, appended.length);
                this.content = newInstance;
            } else {
                this.content = appended;
            }
            this.inMemoryBuffer = null;
        }
    }

    public IndexId getId() {
        return this.id;
    }

    public void setId(IndexId id) {
        this.id = id;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public byte[] getContent() {
        this.flush();
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public int getFilePointer() {
        return this.filePointer + Optional.ofNullable(this.inMemoryBuffer).map(ByteArrayOutputStream::size).orElse(0);
    }

    public void setFilePointer(int filePointer) {
        this.filePointer = filePointer;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public void write(int offset, int length, byte ... bytes) {
        if (this.inMemoryBuffer == null) {
            this.inMemoryBuffer = new ByteArrayOutputStream();
        }
        this.inMemoryBuffer.write(bytes, offset, length);
        this.fileLength += (long)length;
        this.filePointer += length;
    }
}

