/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.lucene;

import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.store.Directory;
import org.tomitribe.tribestream.registryng.lucene.JPADirectoryFactory;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class JPADirectoryFactory {
    @PersistenceContext
    private EntityManager em;
    @Resource
    private SessionContext ctx;
    private JPADirectoryFactory self;

    @PostConstruct
    private void captureFacade() {
        this.self = (JPADirectoryFactory)this.ctx.getBusinessObject(JPADirectoryFactory.class);
    }

    public Directory newInstance(String marker) {
        return new JPADirectory(task -> this.self.execute(task), this.em, marker);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public <T> T execute(Supplier<T> task) {
        return task.get();
    }
}

