/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.lucene;

import java.io.EOFException;
import java.io.IOException;
import javax.enterprise.inject.Vetoed;
import org.apache.lucene.store.IndexInput;

@Vetoed
public class JPAIndexInput
extends IndexInput {
    private final byte[] content;
    private int pos = 0;

    public JPAIndexInput(String description, byte[] content) {
        super(description);
        this.content = content;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.length()) {
            throw new EOFException("pos=" + pos + ", length=" + this.length() + " ; can't move to that position");
        }
        this.pos = (int)pos;
    }

    public long length() {
        return this.content.length;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: " + this);
        }
        byte[] sliceContent = new byte[(int)length];
        System.arraycopy(this.content, (int)offset, sliceContent, 0, (int)length);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public byte readByte() throws IOException {
        byte[] b = new byte[1];
        this.readBytes(b, 0, 1);
        return b[0];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int available = (int)(this.length() - (long)this.pos);
        int bytesToCopy = len < available ? len : available;
        System.arraycopy(this.content, this.pos, b, offset, bytesToCopy);
        this.pos += bytesToCopy;
    }
}

