/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.lucene;

import java.io.IOException;
import javax.enterprise.inject.Vetoed;
import org.apache.lucene.store.IndexOutput;
import org.tomitribe.tribestream.registryng.lucene.JPADirectoryFactory;

@Vetoed
public class JPAIndexOutput
extends IndexOutput {
    private final JPADirectoryFactory.JPADirectory directory;

    public JPAIndexOutput(JPADirectoryFactory.JPADirectory directory, String name) {
        super("JPAIndexOutput(marker=" + directory.getMarker() + ", name=" + name + ")", name);
        this.directory = directory;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.directory.getFilePointer(this.getName());
    }

    public long getChecksum() throws IOException {
        return this.directory.getChecksum(this.getName());
    }

    public void writeByte(byte b) throws IOException {
        this.directory.writeBytes(this.getName(), new byte[]{b}, 0, 1);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.directory.writeBytes(this.getName(), b, offset, length);
    }
}

