/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.HistoryEntry;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.security.LoginContext;
import org.tomitribe.tribestream.registryng.service.search.SearchEngine;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class Repository {
    private static final Logger LOGGER = Logger.getLogger(Repository.class.getName());
    @PersistenceContext
    private EntityManager em;
    @Inject
    @Named(value="SwaggerObjectMapper")
    private ObjectMapper mapper;
    @Inject
    private LoginContext loginContext;
    @Inject
    private SearchEngine searchEngine;

    public static String getApplicationId(Swagger swagger) {
        return swagger.getInfo().getTitle() + "-" + swagger.getInfo().getVersion();
    }

    public Collection<OpenApiDocument> getAllOpenApiDocuments() {
        return this.em.createNamedQuery("OpenApiDocument.findAll", OpenApiDocument.class).getResultList();
    }

    public Collection<Endpoint> getAllEndpoints() {
        List result = this.em.createNamedQuery("Endpoint.findAll", Endpoint.class).getResultList();
        for (Endpoint endpoint : result) {
            endpoint.getApplication();
        }
        return result;
    }

    public OpenApiDocument findByApplicationId(String applicationId) throws NoResultException {
        try {
            return (OpenApiDocument)this.em.createNamedQuery("OpenApiDocument.findByApplicationId", OpenApiDocument.class).setParameter("applicationId", (Object)applicationId).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find application by id {0}", applicationId);
            return null;
        }
    }

    public OpenApiDocument findByApplicationIdAndRevision(String applicationid, int revision) {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.em);
        OpenApiDocument openApiDocument = (OpenApiDocument)auditReader.find(OpenApiDocument.class, (Object)applicationid, (Number)revision);
        for (Endpoint endpoint : openApiDocument.getEndpoints()) {
            endpoint.getDocument();
        }
        return openApiDocument;
    }

    public <T> List<HistoryEntry<T>> getRevisions(Class<T> entityClass, String id, int first, int pageSize) throws NoResultException {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.em);
        AuditQuery query = auditReader.createQuery().forRevisionsOfEntity(entityClass, false, true);
        query.add(AuditEntity.id().eq((Object)id));
        query.addOrder(AuditEntity.revisionNumber().desc());
        query.setFirstResult(first).setMaxResults(pageSize);
        List objects = query.getResultList();
        return objects.stream().map(HistoryEntry::new).collect(Collectors.toList());
    }

    public <T> int getNumberOfRevisions(Class<T> entityClass, String id) {
        AuditQuery query = AuditReaderFactory.get((EntityManager)this.em).createQuery().forRevisionsOfEntity(entityClass, true, true);
        query.add(AuditEntity.id().eq((Object)id));
        query.addProjection(AuditEntity.revisionNumber().count());
        return ((Number)query.getSingleResult()).intValue();
    }

    public OpenApiDocument findByApplicationIdWithEndpoints(String applicationId) {
        try {
            return (OpenApiDocument)this.em.createNamedQuery("OpenApiDocument.findByApplicationIdWithEndpoints", OpenApiDocument.class).setParameter("applicationId", (Object)applicationId).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find application by id {0}", applicationId);
            return null;
        }
    }

    public Endpoint findEndpointByIdAndRevision(String endpointId, int revision) {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.em);
        Endpoint endpoint = (Endpoint)auditReader.find(Endpoint.class, (Object)endpointId, (Number)revision);
        endpoint.getApplication().getId();
        return endpoint;
    }

    public OpenApiDocument findApplicationByNameAndVersion(String name, String version) {
        try {
            return (OpenApiDocument)this.em.createNamedQuery("OpenApiDocument.findByNameAndVersion", OpenApiDocument.class).setParameter("name", (Object)name).setParameter("version", (Object)version).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find application by name '{0}' and version '{1}'", new Object[]{name, version});
            return null;
        }
    }

    public List<OpenApiDocument> findAllApplications() {
        return this.em.createNamedQuery("OpenApiDocument.findAll", OpenApiDocument.class).getResultList();
    }

    public List<OpenApiDocument> findAllApplicationsWithEndpoints() {
        return this.em.createNamedQuery("OpenApiDocument.findAllWithEndpoints", OpenApiDocument.class).getResultList();
    }

    public Endpoint findEndpointById(String endpointId) {
        try {
            return (Endpoint)this.em.find(Endpoint.class, (Object)endpointId);
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find endpoint by id %s", endpointId);
            return null;
        }
    }

    public Endpoint findEndpoint(String applicationId, String verb, String path) {
        try {
            return (Endpoint)this.em.createNamedQuery("Endpoint.findByApplicationIdVerbAndPath", Endpoint.class).setParameter("applicationId", (Object)applicationId).setParameter("verb", (Object)verb).setParameter("path", (Object)(path.startsWith("/") ? path : "/" + path)).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find endpoint by application id '{0}', verb '{1}' and path '{2}'", new Object[]{applicationId, verb, path});
            return null;
        }
    }

    public Collection<Endpoint> findAllEndpoints() {
        return this.em.createNamedQuery("Endpoint.findAllWithApplication", Endpoint.class).getResultList();
    }

    public OpenApiDocument insert(Swagger swagger) {
        OpenApiDocument document = new OpenApiDocument();
        document.setName(swagger.getInfo().getTitle());
        document.setVersion(swagger.getInfo().getVersion());
        Swagger clone = Repository.createShallowCopy((Swagger)swagger);
        clone.setPaths(null);
        document.setSwagger(clone);
        String username = this.getUser();
        Date now = new Date();
        document.setCreatedAt(now);
        document.setUpdatedAt(now);
        document.setCreatedBy(username);
        document.setUpdatedBy(username);
        this.em.persist((Object)document);
        if (swagger.getPaths() != null) {
            for (Map.Entry stringPathEntry : swagger.getPaths().entrySet()) {
                String path = (String)stringPathEntry.getKey();
                Path pathObject = (Path)stringPathEntry.getValue();
                for (Map.Entry httpMethodOperationEntry : pathObject.getOperationMap().entrySet()) {
                    String verb = ((HttpMethod)httpMethodOperationEntry.getKey()).name().toUpperCase();
                    Operation operation = (Operation)httpMethodOperationEntry.getValue();
                    Endpoint endpoint = new Endpoint();
                    endpoint.setApplication(document);
                    endpoint.setPath(path);
                    endpoint.setVerb(verb);
                    endpoint.setOperation(operation);
                    this.em.persist((Object)endpoint);
                    this.em.flush();
                    this.searchEngine.indexEndpoint(endpoint, true);
                }
            }
        }
        return document;
    }

    protected String getUser() {
        return this.loginContext.getUsername();
    }

    public Endpoint insert(Endpoint endpoint, String applicationId) {
        OpenApiDocument application = this.findByApplicationId(applicationId);
        application.getEndpoints().add(endpoint);
        endpoint.setApplication(application);
        Date now = new Date();
        endpoint.setCreatedAt(now);
        endpoint.setUpdatedAt(now);
        endpoint.setCreatedBy(this.getUser());
        endpoint.setUpdatedBy(this.getUser());
        application.setUpdatedAt(now);
        application.setUpdatedBy(this.getUser());
        this.em.persist((Object)endpoint);
        this.update(application);
        this.em.flush();
        this.searchEngine.indexEndpoint(endpoint, true);
        return endpoint;
    }

    public static Swagger createShallowCopy(Swagger swagger) {
        Swagger result = new Swagger();
        result.setSwagger(swagger.getSwagger());
        result.info(swagger.getInfo());
        result.setHost(swagger.getHost());
        result.setBasePath(swagger.getBasePath());
        result.setSchemes(swagger.getSchemes());
        result.setConsumes(swagger.getConsumes());
        result.setProduces(swagger.getProduces());
        result.setPaths(swagger.getPaths());
        result.setDefinitions(swagger.getDefinitions());
        result.setParameters(swagger.getParameters());
        result.setResponses(swagger.getResponses());
        result.setSecurityDefinitions(swagger.getSecurityDefinitions());
        result.setSecurity(swagger.getSecurity());
        result.setTags(swagger.getTags());
        result.setExternalDocs(swagger.getExternalDocs());
        return result;
    }

    public OpenApiDocument update(OpenApiDocument document) {
        document.setUpdatedAt(new Date());
        document.setUpdatedBy(this.loginContext.getUsername());
        if (document.getSwagger() != null) {
            document.setDocument(this.convertToJson((Object)document.getSwagger()));
        }
        return (OpenApiDocument)this.em.merge((Object)document);
    }

    public Endpoint update(Endpoint endpoint) {
        endpoint.setUpdatedAt(new Date());
        endpoint.setUpdatedBy(this.loginContext.getUsername());
        if (endpoint.getOperation() != null) {
            endpoint.setDocument(this.convertToJson((Object)endpoint.getOperation()));
        }
        this.searchEngine.indexEndpoint(endpoint, false);
        return (Endpoint)this.em.merge((Object)endpoint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertToJson(Object object) {
        try (StringWriter sw = new StringWriter();){
            this.mapper.writeValue((Writer)sw, object);
            sw.flush();
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteApplication(String applicationId) {
        OpenApiDocument document = this.findByApplicationId(applicationId);
        if (document == null) {
            return false;
        }
        Optional.ofNullable(document.getEndpoints()).ifPresent(e -> e.forEach(arg_0 -> ((SearchEngine)this.searchEngine).deleteEndpoint(arg_0)));
        this.em.remove((Object)document);
        return true;
    }

    public boolean deleteEndpoint(String applicationId, String endpointId) {
        Endpoint endpoint = this.findEndpointById(endpointId);
        if (endpoint == null || !applicationId.equals(endpoint.getApplication().getId())) {
            return false;
        }
        this.searchEngine.deleteEndpoint(endpoint);
        this.em.remove((Object)endpoint);
        return true;
    }
}

