/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.ApplicationWrapper;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.resources.util.ApplicationWrapperUtil;

@Path(value="/application")
@ApplicationScoped
@Produces(value={"application/json"})
public class ApplicationResource {
    private final Repository repository;

    @Inject
    public ApplicationResource(Repository repository) {
        this.repository = repository;
    }

    public ApplicationResource() {
        this(null);
    }

    @GET
    @Path(value="/")
    public Response getAllApplications(@Context UriInfo uriInfo) {
        List applications = this.repository.findAllApplicationsWithEndpoints();
        HashSet ids = new HashSet();
        ArrayList<ApplicationWrapper> uniqueResults = new ArrayList<ApplicationWrapper>();
        for (OpenApiDocument application : applications) {
            Swagger swagger = ApplicationWrapperUtil.shrinkSwagger((Swagger)ApplicationWrapperUtil.mergeSwagger((Swagger)application.getSwagger(), (Collection)application.getEndpoints()));
            ApplicationWrapper applicationWrapper = new ApplicationWrapper(swagger);
            uniqueResults.add(applicationWrapper);
        }
        return Response.status((Response.Status)Response.Status.OK).entity(uniqueResults).build();
    }

    private Link[] buildLinks(UriInfo uriInfo, OpenApiDocument application) {
        ArrayList<Link> result = new ArrayList<Link>();
        result.add(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}").resolveTemplate("applicationId", (Object)application.getId())).rel("self").build(new Object[0]));
        result.add(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("history/application/{applicationId}").resolveTemplate("applicationId", (Object)application.getId())).rel("history").build(new Object[0]));
        for (Endpoint endpoint : application.getEndpoints()) {
            result.add(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)application.getId()).resolveTemplate("endpointId", (Object)endpoint.getId())).rel(endpoint.getVerb().toUpperCase() + " " + endpoint.getPath()).build(new Object[0]));
        }
        return result.toArray(new Link[result.size()]);
    }

    @GET
    @Path(value="/{applicationId}")
    public Response getApplication(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId) {
        OpenApiDocument application = this.repository.findByApplicationIdWithEndpoints(applicationId);
        if (application == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Swagger reducedSwagger = ApplicationWrapperUtil.shrinkSwagger((Swagger)ApplicationWrapperUtil.mergeSwagger((Swagger)application.getSwagger(), (Collection)application.getEndpoints()));
        ApplicationWrapper applicationWrapper = new ApplicationWrapper(reducedSwagger);
        return Response.ok((Object)applicationWrapper).links(this.buildLinks(uriInfo, application)).build();
    }

    @POST
    @Path(value="/")
    public Response createService(@Context UriInfo uriInfo, ApplicationWrapper application) {
        Swagger swagger = application.getSwagger();
        this.validate(swagger);
        OpenApiDocument document = this.repository.insert(swagger);
        OpenApiDocument newDocument = this.repository.findByApplicationIdWithEndpoints(document.getId());
        ApplicationWrapper applicationWrapper = new ApplicationWrapper(ApplicationWrapperUtil.shrinkSwagger((Swagger)ApplicationWrapperUtil.mergeSwagger((Swagger)newDocument.getSwagger(), (Collection)newDocument.getEndpoints())));
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)applicationWrapper).links(this.buildLinks(uriInfo, newDocument)).build();
    }

    private void validate(Swagger swagger) {
        if (swagger == null) {
            throw new WebApplicationException("Swagger document is null!", Response.Status.BAD_REQUEST);
        }
        if (!"2.0".equals(swagger.getSwagger())) {
            throw new WebApplicationException("Unsupported swagger version!", Response.Status.BAD_REQUEST);
        }
        if (swagger.getInfo() == null) {
            throw new WebApplicationException("Swagger document has no info property!", Response.Status.BAD_REQUEST);
        }
        if (swagger.getInfo().getTitle() == null) {
            throw new WebApplicationException("Swagger document has no title!", Response.Status.BAD_REQUEST);
        }
        if (swagger.getInfo().getTitle() == null) {
            throw new WebApplicationException("Swagger document has no version!", Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Path(value="/{id}")
    public Response updateService(@Context UriInfo uriInfo, @PathParam(value="id") String applicationId, ApplicationWrapper application) {
        Swagger swagger = application.getSwagger();
        OpenApiDocument oldDocument = this.repository.findByApplicationIdWithEndpoints(applicationId);
        if (oldDocument == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.merge(oldDocument.getSwagger(), swagger);
        this.validate(oldDocument.getSwagger());
        this.repository.update(oldDocument);
        OpenApiDocument updatedDocument = this.repository.findByApplicationIdWithEndpoints(applicationId);
        ApplicationWrapper applicationWrapper = new ApplicationWrapper(ApplicationWrapperUtil.shrinkSwagger((Swagger)updatedDocument.getSwagger()));
        return Response.status((Response.Status)Response.Status.OK).links(this.buildLinks(uriInfo, updatedDocument)).entity((Object)applicationWrapper).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteService(@Context UriInfo uriInfo, @PathParam(value="id") String applicationId) {
        if (!this.repository.deleteApplication(applicationId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private void merge(Swagger target, Swagger source) {
        if (source.getSwagger() != null) {
            target.setSwagger(source.getSwagger());
        }
        if (source.getInfo() != null) {
            target.setInfo(source.getInfo());
        }
        if (source.getHost() != null) {
            target.setHost(source.getHost());
        }
        if (source.getBasePath() != null) {
            target.setBasePath(source.getBasePath());
        }
        if (source.getSchemes() != null) {
            target.setSchemes(source.getSchemes());
        }
        if (source.getConsumes() != null) {
            target.setConsumes(source.getConsumes());
        }
        if (source.getProduces() != null) {
            target.setProduces(source.getProduces());
        }
        if (source.getDefinitions() != null) {
            target.setDefinitions(source.getDefinitions());
        }
        if (source.getParameters() != null) {
            target.setParameters(source.getParameters());
        }
        if (source.getResponses() != null) {
            target.setResponses(source.getResponses());
        }
        if (source.getSecurity() != null) {
            target.setSecurity(source.getSecurity());
        }
        if (source.getTags() != null) {
            target.setTags(source.getTags());
        }
        if (source.getVendorExtensions() != null) {
            target.getVendorExtensions().clear();
            target.getVendorExtensions().putAll(source.getVendorExtensions());
        }
    }
}

