/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.ApplicationWrapper;
import org.tomitribe.tribestream.registryng.domain.EndpointWrapper;
import org.tomitribe.tribestream.registryng.domain.HistoryItem;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenAPIDocumentSerializer;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.resources.util.ApplicationWrapperUtil;

@Path(value="/history/application")
@ApplicationScoped
@Produces(value={"application/json"})
public class HistoryResource {
    private final Repository repository;
    private final OpenAPIDocumentSerializer documentSerializer;

    @Inject
    public HistoryResource(Repository repository, OpenAPIDocumentSerializer documentSerializer) {
        this.repository = repository;
        this.documentSerializer = documentSerializer;
    }

    protected HistoryResource() {
        this(null, null);
    }

    @GET
    @Path(value="/{applicationId}")
    public Response getApplicationHistory(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @QueryParam(value="page") @DefaultValue(value="1") int page, @QueryParam(value="per_page") @DefaultValue(value="20") int perPage) {
        int first = (page - 1) * perPage;
        List history = this.repository.getRevisions(OpenApiDocument.class, applicationId, first, perPage);
        List result = history.stream().map(HistoryItem::new).collect(Collectors.toList());
        UriBuilder historyApplicationBaseUriBuilder = uriInfo.getBaseUriBuilder().path("history/application/{applicationId}").resolveTemplate("applicationId", (Object)applicationId);
        return Response.ok(result).links(this.buildPaginationLinks(historyApplicationBaseUriBuilder, this.repository.getNumberOfRevisions(OpenApiDocument.class, applicationId), page, perPage)).links(this.buildRevisionLinks(historyApplicationBaseUriBuilder, result)).links(new Link[]{this.buildCurrentApplicationLink(uriInfo, applicationId)}).build();
    }

    private Link buildCurrentApplicationLink(UriInfo uriInfo, String applicationId) {
        return Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}").resolveTemplate("applicationId", (Object)applicationId)).rel("application").build(new Object[0]);
    }

    private Link buildCurrentEndpointLink(UriInfo uriInfo, String applicationId, String endpointId) {
        return Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)applicationId).resolveTemplate("endpointId", (Object)endpointId)).rel("application").build(new Object[0]);
    }

    private Link[] buildRevisionLinks(UriBuilder baseUriBuilder, List<HistoryItem> historyItems) {
        List<Link> result = historyItems.stream().map(historyItem -> Link.fromUriBuilder((UriBuilder)baseUriBuilder.clone().path("/{revisionId}").resolveTemplate("revisionId", (Object)historyItem.getRevisionId())).rel("revision " + historyItem.getRevisionId()).build(new Object[0])).collect(Collectors.toList());
        return result.toArray(new Link[result.size()]);
    }

    private Link[] buildPaginationLinks(UriBuilder pageUriBuilder, int numberOfRevisions, int currentPage, int currentPageSize) {
        ArrayList<Link> result = new ArrayList<Link>();
        result.add(this.createLink(pageUriBuilder, currentPage, currentPageSize, "self"));
        if (numberOfRevisions >= 1) {
            result.add(this.createLink(pageUriBuilder, 1, currentPageSize, "first"));
            result.add(this.createLink(pageUriBuilder, numberOfRevisions / currentPageSize + 1, currentPageSize, "last"));
        }
        if (numberOfRevisions > currentPage * currentPageSize) {
            result.add(this.createLink(pageUriBuilder, currentPage + 1, currentPageSize, "next"));
        }
        if (currentPage > 1) {
            result.add(this.createLink(pageUriBuilder, currentPage - 1, currentPageSize, "previous"));
        }
        return result.toArray(new Link[result.size()]);
    }

    @GET
    @Path(value="/{applicationId}/endpoint/{endpointId}")
    public Response getEndpointHistory(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="endpointId") String endpointId, @QueryParam(value="page") @DefaultValue(value="1") int page, @QueryParam(value="per_page") @DefaultValue(value="20") int perPage) {
        int first = (page - 1) * perPage;
        List history = this.repository.getRevisions(Endpoint.class, endpointId, first, perPage);
        List result = history.stream().map(HistoryItem::new).collect(Collectors.toList());
        UriBuilder endpointHistoryBaseUriBuilder = uriInfo.getBaseUriBuilder().path("history/application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)applicationId).resolveTemplate("endpointId", (Object)endpointId);
        return Response.ok(result).links(this.buildPaginationLinks(endpointHistoryBaseUriBuilder, this.repository.getNumberOfRevisions(Endpoint.class, endpointId), page, perPage)).links(this.buildRevisionLinks(endpointHistoryBaseUriBuilder, result)).build();
    }

    @GET
    @Path(value="/{applicationId}/{revisionId:[0-9]+}")
    public Response getApplicationWithRevision(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="revisionId") int revisionId) {
        OpenApiDocument application = this.repository.findByApplicationIdAndRevision(applicationId, revisionId);
        if (application == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.documentSerializer.postLoad((Object)application);
        Swagger reducedSwagger = ApplicationWrapperUtil.shrinkSwagger((Swagger)ApplicationWrapperUtil.mergeSwagger((Swagger)application.getSwagger(), (Collection)application.getEndpoints()));
        ApplicationWrapper applicationWrapper = new ApplicationWrapper(reducedSwagger);
        return Response.ok((Object)applicationWrapper).links(new Link[]{this.buildCurrentApplicationLink(uriInfo, applicationId)}).build();
    }

    @GET
    @Path(value="/{applicationId}/endpoint/{endpointId}/{revisionId:[0-9]+}")
    public Response getEndpointWithRevision(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="endpointId") String endpointId, @PathParam(value="revisionId") int revisionId) {
        Endpoint endpoint = this.repository.findEndpointByIdAndRevision(endpointId, revisionId);
        if (endpoint == null || endpoint.getApplication().getId() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.documentSerializer.postLoad((Object)endpoint);
        EndpointWrapper endpointWrapper = new EndpointWrapper(endpoint.getVerb(), endpoint.getPath(), endpoint.getOperation());
        return Response.ok((Object)endpointWrapper).links(new Link[]{this.buildCurrentEndpointLink(uriInfo, applicationId, endpointId)}).build();
    }

    private Link createLink(UriBuilder uriBuilder, int page, int currentPageSize, String rel) {
        return Link.fromUriBuilder((UriBuilder)uriBuilder.clone().queryParam("page", new Object[]{page}).queryParam("per_page", new Object[]{currentPageSize})).rel(rel).build(new Object[0]);
    }
}

