/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.SearchPage;
import org.tomitribe.tribestream.registryng.domain.SearchResult;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.service.search.SearchEngine;
import org.tomitribe.tribestream.registryng.service.search.SearchRequest;

@Path(value="registry")
@ApplicationScoped
@Produces(value={"application/json"})
public class RegistryResource {
    @Inject
    private Repository repository;
    private final SearchEngine searchEngine;

    protected RegistryResource() {
        this.searchEngine = null;
    }

    @Inject
    public RegistryResource(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    @GET
    public SearchPage getSearchPage(@Context UriInfo uriInfo, @Context HttpHeaders headers, @QueryParam(value="query") @DefaultValue(value="*") String query, @QueryParam(value="tag") List<String> tags, @QueryParam(value="category") List<String> categories, @QueryParam(value="role") List<String> roles, @QueryParam(value="app") List<String> apps, @QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="count") @DefaultValue(value="1000") int count) {
        SearchRequest searchRequest = new SearchRequest(query, tags, categories, roles, apps, page, count);
        SearchPage searchPage = this.searchEngine.search(searchRequest);
        for (SearchResult searchResult : searchPage.getResults()) {
            searchResult.setLink(uriInfo.getBaseUriBuilder().path("/application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)searchResult.getApplicationId()).resolveTemplate("endpointId", (Object)searchResult.getEndpointId()).build(new Object[0]).toASCIIString());
        }
        return searchPage;
    }
}

