/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.SearchPage;
import org.tomitribe.tribestream.registryng.service.search.SearchEngine;
import org.tomitribe.tribestream.registryng.service.search.SearchRequest;

@Path(value="search")
@ApplicationScoped
@Produces(value={"application/json"})
public class SearchResource {
    protected final SearchEngine engine;

    @Inject
    public SearchResource(SearchEngine engine) {
        this.engine = engine;
    }

    protected SearchResource() {
        this(null);
    }

    @HEAD
    @Path(value="reindex")
    public void reindex() {
        this.engine.resetIndex();
    }

    @GET
    @Path(value="pending")
    public int pendingTasks() {
        return this.engine.pendingTasks();
    }

    @GET
    public SearchPage search(@QueryParam(value="query") String query, @QueryParam(value="tag") List<String> tags, @QueryParam(value="category") List<String> categories, @QueryParam(value="role") List<String> roles, @QueryParam(value="app") List<String> apps, @QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="max") @DefaultValue(value="20") int max) {
        return this.engine.search(new SearchRequest(query, tags, categories, roles, apps, page, max));
    }

    @Path(value="top")
    @GET
    public SearchPage top(@Context UriInfo uriInfo, @Context HttpHeaders headers, @QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="max") @DefaultValue(value="20") int max) {
        throw new UnsupportedOperationException();
    }
}

