/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources.util;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.repository.Repository;

public final class ApplicationWrapperUtil {
    private ApplicationWrapperUtil() {
    }

    public static Swagger shrinkSwagger(Swagger swagger) {
        Swagger applicationClone = Repository.createShallowCopy((Swagger)swagger);
        Map paths = applicationClone.getPaths();
        if (paths != null) {
            HashMap shrunkPaths = new HashMap();
            for (Map.Entry pathEntry : paths.entrySet()) {
                Path shrunkPath = new Path();
                shrunkPaths.put(pathEntry.getKey(), shrunkPath);
                for (Map.Entry httpMethodOperationEntry : ((Path)pathEntry.getValue()).getOperationMap().entrySet()) {
                    Operation shrunkOperation = new Operation();
                    shrunkOperation.setDescription(((Operation)httpMethodOperationEntry.getValue()).getDescription());
                    shrunkOperation.setSummary(((Operation)httpMethodOperationEntry.getValue()).getSummary());
                    shrunkPath.set(((HttpMethod)httpMethodOperationEntry.getKey()).name().toLowerCase(), shrunkOperation);
                }
            }
            applicationClone.setPaths(shrunkPaths);
        }
        return applicationClone;
    }

    public static Swagger mergeSwagger(Swagger swagger, Collection<Endpoint> endpoints) {
        Swagger result = Repository.createShallowCopy((Swagger)swagger);
        HashMap<String, Path> newPaths = new HashMap<String, Path>();
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                Path newPath = (Path)newPaths.get(endpoint.getPath());
                if (newPath == null) {
                    newPath = new Path();
                    newPaths.put(endpoint.getPath(), newPath);
                }
                newPath.set(endpoint.getVerb().toLowerCase(), endpoint.getOperation());
            }
        }
        result.setPaths(newPaths);
        return result;
    }
}

