/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.service.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.complexPhrase.ComplexPhraseQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.tomitribe.tribestream.registryng.domain.CloudItem;
import org.tomitribe.tribestream.registryng.domain.SearchPage;
import org.tomitribe.tribestream.registryng.domain.SearchResult;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.lucene.JPADirectoryFactory;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.service.search.SearchRequest;
import org.tomitribe.util.Duration;
import org.tomitribe.util.IO;
import org.tomitribe.util.Join;

/*
 * Exception performing whole class analysis ignored.
 */
@Startup
@Singleton
@Lock(value=LockType.READ)
@TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
public class SearchEngine {
    private static final Logger LOGGER = Logger.getLogger(SearchEngine.class.getName());
    private static final String APPLICATION_ID_FIELD = "applicationId";
    private static final String ENDPOINT_ID_FIELD = "endpointId";
    private static final String VERB = "verb";
    private static final String HTTP_METHOD = "httpMethod";
    private static final String PATH = "path";
    private static final String DOC = "doc";
    private static final String SUMMARY = "summary";
    private final Duration duration;
    private final Repository repository;
    private final Directory indexDir;
    private final Directory indexFacetsDir;
    @Resource
    private SessionContext ctx;
    private DirectoryReader reader;
    private IndexSearcher searcher;
    private IndexWriter writer;
    private DirectoryTaxonomyWriter taxonomyWriter;
    private DirectoryTaxonomyReader taxonomyReader;
    private FacetsConfig facetsConfig = new FacetsConfig();
    private final BlockingQueue<Future<?>> pendingAdd = new LinkedBlockingQueue();
    private final BlockingQueue<Future<?>> pendingRemove = new LinkedBlockingQueue();
    private volatile boolean closed;
    private Analyzer analyzer;
    private Duration writeTimeout = new Duration("1 minute");

    @Inject
    public SearchEngine(Repository repository, JPADirectoryFactory directory) {
        this.duration = new Duration(10L, TimeUnit.SECONDS);
        this.repository = repository;
        this.indexDir = directory.newInstance("index");
        this.indexFacetsDir = directory.newInstance("facets");
    }

    protected SearchEngine() {
        this(null, null);
    }

    public SearchPage search(SearchRequest request) {
        int pageSize = request.getCount();
        try {
            IndexSearcher indexSearcher = this.searcher();
            if (indexSearcher == null) {
                return new SearchPage(new ArrayList(), 0, 0, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            Stream.of(this.createQuery(request.getQuery()), this.drillDownFor("category", request.getCategories()), this.drillDownFor("tag", request.getTags()), this.drillDownFor("role", request.getRoles())).filter(q -> q != null).forEach(q -> query.add(q, BooleanClause.Occur.MUST));
            if (request.getApps() != null && request.getApps().size() > 0) {
                BooleanQuery.Builder appFilter = new BooleanQuery.Builder();
                appFilter.setMinimumNumberShouldMatch(1);
                for (String s : request.getApps()) {
                    appFilter.add((Query)new TermQuery(new Term("context", s)), BooleanClause.Occur.SHOULD);
                    appFilter.add((Query)new TermQuery(new Term("applicationName", s)), BooleanClause.Occur.SHOULD);
                }
                query.add((Query)appFilter.build(), BooleanClause.Occur.MUST);
            }
            TopScoreDocCollector topScoreDocCollector = TopScoreDocCollector.create((int)((request.getPage() + 1) * pageSize));
            FacetsCollector facetsCollector = new FacetsCollector(true);
            indexSearcher.search((Query)query.build(), MultiCollector.wrap((Collector[])new Collector[]{topScoreDocCollector, facetsCollector}));
            TopDocs searchResult = topScoreDocCollector.topDocs(request.getPage() * pageSize, pageSize);
            FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts((TaxonomyReader)this.taxonomyReader, this.facetsConfig, facetsCollector);
            FacetResult category = facets.getTopChildren(10, "category", new String[0]);
            FacetResult tag = facets.getTopChildren(10, "tag", new String[0]);
            FacetResult role = facets.getTopChildren(10, "role", new String[0]);
            FacetResult context = facets.getTopChildren(10, "context", new String[0]);
            LinkedList<SearchResult> results = new LinkedList<SearchResult>();
            for (ScoreDoc sd : searchResult.scoreDocs) {
                Document doc = this.searcher.doc(sd.doc);
                results.add(new SearchResult(doc.get("endpointId"), doc.get("applicationId"), doc.get("endpointId"), doc.get("applicationName"), doc.get("applicationVersion"), doc.get("verb"), doc.get("path"), doc.get("summary"), new HashSet(), new HashSet(), false, false, sd.score));
            }
            return new SearchPage(results, searchResult.totalHits, request.getPage(), this.toCloudItems(context), this.toCloudItems(category), this.toCloudItems(tag), this.toCloudItems(role));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Collection<CloudItem> toCloudItems(FacetResult result) {
        ArrayList<CloudItem> cloudItems = new ArrayList<CloudItem>();
        if (result != null) {
            for (LabelAndValue labelAndValue : result.labelValues) {
                cloudItems.add(new CloudItem(labelAndValue.label, labelAndValue.value.intValue()));
            }
        }
        return cloudItems;
    }

    private BooleanQuery drillDownFor(String key, List<String> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder().setDisableCoord(true);
        for (String value : values) {
            String indexFieldName = this.facetsConfig.getDimConfig((String)key).indexFieldName;
            query.add((Query)new TermQuery(DrillDownQuery.term((String)indexFieldName, (String)key, (String[])new String[]{value})), BooleanClause.Occur.MUST);
        }
        return query.build();
    }

    private Query createQuery(String query) throws ParseException {
        if (query == null || query.isEmpty()) {
            return null;
        }
        ComplexPhraseQueryParser queryParser = new ComplexPhraseQueryParser("search", this.analyzer);
        queryParser.setAllowLeadingWildcard(true);
        queryParser.setDefaultOperator(QueryParser.Operator.AND);
        int pathStart = query.indexOf("path:");
        if (pathStart >= 0) {
            int pathEnd = Math.max(query.indexOf(" ", pathStart), query.length());
            String escapedPath = "path:" + query.substring(pathStart + "path:".length(), pathEnd).replace("/", "\\/") + query.substring(pathEnd);
            return queryParser.parse(escapedPath);
        }
        return queryParser.parse(query);
    }

    @PostConstruct
    private void createIndex() {
        HashMap<String, KeywordAnalyzer> fieldAnalyzers = new HashMap<String, KeywordAnalyzer>();
        KeywordAnalyzer keywordAnalyzer = new KeywordAnalyzer();
        fieldAnalyzers.put("applicationId", keywordAnalyzer);
        fieldAnalyzers.put("endpointId", keywordAnalyzer);
        fieldAnalyzers.put("category", keywordAnalyzer);
        fieldAnalyzers.put("tag", keywordAnalyzer);
        fieldAnalyzers.put("role", keywordAnalyzer);
        fieldAnalyzers.put("context", keywordAnalyzer);
        fieldAnalyzers.put("path", keywordAnalyzer);
        fieldAnalyzers.put("httpMethod", keywordAnalyzer);
        fieldAnalyzers.put("application", keywordAnalyzer);
        fieldAnalyzers.put("applicationName", keywordAnalyzer);
        fieldAnalyzers.put("applicationVersion", keywordAnalyzer);
        fieldAnalyzers.put("doc", keywordAnalyzer);
        fieldAnalyzers.put("summary", keywordAnalyzer);
        this.analyzer = new PerFieldAnalyzerWrapper((Analyzer)new EnglishAnalyzer(), fieldAnalyzers);
        try {
            IndexWriterConfig writerConfig = new IndexWriterConfig(this.analyzer);
            this.writer = new IndexWriter(this.indexDir, writerConfig);
            this.taxonomyWriter = new DirectoryTaxonomyWriter(this.indexFacetsDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.facetsConfig.setMultiValued("category", true);
        this.facetsConfig.setMultiValued("tag", true);
        this.facetsConfig.setMultiValued("role", true);
        this.closed = false;
    }

    public Future<?> resetIndex() {
        this.waitForWrites();
        Future future = ((SearchEngine)this.ctx.getBusinessObject(SearchEngine.class)).doReindex();
        this.pendingRemove.add(future);
        this.pendingAdd.add(future);
        return future;
    }

    @Asynchronous
    @Lock(value=LockType.WRITE)
    public Future<?> doReindex() {
        try {
            this.removeIndex().get();
            this.doIndex().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.log(Level.WARNING, "Unexpected exception while reindexing", e);
        }
        return new AsyncResult(null);
    }

    public int pendingTasks() {
        return this.pendingAdd.size() + this.pendingRemove.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher searcher() {
        block18: {
            SearchEngine e2;
            if (this.searcher == null) {
                try {
                    if (!DirectoryReader.indexExists((Directory)this.indexDir)) {
                        return null;
                    }
                }
                catch (IOException e2) {
                    return null;
                }
                e2 = this;
                synchronized (e2) {
                    if (this.searcher == null) {
                        try {
                            this.reader = DirectoryReader.open((Directory)this.indexDir);
                            this.searcher = new IndexSearcher((IndexReader)this.reader);
                            this.taxonomyReader = new DirectoryTaxonomyReader(this.taxonomyWriter);
                        }
                        catch (IndexNotFoundException infe) {
                            return null;
                        }
                        catch (IOException e3) {
                            throw new IllegalStateException(e3);
                        }
                    }
                }
            }
            try {
                if (this.reader.isCurrent()) break block18;
                e2 = this;
                synchronized (e2) {
                    if (!this.reader.isCurrent()) {
                        DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)this.reader);
                        if (newReader != null) {
                            this.reader.close();
                            this.reader = newReader;
                        }
                        this.searcher = new IndexSearcher((IndexReader)this.reader);
                        this.taxonomyReader = new DirectoryTaxonomyReader(this.taxonomyWriter);
                    }
                }
            }
            catch (IOException e4) {
                throw new IllegalStateException(e4);
            }
        }
        return this.searcher;
    }

    @Asynchronous
    @Lock(value=LockType.WRITE)
    public Future<?> doIndex() {
        if (this.indexDir == null) {
            return new AsyncResult((Object)true);
        }
        if (this.writer == null) {
            return new AsyncResult((Object)true);
        }
        if (this.taxonomyWriter == null) {
            return new AsyncResult((Object)true);
        }
        Collection allEndpoints = this.repository.findAllEndpoints();
        LOGGER.info(() -> String.format("FOUND %s endpoints", allEndpoints.size()));
        for (Endpoint endpoint : allEndpoints) {
            this.indexEndpoint(endpoint, false);
        }
        return new AsyncResult((Object)true);
    }

    public void indexEndpoint(Endpoint endpoint, boolean update) {
        LOGGER.info(() -> String.format("Indexing %s %s", endpoint.getVerb(), endpoint.getPath()));
        String webCtx = endpoint.getApplication().getSwagger().getBasePath();
        try {
            Document eDoc = this.createDocument(endpoint, webCtx);
            this.addFacets(endpoint, webCtx != null ? webCtx : "/", eDoc);
            Document document = this.facetsConfig.build((TaxonomyWriter)this.taxonomyWriter, eDoc);
            if (update) {
                this.writer.addDocument((Iterable)document);
            } else {
                this.writer.updateDocument(new Term("endpointId", endpoint.getId()), (Iterable)document.getFields());
            }
            this.writer.commit();
            this.waitWrite();
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, ioe, () -> String.format("Can't flush index for application %s", webCtx));
        }
    }

    public void deleteEndpoint(Endpoint endpoint) {
        LOGGER.info(() -> String.format("Deleting Index %s %s", endpoint.getVerb(), endpoint.getPath()));
        String webCtx = endpoint.getApplication().getSwagger().getBasePath();
        try {
            this.writer.deleteDocuments(new Query[]{this.endpointQuery(endpoint)});
            this.writer.commit();
            this.waitWrite();
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, ioe, () -> String.format("Can't flush index for application %s", webCtx));
        }
    }

    private BooleanQuery endpointQuery(Endpoint endpoint) {
        return new BooleanQuery.Builder().add((Query)new TermQuery(new Term("applicationId", endpoint.getApplication().getId())), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("endpointId", endpoint.getId())), BooleanClause.Occur.MUST).build();
    }

    private void waitWrite() throws InterruptedException {
        long remaining;
        long pauseDuration = 200L;
        for (remaining = this.writeTimeout.getTime(TimeUnit.MILLISECONDS); this.writer.hasPendingMerges() && remaining > 0L; remaining -= 200L) {
            Thread.sleep(200L);
        }
        if (remaining <= 0L) {
            throw new IllegalStateException("Can't save the index properly, you should check what happens");
        }
    }

    private void addFacets(Endpoint endpoint, String web, Document doc) {
        this.addFacetFields(doc, (Collection)this.getExtensionProperty(endpoint, "categories", Collections::emptyList), "category");
        this.addFacetFields(doc, (Collection)endpoint.getOperation().getTags(), "tag");
        this.addFacetFields(doc, (Collection)this.getExtensionProperty(endpoint, "roles", Collections::emptyList), "role");
        if (!web.isEmpty()) {
            doc.add((IndexableField)new FacetField("context", new String[]{web}));
        }
    }

    private void addFacetFields(Document doc, Collection<String> set, String name) {
        if (set != null) {
            for (String value : set) {
                doc.add((IndexableField)new FacetField(name, new String[]{value}));
            }
        }
    }

    private Document createDocument(Endpoint endpoint, String webCtx) {
        String doc;
        String defaultDoc;
        OpenApiDocument application = endpoint.getApplication();
        Document eDoc = new Document();
        eDoc.add(SearchEngine.field((String)"applicationId", (String)application.getId(), (boolean)true));
        eDoc.add(SearchEngine.field((String)"endpointId", (String)endpoint.getId(), (boolean)true));
        eDoc.add(SearchEngine.field((String)"applicationName", (String)endpoint.getApplication().getSwagger().getInfo().getTitle(), (boolean)true));
        eDoc.add(SearchEngine.field((String)"applicationVersion", (String)endpoint.getApplication().getSwagger().getInfo().getVersion(), (boolean)true));
        if (webCtx != null && !webCtx.isEmpty()) {
            eDoc.add(SearchEngine.field((String)"context", (String)webCtx, (boolean)true));
        }
        if (application.getSwagger().getHost() != null) {
            eDoc.add(SearchEngine.field((String)"host", (String)application.getSwagger().getHost(), (boolean)true));
        }
        if ((defaultDoc = application.getSwagger().getInfo().getDescription()) != null && !defaultDoc.isEmpty()) {
            eDoc.add(SearchEngine.field((String)"applicationDoc", (String)defaultDoc, (boolean)false));
        }
        eDoc.add(SearchEngine.field((String)"path", (String)endpoint.getPath(), (boolean)true));
        eDoc.add(SearchEngine.field((String)"httpMethod", (String)endpoint.getVerb()));
        eDoc.add(SearchEngine.field((String)"verb", (String)endpoint.getVerb(), (boolean)true));
        for (String value : (List)this.getExtensionProperty(endpoint, "categories", Collections::emptyList)) {
            eDoc.add(SearchEngine.field((String)"category", (String)value));
        }
        if (endpoint.getOperation().getTags() != null) {
            for (String value : endpoint.getOperation().getTags()) {
                eDoc.add(SearchEngine.field((String)"tag", (String)value));
            }
        }
        for (String value : (List)this.getExtensionProperty(endpoint, "roles", Collections::emptyList)) {
            eDoc.add(SearchEngine.field((String)"role", (String)value));
        }
        String summary = endpoint.getOperation().getSummary();
        if (summary != null && !summary.isEmpty()) {
            eDoc.add(SearchEngine.field((String)"summary", (String)summary, (boolean)true));
        }
        if ((doc = endpoint.getOperation().getDescription()) != null && !doc.isEmpty()) {
            eDoc.add(SearchEngine.field((String)"doc", (String)doc));
        }
        String[] split = endpoint.getPath().split("[-_:/]");
        ArrayList<String> pathSplit = new ArrayList<String>();
        for (String s : split) {
            if (s.length() == 0) continue;
            pathSplit.add(s);
            for (int i = 0; i < s.length() - 1; ++i) {
                for (int j = 2; j <= s.length() - i; ++j) {
                    String sub = s.substring(i, i + j);
                    if (s.equals(sub)) continue;
                    pathSplit.add(sub);
                }
            }
        }
        String tags = endpoint.getOperation().getTags() == null ? "" : Join.join((String)",", (Collection)endpoint.getOperation().getTags());
        String search = endpoint.getVerb() + " " + endpoint.getPath() + " " + Join.join((String)",", pathSplit) + " " + Join.join((String)",", (Collection)((List)this.getExtensionProperty(endpoint, "categories", Collections::emptyList))) + " " + Join.join((String)",", (Collection)((List)this.getExtensionProperty(endpoint, "roles", Collections::emptyList))) + " " + tags + " " + (doc == null ? "" : doc) + " " + webCtx;
        eDoc.add(SearchEngine.field((String)"search", (String)search));
        return eDoc;
    }

    private <T> T getExtensionProperty(Endpoint endpoint, String extensionPropertyName, Supplier<T> defaultSupplier) {
        return (T)Optional.ofNullable(endpoint.getOperation().getVendorExtensions()).map(vendorExtensions -> (Map)vendorExtensions.get("x-tribestream-api-registry")).map(tapirExtension -> tapirExtension.get(extensionPropertyName)).orElseGet(defaultSupplier);
    }

    public void waitForWrites() {
        this.flushTasks(this.pendingAdd);
        this.flushTasks(this.pendingRemove);
    }

    @Asynchronous
    @Lock(value=LockType.WRITE)
    public Future<?> removeIndex() {
        this.flushTasks(this.pendingAdd);
        IndexWriter w = this.writer;
        if (w == null) {
            return new AsyncResult((Object)true);
        }
        try {
            w.deleteAll();
            w.deleteUnusedFiles();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Can't clear index", e);
        }
        finally {
            try {
                w.commit();
            }
            catch (IOException iOException) {}
        }
        return new AsyncResult((Object)true);
    }

    @PreDestroy
    private void releaseIndex() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.waitForWrites();
        if (this.reader != null) {
            IO.close((Closeable)this.reader);
            this.reader = null;
        }
        if (this.writer != null) {
            IO.close((Closeable)this.writer);
            this.writer = null;
        }
        if (this.taxonomyWriter != null) {
            IO.close((Closeable)this.taxonomyWriter);
            this.taxonomyWriter = null;
        }
        if (this.taxonomyReader != null) {
            IO.close((Closeable)this.taxonomyReader);
            this.taxonomyReader = null;
        }
        if (this.indexDir != null) {
            try {
                this.indexDir.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (this.indexFacetsDir != null) {
            try {
                this.indexFacetsDir.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void flushTasks(BlockingQueue<Future<?>> tasks) {
        ArrayList list = new ArrayList(tasks.size());
        tasks.drainTo(list);
        for (Future task : list) {
            try {
                long iterations = this.duration.getUnit().toMillis(this.duration.getTime()) / 250L;
                for (long i = 0L; i < iterations; ++i) {
                    while (!task.isDone() && !task.isCancelled()) {
                        task.get(250L, TimeUnit.MILLISECONDS);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.warning("Interrupted while waiting for tasks to finish");
                Thread.interrupted();
            }
            catch (Exception exception) {
            }
        }
    }

    private static IndexableField field(String name, String value, boolean store) {
        return new StringField(name, value, store ? Field.Store.YES : Field.Store.NO);
    }

    private static IndexableField field(String name, String value) {
        return new StringField(name, value, Field.Store.NO);
    }
}

