/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.service.serialization;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.tomitribe.tribestream.registryng.service.serialization.SwaggerJsonMapperProducer;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomJacksonJaxbJsonProvider
extends JacksonJaxbJsonProvider {
    private static final Logger LOGGER = Logger.getLogger(CustomJacksonJaxbJsonProvider.class.getName());

    public CustomJacksonJaxbJsonProvider() {
        super(SwaggerJsonMapperProducer.lookup(), JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Reading entity failed!", e);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            return super.getSize(value, type, genericType, annotations, mediaType);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Getting size for writing entity failed!", e);
            throw new RuntimeException(e);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            return super.isWriteable(type, genericType, annotations, mediaType);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Checking if entity is writable failed!", e);
            throw new RuntimeException(e);
        }
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            super.writeTo(value, type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Writing entity failed!", e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Writing entity failed!", e);
            throw new IOException(e);
        }
    }
}

