angular.module("website-components",["ui.codemirror","hc.marked","website-components-filters","website-components-multiselect","website-components-singleselect","website-components-text","website-components-markdown"]).directive("tribeEditableButtonText",[function(){return{restrict:"A",scope:{value:"="},templateUrl:"app/templates/component_editable_button_text.html"}}]).directive("tribeEditableLink",["$document",function($document){return{restrict:"A",scope:{href:"=",title:"=",emptyText:"@?"},templateUrl:"app/templates/component_editable_link.html",controller:["$scope",function($scope){$scope.emptyText&&""!==$scope.emptyText.trim()||($scope.emptyText="Empty link")}],link:function(scope,el,attrs,controller){var valueDiv=el.find(".value");valueDiv.detach();var body=$document.find("body"),clear=function(){el.removeClass("visible"),valueDiv.detach()},elWin=$($document.find("div[data-app-endpoints-details] > div"));el.find("div.edit-trigger").on("click",function(){if(el.hasClass("visible"))valueDiv.detach(),el.removeClass("visible"),valueDiv.off("scroll",clear);else{var pos=el.find("> div").offset();valueDiv.css({top:pos.top+el.find("> div").outerHeight()+"px",left:pos.left+"px"}),body.append(valueDiv),el.addClass("visible"),elWin.on("scroll",clear)}}),scope.$on("$destroy",function(){valueDiv.remove(),elWin.off("scroll",clear)})}}}]).directive("tribeEditableMd",[function(){return{restrict:"A",scope:{content:"="},templateUrl:"app/templates/component_editable_md.html",controller:["$scope","$timeout","$element",function($scope,$timeout,$element){$scope.editorHolder={editor:null},$scope.cmOption={lineNumbers:!1,lineWrapping:!0,viewportMargin:1/0,mode:"markdown",onLoad:function(editor){$timeout(function(){$scope.$apply(function(){$scope.editorHolder.editor=editor})})}},$scope.$watch("content",function(){$timeout(function(){$scope.$apply(function(){$scope.content&&""!==$scope.content.trim()?$scope.compiledContent=marked($scope.content):$scope.compiledContent=""})})}),$scope.codemirrorLoaded=function(_editor){_editor.on("blur",function(){$element.removeClass("edit")})}}],link:function(scope,el,attr,controller){scope.$watch("editorHolder.editor",function(){var editor=scope.$eval("editorHolder.editor");if(editor){var activate=function(){el.addClass("edit"),editor.refresh(),editor.focus()};el.on("click",activate),el.find("> div").on("focus",activate),editor.on("blur",function(){el.removeClass("edit")})}})}}}]).directive("tribeEditableBlock",[function(){return{restrict:"A",scope:{content:"="},templateUrl:"app/templates/component_editable_block.html",controller:["$scope","$timeout",function($scope,$timeout){$scope.editorHolder={editor:null},$scope.cmOption={lineNumbers:!1,lineWrapping:!0,viewportMargin:1/0,onLoad:function(editor){$timeout(function(){$scope.$apply(function(){$scope.editorHolder.editor=editor})})}}}],link:function(scope,el,attr,controller){scope.$watch("editorHolder.editor",function(){var editor=scope.$eval("editorHolder.editor");if(editor){editor.refresh();var activate=function(){el.addClass("edit"),editor.refresh(),editor.focus()};el.on("click",activate),el.find("> div").on("focus",activate),editor.on("blur",function(){el.removeClass("edit")})}})}}}]).directive("tribeEditableNumber",["$timeout",function($timeout){return{restrict:"A",scope:{value:"=",adjust:"@?"},templateUrl:"app/templates/component_editable_number.html",link:function(scope,el,attrs,controller){var activate=function(){var span=el.find("span"),width=span.width();el.addClass("edit");var input=el.find("input");"false"!==scope.adjust&&input.width(width),input.focus()};el.on("click",activate),el.find("input").on("blur",function(){el.removeClass("edit")}),el.find("> div").on("focus",activate)}}}]).directive("tribeEditableText",["$timeout","$interval",function($timeout,$interval){return{restrict:"A",scope:{value:"=",adjust:"@?",emptyText:"@?"},templateUrl:"app/templates/component_editable_text.html",link:function(scope,el){$timeout(function(){var activate=function(){var span=el.find("span"),width=span.width();el.addClass("edit");var input=el.find("input");"false"!==scope.adjust&&input.width(width),input.focus()};el.on("click",activate),el.find("input").on("blur",function(){el.removeClass("edit")}),el.find("> div").on("focus",activate)})}}}]).directive("tribeEditableOption",["$timeout","$document",function($timeout,$document){return{restrict:"A",scope:{value:"=",options:"=",emptyText:"@?"},templateUrl:"app/templates/component_editable_option.html",controller:["$scope","$timeout",function($scope,$timeout){$scope.visible=!1,$scope.emptyText||($scope.emptyText="empty"),$scope.selectOption=function(opt){return $timeout(function(){return $scope.$apply(function(){$scope.value=opt,$scope.visible=!1})})},$scope.$watch("value",function(){$timeout($scope.value?function(){return $scope.$apply(function(){for(var _i=0,_a=$scope.options;_i<_a.length;_i++){var opt=_a[_i];if(opt===$scope.value||opt.value===$scope.value)return void($scope.valueText=opt.text?opt.text:opt)}$scope.valueText=""})}:function(){return $scope.$apply(function(){return $scope.valueText=""})})}),$scope.open=function(){return $timeout(function(){return $scope.$apply(function(){$scope.visible=!0})})}}],link:function(scope,el){return $timeout(function(){var optionsDiv=el.find(".options");optionsDiv.detach();var body=$document.find("body"),detachOptions=function(){optionsDiv.detach(),el.removeClass("visible"),$timeout(function(){return scope.$apply(function(){scope.visible=!1})})};el.on("mouseover",function(){$document.off("click",detachOptions)}),optionsDiv.on("mouseover",function(){$document.off("click",detachOptions)}),el.on("mouseout",function(){$document.on("click",detachOptions)}),optionsDiv.on("mouseout",function(){$document.on("click",detachOptions)}),scope.$watch("visible",function(){if(scope.visible){el.addClass("visible");var pos=el.find("> div").offset();optionsDiv.css({top:pos.top+el.find("> div").height()+"px",left:pos.left+"px"}),body.append(optionsDiv),$document.on("click",detachOptions)}else detachOptions(),$document.off("click",detachOptions)});var escapeDetach=function(event){27===event.keyCode&&detachOptions()};$document.on("keyup",escapeDetach),scope.$on("$destroy",function(){el.remove(),optionsDiv.remove(),$document.off("click",detachOptions),$document.off("keyup",escapeDetach)})})}}}]).directive("tribeSwitch",["$timeout",function($timeout){return{restrict:"A",scope:{value:"=",trueValue:"=?",falseValue:"=?"},templateUrl:"app/templates/component_switch.html",link:function(scope,el){scope.uniqueId=_.uniqueId("tribeSwitch-");var updateValue=function(){$timeout(function(){scope.$apply(function(){scope.value=!scope.value})})};el.find("div[tabindex]").on("click",updateValue),el.find("div[tabindex]").on("keypress",updateValue)},controller:["$scope",function($scope){(_.isNull($scope.trueValue)||_.isUndefined($scope.trueValue))&&($scope.trueValue=!0),(_.isNull($scope.falseValue)||_.isUndefined($scope.falseValue))&&($scope.falseValue=!1)}]}}]),angular.module("website-components-field-actions",[]).directive("tribeFieldActions",["$interval","$document",function($interval,$document){return{restrict:"A",scope:{onCancel:"&",onConfirm:"&",active:"=",version:"="},templateUrl:"app/templates/component_field_actions.html",controller:["$scope",function($scope){$scope.confirm=function(){return $scope.onConfirm()},$scope.cancel=function(){return $scope.onCancel()}}],link:function(scope,element,attrs,controller){var floatingBody=angular.element(element.find("> div"));floatingBody.detach();var body=$document.find("body"),adjustOffset=function(){if(floatingBody.parent().length){var position=element.offset();floatingBody.offset(position)}};scope.$watch("active",function(){scope.active?(body.append(floatingBody),adjustOffset()):floatingBody.detach()});var adjustInterval=$interval(adjustOffset,500);scope.$on("$destroy",function(){$interval.cancel(adjustInterval),floatingBody.remove(),element.remove()})}}}]),angular.module("website-components-filters",[]).filter("uriencode",["$window",function($window){return $window.encodeURIComponent}]).filter("pathencode",[function(){return function(input){return"/"===input?"/":input.split("/").map(function(part){return part.match("{.*}")?":"+part.slice(1,-1):part}).join("/")}}]).filter("tribeHtml",["$sce",function($sce){return function(input){return $sce.trustAsHtml(input)}}]).filter("tribeHtmlText",[function(){return function(input){var el=angular.element("<div></div>");return el.append(input),el.text()}}]),angular.module("website-components-markdown-service",[]).factory("tribeMarkdownService",[function(){return{compileMd:function(content){if(null===content||void 0===content||""===content.trim())return"";var compiledMd=angular.element("<div></div>");return angular.element(marked(content)).each(function(index,el){compiledMd.append(el)}),compiledMd.find("code").each(function(index,codeTag){var aCode=angular.element(codeTag);aCode.attr("class")&&hljs.highlightBlock(codeTag)}),compiledMd.html()}}}]),angular.module("website-components-markdown",["website-components-field-actions","website-components-filters","website-components-markdown-service"]).directive("tribeMarkdownHelp",["$document","$timeout",function($document,$timeout){return{restrict:"A",scope:{visible:"="},templateUrl:"app/templates/component_markdown_help.html",link:function(scope,el){var content=el.find("> div > div.markdown-help-content");content.detach();var body=$document.find("body"),keyPress=function(event){console.log("event.keyCode -> "+event.keyCode),27===event.keyCode&&$timeout(function(){return scope.$apply(function(){scope.visible=!1})})};scope.$watch("visible",function(){scope.visible?(body.addClass("noscroll"),body.append(content),$document.on("keyup",keyPress)):(content.detach(),body.removeClass("noscroll"),$document.off("keyup",keyPress))}),scope.$on("$destroy",function(){content.remove(),el.remove(),body.removeClass("noscroll"),$document.off("keyup",keyPress)})}}}]).directive("tribeMarkdown",["$window","$timeout","$log","tribeMarkdownService",function($window,$timeout,$log,mdService){return{restrict:"A",scope:{originalValue:"=value"},templateUrl:"app/templates/component_markdown.html",controller:["$scope",function($scope){return $timeout(function(){$scope.helpVisible=!1,$scope.simplemde=null,$scope.version=0,$scope.fieldDirty=!1,$scope.cmFocused=!1,$scope.$watch("originalValue",function(){return $timeout(function(){return $scope.$apply(function(){$scope.value=$scope.originalValue?_.clone($scope.originalValue):""})})}),$scope.$watch("value",function(){return $timeout(function(){return $scope.$apply(function(){$scope.preview=mdService.compileMd($scope.value)})})}),$scope.onCommit=function(){return $timeout(function(){return $scope.$apply(function(){$scope.cmFocused=!1,$scope.fieldDirty&&($scope.fieldDirty=!1,$scope.originalValue=_.clone($scope.value),$scope.$broadcast("fieldCommited"))})})},$scope.onCancel=function(){return $timeout(function(){return $scope.$apply(function(){$scope.fieldDirty=!1,$scope.value=_.clone($scope.originalValue),$scope.$broadcast("fieldCanceled")})})},$scope.onChange=function(newValue){return $timeout(function(){return $scope.$apply(function(){$scope.version=$scope.version+1,$scope.originalValue!==newValue&&($scope.value=newValue,$scope.fieldDirty=!0)})})}})}],link:function(scope,el){return $timeout(function(){var simplemde=null,deactivatePromise=null,cancelDeactivate=function(){deactivatePromise&&$timeout.cancel(deactivatePromise),deactivatePromise=null},deactivate=function(){cancelDeactivate(),deactivatePromise=$timeout(function(){scope.onCommit(),el.removeClass("active"),simplemde&&simplemde.isPreviewActive()&&SimpleMDE.togglePreview(simplemde)},500)},focusAction=function(cm){$log.debug("codemirror focus; cm.getSelection() empty? "+!!cm.getSelection()),cancelDeactivate(),scope.cmFocused||cm.execCommand("selectAll"),$timeout(function(){return scope.$apply(function(){scope.cmFocused=!0,scope.version=scope.version+1,scope.fieldDirty=!0})})},anchorEl=el.find("div.value > textarea")[0],actionClick=function(editor,callback){cancelDeactivate(),callback(editor),editor.codemirror.off("focus",focusAction),editor.codemirror.focus(),editor.codemirror.on("focus",focusAction)};simplemde=new SimpleMDE({element:anchorEl,status:!1,spellChecker:!1,previewRender:mdService.compileMd,toolbar:["bold","italic","heading","quote"],toolbar:[{name:"bold",action:function(editor){return actionClick(editor,SimpleMDE.toggleBold)},className:"fa fa-bold",title:"Bold"},{name:"italic",action:function(editor){return actionClick(editor,SimpleMDE.toggleItalic)},className:"fa fa-italic",title:"Italic"},{name:"heading",action:function(editor){return actionClick(editor,SimpleMDE.toggleHeadingSmaller)},className:"fa fa-header",title:"Heading"},"|",{name:"code",action:function(editor){return actionClick(editor,SimpleMDE.toggleCodeBlock)},className:"fa fa-code",title:"Code"},{name:"quote",action:function(editor){return actionClick(editor,SimpleMDE.toggleBlockquote)},className:"fa fa-quote-left",title:"Quote"},{name:"unordered-list",action:function(editor){return actionClick(editor,SimpleMDE.toggleUnorderedList)},className:"fa fa-list-ul",title:"Generic List"},{name:"ordered-list",action:function(editor){return actionClick(editor,SimpleMDE.toggleOrderedList)},className:"fa fa-list-ol",title:"Numbered List"},{name:"clean-block",action:function(editor){return actionClick(editor,SimpleMDE.cleanBlock)},className:"fa fa-eraser fa-clean-block",title:"Clean block"},"|",{name:"preview",action:function(editor){return $timeout(function(){return scope.$apply(function(){cancelDeactivate(),SimpleMDE.togglePreview(editor),editor.isPreviewActive()||editor.codemirror.focus()})})},className:"fa fa-eye no-disable",title:"Toggle Preview"},{name:"guide",action:function(editor){return $timeout(function(){return scope.$apply(function(){scope.helpVisible=!0})})},className:"fa fa-question-circle",title:"Markdown Guide"}]}),simplemde.codemirror.on("change",function(){scope.onChange(simplemde.value())}),simplemde.codemirror.on("focus",focusAction),simplemde.codemirror.on("blur",function(){return $timeout(function(){deactivate()})});var disablePreview=function(){simplemde.isPreviewActive()&&simplemde.togglePreview()};scope.$on("fieldCanceled",disablePreview),scope.$watch("value",function(){return $timeout(function(){$log.debug("scope.fieldDirty = "+scope.fieldDirty+"; scope.value = "+scope.value),scope.fieldDirty||simplemde.value(scope.value?scope.value:"")})}),scope.$on("$destroy",function(){el.remove()}),el.find("> div").on("focus",function(){el.addClass("active"),$timeout(function(){return simplemde.codemirror.focus()})})})}}}]),angular.module("website-components-multiselect",["website-components-field-actions"]).directive("tribeMultiselect",["$window","$timeout",function($window,$timeout){return{restrict:"A",scope:{originalAvailableOptions:"=availableOptions",originalSelectedOptions:"=selectedOptions",originalGetOptionText:"=getOptionText",newLabel:"@?"},templateUrl:"app/templates/component_multiselect.html",controller:["$log","$scope","$timeout",function($log,$scope,$timeout){return $timeout(function(){$scope.$watch("originalGetOptionText",function(){$scope.originalGetOptionText?$scope.getOptionText=$scope.originalGetOptionText:$scope.getOptionText=function(item){return item&&void 0!==item.text?item.text:item}}),$scope.$watch("originalSelectedOptions",function(){return $timeout(function(){return $scope.$apply(function(){$scope.originalSelectedOptions?$scope.selectedOptions=_.clone($scope.originalSelectedOptions):$scope.selectedOptions=[]})})}),$scope.$watch("originalAvailableOptions",function(){$scope.availableOptions=_.clone($scope.originalAvailableOptions)}),$scope.fieldDirty=!1,$scope.optionsActivated=!1,$scope.optionsActivatedTopDown=0,$scope.optionsActivatedBottomUp=0,$scope.version=0,$scope.selectedOption=null,$scope.inputText="",$scope.fieldChanged=function(){return $timeout(function(){return $scope.$apply(function(){$scope.fieldDirty=!0,$scope.version=$scope.version+1})})},$scope.fieldCommitted=function(){return $timeout(function(){return $scope.$apply(function(){$scope.onCommit(),$scope.$broadcast("fieldCommitted")})})},$scope.onCommit=function(){return $timeout(function(){return $scope.$apply(function(){$scope.fieldDirty&&($scope.fieldDirty=!1,$scope.optionsActivated=!1,$scope.originalSelectedOptions=_.clone($scope.selectedOptions),$log.debug("field committed. values: "+$scope.selectedOptions))})})},$scope.fieldCanceled=function(){$scope.fieldDirty=!1,$scope.selectedOptions=_.clone($scope.originalSelectedOptions),$scope.$broadcast("fieldCanceled")},$scope.onSelectTopDownOption=function(){return $timeout(function(){return $scope.$apply(function(){$scope.optionsActivatedTopDown=$scope.optionsActivatedTopDown+1,$scope.optionsActivated=!0})})},$scope.onSelectBottomUpOption=function(){return $timeout(function(){return $scope.$apply(function(){$scope.optionsActivatedBottomUp=$scope.optionsActivatedBottomUp+1,$scope.optionsActivated=!0})})},$scope.onOptionsDeactivated=function(){return $timeout(function(){return $scope.$apply(function(){$scope.optionsActivated=!1})})}})}],link:function(scope,el){return $timeout(function(){var deactivatePromise=null,cancelDeactivate=function(){deactivatePromise&&$timeout.cancel(deactivatePromise),deactivatePromise=null},deactivate=function(){cancelDeactivate(),deactivatePromise=$timeout(function(){scope.onCommit(),el.removeClass("active")},500)};el.find("> div").on("focus",function(){return el.find("input").focus()}),el.find("input").on("focus",function(){cancelDeactivate(),el.addClass("active"),$timeout(function(){return scope.$apply(function(){return scope.fieldDirty=!0})})}),el.find("input").on("blur",deactivate),scope.$on("fieldDirty",function(){scope.fieldDirty&&(cancelDeactivate(),el.addClass("active"))}),scope.$on("$destroy",function(){return el.remove()}),scope.$on("fieldCanceled",function(){return $timeout(function(){return el.find("input").blur()})}),scope.$on("fieldCommitted",function(){return $timeout(function(){return el.find("input").blur()})})})}}}]).directive("tribeMultiselectAvailable",["$document","$window","$timeout",function($document,$window,$timeout){return{restrict:"A",scope:{selectedOptions:"=",originalAvailableOptions:"=availableOptions",active:"=",activeTopDown:"=",activeBottomUp:"=",onSelect:"&",inputText:"=",selectedItem:"=selectedOption",newLabel:"@?",getOptionText:"="},templateUrl:"app/templates/component_multiselect_available.html",controller:["$scope","$timeout",function($scope,$timeout){$scope.availableOptions=[],$scope.showOptions=function(){return $timeout(function(){return $scope.$apply(function(){$scope.selectedItem=null,$scope.newOpt=null,$scope.availableOptions=_.clone($scope.originalAvailableOptions);for(var _i=0,_a=$scope.selectedOptions;_i<_a.length;_i++){var opt=_a[_i];$scope.availableOptions=_.without($scope.availableOptions,opt)}$scope.inputText.trim()&&($scope.availableOptions=_.filter($scope.availableOptions,function(opt){return opt.startsWith($scope.inputText)}),$scope.selectedItem=_.find($scope.availableOptions,function(opt){return opt.startsWith($scope.inputText.trim())}),_.find($scope.availableOptions,function(opt){return opt===$scope.inputText.trim()})?$scope.newOpt=null:$scope.newOpt=$scope.inputText.trim(),$scope.selectedItem||($scope.selectedItem=$scope.newOpt))})})},$scope.selectedItem=null,$scope.selectAvailableItem=function(item){return $timeout(function(){return $scope.$apply(function(){$scope.selectedItem=item})})},$scope.selectNext=function(){return $timeout(function(){return $scope.$apply(function(){var ordered=_.sortBy($scope.availableOptions,function(item){return $scope.getOptionText(item).toLowerCase()});if($scope.selectedItem){var index=ordered.indexOf($scope.selectedItem)+1;index>=ordered.length?$scope.newOpt?$scope.selectedItem=$scope.newOpt:$scope.selectedItem=ordered[0]:$scope.selectedItem=ordered[index]}else $scope.selectedItem=_.first(ordered)})})},$scope.selectPrevious=function(){return $timeout(function(){return $scope.$apply(function(){var ordered=_.sortBy($scope.availableOptions,function(item){return $scope.getOptionText(item).toLowerCase()});if($scope.selectedItem)if($scope.newOpt===$scope.selectedItem&&ordered.length)$scope.selectedItem=_.last(ordered);else{var index=ordered.indexOf($scope.selectedItem)-1;0>index?$scope.newOpt?$scope.selectedItem=$scope.newOpt:$scope.selectedItem=_.last(ordered):$scope.selectedItem=ordered[index]}else $scope.newOpt?$scope.selectedItem=$scope.newOpt:$scope.selectedItem=_.last(ordered)})})},$scope.selectItem=function(opt){return $timeout(function(){return $scope.$apply(function(){$scope.selectedOptions.push(opt),$scope.active=!1,$scope.inputText=""})})},$scope.$watch("inputText",function(){$timeout(function(){return $scope.$apply(function(){$scope.inputText?($scope.selectedItem=_.find($scope.availableOptions,function(opt){return opt.startsWith($scope.inputText)}),$scope.active=!0,$scope.showOptions()):($scope.selectedItem=null,$scope.active=!1)})})})}],link:function(scope,element){var floatingBody=angular.element(element.find("> div"));floatingBody.detach();var body=$document.find("body"),adjustOffset=function(){var position=element.offset();floatingBody.offset(position)};scope.$watch("active",function(){scope.active?(body.append(floatingBody),adjustOffset(),scope.showOptions(),element.addClass("active")):($timeout(function(){return scope.$apply(function(){scope.selectedItem=null})}),floatingBody.detach(),element.removeClass("active"))}),scope.$watch("activeTopDown",function(){scope.activeTopDown&&scope.selectNext()}),scope.$watch("activeBottomUp",function(){scope.activeBottomUp&&scope.selectPrevious()}),scope.$watch("version",function(){return adjustOffset()});var eWin=angular.element($window);eWin.bind("resize",adjustOffset),scope.$on("$destroy",function(){eWin.unbind("resize",adjustOffset),floatingBody.remove(),element.remove()})}}}]).directive("tribeMultiselectSelected",[function(){return{restrict:"A",scope:{selectedOptions:"=",onChange:"&",onCommit:"&",onCancel:"&",onSelectTopDownOption:"&",onSelectBottomUpOption:"&",onOptionsDeactivated:"&",selectedOption:"=",inputText:"="},templateUrl:"app/templates/component_multiselect_selected.html",controller:["$log","$scope","$timeout",function($log,$scope,$timeout){$scope.inputText="",$scope.releaseEngaged=!1,$scope.selectedItem=null;var selectOrDeleteLast=function(){return $timeout(function(){return $scope.$apply(function(){var ordered=_.sortBy($scope.selectedOptions,function(item){return item});if($scope.selectedItem){var selectedIndex=ordered.indexOf($scope.selectedItem);$scope.selectedOptions=_.without($scope.selectedOptions,$scope.selectedItem),ordered=_.without(ordered,$scope.selectedItem),ordered.length?(selectedIndex>=ordered.length&&(selectedIndex=ordered.length-1),$scope.selectedItem=ordered[selectedIndex]):$scope.selectedItem=null,$scope.onChange()}else $scope.selectedItem=_.last(ordered)})})},releaseSelection=function(){return $timeout(function(){return $scope.$apply(function(){return $scope.selectedItem=null})})},selectLeft=function(){return $timeout(function(){return $scope.$apply(function(){if($scope.selectedOptions.length)if($scope.selectedItem){var ordered=_.sortBy($scope.selectedOptions,function(item){return item}),next=ordered.indexOf($scope.selectedItem)-1;-1===next&&(next=ordered.length-1),$scope.selectedItem=ordered[next]}else selectOrDeleteLast()})})},selectRight=function(){return $timeout(function(){return $scope.$apply(function(){if($scope.selectedOptions.length){var ordered=_.sortBy($scope.selectedOptions,function(item){return item});if($scope.selectedItem){var next=ordered.indexOf($scope.selectedItem)+1;next===ordered.length&&(next=0),$scope.selectedItem=ordered[next]}else $scope.selectedItem=ordered[0]}})})},addItem=function(){if($scope.selectedOption){var existing=_.find($scope.selectedOptions,function(selected){return selected===$scope.selectedOption});existing||$scope.selectedOptions.push($scope.selectedOption)}$scope.selectedOption=null,$scope.inputText=""};$scope.keyEntered=function(event){return $timeout(function(){return $scope.$apply(function(){if(13===event.keyCode){var isCommitChanges=!$scope.inputText&&!$scope.selectedOption;$log.debug("enter key detected. commit values? "+isCommitChanges),isCommitChanges?($scope.onOptionsDeactivated(),$scope.releaseEngaged=!1,$scope.selectedItem=null,$scope.onCommit()):(addItem(),releaseSelection(),$scope.onOptionsDeactivated(),$scope.onChange())}else if(27===event.keyCode){var isCancelChanges=!$scope.inputText;$scope.inputText="",releaseSelection(),$scope.onOptionsDeactivated(),isCancelChanges&&$scope.onCancel()}else 8===event.keyCode?$scope.inputText||selectOrDeleteLast():37!==event.keyCode||$scope.inputText?39!==event.keyCode||$scope.inputText?40===event.keyCode?$scope.onSelectTopDownOption():38===event.keyCode?$scope.onSelectBottomUpOption():releaseSelection():selectRight():selectLeft()})})},$scope.releaseItem=function(item){$scope.selectedOptions=_.without($scope.selectedOptions,item),$scope.onChange()},$scope.$on("fieldCanceled",function(){return $timeout(function(){return $scope.$apply(function(){$scope.inputText="",$scope.releaseEngaged=!1,$scope.selectedItem=null})})})}]}}]),angular.module("website-components-singleselect",["website-components-field-actions"]).directive("tribeSingleselect",["$window","$timeout",function($window,$timeout){return{restrict:"A",scope:{editable:"@?",originalAvailableOptions:"=availableOptions",originalSelectedOption:"=selectedOption",originalGetOptionText:"=getOptionText",newLabel:"@?"},templateUrl:"app/templates/component_singleselect.html",controller:["$scope","$timeout",function($scope,$timeout){return $timeout(function(){$scope.$watch("originalGetOptionText",function(){$scope.originalGetOptionText?$scope.getOptionText=$scope.originalGetOptionText:$scope.getOptionText=function(item){return item&&void 0!==item.text?item.text:item}}),$scope.getOptionValue=function(item){return item&&void 0!==item.value?item.value:item},void 0===$scope.editable?$scope.editable=!1:$scope.editable="true"===$scope.editable,$scope.selectedItem=null,$scope.inputText=null,$scope.fieldDirty=!1,$scope.optionsActivated=!1,$scope.optionsActivatedTopDown=0,$scope.optionsActivatedBottomUp=0,$scope.version=0,$scope.$watch("originalAvailableOptions",function(){$scope.availableOptions=_.clone($scope.originalAvailableOptions),$scope.$watch("originalSelectedOption",function(){var existing=_.find($scope.availableOptions,function(item){var availValue=$scope.getOptionValue(item);return availValue===$scope.originalSelectedOption});existing?($scope.inputText=$scope.getOptionText(_.clone(existing)),$scope.selectedItem=_.clone(existing)):($scope.inputText=_.clone($scope.originalSelectedOption),$scope.selectedItem=_.clone($scope.originalSelectedOption))})}),$scope.onChange=function(){return $timeout(function(){return $scope.$apply(function(){$scope.optionsActivated=!0,$scope.fieldDirty=!0,$scope.version=$scope.version+1})})},$scope.onCancel=function(){return $timeout(function(){return $scope.$apply(function(){$scope.fieldDirty=!1,$scope.optionsActivated=!1;var existing=_.find($scope.availableOptions,function(item){var availValue=$scope.getOptionValue(item);return availValue===$scope.originalSelectedOption});$scope.inputText=$scope.getOptionText(existing),$scope.selectedItem=_.clone(existing),$scope.$broadcast("fieldCanceled")})})},$scope.onCommit=function(revertIfNoMatch){return $timeout(function(){return $scope.$apply(function(){if($scope.selectedItem)$scope.fieldDirty=!1,$scope.optionsActivated=!1,$scope.originalSelectedOption=$scope.getOptionValue($scope.selectedItem),$scope.inputText=$scope.getOptionText($scope.selectedItem),$scope.selectedItem=_.clone($scope.originalSelectedOption),$scope.$broadcast("fieldCommitted");else if(revertIfNoMatch){$scope.fieldDirty=!1,$scope.optionsActivated=!1;var existing=_.find($scope.availableOptions,function(item){var availValue=$scope.getOptionValue(item);return availValue===$scope.originalSelectedOption});$scope.inputText=$scope.getOptionText(existing),$scope.selectedItem=_.clone(existing)}})})},$scope.onSelectTopDownOption=function(){return $timeout(function(){return $scope.$apply(function(){$scope.optionsActivatedTopDown=$scope.optionsActivatedTopDown+1,$scope.optionsActivated=!0})})},$scope.onSelectBottomUpOption=function(){return $timeout(function(){return $scope.$apply(function(){$scope.optionsActivatedBottomUp=$scope.optionsActivatedBottomUp+1,$scope.optionsActivated=!0})})}})}],link:function(scope,el){return $timeout(function(){var deactivatePromise=null,cancelDeactivate=function(){deactivatePromise&&$timeout.cancel(deactivatePromise),deactivatePromise=null},deactivate=function(){cancelDeactivate(),deactivatePromise=$timeout(function(){el.removeClass("active"),scope.fieldDirty&&scope.onCommit(!0)},500)};el.find("> div").on("focus",function(){return el.find("input").focus()}),el.find("input").on("focus",function(){cancelDeactivate(),el.addClass("active"),$timeout(function(){return scope.$apply(function(){scope.fieldDirty=!0,scope.version=scope.version+1})})}),scope.$on("fieldCanceled",function(){return el.find("input").blur()}),scope.$on("fieldCommitted",function(){return el.find("input").blur()}),el.find("input").on("blur",deactivate),scope.$on("fieldDirty",function(){scope.fieldDirty&&(cancelDeactivate(),el.addClass("active"))}),scope.$watch("inputText",function(){el.hasClass("active")&&scope.onChange()}),scope.$on("$destroy",function(){return el.remove()})})}}}]).directive("tribeSingleselectAvailable",["$document","$window",function($document,$window){return{restrict:"A",scope:{originalAvailableOptions:"=availableOptions",active:"=",activeTopDown:"=",activeBottomUp:"=",onSelect:"&",inputText:"=",selectedItem:"=",version:"=",newLabel:"@?",editable:"=",getOptionText:"="},templateUrl:"app/templates/component_singleselect_available.html",controller:["$scope","$timeout",function($scope,$timeout){$scope.showOptions=function(){return $timeout(function(){return $scope.$apply(function(){$scope.selectedItem=null,$scope.newOpt=null,$scope.availableOptions=_.clone($scope.originalAvailableOptions);var text=$scope.inputText?$scope.inputText.trim():"";$scope.availableOptions=_.sortBy(_.filter($scope.availableOptions,function(opt){return $scope.getOptionText(opt).startsWith(text)}),function(item){return $scope.getOptionText(item)}),$scope.selectedItem=_.find($scope.availableOptions,function(opt){return $scope.getOptionText(opt).startsWith(text)}),$scope.editable&&(_.find($scope.availableOptions,function(opt){return $scope.getOptionText(opt)===text})?$scope.newOpt=null:$scope.newOpt=text,$scope.selectedItem||($scope.selectedItem=$scope.newOpt))})})},$scope.selectAvailableItem=function(item){return $timeout(function(){return $scope.$apply(function(){$scope.selectedItem=item})})},$scope.selectNext=function(){return $timeout(function(){return $scope.$apply(function(){var ordered=_.sortBy($scope.availableOptions,function(item){return $scope.getOptionText(item).toLowerCase()});if($scope.selectedItem){var index=ordered.indexOf($scope.selectedItem)+1;index>=ordered.length?$scope.newOpt?$scope.selectedItem=$scope.newOpt:$scope.selectedItem=ordered[0]:$scope.selectedItem=ordered[index]}else $scope.selectedItem=_.first(ordered)})})},$scope.selectPrevious=function(){return $timeout(function(){return $scope.$apply(function(){var ordered=_.sortBy($scope.availableOptions,function(item){return $scope.getOptionText(item).toLowerCase()});if($scope.selectedItem)if($scope.newOpt===$scope.selectedItem&&ordered.length)$scope.selectedItem=_.last(ordered);else{var index=ordered.indexOf($scope.selectedItem)-1;0>index?$scope.newOpt?$scope.selectedItem=$scope.newOpt:$scope.selectedItem=_.last(ordered):$scope.selectedItem=ordered[index]}else $scope.newOpt?$scope.selectedItem=$scope.newOpt:$scope.selectedItem=_.last(ordered)})})},$scope.selectItem=function(opt){
$scope.selectedOption=opt,$scope.active=!1,$scope.inputText=$scope.getOptionText(opt)}}],link:function(scope,element){var floatingBody=angular.element(element.find("> div"));floatingBody.detach();var body=$document.find("body"),adjustOffset=function(){var position=element.offset();floatingBody.offset(position)};scope.$watch("active",function(){scope.active?(body.append(floatingBody),adjustOffset(),scope.showOptions(),element.addClass("active")):(floatingBody.detach(),element.removeClass("active"))}),scope.$watch("activeTopDown",function(){scope.activeTopDown&&scope.selectNext()}),scope.$watch("activeBottomUp",function(){scope.activeBottomUp&&scope.selectPrevious()}),scope.$watch("version",function(){adjustOffset(),scope.active&&(scope.showOptions(),element.addClass("active"))});var eWin=angular.element($window);eWin.bind("resize",adjustOffset),scope.$on("$destroy",function(){eWin.unbind("resize",adjustOffset),floatingBody.remove(),element.remove()})}}}]).directive("tribeSingleselectSelected",[function(){return{restrict:"A",scope:{onChange:"&",onCancel:"&",onCommit:"&",onSelectTopDownOption:"&",onSelectBottomUpOption:"&",inputText:"="},templateUrl:"app/templates/component_singleselect_selected.html",controller:["$scope","$timeout",function($scope,$timeout){$scope.keyEntered=function(event){return $timeout(function(){return $scope.$apply(function(){27===event.keyCode?$scope.onCancel():40===event.keyCode?$scope.onSelectTopDownOption():38===event.keyCode?$scope.onSelectBottomUpOption():13===event.keyCode?$scope.onCommit():9===event.keyCode})})}}]}}]),angular.module("website-components-text",["website-components-field-actions"]).directive("tribeText",["$window","$timeout",function($window,$timeout){return{restrict:"A",scope:{originalValue:"=value",type:"@"},templateUrl:"app/templates/component_text.html",controller:["$log","$scope",function($log,$scope){return $timeout(function(){$scope.version=0,$scope.fieldDirty=!1,$scope.$watch("originalValue",function(){return $timeout(function(){return $scope.$apply(function(){$scope.value=_.clone($scope.originalValue)})})}),$scope.onCommit=function(){return $timeout(function(){return $scope.$apply(function(){$scope.fieldDirty&&($scope.fieldDirty=!1,$scope.originalValue=_.clone($scope.value),$scope.$broadcast("fieldCommited"))})})},$scope.onCancel=function(){return $timeout(function(){return $scope.$apply(function(){$scope.fieldDirty=!1,$scope.value=_.clone($scope.originalValue),$scope.$broadcast("fieldCanceled")})})},$scope.onChange=function(){return $timeout(function(){return $scope.$apply(function(){$scope.version=$scope.version+1,$scope.originalValue!==$scope.value&&($scope.fieldDirty=!0)})})},$scope.keyEntered=function(event){return $timeout(function(){return $scope.$apply(function(){13===event.keyCode?$scope.onCommit():27===event.keyCode?$scope.onCancel():$scope.onChange()})})}})}],link:function(scope,element){return $timeout(function(){var deactivatePromise=null,cancelDeactivate=function(){deactivatePromise&&$timeout.cancel(deactivatePromise),deactivatePromise=null},deactivate=function(){cancelDeactivate(),deactivatePromise=$timeout(function(){scope.onCommit(),element.removeClass("active")},500)},input=element.find("input");scope.$on("fieldCanceled",function(){return input.blur()}),scope.$on("fieldCommited",function(){return input.blur()}),input.on("blur",function(){return deactivate()}),input.on("focus",function(){cancelDeactivate(),element.addClass("active"),input.select(),$timeout(function(){return scope.$apply(function(){scope.version=scope.version+1,scope.fieldDirty=!0})})}),element.find("> div").on("focus",function(){return input.focus()}),scope.$on("$destroy",function(){return element.remove()})})}}}]),angular.module("tribe-main",["website-components","website-services","website-messages","ngRoute","ngStorage","foundation","tribe-app","tribe-authentication","tribe-endpoints","tribe-endpoints-details"]).config(["$locationProvider","$routeProvider","$httpProvider",function($locationProvider,$routeProvider,$httpProvider){$httpProvider.interceptors.push("httpInterceptor"),$locationProvider.html5Mode({enabled:!0,requireBase:!0}),$routeProvider.when("/",{templateUrl:"app/templates/page_endpoints.html"}).when("/showcase",{templateUrl:"app/templates/page_components.html",controller:["$scope",function($scope){$scope.toUppercase=function(item){return item?item.text?item.text.toUpperCase():item.toUpperCase():null}}]}).when("/see/:aggregatedId",{templateUrl:"app/templates/page_see.html",controller:["$scope","$routeParams",function($scope,$routeParams){$scope.aggregatedId=$routeParams.aggregatedId}]}).when("/application/:app",{templateUrl:"app/templates/page_application_details.html",controller:["$scope","$routeParams",function($scope,$routeParams){$scope.app=$routeParams.app}]}).when("/application/:app/endpoint/:endpointId?",{templateUrl:"app/templates/page_endpoints_details.html",controller:["$scope","$routeParams",function($scope,$routeParams){$scope.applicationId=$routeParams.app,$scope.endpointId=$routeParams.endpointId}]}).when("/login",{templateUrl:"app/templates/page_login.html"}).otherwise({controller:["$scope","$location",function($scope,$location){$scope.path=$location.path()}],templateUrl:"app/templates/page_not_implemented.html"})}]).factory("httpInterceptor",["$q","$window","$location",function($q,$window,$location){return{responseError:function(response){return 401===response.status&&$location.url("/login"),$q.reject(response)}}}]).run(["$rootScope",function($rootScope){$rootScope.baseFullPath=angular.element("head base").first().attr("href")}]).run(["tribeAuthorizationService","$sessionStorage",function(Authorization,$sessionStorage){null==$sessionStorage.tribe?$sessionStorage.tribe={}:Authorization.restoreSession()}]).run(["tribeAuthorizationService","$sessionStorage","$location",function(Authorization,$sessionStorage,$location){$sessionStorage.tribe.isConnected||(Authorization.targetPath=$location.path(),$location.path("/login"))}]).run(function(){}),angular.module("tribe-alerts",[]).factory("tribeErrorHandlerService",["systemMessagesService",function(systemMessagesService){return{ensureErrorHandler:function(originalCallback){return originalCallback?originalCallback:function(evn){evn.statusText&&""!==evn.statusText||systemMessagesService.error("There are something wrong with your connection."),systemMessagesService.error(evn.statusText)}}}}]).factory("systemMessagesService",[function(){var listeners=[],messages=[],addMessage=function(msgType,msgText,timeout){var msgObj={msgType:msgType,msgText:msgText,msgTimeout:timeout};triggerUpdateEvent(msgObj)},triggerUpdateEvent=function(newMessage){newMessage&&messages.push(newMessage);var cloneMessages=_.clone(messages);_.each(listeners,function(listener){listener.onMessage(cloneMessages,newMessage)})};return{addListener:function(listener){listeners=_.union([listener],listeners)},removeListener:function(listener){listeners=_.reject(listeners,function(item){return item===listener})},getMessages:function(){return _.clone(messages)},info:function(msg,timeout){addMessage("info",msg,timeout)},warn:function(msg,timeout){addMessage("warn",msg,timeout)},error:function(msg,timeout){addMessage("error",msg,timeout)},setMessageRead:function(msg){msg.read=!0,triggerUpdateEvent()}}}]).run(function(){});var services;!function(services){angular.module("website-services",["ngRoute","ngResource","ngCookies","ngStorage","website-browser","tribe-alerts"]).factory("tribeFilterService",["$location",function($location){return{filterByCategory:function(app,category){$location.search({a:app,c:category}),$location.path("/")},filterByRole:function(app,role){$location.search({a:app,r:role}),$location.path("/")},filterByTag:function(app,tag){$location.search({a:app,t:tag}),$location.path("/")}}}]).factory("tribeAuthorizationService",["Base64","$cookieStore","$http","$sessionStorage",function(Base64,$cookieStore,$http,$sessionStorage){var asBasic=function(token){return"Basic "+token};return{token:function(){return $sessionStorage.tribe?asBasic($sessionStorage.tribe.authtoken):void 0},login:function(credentials){return $sessionStorage.tribe&&$sessionStorage.tribe.authtoken&&this.clearCredentials(),$http.post("api/login",$.param({username:credentials.username,password:credentials.password}),{headers:{"Content-Type":"application/x-www-form-urlencoded"}})},setCredentials:function(username,password){var encoded=Base64.encode(username+":"+password);$http.defaults.headers.common.Authorization=asBasic(encoded),$sessionStorage.tribe.authtoken=encoded,$sessionStorage.tribe.username=username},restoreSession:function(){var encoded=$sessionStorage.tribe.authtoken;null!=encoded&&($http.defaults.headers.common.Authorization=asBasic(encoded))},clearCredentials:function(){try{document.execCommand("ClearAuthenticationCache")}catch(e){}$sessionStorage.tribe={},delete $http.defaults.headers.common.Authorization}}}]).factory("tribeServerService",["$resource","$http","tribeErrorHandlerService",function($resource,$http,tribeErrorHandlerService){var resource=$resource("api/server/info",null,{info:{method:"GET",params:{},isArray:!1}});return{getInfo:function(){return{then:function(successCallback,errorCallback){resource.info({},successCallback,tribeErrorHandlerService.ensureErrorHandler(errorCallback))}}}}}]).run(function(){})}(services||(services={}));var services;!function(services){angular.module("website-browser",[]).factory("Base64",[function(){return Base64}]).run(function(){})}(services||(services={}));var services;!function(services){angular.module("website-services-endpoints",["ngRoute","ngResource","ngCookies","ngStorage","tribe-alerts"]).factory("tribeLinkHeaderService",[function(){return{parseLinkHeader:function(linkHeader){if(!linkHeader)return{};var parts=linkHeader.split(","),links={};return _.each(parts,function(p){var section=p.split(";");if(2!=section.length)throw new Error("section could not be split on ';'");var url=section[0].replace(/<(.*)>/,"$1").trim(),name=section[1].replace(/rel="(.*)"/,"$1").trim();links[name]=url}),links}}}]).factory("tribeEndpointsService",["$location","$resource","$http","tribeErrorHandlerService","$sessionStorage","$filter","tribeLinkHeaderService",function($location,$resource,$http,tribeErrorHandlerService,$sessionStorage,$filter,tribeLinkHeaderService){var httpListCall=function(url,params,successCallback,errorCallback){$http({url:url,method:"GET",params:params}).then(successCallback,tribeErrorHandlerService.ensureErrorHandler(errorCallback))};return{list:function(){return{then:function(successCallback,errorCallback){var params={},rawParams=$location.search();_.each(rawParams,function(value,key){"a"===key?params.app=value.split(","):"c"===key?params.category=value.split(","):"t"===key?params.tag=value.split(","):"r"===key?params.role=value.split(","):"q"===key&&(params.query=value)});var removeSelected=function(list,qparam){var param=rawParams[qparam];return param?(param=param.split(","),_.filter(list,function(entry){return!_.some(param,function(pEntry){return entry.text===pEntry})})):list};httpListCall("api/registry",params,function(rawData){for(var data=rawData.data,compiledResults=[],_i=0,_a=data.results;_i<_a.length;_i++){var rawEndpoint=_a[_i];compiledResults.push(rawEndpoint)}successCallback({total:data.total,endpoints:compiledResults,applications:removeSelected(data.applications,"a"),categories:removeSelected(data.categories,"c"),tags:removeSelected(data.tags,"t"),roles:removeSelected(data.roles,"r")})},errorCallback)}}},getApplicationDetails:function(applicationId){return{then:function(successCallback,errorCallback){$http.get("api/application/"+applicationId).then(function(data){data&&data.data&&data.data.swagger&&successCallback(data)},tribeErrorHandlerService.ensureErrorHandler(errorCallback))}}},getDetails:function(app,endpointId){return{then:function(successCallback,errorCallback){if(endpointId)$http.get("api/application/"+app+"/endpoint/"+endpointId).then(function(data){successCallback(data)},tribeErrorHandlerService.ensureErrorHandler(errorCallback));else{var newEntry={};successCallback(newEntry)}}}},getEndpointHistory:function(url){return{then:function(successCallback,errorCallback){url&&$http.get(url).then(function(data){successCallback(data)},tribeErrorHandlerService.ensureErrorHandler(errorCallback))}}},getHistoricEndpoint:function(historyItem){return{then:function(successCallback,errorCallback){$http.get(historyItem.link).then(function(data){successCallback(data)},tribeErrorHandlerService.ensureErrorHandler(errorCallback))}}},getSeeContent:function(aggregateId){return{then:function(successCallback,errorCallback){$http.get("api/id/registry/see/"+aggregateId).then(function(data){successCallback(data.data)},tribeErrorHandlerService.ensureErrorHandler(errorCallback))}}},saveEndpoint:function(applicationId,endpointId,endpoint){return{then:function(successCallback,errorCallback){$http.put("api/application/"+applicationId+"/endpoint/"+(endpointId?endpointId:""),endpoint).then(function(data){data&&data.data&&data.data.operation&&successCallback(data)},tribeErrorHandlerService.ensureErrorHandler(errorCallback))}}}}}]).run(function(){})}(services||(services={})),angular.module("tribe-app",["website-services"]).directive("app",[function(){return{restrict:"A",templateUrl:"app/templates/app.html",transclude:!0,scope:{}}}]).directive("appFooter",[function(){return{restrict:"A",scope:{},templateUrl:"app/templates/app_footer.html",controller:["$timeout","$scope","tribeServerService",function($timeout,$scope,server){$scope.now=Date.now(),server.getInfo().then(function(data){$timeout(function(){$scope.$apply(function(){$scope.version={app:data.applicationVersion,server:data.serverVersion}})})})}]}}]).directive("appHeader",[function(){return{restrict:"A",scope:{},templateUrl:"app/templates/app_header.html"}}]).run(function(){}),angular.module("website-messages",["website-services","tribe-alerts"]).directive("appNgClickConfirm",["$document","$parse","$compile",function($document,$parse,$compile){return{restrict:"A",link:function(scope,el,attrs){var getMessage=function(attrKey,strDefault){var msg=attrs[attrKey];return msg||(msg=strDefault),msg},appConfirmationTitle=getMessage("appConfirmationMessageTitle",""),appConfirmationMessage=getMessage("appConfirmationMessage","Do you confirm this action?"),appConfirmationMessageYes=getMessage("appConfirmationMessageYes","yes"),appConfirmationMessageNo=getMessage("appConfirmationMessageNo","no"),html=$compile(["<i, data-app-ng-click-confirm-el ",'data-action="'+attrs.appNgClickConfirm+'" ','data-title="'+appConfirmationTitle+'" ','data-message="'+appConfirmationMessage+'" ','data-yes="'+appConfirmationMessageYes+'" ','data-no="'+appConfirmationMessageNo+'"',"></i>"].join(""))(scope.$new());el.on("click",function(){var body=$document.find("body");body.append(html)}),el.on("$destroy",function(){html.remove()})}}}]).directive("appNgClickConfirmEl",[function(){return{restrict:"A",templateUrl:"app/templates/component_confirmation_popup.html",controller:["$timeout","$element","$scope","$parse",function($timeout,$element,$scope,$parse){$scope.yesClick=function(){$timeout(function(){$element.detach();var fn=$parse($scope.action,null,!0),callback=function(){fn($scope,{$event:event})};$scope.$apply(callback)})},$scope.noClick=function(){$element.detach()}}],link:function(scope,el,attrs){scope.action=attrs.action,scope.title=attrs.title,scope.message=attrs.message,scope.yes=attrs.yes,scope.no=attrs.no}}}]).directive("appClosableMessages",[function(){return{restrict:"A",scope:!0,templateUrl:"app/templates/app_closable_messages.html",controller:["$scope","$timeout","systemMessagesService",function($scope,$timeout,systemMessagesService){$scope.messages=systemMessagesService.getMessages();var me=this;me.onMessage=function(msgs){$timeout(function(){$scope.messages=_.reject(msgs,function(msg){return msg.read})})},systemMessagesService.addListener(me),me.disconnectListener=function(){systemMessagesService.removeListener(me)},me.setMessageRead=function(msg){systemMessagesService.setMessageRead(msg)}}],link:function(scope,el,attrs,controller){el.on("$destroy",function(){controller.disconnectListener()})}}}]).directive("appClosableMessage",["$timeout",function($timeout){return{restrict:"A",scope:{message:"="},require:"^appClosableMessages",link:function(scope,el,attrs,controller){var removeTimer,setTimer=function(){var timeoutValue="error"===scope.message.msgType?1e4:2e3;scope.message.msgTimeout&&(timeoutValue=scope.message.msgTimeout),removeTimer=$timeout(function(){controller.setMessageRead(scope.message)},timeoutValue)};setTimer(),el.on("$destroy",function(){$timeout.cancel(removeTimer)}),el.on("mouseover",function(){$timeout.cancel(removeTimer)}),el.on("mouseout",function(){setTimer()}),el.on("click",function(){controller.setMessageRead(scope.message)})}}}]).run(function(){}),angular.module("tribe-authentication",["website-services","tribe-alerts"]).directive("appLogin",[function(){return{restrict:"A",scope:!0,controller:["$scope","$location","tribeAuthorizationService","$sessionStorage","systemMessagesService",function($scope,$location,authorization,$sessionStorage,systemMessagesService){var me=this;me.onMessage=function(msgs){$scope.messages=msgs},systemMessagesService.addListener(me),me.disconnectListener=function(){systemMessagesService.removeListener(me)};var redirect=function(){var path=authorization.targetPath;path?(delete authorization.targetPath,$location.path(path)):$location.path("/")};$scope.login=function(){var credentials={username:$scope.username,password:$scope.password};authorization.login(credentials).success(function(data){$sessionStorage.tribe.isConnected=!0,$sessionStorage.tribe.user=data,authorization.setCredentials(credentials.username,credentials.password),redirect()}).error(function(data,status,headers,config){systemMessagesService.error("The server authentication failed with status "+status)})},$scope.loginAsGuest=function(){$sessionStorage.tribe.isConnected=!0,redirect()}}],link:function(scope,el,attrs,controller){el.on("$destroy",function(){controller.disconnectListener()})}}}]).directive("appLogout",[function(){return{restrict:"A",controller:["$scope","$window","$location","tribeAuthorizationService",function($scope,$window,$location,authorization){this.logout=function(){authorization.clearCredentials(),$location.search({}),$location.path("/"),$window.location.reload()}}],link:function(scope,el,attr,ctlr){el.on("click",function(){ctlr.logout()})}}}]).directive("appLoggedIn",[function(){return{restrict:"A",scope:!0,controller:["$scope","$sessionStorage",function($scope,$sessionStorage){$sessionStorage.tribe&&$sessionStorage.tribe.user?$scope.user=$sessionStorage.tribe.user.name:$scope.user="guest"}]}}]).run(function(){}),angular.module("tribe-endpoints",["website-services"]).directive("appSee",[function(){return{restrict:"A",templateUrl:"app/templates/app_see.html",scope:{aggregatedId:"="},controller:["$timeout","$scope","tribeEndpointsService",function($timeout,$scope,srv){$scope.$watch("aggregatedId",function(){$scope.aggregatedId&&srv.getSeeContent($scope.aggregatedId).then(function(data){$timeout(function(){$scope.$apply(function(){$scope.see=data})})})})}]}}]).directive("appApplicationDetails",[function(){return{restrict:"A",templateUrl:"app/templates/app_application_details.html",scope:{app:"=application"},controller:["$timeout","$scope","tribeEndpointsService","tribeFilterService","tribeLinkHeaderService",function($timeout,$scope,srv,tribeFilterService,tribeLinkHeaderService){srv.getApplicationDetails($scope.app).then(function(response){$timeout(function(){$scope.$apply(function(){var data=response.data;$scope.swagger=data.swagger;var endpoints=[];if(data.swagger.paths)for(var pathName in data.swagger.paths){var ops=data.swagger.paths[pathName];for(var opname in ops)if(!opname.match("^x-.*")){var links=tribeLinkHeaderService.parseLinkHeader(response.headers("link")),link=links[opname.toUpperCase()+" "+pathName],endpointId=link.substring(link.lastIndexOf("/")+1),operationObject={path:pathName,operation:opname,summary:ops[opname].summary,description:ops[opname].description,id:endpointId};endpoints.push(operationObject)}}$scope.endpoints=endpoints,$scope.categories=data.categories,$scope.tags=data.tags,$scope.roles=data.roles})})}),$scope.filterByCategory=function(category){tribeFilterService.filterByCategory($scope.details.name,category)},$scope.filterByRole=function(role){tribeFilterService.filterByRole($scope.details.name,role)},$scope.filterByTag=function(tag){tribeFilterService.filterByTag($scope.details.name,tag)}}]}}]).directive("appEndpoints",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints.html",scope:{},controller:["$timeout","$scope","tribeEndpointsService",function($timeout,$scope,srv){srv.list().then(function(data){$timeout(function(){$scope.$apply(function(){$scope.total=data.total,$scope.endpoints=data.endpoints,$scope.applications=data.applications,$scope.categories=data.categories,$scope.tags=data.tags,$scope.roles=data.roles})})})}]}}]).directive("appEndpointsHeader",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_header.html",scope:{total:"=",endpoints:"="}}}]).directive("appEndpointsHeaderCreateBtn",["$document",function($document){return{restrict:"A",templateUrl:"app/templates/app_endpoints_header_create_btn.html",scope:{endpoints:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.$watch("endpoints",function(){$timeout(function(){$scope.$apply(function(){var applicationsMap=_.groupBy($scope.endpoints,function(endpoint){return endpoint.applicationId}),applications=[];_.each(applicationsMap,function(endpoints,applicationId){applications.push({applicationId:applicationId,name:endpoints[0].application,endpoints:endpoints})}),$scope.applications=applications})})})}],link:function(scope,el,attrs,controller){var valueDiv=el.find(".button-applications");valueDiv.detach();var body=$document.find("body"),clear=function(){el.removeClass("visible"),valueDiv.detach()},elWin=$document;el.find("div.trigger").on("click",function(){if(el.hasClass("visible"))valueDiv.detach(),el.removeClass("visible"),valueDiv.off("scroll",clear);else{var pos=el.find("> div").offset();valueDiv.css({top:pos.top+el.find("> div").outerHeight()+"px",left:pos.left+"px"}),body.append(valueDiv),el.addClass("visible"),elWin.on("scroll",clear)}}),scope.$on("$destroy",function(){valueDiv.remove(),elWin.off("scroll",clear)})}}}]).directive("appEndpointsListApplication",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_list_application.html",scope:{application:"="},controller:["$scope","$timeout",function($scope,$timeout){$scope.pageSize=5,$scope.$watch("application",function(){$scope.application&&$timeout(function(){$scope.$apply(function(){$scope.application.endpoints?($scope.endpoints=$scope.application.endpoints.slice(0,$scope.pageSize),$scope.endpoints.length<$scope.application.endpoints.length&&($scope.showAll=!0)):$scope.endpoints=[]})})}),$scope.showAllEndpoints=function(){$scope.endpoints=$scope.application.endpoints,$scope.showAll=!1}}]}}]).directive("appEndpointsList",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_list.html",scope:{total:"=",endpoints:"="},controller:["$timeout","$scope",function($timeout,$scope){$scope.$watch("endpoints",function(){$timeout(function(){$scope.$apply(function(){var applicationsMap=_.groupBy($scope.endpoints,function(endpoint){return endpoint.applicationId}),applications=[];_.each(applicationsMap,function(endpoints,applicationId){applications.push({applicationId:applicationId,name:endpoints[0].application,version:endpoints[0].applicationVersion,endpoints:endpoints})}),$scope.applications=applications})})})}]}}]).directive("appEndpointsListFilterEntries",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_list_filter_entries.html",scope:{key:"@",list:"=",title:"@"},controller:["$scope","$location","$route",function($scope,$location,$route){$scope.removeFilter=function(entry){var rawQuery=$location.search(),query=rawQuery[$scope.key];query&&(query=query.split(","),query=_.filter(query,function(qEntry){return qEntry!==entry}),query.length?rawQuery[$scope.key]=query.join(","):delete rawQuery[$scope.key],$location.search(rawQuery),$route.reload())}}]}}]).directive("appEndpointsFilterBubble",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_filter_bubble.html",scope:{name:"=",length:"=",qfield:"="},controller:["$location","$route","$scope",function($location,$route,$scope){this.updateQuery=function(){var values=$location.search(),currentQuery=[];values[$scope.qfield]&&(currentQuery=values[$scope.qfield].split(",")),currentQuery.push($scope.name),values[$scope.qfield]=_.uniq(currentQuery).join(","),$location.search(values),$route.reload()}}],link:function(scope,el,attrs,controller){el.on("click",function(){controller.updateQuery()})}}}]).directive("appEndpointsFilter",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_filter.html",scope:{title:"@",list:"=",qfield:"@"}}}]).directive("appEndpointsQueryInput",["$timeout",function($timeout){return{restrict:"A",templateUrl:"app/templates/app_endpoints_query_input.html",scope:{},controller:["$scope","$location","$route",function($scope,$location,$route){var currentQuery=$location.search().q;currentQuery?$scope.value=currentQuery:$scope.value="",this.updateQuery=function(){var values=$location.search();values.q=$scope.value.trim(),""===values.q&&delete values.q,$location.search(values),$route.reload()},$scope.updateQuery=this.updateQuery}],link:function(scope,el,attrs,controller){var update=function(event){controller.updateQuery(),event.preventDefault()};el.find("input").bind("keydown keypress",function(event){13===event.which&&update(event)}),$timeout(function(){el.find("input").focus()})}}}]).directive("appEndpointsSelectedFilter",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_selected_filter.html",scope:{},controller:["$timeout","$location","$scope",function($timeout,$location,$scope){var params=$location.search();$timeout(function(){$scope.$apply(function(){params.a&&($scope.selectedApps=params.a.split(",")),params.c&&($scope.selectedCategories=params.c.split(",")),params.t&&($scope.selectedTags=params.t.split(",")),params.r&&($scope.selectedRoles=params.r.split(","))})})}]}}]).run(function(){}),angular.module("tribe-endpoints-details",["website-services","website-services-endpoints"]).factory("appEndpointsDetailsHeaderService",[function($location){return{getBaseUrl:function(swagger){var basePath="/"===swagger.basePath?"":swagger.basePath;return swagger.host+basePath}}}]).directive("appEndpointsDetailsHeader",["$window","$timeout","$filter",function($window,$timeout,$filter){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details_header.html",scope:!0,controller:["$scope","$timeout","appEndpointsDetailsHeaderService",function($scope,$timeout,srv){$scope.toUppercase=function(item){return item?item.text?item.text.toUpperCase():item.toUpperCase():null},$scope.$watch("application",function(){$scope.application&&$scope.application.swagger&&$scope.application.swagger.host&&$scope.application.swagger.basePath&&$timeout(function(){$scope.$apply(function(){$scope.endpoint.operation.schemes?$scope.endpointProtocol=$scope.endpoint.operation.schemes.indexOf("https")>=0?"https":"http":$scope.application&&$scope.application.swagger&&$scope.application.swagger.schemes&&($scope.endpointProtocol=$scope.application.swagger.schemes.indexOf("https")>=0?"https":"http"),$scope.resourceUrl=srv.getBaseUrl($scope.application.swagger,$scope.endpoint.path)+$scope.endpoint.path})})})}]}}]).factory("tribeEndpointDetailsTocService",[function(){var data={selectedAnchor:null,anchors:[]};return{getData:function(){return data},setAnchor:function(title,isSubmenu,el){data.anchors.push({title:title,submenu:isSubmenu,el:el})},clearAnchors:function(){data.anchors=[]}}}]).directive("appEndpointsDetailsToc",["tribeEndpointDetailsTocService","$window",function(srv,$window){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details_toc.html",scope:{},controller:["tribeEndpointDetailsTocService","$scope","$document",function(srv,$scope,$document){$scope.anchors=srv.getData().anchors,$scope.getIndex=function(anchor){var tags=$document.find("article.app-ep-details-body *[app-endpoints-details-toc-anchor]");return tags.index(anchor.el)},this.clearAnchors=function(){srv.clearAnchors()}}],link:function(scope,el,attrs,controller){el.find("div.collapse-icon").on("click",function(){el.toggleClass("collapsed")}),el.find("li[data-app-endpoints-details-toc-item]").on("click",function(){el.removeClass("collapsed")}),scope.$on("$destroy",function(){controller.clearAnchors()})}}}]).directive("appEndpointsDetailsTocItem",["$timeout","$window",function($timeout,$window){return{restrict:"A",scope:{anchor:"=appEndpointsDetailsTocItem"},templateUrl:"app/templates/app_endpoints_details_toc_item.html",controller:["$scope","tribeEndpointDetailsTocService",function($scope,srv){$scope.tocData=srv.getData(),this.selectMe=function(){$timeout(function(){$scope.$apply(function(){$scope.tocData.selectedAnchor=$scope.anchor})})}}],link:function(scope,el,attrs,controller){el.on("click",function(){controller.selectMe();var winEl=angular.element("div[data-app-endpoints-details] > div"),calculateScroll=function(){var target=scope.anchor.el,elOffset=target.offset().top,elHeight=target.height(),windowHeight=$(window).height();return windowHeight>elHeight?elOffset-(windowHeight/2-elHeight/2):elOffset};winEl.animate({scrollTop:calculateScroll()},function(){scope.anchor.el.focus(),scope.anchor.el.is(":focus")||scope.anchor.el.find("*").each(function(kidindex,rawKid){var kid=angular.element(rawKid);return kid.focus(),kid.is(":focus")?!1:void 0})})}),scope.$watch("tocData.selectedAnchor",function(){var selected=scope.$eval("tocData.selectedAnchor");selected&&selected===scope.anchor?el.find("h4").addClass("selected"):el.find("h4").removeClass("selected")})}}}]).directive("appEndpointsDetailsTocAnchor",["$timeout",function($timeout){return{restrict:"A",scope:{title:"@appEndpointsDetailsTocAnchor",submenu:"@"},controller:["tribeEndpointDetailsTocService","$scope",function(srv,$scope){$scope.data=srv.getData(),this.registerAnchor=function(el){srv.setAnchor($scope.title,$scope.submenu,el)},this.setSelectedAnchor=function(el){$timeout(function(){$scope.$apply(function(){var anchors=$scope.data.anchors;$scope.data.selectedAnchor=anchors.find(function(item){return item.el===el})})})}}],link:function(scope,el,attrs,controller){$timeout(function(){controller.registerAnchor(el);var callback=function(){controller.setSelectedAnchor(el)};el.find("*").on("focus",callback),el.find("*").on("click",callback)})}}}]).directive("appEndpointsDetailsParameters",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details_parameters.html",scope:!0,controller:["$scope","$timeout",function($scope,$timeout){$scope.$watch("endpoint.uri.path",function(){var path=$scope.$eval("endpoint.uri.path");if(path){var params=path.match(/:[a-zA-Z0-9_]+/g);params&&(params=_.map(params,function(value){return value.substring(1)})),params||(params=[]),$timeout(function(){$scope.$apply(function(){$scope.pathParams=params})})}}),$scope.removeParam=function(p){return $timeout(function(){return $scope.$apply(function(){$scope.endpoint.operation.parameters=_.without($scope.endpoint.operation.parameters,p)})})},$scope.addParam=function(){var params=$scope.$eval("endpoint.operation.parameters");params||($scope.endpoint.operation||($scope.endpoint.operation={}),$scope.endpoint.operation.parameters=[],params=$scope.endpoint.operation.parameters),$timeout(function(){$scope.$apply(function(){params.unshift({type:"string",style:"query",sampleValues:"",required:!1}),$scope.params=params;
})})}}]}}]).directive("appEndpointsDetailsResourceInformation",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details_resource_information.html",scope:!0,controller:["$scope","$timeout",function($scope,$timeout){$scope.requestFormatsOptions=["text/plain","application/json","application/xml"],$scope.responseFormatsOptions=["text/plain","application/json","application/xml"],$scope.statusOptions=["PROPOSAL","STUB","DRAFT","TEST","VALIDATION","ACCEPTED","CONFIDENTIAL"],$scope.rateUnits=["SECONDS","MINUTES","HOURS","DAYS"],$scope.$watch("endpoint",function(){$scope.endpoint&&$scope.endpoint.operation&&($scope.addRate=function(){$timeout(function(){$scope.$apply(function(){$scope.endpoint.rates||($scope.endpoint.rates=[]),$scope.endpoint.rates.push({})})})},$scope.removeRate=function(rate){$timeout(function(){$scope.$apply(function(){$scope.endpoint.rates&&($scope.endpoint.rates=_.without($scope.endpoint.rates,rate))})})})});var initList=function(path,name){$scope.$watch(path,function(){var xapi=$scope.$eval(path);xapi&&(xapi[name]||(xapi[name]=[]))})};initList("endpoint.operation['x-tribestream-api-registry']","roles"),initList("endpoint.operation['x-tribestream-api-registry']","categories"),initList("endpoint.operation","tags"),initList("endpoint.operation['x-tribestream-api-registry']","api-versions")}]}}]).directive("appEndpointsDetailsResponseRequest",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details_response_request.html",scope:!0,controller:["$scope","$timeout",function($scope,$timeout){$scope.$watch("endpoint.operation",function(){if($scope.endpoint&&$scope.endpoint.operation&&$scope.endpoint.operation.responses){var positiveResponses=Object.keys($scope.endpoint.operation.responses).filter(function(httpStatus){return!!httpStatus.match("2..")});if(positiveResponses&&positiveResponses.length>0){$scope.positiveResponse=$scope.endpoint.operation.responses[positiveResponses[0]];var examples_1=$scope.positiveResponse.examples;examples_1&&examples_1["application/xml"]&&$timeout(function(){$scope.$apply(function(){$scope.exampleResponseXml=examples_1["application/xml"]})})}var errorResponse_1=$scope.endpoint.operation.responses["default"];errorResponse_1&&errorResponse_1.examples&&$timeout(function(){$scope.$apply(function(){$scope.errorResponseXml=errorResponse_1.examples["application/xml"]})})}$timeout(function(){$scope.$apply(function(){$scope.endpoint.errors||($scope.endpoint.errors=[]),$scope.endpoint.expectedValues||($scope.endpoint.expectedValues=[])})})}),$scope.removeErrorCode=function(code){$timeout(function(){$scope.$apply(function(){$scope.endpoint.operation&&$scope.endpoint.operation["x-tribestream-api-registry"]&&$scope.endpoint.operation["x-tribestream-api-registry"]["response-codes"]&&($scope.endpoint.operation["x-tribestream-api-registry"]["response-codes"]=_.without($scope.endpoint.operation["x-tribestream-api-registry"]["response-codes"],code))})})},$scope.addErrorCode=function(){$timeout(function(){$scope.$apply(function(){$scope.endpoint.operation||($scope.endpoint.operation={}),$scope.endpoint.operation["x-tribestream-api-registry"]||($scope.endpoint.operation["x-tribestream-api-registry"]={}),$scope.endpoint.operation["x-tribestream-api-registry"]["response-codes"]||($scope.endpoint.operation["x-tribestream-api-registry"]["response-codes"]=[]),$scope.endpoint.operation["x-tribestream-api-registry"]["response-codes"].push({http_status:0,error_code:0,message:"",description:""})})})},$scope.removeExpectedValue=function(value){$timeout(function(){$scope.$apply(function(){$scope.endpoint.expectedValues=_.without($scope.endpoint.expectedValues,value)})})},$scope.addExpectedValue=function(){$timeout(function(){$scope.$apply(function(){$scope.endpoint.expectedValues.push({name:"",values:""})})})}}],link:function(scope,el){scope.$on("$destroy",function(){return el.remove()})}}}]).directive("appEndpointsDetailsSee",["$timeout",function($timeout){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details_see.html",scope:{endpoint:"="},controller:["$scope",function($scope){this.addLink=function(){$timeout(function(){$scope.$apply(function(){$scope.endpoint.metadata=$scope.endpoint.metadata||{},$scope.endpoint.metadata.sees=$scope.endpoint.metadata.sees||[],$scope.endpoint.metadata.sees.push({})})})},$scope.removeLink=function(link){$timeout(function(){$scope.$apply(function(){$scope.endpoint.metadata&&$scope.endpoint.metadata.sees&&($scope.endpoint.metadata.sees=_.without($scope.endpoint.metadata.sees,link))})})}}],link:function(scope,el,attrs,controller){el.find("div.add-link").on("click",function(){controller.addLink(),$timeout(function(){var newItem=el.find("i[data-tribe-editable-text] > div").last();newItem.focus()},500)})}}}]).directive("appEndpointsDetailsHistory",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details_history.html",scope:!0,controller:["$scope","tribeEndpointsService","tribeFilterService","$timeout","$filter","$log","systemMessagesService","tribeLinkHeaderService",function($scope,srv,tribeFilterService,$timeout,$filter,$log,systemMessagesService,tribeLinkHeaderService){}]}}]).directive("appEndpointsDetails",[function(){return{restrict:"A",templateUrl:"app/templates/app_endpoints_details.html",scope:{applicationId:"=",endpointId:"="},controller:["$scope","tribeEndpointsService","tribeFilterService","$timeout","$filter","$log","systemMessagesService","tribeLinkHeaderService",function($scope,srv,tribeFilterService,$timeout,$filter,$log,systemMessagesService,tribeLinkHeaderService){$timeout(function(){$scope.$apply(function(){$scope.history=null,$scope.endpoint={httpMethod:"",path:"",operation:{}}})}).then(function(){srv.getDetails($scope.applicationId,$scope.endpointId).then(function(detailsResponse){if(detailsResponse.headers){var links=tribeLinkHeaderService.parseLinkHeader(detailsResponse.headers("link"));$scope.historyLink=links.history,$timeout(function(){$scope.$apply(function(){var detailsData=detailsResponse.data;$scope.endpoint.httpMethod=detailsData.httpMethod,$scope.endpoint.path=$filter("pathencode")(detailsData.path),$scope.endpoint.operation=detailsData.operation})})}srv.getApplicationDetails($scope.applicationId).then(function(applicationDetails){$timeout(function(){$scope.$apply(function(){applicationDetails.data&&applicationDetails.data.swagger||$log.error("Got no application details!"),$scope.application=applicationDetails.data})})})})}),$scope.save=function(){srv.saveEndpoint($scope.applicationId,$scope.endpointId,{httpMethod:$scope.endpoint.httpMethod,path:$scope.endpoint.path,operation:$scope.endpoint.operation}).then(function(saveResponse){systemMessagesService.info("Saved endpoint details! "+saveResponse.status)})},$scope.showHistory=function(){srv.getEndpointHistory($scope.historyLink).then(function(response){for(var links=tribeLinkHeaderService.parseLinkHeader(response.headers("link")),_i=0,_a=response.data;_i<_a.length;_i++){var entry=_a[_i];entry.link=links["revision "+entry.revisionId]}$timeout(function(){$scope.$apply(function(){$scope.history=response.data})})})},$scope.closeHistory=function(){$timeout(function(){$scope.$apply(function(){$scope.history=null})})},$scope.showHistoricEndpoint=function(historyItem){$timeout(function(){$scope.$apply(function(){$scope.history=null})}),srv.getHistoricEndpoint(historyItem).then(function(response){$timeout(function(){$scope.$apply(function(){var detailsData=response.data;$scope.historyItem=historyItem,$scope.endpoint.httpMethod=detailsData.httpMethod,$scope.endpoint.path=$filter("pathencode")(detailsData.path),$scope.endpoint.operation=detailsData.operation})})})}}]}}]).run(function(){});
//# sourceMappingURL=data:application/json;base64,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
