describe("it tests the endpoint details page",function(){var compile,rootScope,timeout,document,appEndpointsDetailsHeaderService,expect=chai.expect;beforeEach(function(){return angular.module("tribe-endpoints-details")}),beforeEach(function(){return angular.module("website-components-markdown")}),beforeEach(function(){return angular.module("website-components")}),beforeEach(function(){return angular.module("website-components-field-actions")}),beforeEach(function(){return angular.module("website-components")}),beforeEach(function(done){angular.injector(["ng","tribe-endpoints-details","website-components"]).invoke(["$compile","$rootScope","$timeout","$document","appEndpointsDetailsHeaderService",function($compile,$rootScope,$timeout,$document,$appEndpointsDetailsHeaderService){compile=$compile,rootScope=$rootScope,timeout=$timeout,document=$document,appEndpointsDetailsHeaderService=$appEndpointsDetailsHeaderService}]),done()}),afterEach(function(){return rootScope.$destroy()});var timeoutTryCatch=function(ms,done,callback){return timeout(function(){try{callback()}catch(e){done(e)}},ms)};it("should load baseUrl acording to the swagger file",function(){expect(appEndpointsDetailsHeaderService.getBaseUrl({basePath:"/kakaka",host:"http://lalala:8080"})).to.equal("http://lalala:8080/kakaka"),expect(appEndpointsDetailsHeaderService.getBaseUrl({basePath:"/kakaka/tatata",host:"http://lalala"})).to.equal("http://lalala/kakaka/tatata"),expect(appEndpointsDetailsHeaderService.getBaseUrl({basePath:"/",host:"http://lalala:8080"})).to.equal("http://lalala:8080")}),it('should load "response request" section',function(done){var scope=rootScope.$new(),item={http_status:222,error_code:333,message:"lalala",description:"lelele"};scope.endpoint={operation:{"x-tribestream-api-registry":{"response-codes":[item]}}};var element=angular.element("<div data-app-endpoints-details-response-request></div>");compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(200,done,function(){expect(element.html()).to.contain("lalala");var compiledScope=element.find("> div").scope();compiledScope.addErrorCode(),timeoutTryCatch(100,done,function(){expect(compiledScope.endpoint.operation["x-tribestream-api-registry"]["response-codes"].length).to.equal(2),compiledScope.removeErrorCode(item),timeoutTryCatch(100,done,function(){expect(compiledScope.endpoint.operation["x-tribestream-api-registry"]["response-codes"].length).to.equal(1);var remainingItem=compiledScope.endpoint.operation["x-tribestream-api-registry"]["response-codes"][0];expect(remainingItem.http_status).to.equal(0),expect(remainingItem.error_code).to.equal(0),expect(remainingItem.message).to.equal(""),expect(remainingItem.description).to.equal(""),done()})})})})}),describe("it tests our custom markdown component",function(){var compile,rootScope,timeout,document,expect=chai.expect;beforeEach(function(){return angular.module("website-components-text")}),beforeEach(function(done){angular.injector(["ng","website-components-markdown"]).invoke(["$compile","$rootScope","$timeout","$document",function($compile,$rootScope,$timeout,$document){compile=$compile,rootScope=$rootScope,timeout=$timeout,document=$document}]),done()}),afterEach(function(){return rootScope.$destroy()});var timeoutTryCatch=function(ms,done,callback){return timeout(function(){try{callback()}catch(e){done(e)}},ms)};it("should load markdown; confirm and cancel edit;",function(done){var scope=rootScope.$new();scope.myvalue="\n# title\n\nbody content here\n        ";var element=angular.element('<div data-tribe-markdown data-value="myvalue"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){expect(element.find("div.preview").html()).to.contain("<p>body content here</p>"),expect(element.find("div.preview").html()).to.not.contain("<p>second paragraph</p>"),timeoutTryCatch(100,done,function(){var mainDiv=element.find("> div");expect(mainDiv.scope().cmFocused).to.equal(!1),mainDiv.focus(),timeoutTryCatch(100,done,function(){var elScope=mainDiv.scope();expect(elScope.cmFocused).to.equal(!0),elScope.$apply(function(){return elScope.value="\n# title\n\nbody content here\n\nsecond paragraph\n"}),timeoutTryCatch(100,done,function(){expect(elScope.fieldDirty).to.equal(!0);var actionBtns=document.find("div.tribe-field-actions-body");expect(actionBtns.length).to.equal(1),expect(element.find("div.preview").html()).to.contain("<p>body content here</p>"),expect(element.find("div.preview").html()).to.contain("<p>second paragraph</p>"),timeoutTryCatch(100,done,function(){actionBtns.find('div[ng-click="cancel()"]').click(),timeoutTryCatch(100,done,function(){expect(element.find("div.preview").html()).to.contain("<p>body content here</p>"),expect(element.find("div.preview").html()).to.not.contain("<p>second paragraph</p>"),elScope.$apply(function(){return elScope.value="\n# title\n\nbody content here\n\nsecond paragraph\n"}),timeoutTryCatch(100,done,function(){expect(elScope.fieldDirty).to.equal(!0);var actionBtns=document.find("div.tribe-field-actions-body");expect(actionBtns.length).to.equal(1),expect(element.find("div.preview").html()).to.contain("<p>body content here</p>"),expect(element.find("div.preview").html()).to.contain("<p>second paragraph</p>"),timeoutTryCatch(100,done,function(){actionBtns.find('div[ng-click="confirm()"]').click(),timeoutTryCatch(100,done,function(){expect(element.find("div.preview").html()).to.contain("<p>body content here</p>"),expect(element.find("div.preview").html()).to.contain("<p>second paragraph</p>"),done()})})})})})})})})})}),it("should show markdown preview",function(done){var scope=rootScope.$new();scope.myvalue="\n# title\n\n*body* content here\n";var element=angular.element('<div data-tribe-markdown data-value="myvalue"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){var toggleBtn=element.find("div.editor-toolbar > a.fa-eye");toggleBtn.click(),timeoutTryCatch(100,done,function(){expect(element.find("div.editor-preview").html()).to.contain("<em>body</em>"),done()})})}),it("should highlight code",function(done){var scope=rootScope.$new();scope.myvalue="```xml\n <root><a>a</a></root> \n ```";var element=angular.element('<div data-tribe-markdown data-value="myvalue"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){var toggleBtn=element.find("div.editor-toolbar > a.fa-eye");toggleBtn.click(),timeoutTryCatch(100,done,function(){expect(element.find("div.preview > div[x-ng-bind-html]").html()).to.contain('<code class="lang-xml hljs">'),done()})})});var triggerKeyDown=function(element,keyCode){var e=$.Event("keyup");e.keyCode=keyCode,element.trigger(e)};it("should show help page",function(done){var scope=rootScope.$new();scope.myvalue="";var element=angular.element('<div data-tribe-markdown data-value="myvalue"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){var toggleBtn=element.find("div.editor-toolbar > a.fa-question-circle");toggleBtn.click(),timeoutTryCatch(100,done,function(){expect(document.find("body div.markdown-help-content").length).to.equal(1),triggerKeyDown(document,27),timeoutTryCatch(100,done,function(){expect(document.find("body div.markdown-help-content").length).to.equal(0),done()})})})})}),describe("it tests our custom multiselect component",function(){var compile,rootScope,timeout,document,expect=chai.expect;beforeEach(function(){return angular.module("website-components-multiselect")}),beforeEach(function(done){angular.injector(["ng","website-components-multiselect"]).invoke(["$compile","$rootScope","$timeout","$document",function($compile,$rootScope,$timeout,$document){compile=$compile,rootScope=$rootScope,timeout=$timeout,document=$document}]),done()}),afterEach(function(){return rootScope.$destroy()});var timeoutTryCatch=function(ms,done,callback){return timeout(function(){try{callback()}catch(e){done(e)}},ms)},triggerKeyDown=function(element,keyCode){var e=$.Event("keyup");e.keyCode=keyCode,element.trigger(e)};it("should load selected options",function(done){var scope=rootScope.$new();scope.selected=["aaa","bbb"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){var selectedItems=angular.element(element.find("div[data-tribe-multiselect-selected] .items"));timeoutTryCatch(100,done,function(){var values=_.map(selectedItems,function(item){return angular.element(item).scope().opt});expect(values).to.deep.equal(["aaa","bbb"]),expect(angular.element(element.find("div[data-tribe-multiselect-selected] .items i.remove")).css("display")).to.equal("none"),done()})})}),it("should show action buttons on input focus",function(done){var scope=rootScope.$new();scope.selected=["aaa"],scope.options=[];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){expect(document.find("div.tribe-field-actions-body").length).to.equal(0);var componentWrapper=angular.element(element.find("> div"));componentWrapper.focus(),timeoutTryCatch(100,done,function(){var input=angular.element(element.find("input"));expect(input.is(":focus")).to.equal(!0),timeoutTryCatch(100,done,function(){expect(document.find("div.tribe-field-actions-body").length).to.equal(1),done()})})})}),it("should show available options",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=["aaa","bbb"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var input=angular.element(element.find("input"));timeoutTryCatch(100,done,function(){input.focus(),timeoutTryCatch(100,done,function(){triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){var available=element.find("div[data-tribe-multiselect-available]");expect(available.hasClass("active")).to.equal(!0),done()})})})})})}),it("should select selected items with the left-right keys",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=["aaa","bbb","ccc"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var input=angular.element(element.find("input"));timeoutTryCatch(100,done,function(){input.focus(),triggerKeyDown(input,37),timeoutTryCatch(100,done,function(){var selected=element.find("div[data-tribe-multiselect-selected]");expect(angular.element(selected.find(".selected")).scope().opt).to.equal("ccc"),triggerKeyDown(input,39),timeoutTryCatch(100,done,function(){var selected=element.find("div[data-tribe-multiselect-selected]");expect(angular.element(selected.find(".selected")).scope().opt).to.equal("aaa"),triggerKeyDown(input,39),timeoutTryCatch(100,done,function(){var selected=element.find("div[data-tribe-multiselect-selected]");expect(angular.element(selected.find(".selected")).scope().opt).to.equal("bbb"),triggerKeyDown(input,8),timeoutTryCatch(100,done,function(){var selected=element.find("div[data-tribe-multiselect-selected]");expect(angular.element(selected.find(".selected")).scope().opt).to.equal("ccc"),triggerKeyDown(input,8),timeoutTryCatch(100,done,function(){var selected=element.find("div[data-tribe-multiselect-selected]");expect(angular.element(selected.find(".selected")).scope().opt).to.equal("aaa"),done()})})})})})})})})}),it("should enter new items",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=["aaa","bbb","ccc"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-multiselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){var lastSelected=selected.find(".items").last();expect(angular.element(lastSelected).scope().opt).to.equal("fff"),selectedScope.$apply(function(){return selectedScope.inputText="eee"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){var lastSelected=selected.find(".items")[3];expect(angular.element(lastSelected).scope().opt).to.equal("eee"),triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){var available=element.find("div[data-tribe-multiselect-available]");expect(available.hasClass("active")).to.equal(!0);var availableOptions=document.find("div.tribe-data-tribe-multiselect-available-body div.option");expect(availableOptions.length).to.equal(1),expect(angular.element(availableOptions.last()).scope().opt).to.equal("ddd"),triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){expect(angular.element(selected.find(".items")[3]).scope().opt).to.equal("ddd"),done()})})})})})})})})})})}),it("should cancel and confirm edits",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=["aaa","bbb","ccc"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-multiselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc","fff"]),document.find('div.tribe-field-actions-body div[ng-click="cancel()"]').click(),timeoutTryCatch(100,done,function(){expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc"]),selectedScope.$apply(function(){return selectedScope.inputText="ggg"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){document.find('div.tribe-field-actions-body div[ng-click="confirm()"]').click(),timeoutTryCatch(100,done,function(){expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc","ggg"]),done()})})})})})})})})})}),it("should confirm edits with double enter",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=["aaa","bbb","ccc"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-multiselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc","fff"]),triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){expect(selected.scope().fieldDirty).to.equal(!1),expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc","fff"]),done()})})})})})})}),it("should cancel edits with double escape",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=["aaa","bbb","ccc"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-multiselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc","fff"]),selectedScope.$apply(function(){return selectedScope.inputText="ddd"}),triggerKeyDown(input,27),timeoutTryCatch(100,done,function(){timeoutTryCatch(100,done,function(){expect(selectedScope.inputText).to.equal(""),expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc","fff"]),triggerKeyDown(input,27),timeoutTryCatch(100,done,function(){timeoutTryCatch(100,done,function(){expect(_.map(angular.element(selected.find(".items")),function(item){return angular.element(item).scope().opt})).to.deep.equal(["aaa","bbb","ccc"]),done()})})})})})})})})})}),it('should show the "new item" label in the available oprions list',function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=["aaa","bbb","ccc"],scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options" data-new-label="new lala"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-multiselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){selectedScope.$apply(function(){return selectedScope.inputText="fffffff"}),timeoutTryCatch(100,done,function(){var newLabel=angular.element(document.find("div.tribe-data-tribe-multiselect-available-body .new-opt"));expect(newLabel.find("span").first().html()).to.deep.equal("new lala:"),done()})})})})})}),it("should order available options list case insensitive",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.options=["basic","form","digest","HTTP Signatures","Bearer"];var element=angular.element('<div data-tribe-multiselect data-selected-options="[]" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-multiselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus(),triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){var availableOptions=document.find("div.tribe-data-tribe-multiselect-available-body div.option");expect(_.map(angular.element(availableOptions),function(item){return angular.element(item).scope().opt})).to.deep.equal(["basic","Bearer","digest","form","HTTP Signatures"]),done()})})})})}),it("should enter new items when selected items is null",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=null,scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-multiselect data-selected-options="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-multiselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="aaa"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){var lastSelected=selected.find(".items").last();expect(angular.element(lastSelected).scope().opt).to.equal("aaa"),done()})})})})})})}),describe("it tests our custom options component",function(){var compile,rootScope,timeout,document,expect=chai.expect;beforeEach(function(){return angular.module("website-components")}),beforeEach(function(done){angular.injector(["ng","website-components"]).invoke(["$compile","$rootScope","$timeout","$document",function($compile,$rootScope,$timeout,$document){compile=$compile,rootScope=$rootScope,timeout=$timeout,document=$document}]),done()}),afterEach(function(){return rootScope.$destroy()});var timeoutTryCatch=function(ms,done,callback){return timeout(function(){try{callback()}catch(e){done(e)}},ms)},triggerKeyDown=function(element,keyCode){var e=$.Event("keyup");e.keyCode=keyCode,element.trigger(e)};it("should show options",function(done){var scope=rootScope.$new();scope.options=["Copy...","Release...","Export...","Share link..."];var element=angular.element('<i data-tribe-editable-option data-empty-text="Actions" data-value="action" data-options="options"></i>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){var comp=document.find("body [data-tribe-editable-option]");expect(comp.length).to.equal(1),expect(document.find("body").html()).to.not.contain("Copy...");var compScope=comp.find("> div").scope();compScope.open(),timeoutTryCatch(100,done,function(){expect(document.find("body").html()).to.contain("Copy..."),document.find("body").click(),timeoutTryCatch(100,done,function(){expect(document.find("body").html()).to.not.contain("Copy..."),compScope.open(),timeoutTryCatch(100,done,function(){expect(document.find("body").html()).to.contain("Copy..."),triggerKeyDown(document,27),timeoutTryCatch(100,done,function(){expect(document.find("body").html()).to.not.contain("Copy..."),compScope.open(),done()})})})})})})}),describe("it tests our custom singleselect component",function(){var compile,rootScope,timeout,document,expect=chai.expect;beforeEach(function(){return angular.module("website-components-singleselect")}),beforeEach(function(done){angular.injector(["ng","website-components-singleselect"]).invoke(["$compile","$rootScope","$timeout","$document",function($compile,$rootScope,$timeout,$document){compile=$compile,rootScope=$rootScope,timeout=$timeout,document=$document}]),done()}),afterEach(function(){return rootScope.$destroy()});var timeoutTryCatch=function(ms,done,callback){return timeout(function(){try{callback()}catch(e){done(e)}},ms)},triggerKeyDown=function(element,keyCode){var e=$.Event("keyup");e.keyCode=keyCode,element.trigger(e)};it("should show action buttons on input focus",function(done){var scope=rootScope.$new();scope.selected="aaa",scope.options=[];var element=angular.element('<div data-tribe-singleselect data-selected-option="selected" data-available-options="options"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){expect(document.find("div.tribe-field-actions-body").length).to.equal(0);var componentWrapper=angular.element(element.find("> div"));componentWrapper.focus(),timeoutTryCatch(100,done,function(){var input=angular.element(element.find("input"));expect(input.is(":focus")).to.equal(!0),timeoutTryCatch(100,done,function(){expect(document.find("div.tribe-field-actions-body").length).to.equal(1),done()})})})}),it("should show available options",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected="aaa",scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-singleselect data-selected-option="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var input=angular.element(element.find("input"));timeoutTryCatch(100,done,function(){input.focus(),timeoutTryCatch(100,done,function(){triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){var available=element.find("div[data-tribe-singleselect-available]");expect(available.hasClass("active")).to.equal(!0),done()})})})})})}),it("should enter new items",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected="aaa",scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-singleselect data-editable="true" data-selected-option="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-singleselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){var newLabel=angular.element(document.find("div.tribe-data-tribe-singleselect-available-body .new-opt"));expect(newLabel.find("span").first().html()).to.deep.equal("New:"),expect(newLabel.find("span").last().html()).to.deep.equal("fff"),input.blur(),timeoutTryCatch(100,done,function(){expect(selectedScope.selectedItem).to.equal("fff"),done()})})})})})})}),it("should not enter new items",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected="aaa",scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-singleselect data-editable="false" data-selected-option="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-singleselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();expect(selectedScope.selectedItem).to.equal("aaa"),selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){var newLabel=angular.element(document.find("div.tribe-data-tribe-singleselect-available-body .new-opt"));expect(newLabel.find("span").first().html()).to.deep.equal("No matches"),done()})})})})})}),it("should cancel edit",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected="aaa",scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-singleselect data-selected-option="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-singleselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,27),timeoutTryCatch(200,done,function(){expect(selectedScope.selectedItem).to.equal("aaa"),done()})})})})})}),it("should do nothing when trying to commit new non-available entry",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected="aaa",scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-singleselect data-selected-option="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-singleselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus();var selectedScope=selected.scope();selectedScope.$apply(function(){return selectedScope.inputText="fff"}),timeoutTryCatch(100,done,function(){triggerKeyDown(input,13),timeoutTryCatch(100,done,function(){expect(selectedScope.selectedItem).to.equal("aaa"),input.blur(),timeoutTryCatch(100,done,function(){expect(selectedScope.inputText).to.equal("aaa"),done()})})})})})})}),it("should show empty label",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected=null,scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-singleselect data-selected-option="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){expect(angular.element(element.find("span.empty")).length).to.equal(1),done()})})}),it("should not show empty label",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.selected="bbb",scope.options=["aaa","bbb","ccc","ddd","eee"];var element=angular.element('<div data-tribe-singleselect data-selected-option="selected" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){expect(angular.element(element.find("span.empty")).length).to.equal(0),done()})})}),it("should order available options list case insensitive",function(done){timeoutTryCatch(100,done,function(){var scope=rootScope.$new();scope.option="",scope.options=["basic","form","digest","HTTP Signatures","Bearer"];var element=angular.element('<div data-tribe-singleselect data-selected-option="option" data-available-options="options"></div>');element.appendTo(document.find("body")),compile(element)(scope),timeoutTryCatch(100,done,function(){var selected=angular.element(element.find("div[data-tribe-singleselect-selected]")),input=angular.element(selected.find("input"));timeoutTryCatch(100,done,function(){input.focus(),triggerKeyDown(input,40),timeoutTryCatch(100,done,function(){var availableOptions=document.find("div.tribe-data-tribe-singleselect-available-body div.option");expect(_.map(angular.element(availableOptions),function(item){return angular.element(item).scope().opt})).to.deep.equal(["basic","Bearer","digest","form","HTTP Signatures"]),done()})})})})})}),describe("it tests our custom text component",function(){var compile,rootScope,timeout,document,expect=chai.expect;beforeEach(function(){return angular.module("website-components-text")}),beforeEach(function(done){angular.injector(["ng","website-components-text"]).invoke(["$compile","$rootScope","$timeout","$document",function($compile,$rootScope,$timeout,$document){compile=$compile,rootScope=$rootScope,timeout=$timeout,document=$document}]),done()}),afterEach(function(){return rootScope.$destroy();
});var timeoutTryCatch=function(ms,done,callback){return timeout(function(){try{callback()}catch(e){done(e)}},ms)};it("should have title",function(done){var scope=rootScope.$new();scope.value=null;var element=angular.element('<div data-tribe-text data-value="value"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){expect(element.find("> div").attr("title")).to.deep.equal("Click to edit"),done()})}),it("should load selected option",function(done){var scope=rootScope.$new();scope.value="aaa";var element=angular.element('<div data-tribe-text data-value="value"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){var value=element.scope().value;expect(value).to.deep.equal("aaa"),done()})}),it("should show action buttons on change",function(done){var scope=rootScope.$new();scope.value=1;var element=angular.element('<div data-tribe-text data-type="number" data-value="value"></div>');compile(element)(scope),element.appendTo(document.find("body")),timeoutTryCatch(100,done,function(){var input=angular.element(element.find("input"));expect(input.scope().value).to.deep.equal(1),input.focus(),timeoutTryCatch(100,done,function(){input.scope().value=3,input.scope().keyEntered({keyCode:27}),timeoutTryCatch(100,done,function(){expect(input.scope().value).to.deep.equal(1),input.focus(),timeoutTryCatch(100,done,function(){input.scope().value=3,timeoutTryCatch(100,done,function(){expect(document.find("div.tribe-field-actions-body").length).to.equal(1),input.scope().keyEntered({keyCode:13}),timeoutTryCatch(100,done,function(){expect(input.scope().value).to.deep.equal(3),expect(document.find("div.tribe-field-actions-body").length).to.equal(0),done()})})})})})})})}),describe("it tests our tribeHtml custom filter",function(){var tribeHtml,expect=chai.expect;beforeEach(function(done){module("website-components",function($provide){$provide.value("$sce",{trustAsHtml:function(input){return input+"!!"}})}),inject(function(_$filter_){tribeHtml=_$filter_("tribeHtml")}),done()}),it("should convert to html accordingly",function(){expect(tribeHtml("<i></i>")).to.equal("<i></i>!!")})}),describe("it tests our encodepath filter",function(){var filter,expect=chai.expect;beforeEach(function(){return module("website-components")}),beforeEach(function(){return inject(function(_$filter_){filter=_$filter_("pathencode")})}),it("should convert root to root",function(){expect(filter("/")).to.equal("/")}),it("should convert single path with braces to colon",function(){expect(filter("/{foo}")).to.equal("/:foo")}),it("should convert mixed path with braces to colon",function(){expect(filter("/{foo}/bar")).to.equal("/:foo/bar")}),it("should convert mixed path with trailing braces to colon",function(){expect(filter("/foo/{bar}")).to.equal("/foo/:bar")})});
//# sourceMappingURL=data:application/json;base64,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
