/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.entities;

import io.swagger.models.Swagger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.envers.Audited;
import org.tomitribe.tribestream.registryng.entities.AbstractEntity;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.Normalizer;
import org.tomitribe.tribestream.registryng.entities.OpenAPIDocumentSerializer;
import org.tomitribe.tribestream.registryng.service.serialization.SwaggerJsonMapperProducer;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="UQ_NAME_VERSION", columnNames={"name", "version"})})
@NamedQueries(value={@NamedQuery(name="OpenApiDocument.findByNameAndVersion", query="SELECT d FROM OpenApiDocument d WHERE d.name = :name AND d.version = :version"), @NamedQuery(name="OpenApiDocument.findByApplicationId", query="SELECT d FROM OpenApiDocument d WHERE d.id = :applicationId"), @NamedQuery(name="OpenApiDocument.findByApplicationIdWithEndpoints", query="SELECT DISTINCT d FROM OpenApiDocument d LEFT JOIN FETCH d.endpoints WHERE d.id = :applicationId"), @NamedQuery(name="OpenApiDocument.findByName", query="SELECT d FROM OpenApiDocument d WHERE d.name = :name ORDER BY d.version DESC"), @NamedQuery(name="OpenApiDocument.findAll", query="SELECT d FROM OpenApiDocument d ORDER BY d.name ASC, d.version DESC"), @NamedQuery(name="OpenApiDocument.findAllWithEndpoints", query="SELECT DISTINCT d FROM OpenApiDocument d JOIN FETCH d.endpoints ORDER BY d.name ASC, d.version DESC"), @NamedQuery(name="OpenApiDocument.findByHumanReadableName", query="SELECT d FROM OpenApiDocument d where d.humanReadableName = :applicationName AND d.version = :applicationVersion"), @NamedQuery(name="OpenApiDocument.findByHumanReadableNameWithoutVersion", query="SELECT d FROM OpenApiDocument d where d.humanReadableName = :applicationName"), @NamedQuery(name="OpenApiDocument.findAllMetadata", query="SELECT new OpenApiDocument(d.id, d.name, d.version, d.humanReadableName) FROM OpenApiDocument d ORDER BY d.name ASC, d.version DESC")})
@EntityListeners(value={OpenAPIDocumentSerializer.class})
@Audited
public class OpenApiDocument
extends AbstractEntity {
    @Column(nullable=false)
    private String name;
    @Column(name="HUMAN_READABLE_NAME", nullable=false, unique=true)
    private String humanReadableName;
    @Column(nullable=false)
    private String version;
    @Column(length=0x100000)
    @Lob
    private String document;
    @OneToMany(targetEntity=Endpoint.class, mappedBy="application", cascade={CascadeType.REMOVE})
    private Collection<Endpoint> endpoints = new ArrayList();
    private transient Swagger swagger;

    public OpenApiDocument() {
    }

    public OpenApiDocument(String id, String name, String version, String humanReadableName) {
        super(id);
        this.name = name;
        this.version = version;
        this.humanReadableName = humanReadableName;
    }

    @PrePersist
    @PreUpdate
    public void updateHumanReadbleName() {
        this.humanReadableName = Normalizer.normalize((String)this.name);
        if (this.humanReadableName.startsWith("/")) {
            this.humanReadableName = this.humanReadableName.substring(1);
        }
    }

    public Swagger getSwagger() {
        try {
            return this.swagger == null ? (this.swagger = (Swagger)SwaggerJsonMapperProducer.lookup().readValue(this.document, Swagger.class)) : this.swagger;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDocument() {
        return this.document;
    }

    public Collection<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHumanReadableName(String humanReadableName) {
        this.humanReadableName = humanReadableName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public void setEndpoints(Collection<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setSwagger(Swagger swagger) {
        this.swagger = swagger;
    }

    public String toString() {
        return "OpenApiDocument(name=" + this.getName() + ")";
    }
}

