/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.User;
import org.tomitribe.tribestream.registryng.entities.AccessToken;
import org.tomitribe.tribestream.registryng.security.LoginContext;
import org.tomitribe.tribestream.registryng.security.oauth2.AccessTokenService;
import org.tomitribe.tribestream.registryng.security.oauth2.InvalidTokenException;

@WebFilter(urlPatterns={"/api/*"})
public class SecurityWebFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(SecurityWebFilter.class.getName());
    @Inject
    private AccessTokenService accessTokenService;
    @Inject
    private LoginContext loginContext;
    private Set<String> urlWhiteList;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.urlWhiteList = Stream.of("/api/server/info", "/api/login", "/api/security/oauth2", "/api/security/oauth2/status").map(p -> filterConfig.getServletContext().getContextPath() + p).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (this.isSecuredPath(httpServletRequest)) {
            String authHeader = httpServletRequest.getHeader("Authorization");
            if (authHeader == null) {
                LOGGER.log(Level.FINE, "No Authorization header");
                this.sendUnauthorizedResponse(servletResponse);
                return;
            }
            if (authHeader.startsWith("Basic ")) {
                if (this.loginBasic(httpServletRequest, authHeader)) {
                    try {
                        filterChain.doFilter(servletRequest, servletResponse);
                    }
                    finally {
                        this.logoutBasic(httpServletRequest);
                    }
                } else {
                    this.sendUnauthorizedResponse(servletResponse);
                }
            } else if (authHeader.startsWith("Bearer ")) {
                try {
                    AccessToken token = this.accessTokenService.findToken(authHeader.substring("Bearer ".length()));
                    this.loginContext.setUsername(token.getUsername());
                    this.loginContext.setRoles(Stream.of((Object[])Optional.ofNullable(token.getScope()).map(s -> s.split(" ")).orElseGet(() -> new String[0])).collect(Collectors.toSet()));
                    filterChain.doFilter(servletRequest, servletResponse);
                }
                catch (InvalidTokenException e) {
                    LOGGER.log(Level.INFO, "Token could not be validated!", e);
                    this.sendUnauthorizedResponse(servletResponse);
                }
            } else {
                LOGGER.log(Level.FINE, "Unsupported authorization header");
                this.sendUnauthorizedResponse(servletResponse);
            }
        } else {
            LOGGER.fine(() -> "Request to " + httpServletRequest.getRequestURI() + " is not secured.");
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void logoutBasic(HttpServletRequest httpServletRequest) throws ServletException {
        httpServletRequest.logout();
    }

    private boolean loginBasic(HttpServletRequest httpServletRequest, String authHeader) {
        String encodedToken = authHeader.substring("Basic ".length());
        String clearToken = new String(Base64.getDecoder().decode(encodedToken), StandardCharsets.UTF_8);
        String[] userPassword = clearToken.split(":");
        if (userPassword.length != 2) {
            return false;
        }
        String username = userPassword[0];
        String password = userPassword[1];
        try {
            httpServletRequest.login(username, password);
            this.loginContext.setUsername(username);
            Principal principal = httpServletRequest.getUserPrincipal();
            if (principal instanceof User) {
                HashSet roles = new HashSet();
                ((User)User.class.cast(principal)).getGroups().forEachRemaining(group -> group.getRoles().forEachRemaining(role -> roles.add(role.getRolename())));
                ((User)User.class.cast(principal)).getRoles().forEachRemaining(role -> roles.add(role.getRolename()));
                this.loginContext.setRoles(roles);
            }
            return true;
        }
        catch (ServletException e) {
            LOGGER.log(Level.WARNING, e, () -> String.format("Login failed for user %s", username));
            return false;
        }
    }

    private boolean isSecuredPath(HttpServletRequest httpServletRequest) {
        return !this.urlWhiteList.contains(httpServletRequest.getRequestURI());
    }

    private void sendUnauthorizedResponse(ServletResponse servletResponse) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.sendError(401);
    }

    public void destroy() {
    }
}

