/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.entities;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import java.io.StringWriter;
import java.io.Writer;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.service.serialization.SwaggerJsonMapperProducer;

public class OpenAPIDocumentSerializer {
    private volatile ObjectMapper mapper;

    @PrePersist
    public void prepersist(Object entity) {
        Endpoint endpoint;
        if (entity instanceof OpenApiDocument) {
            OpenApiDocument document = (OpenApiDocument)entity;
            if (document.getSwagger() != null) {
                document.setDocument(this.convertToJson((Object)document.getSwagger()));
            }
        } else if (entity instanceof Endpoint && (endpoint = (Endpoint)entity).getOperation() != null) {
            endpoint.setDocument(this.convertToJson((Object)endpoint.getOperation()));
        }
    }

    @PostLoad
    public void postLoad(Object entity) {
        if (entity instanceof OpenApiDocument) {
            OpenApiDocument document = (OpenApiDocument)entity;
            document.setSwagger((Swagger)this.readJson(document.getDocument(), Swagger.class));
        } else if (entity instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)entity;
            endpoint.setOperation((Operation)this.readJson(endpoint.getDocument(), Operation.class));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertToJson(Object object) {
        try (StringWriter sw = new StringWriter();){
            this.mapper().writeValue((Writer)sw, object);
            sw.flush();
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T readJson(String s, Class<T> clazz) {
        try {
            return (T)this.mapper().readValue(s, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper mapper() {
        if (this.mapper == null) {
            OpenAPIDocumentSerializer openAPIDocumentSerializer = this;
            synchronized (openAPIDocumentSerializer) {
                if (this.mapper == null) {
                    this.mapper = SwaggerJsonMapperProducer.lookup();
                }
            }
        }
        return this.mapper;
    }
}

