/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.query.AuditQuery;
import org.tomitribe.tribestream.registryng.cdi.Tribe;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.HistoryEntry;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.security.LoginContext;
import org.tomitribe.tribestream.registryng.service.search.SearchEngine;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional
@ApplicationScoped
public class Repository {
    private static final Logger LOGGER = Logger.getLogger(Repository.class.getName());
    @PersistenceContext
    private EntityManager em;
    @Inject
    @Tribe
    private ObjectMapper mapper;
    @Inject
    private LoginContext loginContext;
    @Inject
    private SearchEngine searchEngine;

    public Endpoint findEndpointFromHumanReadableMeta(String humanReadableApplicationName, String verb, String humanReadableEndpointPath, String version) {
        try {
            List endpoints = Optional.ofNullable(version).filter(v -> !v.trim().isEmpty()).map(v -> this.em.createNamedQuery("Endpoint.findByHumanReadablePath", Endpoint.class).setParameter("applicationVersion", (Object)version)).orElseGet(() -> this.em.createNamedQuery("Endpoint.findByHumanReadablePathWithoutVersion", Endpoint.class)).setParameter("applicationName", (Object)humanReadableApplicationName).setParameter("verb", (Object)verb).setParameter("endpointPath", (Object)humanReadableEndpointPath).setMaxResults(2).getResultList();
            if (endpoints.size() > 1) {
                throw new IllegalArgumentException("Conflicting endpoints: " + endpoints);
            }
            if (endpoints.isEmpty()) {
                return null;
            }
            return (Endpoint)endpoints.get(0);
        }
        catch (NoResultException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not find endpoint by {0}/{1}/{2}", new Object[]{humanReadableApplicationName, verb, humanReadableEndpointPath});
            }
            return null;
        }
    }

    public OpenApiDocument findApplicationFromHumanReadableMetadata(String humanReadableApplicationName, String version) {
        try {
            List openApiDocuments = Optional.ofNullable(version).filter(v -> !v.trim().isEmpty()).map(v -> this.em.createNamedQuery("OpenApiDocument.findByHumanReadableName", OpenApiDocument.class).setParameter("applicationVersion", (Object)version)).orElseGet(() -> this.em.createNamedQuery("OpenApiDocument.findByHumanReadableNameWithoutVersion", OpenApiDocument.class)).setParameter("applicationName", (Object)humanReadableApplicationName).setMaxResults(2).getResultList();
            if (openApiDocuments.size() > 1) {
                throw new IllegalArgumentException("Conflicting documents: " + openApiDocuments);
            }
            if (openApiDocuments.isEmpty()) {
                return null;
            }
            return (OpenApiDocument)openApiDocuments.get(0);
        }
        catch (NoResultException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Could not find endpoint by {0}", humanReadableApplicationName);
            }
            return null;
        }
    }

    public OpenApiDocument findByApplicationId(String applicationId) throws NoResultException {
        try {
            return (OpenApiDocument)this.em.createNamedQuery("OpenApiDocument.findByApplicationId", OpenApiDocument.class).setParameter("applicationId", (Object)applicationId).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find application by id {0}", applicationId);
            return null;
        }
    }

    public OpenApiDocument findByApplicationIdAndRevision(String applicationid, int revision) {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.em);
        OpenApiDocument openApiDocument = (OpenApiDocument)auditReader.find(OpenApiDocument.class, (Object)applicationid, (Number)revision);
        for (Endpoint endpoint : openApiDocument.getEndpoints()) {
            endpoint.getDocument();
        }
        return openApiDocument;
    }

    public <T> List<HistoryEntry<T>> getRevisions(Class<T> entityClass, String id, int first, int pageSize) throws NoResultException {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.em);
        AuditQuery query = auditReader.createQuery().forRevisionsOfEntity(entityClass, false, true);
        query.add(AuditEntity.id().eq((Object)id));
        query.addOrder(AuditEntity.revisionNumber().desc());
        query.setFirstResult(first).setMaxResults(pageSize);
        List objects = query.getResultList();
        return objects.stream().map(HistoryEntry::new).collect(Collectors.toList());
    }

    public <T> int getNumberOfRevisions(Class<T> entityClass, String id) {
        AuditQuery query = AuditReaderFactory.get((EntityManager)this.em).createQuery().forRevisionsOfEntity(entityClass, true, true);
        query.add(AuditEntity.id().eq((Object)id));
        query.addProjection(AuditEntity.revisionNumber().count());
        return ((Number)query.getSingleResult()).intValue();
    }

    public OpenApiDocument findByApplicationIdWithEndpoints(String applicationId) {
        try {
            return (OpenApiDocument)this.em.createNamedQuery("OpenApiDocument.findByApplicationIdWithEndpoints", OpenApiDocument.class).setParameter("applicationId", (Object)applicationId).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find application by id {0}", applicationId);
            return null;
        }
    }

    public Endpoint findEndpointByIdAndRevision(String endpointId, int revision) {
        AuditReader auditReader = AuditReaderFactory.get((EntityManager)this.em);
        Endpoint endpoint = (Endpoint)auditReader.find(Endpoint.class, (Object)endpointId, (Number)revision);
        endpoint.getApplication().getId();
        return endpoint;
    }

    public OpenApiDocument findApplicationByNameAndVersion(String name, String version) {
        try {
            return (OpenApiDocument)this.em.createNamedQuery("OpenApiDocument.findByNameAndVersion", OpenApiDocument.class).setParameter("name", (Object)name).setParameter("version", (Object)version).getSingleResult();
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find application by name '{0}' and version '{1}'", new Object[]{name, version});
            return null;
        }
    }

    public List<OpenApiDocument> findAllApplicationsMetadata() {
        List result = this.em.createNamedQuery("OpenApiDocument.findAllMetadata", OpenApiDocument.class).getResultList();
        return result;
    }

    public List<OpenApiDocument> findAllApplicationsWithEndpoints() {
        return this.em.createNamedQuery("OpenApiDocument.findAllWithEndpoints", OpenApiDocument.class).getResultList();
    }

    public Endpoint findEndpointById(String endpointId) {
        try {
            return (Endpoint)this.em.find(Endpoint.class, (Object)endpointId);
        }
        catch (NoResultException e) {
            LOGGER.log(Level.FINE, "Could not find endpoint by id %s", endpointId);
            return null;
        }
    }

    public Collection<Endpoint> findAllEndpoints() {
        return this.em.createNamedQuery("Endpoint.findAllWithApplication", Endpoint.class).getResultList();
    }

    public OpenApiDocument insert(Swagger swagger) {
        OpenApiDocument document = new OpenApiDocument();
        document.setName(swagger.getInfo().getTitle());
        document.setVersion(swagger.getInfo().getVersion());
        Swagger clone = Repository.createShallowCopy((Swagger)swagger);
        clone.setPaths(null);
        document.setSwagger(clone);
        String username = this.getUser();
        Date now = new Date();
        document.setCreatedAt(now);
        document.setUpdatedAt(now);
        document.setCreatedBy(username);
        document.setUpdatedBy(username);
        this.em.persist((Object)document);
        if (swagger.getPaths() != null) {
            for (Map.Entry stringPathEntry : swagger.getPaths().entrySet()) {
                String path = (String)stringPathEntry.getKey();
                Path pathObject = (Path)stringPathEntry.getValue();
                for (Map.Entry httpMethodOperationEntry : pathObject.getOperationMap().entrySet()) {
                    String verb = ((HttpMethod)httpMethodOperationEntry.getKey()).name().toUpperCase();
                    Operation operation = (Operation)httpMethodOperationEntry.getValue();
                    Endpoint endpoint = new Endpoint();
                    endpoint.setApplication(document);
                    endpoint.setPath(path);
                    endpoint.setVerb(verb);
                    endpoint.setOperation(operation);
                    this.em.persist((Object)endpoint);
                    this.em.flush();
                    this.searchEngine.indexEndpoint(endpoint);
                }
            }
        }
        return document;
    }

    protected String getUser() {
        return this.loginContext.getUsername();
    }

    public Endpoint insert(Endpoint endpoint, String applicationId) {
        OpenApiDocument application = this.findByApplicationId(applicationId);
        application.getEndpoints().add(endpoint);
        endpoint.setApplication(application);
        Date now = new Date();
        endpoint.setCreatedAt(now);
        endpoint.setUpdatedAt(now);
        endpoint.setCreatedBy(this.getUser());
        endpoint.setUpdatedBy(this.getUser());
        application.setUpdatedAt(now);
        application.setUpdatedBy(this.getUser());
        this.em.persist((Object)endpoint);
        this.update(application);
        this.em.flush();
        this.searchEngine.indexEndpoint(endpoint);
        return endpoint;
    }

    public static Swagger createShallowCopy(Swagger swagger) {
        Swagger result = new Swagger();
        result.setSwagger(swagger.getSwagger());
        result.info(swagger.getInfo());
        result.setHost(swagger.getHost());
        result.setBasePath(swagger.getBasePath());
        result.setSchemes(swagger.getSchemes());
        result.setConsumes(swagger.getConsumes());
        result.setProduces(swagger.getProduces());
        result.setPaths(swagger.getPaths());
        result.setDefinitions(swagger.getDefinitions());
        result.setParameters(swagger.getParameters());
        result.setResponses(swagger.getResponses());
        result.setSecurityDefinitions(swagger.getSecurityDefinitions());
        result.setSecurity(swagger.getSecurity());
        result.setTags(swagger.getTags());
        result.setExternalDocs(swagger.getExternalDocs());
        return result;
    }

    public OpenApiDocument update(OpenApiDocument document) {
        document.setUpdatedAt(new Date());
        document.setUpdatedBy(this.loginContext.getUsername());
        if (document.getSwagger() != null) {
            document.setDocument(this.convertToJson((Object)document.getSwagger()));
        }
        return (OpenApiDocument)this.em.merge((Object)document);
    }

    public Endpoint update(Endpoint endpoint) {
        endpoint.setUpdatedAt(new Date());
        endpoint.setUpdatedBy(this.loginContext.getUsername());
        if (endpoint.getOperation() != null) {
            endpoint.setDocument(this.convertToJson((Object)endpoint.getOperation()));
        }
        this.searchEngine.indexEndpoint(endpoint);
        return (Endpoint)this.em.merge((Object)endpoint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertToJson(Object object) {
        try (StringWriter sw = new StringWriter();){
            this.mapper.writeValue((Writer)sw, object);
            sw.flush();
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean deleteApplication(String applicationId) {
        OpenApiDocument document = this.findByApplicationId(applicationId);
        if (document == null) {
            return false;
        }
        Optional.ofNullable(document.getEndpoints()).ifPresent(e -> e.forEach(arg_0 -> ((SearchEngine)this.searchEngine).deleteEndpoint(arg_0)));
        this.em.remove((Object)document);
        return true;
    }

    public boolean deleteEndpoint(String applicationId, String endpointId) {
        Endpoint endpoint = this.findEndpointById(endpointId);
        if (endpoint == null || !applicationId.equals(endpoint.getApplication().getId())) {
            return false;
        }
        this.searchEngine.deleteEndpoint(endpoint);
        this.em.remove((Object)endpoint);
        return true;
    }
}

