/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources.enricher;

import java.util.ArrayList;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.EntityLink;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;

@ApplicationScoped
public class Linker {
    public EntityLink[] buildEndpointLinks(UriInfo uriInfo, String applicationId, String endpointId) {
        return (EntityLink[])Stream.of(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)applicationId).resolveTemplate("endpointId", (Object)endpointId)).rel("self").build(new Object[0]), Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("history/application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)applicationId).resolveTemplate("endpointId", (Object)endpointId)).rel("history").build(new Object[0]), Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}").resolveTemplate("applicationId", (Object)applicationId)).rel("application").build(new Object[0])).map(l -> new EntityLink(l.getRel(), l.getUri().toASCIIString())).toArray(EntityLink[]::new);
    }

    public EntityLink[] buildApplicationLinks(UriInfo uriInfo, OpenApiDocument application) {
        ArrayList<Link> result = new ArrayList<Link>(2 + application.getEndpoints().size());
        result.add(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}").resolveTemplate("applicationId", (Object)application.getId())).rel("self").build(new Object[0]));
        result.add(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("history/application/{applicationId}").resolveTemplate("applicationId", (Object)application.getId())).rel("history").build(new Object[0]));
        result.add(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}/endpoint").resolveTemplate("applicationId", (Object)application.getId())).rel("endpoints").build(new Object[0]));
        for (Endpoint endpoint : application.getEndpoints()) {
            result.add(Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)application.getId()).resolveTemplate("endpointId", (Object)endpoint.getId())).rel(endpoint.getVerb().toUpperCase() + " " + endpoint.getPath()).build(new Object[0]));
        }
        return (EntityLink[])result.stream().map(l -> new EntityLink(l.getRel(), l.getUri().toASCIIString())).toArray(EntityLink[]::new);
    }
}

