/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.security.oauth2;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.tomitribe.tribestream.registryng.documentation.Description;

@ApplicationScoped
public class Oauth2Configuration {
    @Inject
    @Description(value="If the token is a JWT the username attribute in the payload")
    @ConfigProperty(name="tribe.registry.oauth2.jwt.username", defaultValue="username")
    private String jwtUsernameAttribute;
    @Inject
    @Description(value="OAuth2 endpoint")
    @ConfigProperty(name="tribe.registry.oauth2.authorizationServerUrl")
    private String authServerUrl;
    @Inject
    @Description(value="OAuth2 client id if used")
    @ConfigProperty(name="tribe.registry.oauth2.clientId")
    private String clientId;
    @Inject
    @Description(value="OAuth2 client secret if client id is set")
    @ConfigProperty(name="tribe.registry.oauth2.clientSecret")
    private String clientSecret;
    @Inject
    @Description(value="OAuth2 HTTP TLS protocol supported")
    @ConfigProperty(name="tribe.registry.oauth2.tlsProtocol", defaultValue="TLSv1.2")
    private String tlsProtocol;
    @Inject
    @Description(value="OAuth2 HTTP TLS provider")
    @ConfigProperty(name="tribe.registry.oauth2.tlsProvider")
    private String tlsProvider;
    @Inject
    @Description(value="OAuth2 truststore")
    @ConfigProperty(name="tribe.registry.oauth2.trustStore")
    private String trustStoreFileName;
    @Inject
    @Description(value="OAuth2 truststore type")
    @ConfigProperty(name="tribe.registry.oauth2.trustStoreType")
    private String trustStoreType;

    public String getJwtUsernameAttribute() {
        return this.jwtUsernameAttribute;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getTlsProtocol() {
        return this.tlsProtocol;
    }

    public String getTlsProvider() {
        return this.tlsProvider;
    }

    public String getTrustStoreFileName() {
        return this.trustStoreFileName;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }
}

