/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.bootstrap;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.tomitribe.tribestream.registryng.cdi.Tribe;
import org.tomitribe.tribestream.registryng.documentation.Description;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.security.LoginContext;
import org.tomitribe.tribestream.registryng.service.search.SearchEngine;

@Singleton
@Startup
public class Provisioning {
    private static final Logger LOGGER = Logger.getLogger(Provisioning.class.getName());
    @Inject
    private LoginContext loginContext;
    @Inject
    private Repository repository;
    @Inject
    private SearchEngine searchEngine;
    @Inject
    @Tribe
    private ObjectMapper mapper;
    @Inject
    @Description(value="Where automatic seeding takes the swagger documents, either at classpath or a directory path")
    @ConfigProperty(name="tribe.registry.seeding.location", defaultValue="seed-db")
    private String location;
    @Inject
    @Description(value="Optional script executed at startup (javascript)")
    @ConfigProperty(name="tribe.registry.seeding.script")
    private String script;

    @PostConstruct
    public void init() {
        this.loginContext.setUsername("system");
        Optional.ofNullable(this.script).ifPresent(s -> {
            block17: {
                ScriptEngine engine = new ScriptEngineManager().getEngineByExtension("js");
                Bindings bindings = engine.createBindings();
                bindings.put("props", (Object)System.getProperties());
                File file = new File((String)s);
                if (file.isFile()) {
                    try (FileReader reader = new FileReader(file);){
                        engine.eval((Reader)reader, bindings);
                        break block17;
                    }
                    catch (IOException | ScriptException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                try {
                    engine.eval((String)s, bindings);
                }
                catch (ScriptException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        this.restore();
    }

    private void seedDatabase() {
        File dir = new File(this.location);
        if (dir.isDirectory()) {
            this.doSeeding(dir);
            return;
        }
        URL res = Thread.currentThread().getContextClassLoader().getResource(this.location);
        if (res == null) {
            LOGGER.log(Level.WARNING, "Cannot find seed-db resource in the classpath.");
            return;
        }
        if (!"file".equals(res.getProtocol())) {
            LOGGER.log(Level.WARNING, "Cannot load initial OpenAPI documents because seed-db is at {0}!", res);
            return;
        }
        this.doSeeding(new File(res.getFile()));
    }

    private void doSeeding(File f) {
        Stream.of((Object[])Optional.ofNullable(f.listFiles((dir, name) -> name.endsWith(".json"))).orElseGet(() -> new File[0])).forEach(arg_0 -> this.seedFile(arg_0));
    }

    private void seedFile(File swaggerFile) {
        LOGGER.info("Seeding " + swaggerFile.getName());
        try {
            Swagger swagger = (Swagger)this.mapper.readValue(swaggerFile, Swagger.class);
            if (this.repository.findApplicationByNameAndVersion(swagger.getInfo().getTitle(), swagger.getInfo().getVersion()) == null) {
                OpenApiDocument openApiDocument = this.repository.insert(swagger);
                LOGGER.log(Level.INFO, "Persisted application {0}-{1}", new Object[]{openApiDocument.getName(), openApiDocument.getVersion()});
            } else {
                LOGGER.log(Level.INFO, "Application {0}-{1} already available in DB ", new Object[]{swagger.getInfo().getTitle(), swagger.getInfo().getVersion()});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, () -> String.format("Seeding %s failed!", swaggerFile.getName()));
        }
        LOGGER.info("Memory = " + ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
    }

    public void restore() {
        if (this.location == null) {
            return;
        }
        List apps = this.repository.findAllApplications();
        apps.forEach(d -> this.repository.deleteApplication(d.getId()));
        this.seedDatabase();
    }
}

