/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.entities;

import io.swagger.models.Operation;
import java.io.IOException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.envers.Audited;
import org.tomitribe.tribestream.registryng.entities.AbstractEntity;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.Normalizer;
import org.tomitribe.tribestream.registryng.entities.OpenAPIDocumentSerializer;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.service.serialization.SwaggerJsonMapperProducer;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="UQ_VERB_PATH", columnNames={"verb", "path"})})
@NamedQueries(value={@NamedQuery(name="Endpoint.findAll", query="SELECT ep FROM Endpoint ep ORDER BY ep.application.name ASC, ep.application.version DESC, ep.path ASC, ep.verb ASC"), @NamedQuery(name="Endpoint.findAllWithApplication", query="SELECT ep FROM Endpoint ep JOIN FETCH ep.application  ORDER BY ep.application.name ASC, ep.application.version DESC, ep.path ASC, ep.verb ASC"), @NamedQuery(name="Endpoint.findByApplicationIdVerbAndPath", query="SELECT ep FROM Endpoint ep JOIN FETCH ep.application  WHERE (concat(ep.application.name, '-', ep.application.version) = :applicationId OR ep.application.id = :applicationId)        AND lower(ep.verb) = lower(:verb) AND ep.path = :path"), @NamedQuery(name="Endpoint.findByHumanReadablePath", query="SELECT ep FROM Endpoint ep JOIN FETCH ep.application WHERE ep.humanReadablePath = :endpointPath AND ep.application.humanReadableName = :applicationName AND lower(ep.verb) = lower(:verb) AND ep.application.version = :applicationVersion"), @NamedQuery(name="Endpoint.findByHumanReadablePathWithoutVersion", query="SELECT ep FROM Endpoint ep JOIN FETCH ep.application WHERE ep.humanReadablePath = :endpointPath AND ep.application.humanReadableName = :applicationName AND lower(ep.verb) = lower(:verb) ORDER BY ep.application.version")})
@EntityListeners(value={OpenAPIDocumentSerializer.class})
@Audited
public class Endpoint
extends AbstractEntity {
    @ManyToOne(targetEntity=OpenApiDocument.class, optional=false)
    @JoinColumn(name="APPLICATION_ID", nullable=false, foreignKey=@ForeignKey(name="FK_ENDPOINT_APPLICATION_01"))
    private OpenApiDocument application;
    @Column(name="PATH", nullable=false)
    private String path;
    @Column(name="VERB", nullable=false)
    private String verb;
    @Column(length=0x100000)
    @Lob
    private String document;
    @Column(name="EXTERNAL_INDEX_ID")
    private String elasticsearchId;
    @Column(name="HUMAN_READABLE_PATH", nullable=false)
    private String humanReadablePath;
    private transient Operation operation;

    @PrePersist
    @PreUpdate
    public void updateHumanReadblePath() {
        this.humanReadablePath = Normalizer.normalize((String)this.path);
        if (this.humanReadablePath.startsWith("/")) {
            this.humanReadablePath = this.humanReadablePath.substring(1);
        }
    }

    public Operation getOperation() {
        try {
            return this.operation == null ? (this.operation = (Operation)SwaggerJsonMapperProducer.lookup().readValue(this.document, Operation.class)) : this.operation;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }

    public Endpoint() {
    }

    private Endpoint(OpenApiDocument application, String path, String verb, String document, String elasticsearchId, String humanReadablePath, Operation operation) {
        this.application = application;
        this.path = path;
        this.verb = verb;
        this.document = document;
        this.elasticsearchId = elasticsearchId;
        this.humanReadablePath = humanReadablePath;
        this.operation = operation;
    }

    public OpenApiDocument getApplication() {
        return this.application;
    }

    public String getPath() {
        return this.path;
    }

    public String getVerb() {
        return this.verb;
    }

    public String getDocument() {
        return this.document;
    }

    public String getElasticsearchId() {
        return this.elasticsearchId;
    }

    public String getHumanReadablePath() {
        return this.humanReadablePath;
    }

    public void setApplication(OpenApiDocument application) {
        this.application = application;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public void setElasticsearchId(String elasticsearchId) {
        this.elasticsearchId = elasticsearchId;
    }

    public void setHumanReadablePath(String humanReadablePath) {
        this.humanReadablePath = humanReadablePath;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String toString() {
        return "Endpoint(path=" + this.getPath() + ", verb=" + this.getVerb() + ")";
    }
}

