/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import io.swagger.models.Operation;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.EndpointWrapper;
import org.tomitribe.tribestream.registryng.domain.EntityLink;
import org.tomitribe.tribestream.registryng.domain.HistoryItem;
import org.tomitribe.tribestream.registryng.domain.HistoryPage;
import org.tomitribe.tribestream.registryng.domain.TribestreamOpenAPIExtension;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenAPIDocumentSerializer;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.resources.processor.ApplicationProcessor;

@Path(value="/history/application")
@ApplicationScoped
@Produces(value={"application/json"})
public class HistoryResource {
    private final Repository repository;
    private final OpenAPIDocumentSerializer documentSerializer;
    private final ApplicationProcessor processor;
    private final TribestreamOpenAPIExtension extensions;

    @GET
    @Path(value="/{applicationId}")
    public Response getApplicationHistory(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @QueryParam(value="page") @DefaultValue(value="1") int page, @QueryParam(value="per_page") @DefaultValue(value="20") int perPage, @QueryParam(value="payload") @DefaultValue(value="false") boolean payload) {
        int first = (page - 1) * perPage;
        List history = this.repository.getRevisions(OpenApiDocument.class, applicationId, first, perPage);
        List result = history.stream().map(HistoryItem::new).collect(Collectors.toList());
        UriBuilder historyApplicationBaseUriBuilder = uriInfo.getBaseUriBuilder().path("history/application/{applicationId}").resolveTemplate("applicationId", (Object)applicationId);
        return Response.ok((Object)new HistoryPage(result, (EntityLink[])Stream.of(this.buildPaginationLinks(historyApplicationBaseUriBuilder, this.repository.getNumberOfRevisions(OpenApiDocument.class, applicationId), page, perPage), this.buildRevisionLinks(historyApplicationBaseUriBuilder, result), {this.buildCurrentApplicationLink(uriInfo, applicationId)}).flatMap(Stream::of).toArray(EntityLink[]::new))).build();
    }

    private EntityLink buildCurrentApplicationLink(UriInfo uriInfo, String applicationId) {
        Link link = Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}").resolveTemplate("applicationId", (Object)applicationId)).rel("application").build(new Object[0]);
        return new EntityLink(link.getRel(), link.getUri().toASCIIString());
    }

    private EntityLink buildCurrentEndpointLink(UriInfo uriInfo, String applicationId, String endpointId) {
        Link link = Link.fromUriBuilder((UriBuilder)uriInfo.getBaseUriBuilder().path("application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)applicationId).resolveTemplate("endpointId", (Object)endpointId)).rel("application").build(new Object[0]);
        return new EntityLink(link.getRel(), link.getUri().toASCIIString());
    }

    private EntityLink[] buildRevisionLinks(UriBuilder baseUriBuilder, List<HistoryItem> historyItems) {
        return (EntityLink[])historyItems.stream().map(historyItem -> Link.fromUriBuilder((UriBuilder)baseUriBuilder.clone().path("/{revisionId}").queryParam("per_page", new Object[]{"1"}).queryParam("page", new Object[]{"1"}).resolveTemplate("revisionId", (Object)historyItem.getRevisionId())).rel("revision " + historyItem.getRevisionId()).build(new Object[0])).map(link -> new EntityLink(link.getRel(), link.getUri().toASCIIString())).toArray(EntityLink[]::new);
    }

    private EntityLink[] buildPaginationLinks(UriBuilder pageUriBuilder, int numberOfRevisions, int currentPage, int currentPageSize) {
        ArrayList<Link> result = new ArrayList<Link>();
        result.add(this.createLink(pageUriBuilder, currentPage, currentPageSize, "self"));
        if (numberOfRevisions >= 1) {
            result.add(this.createLink(pageUriBuilder, 1, currentPageSize, "first"));
            result.add(this.createLink(pageUriBuilder, numberOfRevisions / currentPageSize + 1, currentPageSize, "last"));
        }
        if (numberOfRevisions > currentPage * currentPageSize) {
            result.add(this.createLink(pageUriBuilder, currentPage + 1, currentPageSize, "next"));
        }
        if (currentPage > 1) {
            result.add(this.createLink(pageUriBuilder, currentPage - 1, currentPageSize, "previous"));
        }
        return (EntityLink[])result.stream().map(link -> new EntityLink(link.getRel(), link.getUri().toASCIIString())).toArray(EntityLink[]::new);
    }

    @GET
    @Path(value="/{applicationId}/endpoint/{endpointId}")
    public Response getEndpointHistory(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="endpointId") String endpointId, @QueryParam(value="page") @DefaultValue(value="1") int page, @QueryParam(value="per_page") @DefaultValue(value="20") int perPage) {
        int first = (page - 1) * perPage;
        List history = this.repository.getRevisions(Endpoint.class, endpointId, first, perPage);
        List result = history.stream().map(HistoryItem::new).collect(Collectors.toList());
        UriBuilder endpointHistoryBaseUriBuilder = uriInfo.getBaseUriBuilder().path("history/application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)applicationId).resolveTemplate("endpointId", (Object)endpointId);
        return Response.ok((Object)new HistoryPage(result, (EntityLink[])Stream.of(this.buildPaginationLinks(endpointHistoryBaseUriBuilder, this.repository.getNumberOfRevisions(Endpoint.class, endpointId), page, perPage), this.buildRevisionLinks(endpointHistoryBaseUriBuilder, result)).flatMap(Stream::of).toArray(EntityLink[]::new))).build();
    }

    @GET
    @Path(value="/{applicationId}/{revisionId:[0-9]+}")
    public Response getApplicationWithRevision(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="revisionId") int revisionId) {
        OpenApiDocument application = this.repository.findByApplicationIdAndRevision(applicationId, revisionId);
        if (application == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.documentSerializer.postLoad((Object)application);
        return Response.ok((Object)this.processor.toWrapper(application, new EntityLink[]{this.buildCurrentApplicationLink(uriInfo, applicationId)})).build();
    }

    @GET
    @Path(value="/{applicationId}/endpoint/{endpointId}/{revisionId:[0-9]+}")
    public Response getEndpointWithRevision(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="endpointId") String endpointId, @PathParam(value="revisionId") int revisionId) {
        Endpoint endpoint = this.repository.findEndpointByIdAndRevision(endpointId, revisionId);
        if (endpoint == null || endpoint.getApplication().getId() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.documentSerializer.postLoad((Object)endpoint);
        Operation operation = endpoint.getOperation();
        this.extensions.setLinks(operation, new EntityLink[]{this.buildCurrentEndpointLink(uriInfo, applicationId, endpointId)});
        EndpointWrapper endpointWrapper = new EndpointWrapper(applicationId, endpointId, endpoint.getHumanReadablePath(), endpoint.getVerb(), endpoint.getPath(), operation, endpoint.getDocument());
        return Response.ok((Object)endpointWrapper).build();
    }

    private Link createLink(UriBuilder uriBuilder, int page, int currentPageSize, String rel) {
        return Link.fromUriBuilder((UriBuilder)uriBuilder.clone().queryParam("page", new Object[]{page}).queryParam("per_page", new Object[]{currentPageSize})).rel(rel).build(new Object[0]);
    }

    @ConstructorProperties(value={"repository", "documentSerializer", "processor", "extensions"})
    @Inject
    public HistoryResource(Repository repository, OpenAPIDocumentSerializer documentSerializer, ApplicationProcessor processor, TribestreamOpenAPIExtension extensions) {
        this.repository = repository;
        this.documentSerializer = documentSerializer;
        this.processor = processor;
        this.extensions = extensions;
    }

    public HistoryResource() {
        this.repository = null;
        this.documentSerializer = null;
        this.processor = null;
        this.extensions = null;
    }
}

