/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.service.monitoring;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.tomitribe.tribestream.registryng.documentation.Description;
import org.tomitribe.tribestream.registryng.service.monitoring.Alert;

@ApplicationScoped
public class MailAlerter {
    @Inject
    @Description(value="Is mail alerting active")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.active", defaultValue="false")
    private volatile Boolean active;
    @Inject
    @Description(value="Mail transport")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.transport", defaultValue="smtp")
    private String transport;
    @Inject
    @Description(value="Mail user if authentication is required")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.user")
    private String user;
    @Inject
    @Description(value="Mail password if authentication is required")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.password")
    private String password;
    @Inject
    @Description(value="Mail server host")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.host")
    private String host;
    @Inject
    @Description(value="Mail server port")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.port")
    private Integer port;
    @Inject
    @Description(value="Mail sending timeout")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.timeout", defaultValue="0")
    private Integer timeout;
    @Inject
    @Description(value="Is tls needed")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.tls", defaultValue="false")
    private Boolean tls;
    @Inject
    @Description(value="Is authentication required (automatic if password is provided)")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.auth", defaultValue="false")
    private Boolean auth;
    @Inject
    @Description(value="Mail recipient for alerts")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.to")
    private String to;
    @Inject
    @Description(value="Mail from value")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.from")
    private String from;
    @Inject
    @Description(value="Subject of the mail, ${hostname} and ${date} can be used as templates")
    @ConfigProperty(name="tribe.registry.monitoring.alerter.mail.subject", defaultValue="[ALERT][REGISTRY][${hostname}][${date}]")
    private String subjectTemplate;
    private String hostname;
    private Session session;

    @PostConstruct
    private void init() {
        this.active = this.active != false && this.to != null;
        if (!this.active.booleanValue()) {
            return;
        }
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.hostname = "unknown";
        }
        Properties properties = new Properties();
        properties.setProperty("mail.transport.protocol", this.transport);
        properties.setProperty("mail." + this.transport + ".host", this.host);
        properties.setProperty("mail." + this.transport + ".port", Integer.toString(this.port));
        if (this.tls.booleanValue()) {
            properties.setProperty("mail." + this.transport + ".starttls.enable", "true");
        }
        if (this.user != null) {
            properties.setProperty("mail." + this.transport + ".user", this.user);
        }
        if (this.password != null) {
            properties.setProperty("password", this.password);
        }
        if (this.auth.booleanValue() || this.password != null) {
            properties.setProperty("mail." + this.transport + ".auth", "true");
        }
        if (this.timeout > 0) {
            properties.setProperty("mail." + this.transport + ".timeout", Integer.toString(this.timeout));
        }
        if (this.password != null) {
            PasswordAuthentication pa = new PasswordAuthentication(this.user, this.password);
            this.session = Session.getInstance((Properties)properties, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.session = Session.getInstance((Properties)properties);
        }
    }

    @PreDestroy
    private void stop() {
        this.active = false;
    }

    public void onAlert(@Observes Alert alert) {
        if (!this.active.booleanValue()) {
            return;
        }
        try {
            this.sendMail(alert);
        }
        catch (MessagingException e) {
            throw new IllegalStateException(e);
        }
    }

    private void sendMail(Alert alert) throws MessagingException {
        String subject = StrSubstitutor.replace((Object)this.subjectTemplate, (Map)new /* Unavailable Anonymous Inner Class!! */);
        String body = alert.text();
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(this.from));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.to));
        message.setSubject(subject);
        message.setText(body);
        Transport.send((Message)message);
    }

    static /* synthetic */ String access$000(MailAlerter x0) {
        return x0.hostname;
    }
}

