/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.service.monitoring;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.tomitribe.tribestream.registryng.documentation.Description;
import org.tomitribe.tribestream.registryng.service.monitoring.Alert;
import org.tomitribe.tribestream.registryng.service.monitoring.MonitoringService;
import org.tomitribe.tribestream.registryng.service.monitoring.Validation;
import org.tomitribe.tribestream.registryng.service.monitoring.ValidationWrapper;
import org.tomitribe.util.Duration;

@Startup
@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@TransactionManagement(value=TransactionManagementType.BEAN)
public class MonitoringService {
    private static final Logger log = Logger.getLogger(MonitoringService.class.getName());
    @Resource
    private TimerService timerService;
    @Inject
    @Description(value="How often health checks are executed")
    @ConfigProperty(name="tribe.registry.monitoring.period", defaultValue="5 minutes")
    private String period;
    @Inject
    @Description(value="How often health checks are executed")
    @ConfigProperty(name="tribe.registry.monitoring.startup-silent-period", defaultValue="5 minutes")
    private String startupSilentPeriod;
    @Inject
    private HTTPMonitoringValidator httpValidator;
    @Inject
    private DatabaseMonitoringValidator mySqlValidator;
    @Inject
    private Event<Alert> alert;
    private long startedAt;
    private Timer timer;
    private long periodMs;
    private volatile boolean running = false;
    private volatile long lastRun = -1L;
    private volatile List<ValidationWrapper> last;

    @PostConstruct
    private void boot() {
        this.startedAt = System.currentTimeMillis();
        if ("skip".equals(this.period)) {
            log.info("Monitoring is disabled");
            return;
        }
        this.periodMs = new Duration(this.period, TimeUnit.SECONDS).getTime(TimeUnit.MILLISECONDS);
        if (this.periodMs <= 0L) {
            log.info("Monitoring is disabled");
            return;
        }
        this.monitor(null);
        this.timer = this.timerService.createIntervalTimer(this.periodMs, this.periodMs, new TimerConfig((Serializable)((Object)"tribestream-api-registry-monitoring"), false));
        log.info("Monitoring active each " + this.periodMs + "ms");
    }

    @PreDestroy
    private void destroy() {
        Optional.ofNullable(this.timer).ifPresent(Timer::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    public void monitor(Timer ignored) {
        long now = System.currentTimeMillis();
        if (this.running) {
            if (now - this.lastRun > this.periodMs * 2L) {
                log.severe("Seems validation are really slow (taking more than twice the run period: " + this.period + ")");
            }
            return;
        }
        this.running = true;
        try {
            List validations;
            this.last = validations = Stream.of(this.httpValidator, this.mySqlValidator).map(e -> new ValidationWrapper(e.name(), e.valid())).collect(Collectors.toList());
            long end = System.currentTimeMillis();
            if (end - now > this.periodMs) {
                log.warning("Validations take longer than the period: period=" + this.period + ", validation duration=" + TimeUnit.MILLISECONDS.toSeconds(end - now) + "s");
            }
            if (validations.stream().filter(v -> v.getValidation().getState() == Validation.State.KO).findFirst().isPresent()) {
                this.onError(validations);
            } else {
                log.fine("All validations suceeded");
            }
        }
        catch (Throwable exception) {
            log.log(Level.SEVERE, "Error running validations", exception);
        }
        finally {
            this.lastRun = now;
            this.running = false;
        }
    }

    private void onError(Collection<ValidationWrapper> messages) {
        if (System.currentTimeMillis() - this.startedAt < new Duration(this.startupSilentPeriod, TimeUnit.MILLISECONDS).getTime()) {
            return;
        }
        this.alert.fire((Object)new Alert(messages));
    }

    public Collection<ValidationWrapper> currentHealth() {
        return this.last;
    }
}

