webpackJsonp([0],[
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	__webpack_require__(1);
	__webpack_require__(13);
	__webpack_require__(16);
	__webpack_require__(18);
	__webpack_require__(19);
	__webpack_require__(24);
	__webpack_require__(28);
	__webpack_require__(32);
	__webpack_require__(34);
	__webpack_require__(36);
	__webpack_require__(37);
	__webpack_require__(38);
	__webpack_require__(39);
	__webpack_require__(40);
	__webpack_require__(46);
	__webpack_require__(50);
	__webpack_require__(53);
	__webpack_require__(54);
	__webpack_require__(69);
	__webpack_require__(79);
	var tribe_main;
	(function (tribe_main) {
	    angular.module('tribe-main', [
	        'website-components',
	        'website-services',
	        'website-messages',
	        'ngRoute',
	        'ngStorage',
	        'foundation',
	        'tribe-app',
	        'tribe-authentication',
	        'tribe-endpoints',
	        'tribe-endpoints-details'
	    ])
	        .config([
	        '$locationProvider', '$routeProvider', '$httpProvider', '$logProvider',
	        function ($locationProvider, $routeProvider, $httpProvider, $logProvider) {
	            $logProvider.debugEnabled(false); // GUI is really too slow, let's use a debugger if needed
	            // important so that we can intercept any 401 and fire
	            // an authentication process
	            $httpProvider.interceptors.push('httpInterceptor');
	            $locationProvider.html5Mode({
	                enabled: true,
	                requireBase: true
	            });
	            $routeProvider
	                .when('/', {
	                template: __webpack_require__(92)
	            })
	                .when('/showcase', {
	                template: __webpack_require__(93),
	                controller: ['$scope', function ($scope) {
	                        $scope.toUppercase = function (item) {
	                            if (!item) {
	                                return null;
	                            }
	                            if (item.text) {
	                                return item.text.toUpperCase();
	                            }
	                            return item.toUpperCase();
	                        };
	                    }]
	            })
	                .when('/see/:aggregatedId', {
	                template: __webpack_require__(94),
	                controller: ['$scope', '$routeParams', function ($scope, $routeParams) {
	                        $scope.aggregatedId = $routeParams.aggregatedId;
	                    }]
	            })
	                .when('/application/:applicationName*', {
	                template: __webpack_require__(95),
	                controller: ['$scope', '$routeParams', function ($scope, $routeParams) {
	                        $scope.app = $routeParams.applicationName;
	                    }]
	            })
	                .when('/application', {
	                template: __webpack_require__(95),
	                controller: ['$scope', '$routeParams', function ($scope, $routeParams) {
	                        //$scope.app = $routeParams.applicationName;
	                    }]
	            })
	                .when('/endpoint/:application/:verb/:endpoint*', {
	                template: __webpack_require__(96),
	                controller: ['$scope', '$routeParams', function ($scope, $routeParams) {
	                        $scope.requestMetadata = {
	                            applicationName: $routeParams.application,
	                            verb: $routeParams.verb,
	                            endpointPath: $routeParams.endpoint,
	                            version: $routeParams.version
	                        };
	                    }]
	            })
	                .when('/endpoint/:application', {
	                template: __webpack_require__(96),
	                controller: ['$scope', '$routeParams', function ($scope, $routeParams) {
	                        $scope.requestMetadata = {
	                            applicationName: $routeParams.application,
	                            version: $routeParams.version
	                        };
	                    }]
	            })
	                .when('/login', {
	                template: __webpack_require__(97)
	            })
	                .otherwise({
	                controller: ['$scope', '$location', function ($scope, $location) {
	                        $scope.path = $location.path();
	                    }],
	                template: __webpack_require__(98)
	            });
	        }
	    ])
	        .factory('httpInterceptor', ['$q', '$window', '$location', 'currentAuthProvider',
	        function ($q, $window, $location, currentAuthProvider) {
	            return {
	                'request': function (config) {
	                    if (config.url != 'api/security/oauth2' && currentAuthProvider.isActive()) {
	                        return currentAuthProvider.get().getAuthorizationHeader().then(function (token) {
	                            config.headers['Authorization'] = token;
	                            return config;
	                        });
	                    }
	                    return config;
	                },
	                'responseError': function (response) {
	                    if (response.status === 401) {
	                        $location.url('/login');
	                    }
	                    return $q.reject(response);
	                }
	            };
	        }
	    ])
	        .run(['$rootScope', function ($rootScope) {
	            $rootScope.baseFullPath = angular.element('head base').first().attr('href');
	        }])
	        .run(['tribeAuthorizationService', 'currentAuthProvider', function (Authorization, currentProvider) {
	            if (Authorization.isConnected()) {
	                var provider = Authorization.restoreSession();
	                if (provider) {
	                    currentProvider.set(provider);
	                }
	            }
	        }])
	        .run(['tribeAuthorizationService', '$location', function (Authorization, $location) {
	            // redirect to login in case the session storage is empty.
	            if (!Authorization.isConnected()) {
	                // save target path to be used once we successfuly log in.
	                Authorization.targetPath = $location.path();
	                $location.path("/login");
	            }
	            else if ($location.path() === "/login") {
	                $location.path("/");
	            }
	        }])
	        .config(['$logProvider', function ($logProvider) {
	            if (true) {
	                $logProvider.debugEnabled(false);
	            }
	        }]);
	})(tribe_main || (tribe_main = {}));


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var components;
	(function (components) {
	    var marked = __webpack_require__(2);
	    angular.module('website-components', [
	        'ui.codemirror',
	        'website-components-filters',
	        'website-components-multiselect',
	        'website-components-singleselect',
	        'website-components-text',
	        'website-components-tip',
	        'website-components-markdown',
	        'website-components-diff'
	    ])
	        .directive('tribeCheckbox', ['$timeout', function ($timeout) {
	            return {
	                restrict: 'A',
	                scope: {
	                    value: '=',
	                    change: '&?'
	                },
	                template: __webpack_require__(3),
	                controller: ['$scope', function ($scope) {
	                        $scope['keyTriggered'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                            $scope['value'] = !$scope['value'];
	                        }); }); };
	                        $scope.$watch('value', function () {
	                            if ($scope['change'] !== undefined) {
	                                $scope['change']();
	                            }
	                        });
	                    }]
	            };
	        }])
	        .directive('tribeConfirmBtn', ['$timeout', function ($timeout) {
	            return {
	                restrict: 'A',
	                scope: {
	                    callback: '=',
	                    message: '@',
	                    icon: '@',
	                    label: '@?'
	                },
	                template: __webpack_require__(4),
	                link: function (scope, el) {
	                    el.find('.trigger').on('click', function () {
	                        el.addClass('visible');
	                    });
	                    el.find('button.cancel').on('click', function () {
	                        el.removeClass('visible');
	                    });
	                    el.find('button.confirm').on('click', function () {
	                        el.removeClass('visible');
	                        scope['callback']();
	                    });
	                }
	            };
	        }])
	        .directive('tribeEditableButtonText', [function () {
	            return {
	                restrict: 'A',
	                scope: {
	                    value: '='
	                },
	                template: __webpack_require__(5)
	            };
	        }])
	        .directive('tribeEditableLink', ['$document', function ($document) {
	            return {
	                restrict: 'A',
	                scope: {
	                    href: '=',
	                    title: '=',
	                    emptyText: '@?'
	                },
	                template: __webpack_require__(6),
	                controller: ['$scope', function ($scope) {
	                        if (!$scope.emptyText || $scope.emptyText.trim() === '') {
	                            $scope.emptyText = 'Empty link';
	                        }
	                    }],
	                link: function (scope, el, attrs, controller) {
	                    var valueDiv = el.find('.value');
	                    valueDiv.detach();
	                    var body = $document.find('body');
	                    var clear = function () {
	                        el.removeClass('visible');
	                        valueDiv.detach();
	                    };
	                    var elWin = $($document.find('div[data-app-endpoints-details] > div'));
	                    el.find('div.edit-trigger').on('click', function () {
	                        if (el.hasClass('visible')) {
	                            valueDiv.detach();
	                            el.removeClass('visible');
	                            valueDiv.off('scroll', clear);
	                        }
	                        else {
	                            var pos = el.find('> div').offset();
	                            valueDiv.css({
	                                top: (pos.top + el.find('> div').outerHeight()) + "px",
	                                left: pos.left + "px"
	                            });
	                            body.append(valueDiv);
	                            el.addClass('visible');
	                            elWin.on('scroll', clear);
	                        }
	                    });
	                    scope.$on('$destroy', function () {
	                        valueDiv.remove();
	                        elWin.off('scroll', clear);
	                    });
	                }
	            };
	        }])
	        .directive('tribeEditableMd', [function () {
	            return {
	                restrict: 'A',
	                scope: {
	                    content: '='
	                },
	                template: __webpack_require__(7),
	                controller: ['$scope', '$timeout', '$element', function ($scope, $timeout, $element) {
	                        $scope.editorHolder = {
	                            editor: null
	                        };
	                        $scope.cmOption = {
	                            lineNumbers: false,
	                            lineWrapping: true,
	                            viewportMargin: Infinity,
	                            mode: 'markdown',
	                            onLoad: function (editor) {
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        $scope.editorHolder.editor = editor;
	                                    });
	                                });
	                            }
	                        };
	                        $scope.$watch('content', function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    if (!$scope.content || $scope.content.trim() === '') {
	                                        $scope.compiledContent = '';
	                                    }
	                                    else {
	                                        $scope.compiledContent = marked($scope.content);
	                                    }
	                                });
	                            });
	                        });
	                        $scope.codemirrorLoaded = function (_editor) {
	                            _editor.on("blur", function () {
	                                $element.removeClass('edit');
	                            });
	                        };
	                    }],
	                link: function (scope, el, attr, controller) {
	                    scope.$watch('editorHolder.editor', function () {
	                        var editor = scope.$eval('editorHolder.editor');
	                        if (editor) {
	                            var activate = function () {
	                                el.addClass('edit');
	                                editor.refresh();
	                                editor.focus();
	                            };
	                            el.on('click', activate);
	                            el.find('> div').on('focus', activate);
	                            editor.on('blur', function () {
	                                el.removeClass('edit');
	                            });
	                        }
	                    });
	                }
	            };
	        }])
	        .directive('tribeEditableBlock', [function () {
	            return {
	                restrict: 'A',
	                scope: {
	                    content: '='
	                },
	                template: __webpack_require__(8),
	                controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                        $scope.editorHolder = {
	                            editor: null
	                        };
	                        $scope.cmOption = {
	                            lineNumbers: false,
	                            lineWrapping: true,
	                            viewportMargin: Infinity,
	                            onLoad: function (editor) {
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        $scope.editorHolder.editor = editor;
	                                    });
	                                });
	                            }
	                        };
	                    }],
	                link: function (scope, el, attr, controller) {
	                    scope.$watch('editorHolder.editor', function () {
	                        var editor = scope.$eval('editorHolder.editor');
	                        if (editor) {
	                            editor.refresh();
	                            var activate = function () {
	                                el.addClass('edit');
	                                editor.refresh();
	                                editor.focus();
	                            };
	                            el.on('click', activate);
	                            el.find('> div').on('focus', activate);
	                            editor.on('blur', function () {
	                                el.removeClass('edit');
	                            });
	                        }
	                    });
	                }
	            };
	        }])
	        .directive('tribeEditableNumber', ['$timeout', function ($timeout) {
	            return {
	                restrict: 'A',
	                scope: {
	                    value: '=',
	                    adjust: '@?',
	                    placeholder: '@?'
	                },
	                template: __webpack_require__(9),
	                link: function (scope, el, attrs, controller) {
	                    var activate = function () {
	                        var span = el.find('span');
	                        el.addClass('edit');
	                        var input = el.find('input');
	                        if (scope['adjust'] !== 'false') {
	                            input.width(70);
	                        }
	                        input.focus();
	                    };
	                    el.on('focus', activate);
	                    el.find('input').on('blur', function () {
	                        el.removeClass('edit');
	                    });
	                    el.find('> div').on('focus', activate);
	                }
	            };
	        }])
	        .directive('tribeEditableText1', [function () {
	            return {
	                restrict: 'A',
	                scope: {
	                    value: '=',
	                    placeholder: '@?'
	                },
	                template: __webpack_require__(10),
	                link: function (scope, el) {
	                    var activate = function () {
	                        el.addClass('edit');
	                        var input = el.find('input');
	                        input.focus();
	                    };
	                    el.on('focus', activate);
	                    el.find('> div').on('focus', activate);
	                    el.find('input').on('blur', function () {
	                        el.removeClass('edit');
	                    });
	                }
	            };
	        }])
	        .directive('tribeEditableOption', ['$timeout', '$document', function ($timeout, $document) {
	            return {
	                restrict: 'A',
	                scope: {
	                    value: '=',
	                    options: '=',
	                    defaultText: '@?',
	                    emptyText: '@?',
	                    onEditModeOn: '&?',
	                    onEditModeOff: '&?'
	                },
	                template: __webpack_require__(11),
	                controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                        $scope['uniqueId'] = _.uniqueId('tribeEditableOption_');
	                        $scope.visible = false;
	                        if (!$scope.emptyText) {
	                            $scope.emptyText = 'empty';
	                        }
	                        $scope.selectOption = function (opt) { return $timeout(function () { return $scope.$apply(function () {
	                            $scope.value = opt;
	                            $scope.visible = false;
	                        }); }); };
	                        $scope.$watch('value', function () {
	                            if (!$scope.value) {
	                                $timeout(function () { return $scope.$apply(function () { return $scope.valueText = ''; }); });
	                            }
	                            else {
	                                $timeout(function () { return $scope.$apply(function () {
	                                    for (var _i = 0, _a = $scope.options; _i < _a.length; _i++) {
	                                        var opt = _a[_i];
	                                        if (opt === $scope.value || opt.value === $scope.value) {
	                                            $scope.valueText = opt.text ? opt.text : opt;
	                                            return;
	                                        }
	                                    }
	                                    $scope.valueText = '';
	                                }); });
	                            }
	                        });
	                        $scope.open = function () { return $timeout(function () { return $scope.$apply(function () {
	                            $scope.visible = true;
	                        }); }); };
	                    }],
	                link: function (scope, el) { return $timeout(function () {
	                    var optionsDiv = el.find('.options');
	                    optionsDiv.detach();
	                    var body = $document.find('body');
	                    var detachPromise = null;
	                    var detachOptions = function () {
	                        optionsDiv.detach();
	                        el.removeClass('visible');
	                        $timeout(function () { return scope.$apply(function () {
	                            scope['visible'] = false;
	                            if (scope['onEditModeOff']) {
	                                scope['onEditModeOff']({ 'uniqueId': scope['uniqueId'] });
	                            }
	                        }); });
	                    };
	                    el.on('mouseover', function () {
	                        $document.off('click', detachOptions);
	                    });
	                    optionsDiv.on('mouseover', function () {
	                        $document.off('click', detachOptions);
	                    });
	                    el.on('mouseout', function () {
	                        $document.on('click', detachOptions);
	                    });
	                    optionsDiv.on('mouseout', function () {
	                        $document.on('click', detachOptions);
	                    });
	                    scope.$watch('visible', function () {
	                        if (scope['visible']) {
	                            el.addClass('visible');
	                            var pos = el.find('> div').offset();
	                            optionsDiv.css({
	                                top: (pos.top + el.find('> div').height()) + "px",
	                                left: pos.left + "px"
	                            });
	                            body.append(optionsDiv);
	                            $document.on('click', detachOptions);
	                            if (scope['onEditModeOn']) {
	                                scope['onEditModeOn']({ 'uniqueId': scope['uniqueId'] });
	                            }
	                        }
	                        else {
	                            detachOptions();
	                            $document.off('click', detachOptions);
	                        }
	                    });
	                    var escapeDetach = function (event) {
	                        if (event.keyCode === 27 /* Escape */) {
	                            detachOptions();
	                        }
	                    };
	                    $document.on('keyup', escapeDetach);
	                    scope.$on('$destroy', function () {
	                        el.remove();
	                        optionsDiv.remove();
	                        $document.off('click', detachOptions);
	                        $document.off('keyup', escapeDetach);
	                    });
	                }); }
	            };
	        }])
	        .directive('tribeSwitch', ['$timeout', function ($timeout) {
	            return {
	                restrict: 'A',
	                scope: {
	                    value: '=',
	                    trueValue: '=?',
	                    falseValue: '=?'
	                },
	                template: __webpack_require__(12),
	                link: function (scope, el) {
	                    scope['uniqueId'] = _.uniqueId('tribeSwitch-');
	                    var updateValue = function () {
	                        $timeout(function () {
	                            scope.$apply(function () {
	                                scope['value'] = !scope['value'];
	                            });
	                        });
	                    };
	                    el.find('div[tabindex]').on('click', updateValue);
	                    el.find('div[tabindex]').on('keypress', updateValue);
	                },
	                controller: ['$scope', function ($scope) {
	                        if (_.isNull($scope['trueValue']) || _.isUndefined($scope['trueValue'])) {
	                            $scope['trueValue'] = true;
	                        }
	                        if (_.isNull($scope['falseValue']) || _.isUndefined($scope['falseValue'])) {
	                            $scope['falseValue'] = false;
	                        }
	                    }]
	            };
	        }]);
	})(components || (components = {}));


/***/ },
/* 2 */,
/* 3 */
/***/ function(module, exports) {

	module.exports = "<div x-ng-click=\"keyTriggered()\" x-ng-keyup=\"keyTriggered()\" tabindex=\"0\"><div class=\"false\" x-ng-if=\"!value\"></div><div class=\"true\" x-ng-if=\"value\"><i class=\"fa fa-check\"></i></div></div>";

/***/ },
/* 4 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"trigger\"><i class=\"fa fa-{{icon}}\"></i><span x-ng-if=\"label\">{{label}}</span></div><div class=\"confirmation-popup\"><div><div><i class=\"fa fa-exclamation-triangle\"></i><p>{{message}}</p></div><div><div><button class=\"cancel inverted\">Cancel</button><button class=\"confirm\">Confirm</button></div></div></div></div></div>";

/***/ },
/* 5 */
/***/ function(module, exports) {

	module.exports = "<div><div><i class=\"fa fa-plus\"></i></div><input type=\"text\" x-ng-model=\"value\"/></div>";

/***/ },
/* 6 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"view\"><span class=\"empty\" x-ng-if=\"(!title || title.trim() === '') &amp;&amp; (!href || href.trim() === '')\">{{emptyText}}</span><a x-ng-if=\"(title &amp;&amp; title.trim() !== '') || (href &amp;&amp; href.trim() !== '')\" x-ng-href=\"{{href}}\" x-ng-bind-html=\"(title | tribeHtml) || (href | tribeHtml)\"></a><div class=\"edit-trigger\"><i class=\"fa fa-caret-down\"></i></div></div><div class=\"value floating-menu editable-link-menu\"><div><i data-tribe-editable-text=\"data-tribe-editable-text\" data-adjust=\"false\" data-value=\"href\" data-placeholder=\"href not set\"></i></div><div><i data-tribe-editable-text=\"data-tribe-editable-text\" data-adjust=\"false\" data-value=\"title\" data-placeholder=\"title not set\"></i></div></div></div>";

/***/ },
/* 7 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\"><div class=\"static\" x-ng-show=\"compiledContent &amp;&amp; compiledContent.trim() !== ''\" x-ng-bind-html=\"compiledContent | tribeHtml\"></div><div class=\"empty\" x-ng-show=\"!compiledContent || compiledContent.trim() === ''\"><span>empty</span></div><div class=\"dyn\"><textarea x-ui-codemirror=\"cmOption\" x-ng-model=\"content\"></textarea></div><div class=\"icon\"><div><i class=\"fa fa-pencil\"></i></div></div></div>";

/***/ },
/* 8 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\"><textarea x-ui-codemirror=\"cmOption\" x-ng-model=\"content\"></textarea><div class=\"icon\"><div><i class=\"fa fa-pencil\"></i></div></div></div>";

/***/ },
/* 9 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\"><span x-ng-class=\"{empty:!value}\">{{value ? value : placeholder}}</span><input type=\"number\" x-ng-model=\"value\" min=\"0\"/><div><i class=\"fa fa-caret-up\"></i><i class=\"fa fa-caret-down\"></i></div></div>";

/***/ },
/* 10 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\"><span x-ng-class=\"{empty:!value}\">{{value ? value : placeholder}}</span><input type=\"text\" x-ng-model=\"value\"/><div><i class=\"fa fa-pencil\"></i></div></div>";

/***/ },
/* 11 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\" x-ng-click=\"open()\"><div class=\"value\"><span ng-show=\"valueText &amp;&amp; valueText.trim() !== ''\">{{valueText}}</span><span ng-show=\"!(valueText &amp;&amp; valueText.trim() !== '') &amp;&amp; defaultText &amp;&amp; defaultText.trim() !== ''\">{{defaultText}}</span><span class=\"empty\" ng-show=\"!(valueText &amp;&amp; valueText.trim() !== '') &amp;&amp; !(defaultText &amp;&amp; defaultText.trim() !== '')\">{{emptyText}}</span><div><i class=\"fa fa-caret-up\"></i><i class=\"fa fa-caret-down\"></i></div></div><div class=\"options floating-menu\"><div x-ng-repeat=\"opt in options\" x-ng-click=\"selectOption(opt)\" tabindex=\"0\"><span>{{opt.text ? opt.text : opt}}</span></div></div></div>";

/***/ },
/* 12 */
/***/ function(module, exports) {

	module.exports = "<div><input type=\"checkbox\" id=\"{{::uniqueId}}\" x-ng-model=\"value\" x-ng-true-value=\"{{trueValue}}\" x-ng-false-value=\"{{falseValue}}\"/><span>no</span><div tabindex=\"0\"><div></div></div><span>yes</span></div>";

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var _components_diff;
	(function (_components_diff) {
	    var codemirror = __webpack_require__(14);
	    angular.module('website-components-diff', [])
	        .directive('tribeDiff', ['$document', '$timeout', function ($document, $timeout) {
	            return {
	                restrict: 'A',
	                scope: {
	                    valueA: '=',
	                    titleA: '=',
	                    valueB: '=',
	                    titleB: '=',
	                    mode: '@?'
	                },
	                template: __webpack_require__(15),
	                controller: ['$scope', function ($scope) {
	                        $scope['loaded'] = false;
	                        if (!$scope['mode']) {
	                            $scope['mode'] = 'application/json';
	                        }
	                    }],
	                link: function (scope, el) { return $timeout(function () {
	                    var checkLoaded = function () {
	                        if (!scope['valueA']) {
	                            return;
	                        }
	                        if (!scope['valueB']) {
	                            return;
	                        }
	                        $timeout(function () { return scope.$apply(function () { return scope['loaded'] = true; }); });
	                    };
	                    scope.$watch('valueA', checkLoaded);
	                    scope.$watch('valueB', checkLoaded);
	                    scope.$watch('loaded', function () {
	                        if (!scope['loaded']) {
	                            return;
	                        }
	                        codemirror.MergeView(el.find('> div')[0], {
	                            value: scope['valueA'],
	                            orig: scope['valueB'],
	                            mode: scope['mode'],
	                            connect: 'align',
	                            lineNumbers: true,
	                            highlightDifferences: true,
	                            collapseIdentical: false,
	                            lineWrapping: true
	                        });
	                        if (scope['titleA'] && scope['titleB']) {
	                            $timeout(function () {
	                                var diffPanels = el.find('div.CodeMirror-merge-pane');
	                                // left
	                                angular.element(diffPanels[0]).prepend("<h3 class=\"diff-title\">" + scope['titleA'] + "</h3>");
	                                // right
	                                angular.element(diffPanels[1]).prepend("<h3 class=\"diff-title\">" + scope['titleB'] + "</h3>");
	                                $timeout(function () {
	                                    var titleHeight = el.find('div.CodeMirror-merge-pane h3.diff-title').outerHeight();
	                                    var cmHeight = el.find('div.CodeMirror-merge-pane h3.diff-title ~ div.CodeMirror').outerHeight();
	                                    el.find('div.CodeMirror-merge-pane h3.diff-title ~ div.CodeMirror').outerHeight(cmHeight - titleHeight);
	                                });
	                            });
	                        }
	                    });
	                }); }
	            };
	        }]);
	})(_components_diff || (_components_diff = {}));


/***/ },
/* 14 */,
/* 15 */
/***/ function(module, exports) {

	module.exports = "<div></div>";

/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	angular.module('website-components-field-actions', [])
	    .directive('tribeFieldActions', ['$interval', '$document', function ($interval, $document) {
	        return {
	            restrict: 'A',
	            scope: {
	                onCancel: '&',
	                onConfirm: '&',
	                active: '=',
	                version: '=',
	                validValue: '=?'
	            },
	            template: __webpack_require__(17),
	            controller: ['$scope', function ($scope) {
	                    $scope.confirm = function () { return $scope.onConfirm(); };
	                    $scope.cancel = function () { return $scope.onCancel(); };
	                }],
	            link: function (scope, element, attrs, controller) {
	                var floatingBody = angular.element(element.find('> div'));
	                floatingBody.detach();
	                var body = $document.find('body');
	                var adjustOffset = function () {
	                    // do nothing if not attached to the DOM
	                    if (floatingBody.parent().length) {
	                        var position = element.offset();
	                        floatingBody.offset(position);
	                    }
	                };
	                scope.$watch('active', function () {
	                    if (scope['active']) {
	                        body.append(floatingBody);
	                        adjustOffset();
	                    }
	                    else {
	                        floatingBody.detach();
	                    }
	                });
	                var adjustInterval = $interval(adjustOffset, 500);
	                scope.$on('$destroy', function () {
	                    $interval.cancel(adjustInterval);
	                    floatingBody.remove();
	                    element.remove();
	                });
	            }
	        };
	    }]);


/***/ },
/* 17 */
/***/ function(module, exports) {

	module.exports = "<div class=\"tribe-field-actions-body floating-menu\"><div ng-click=\"confirm()\" ng-class=\"{disabled: validValue !== undefined &amp;&amp; validValue === false}\"><i class=\"fa fa-check\"></i></div><div ng-click=\"cancel()\"><i class=\"fa fa-remove\"></i></div></div>";

/***/ },
/* 18 */
/***/ function(module, exports) {

	"use strict";
	angular.module('website-components-filters', [])
	    .filter('uriencode', ['$window', function ($window) { return $window.encodeURIComponent; }])
	    .filter('pathencode', [function () { return function (input) {
	        // The root path is the most simple case
	        if (input === '/') {
	            return '/';
	        }
	        return input.split('/')
	            .map(function (part) {
	            return part.match('\{.*\}') ? ':' + part.slice(1, -1) : part;
	        })
	            .join('/');
	    }; }])
	    .filter('tribeHtml', ['$sce', function ($sce) { return function (input) { return $sce.trustAsHtml(input); }; }])
	    .filter('tribeHtmlText', [function () { return function (input) {
	        var el = angular.element('<div></div>');
	        el.append(input);
	        return el.text();
	    }; }]);


/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var _components_markdown;
	(function (_components_markdown) {
	    var hljs = __webpack_require__(20);
	    var SimpleMDE = __webpack_require__(21);
	    var marked = __webpack_require__(2);
	    angular.module('website-components-markdown-service', [])
	        .factory('tribeMarkdownService', [function () {
	            return {
	                compileMd: function (content) {
	                    if (content === null || content === undefined || content.trim() === '') {
	                        return '';
	                    }
	                    var compiledMd = angular.element('<div></div>');
	                    angular.element(marked(content)).each(function (index, el) {
	                        compiledMd.append(el);
	                    });
	                    compiledMd.find('code').each(function (index, codeTag) {
	                        var aCode = angular.element(codeTag);
	                        if (aCode.attr('class')) {
	                            hljs.highlightBlock(codeTag);
	                        }
	                    });
	                    return compiledMd.html();
	                }
	            };
	        }]);
	    angular.module('website-components-markdown', [
	        'website-components-field-actions',
	        'website-components-filters',
	        'website-components-markdown-service'
	    ])
	        .directive('tribeMarkdownHelp', ['$document', '$timeout', function ($document, $timeout) {
	            return {
	                restrict: 'A',
	                scope: {
	                    visible: '='
	                },
	                controller: ['$timeout', '$scope', function ($timeout, $scope) {
	                        $scope.close = function () {
	                            $timeout(function () { return $scope.$apply(function () {
	                                $scope['visible'] = false;
	                            }); });
	                        };
	                    }],
	                template: __webpack_require__(22),
	                link: function (scope, el, attrs, controller) {
	                    var content = el.find('> div > div.markdown-help-content');
	                    content.detach();
	                    var body = $document.find('body');
	                    var keyPress = function (event) {
	                        console.log('event.keyCode -> ' + event.keyCode);
	                        if (event.keyCode === 27 /* Escape */) {
	                            scope['close']();
	                        }
	                    };
	                    scope.$watch('visible', function () {
	                        if (scope['visible']) {
	                            body.addClass('noscroll');
	                            body.append(content);
	                            $document.on('keyup', keyPress);
	                        }
	                        else {
	                            content.detach();
	                            body.removeClass('noscroll');
	                            $document.off('keyup', keyPress);
	                        }
	                    });
	                    scope.$on('$destroy', function () {
	                        content.remove();
	                        el.remove();
	                        body.removeClass('noscroll');
	                        $document.off('keyup', keyPress);
	                    });
	                }
	            };
	        }])
	        .directive('tribeMarkdown', ['$window', '$timeout', '$log', 'tribeMarkdownService', '$document', function ($window, $timeout, $log, mdService, $document) {
	            return {
	                restrict: 'A',
	                scope: {
	                    originalValue: '=value',
	                    placeholder: '@?',
	                    onEditModeOn: '&?',
	                    onEditModeOff: '&?'
	                },
	                template: __webpack_require__(23),
	                controller: ['$scope', function ($scope) { return $timeout(function () {
	                        $scope['uniqueId'] = _.uniqueId('tribeMarkdown_');
	                        $scope['helpVisible'] = false;
	                        $scope['simplemde'] = null;
	                        $scope['version'] = 0;
	                        $scope['fieldDirty'] = false;
	                        $scope['cmFocused'] = false;
	                        $scope['sidebyside'] = false;
	                        $scope.$watch('originalValue', function () { return $timeout(function () { return $scope.$apply(function () {
	                            $scope['value'] = $scope.originalValue ? _.clone($scope.originalValue) : '';
	                        }); }); });
	                        $scope.$watch('value', function () { return $timeout(function () { return $scope.$apply(function () {
	                            $scope.preview = mdService.compileMd($scope['value']);
	                        }); }); });
	                        $scope.onCommit = function () { return $timeout(function () { return $scope.$apply(function () {
	                            $scope['cmFocused'] = false;
	                            if ($scope['fieldDirty']) {
	                                $scope['fieldDirty'] = false;
	                                $scope.originalValue = _.clone($scope['value']);
	                                $scope.$broadcast('fieldCommited');
	                            }
	                            if ($scope['onEditModeOff']) {
	                                $scope['onEditModeOff']({ 'uniqueId': $scope['uniqueId'] });
	                            }
	                        }); }); };
	                        $scope['onCancel'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                            $scope['fieldDirty'] = false;
	                            $scope['value'] = _.clone($scope.originalValue);
	                            $scope.$broadcast('fieldCanceled');
	                            if ($scope['onEditModeOff']) {
	                                $scope['onEditModeOff']({ 'uniqueId': $scope['uniqueId'] });
	                            }
	                        }); }); };
	                        $scope['onChange'] = function (newValue) { return $timeout(function () { return $scope.$apply(function () {
	                            $scope['version'] = $scope['version'] + 1;
	                            $scope['value'] = newValue;
	                            if ($scope['cmFocused'] && $scope.originalValue !== newValue) {
	                                $scope['fieldDirty'] = true;
	                            }
	                        }); }); };
	                    }); }],
	                link: function (scope, el) { return $timeout(function () {
	                    var body = $document.find('body');
	                    var simplemde = null;
	                    var deactivatePromise = null;
	                    var cancelDeactivate = function () {
	                        if (deactivatePromise) {
	                            $timeout.cancel(deactivatePromise);
	                        }
	                        deactivatePromise = null;
	                    };
	                    var deactivate = function () {
	                        cancelDeactivate();
	                        deactivatePromise = $timeout(function () {
	                            if (simplemde.codemirror.hasFocus()) {
	                                return;
	                            }
	                            scope['onCommit']();
	                            scope.$apply(function () {
	                                scope['sidebyside'] = false;
	                                scope['fullscreen'] = false;
	                            });
	                            el.removeClass('active');
	                            if (simplemde) {
	                                angular.element(simplemde.toolbarElements["side-by-side"]).removeClass('active');
	                                angular.element(simplemde.toolbarElements["fullscreen"]).removeClass('active');
	                                if (simplemde.isPreviewActive()) {
	                                    SimpleMDE.togglePreview(simplemde);
	                                }
	                            }
	                        }, 500);
	                    };
	                    var focusAction = function (cm) {
	                        $log.debug('codemirror focus; cm.getSelection() empty? ' + !!cm.getSelection());
	                        cancelDeactivate();
	                        if (!scope['cmFocused']) {
	                            cm.execCommand('selectAll');
	                        }
	                        $timeout(function () { return scope.$apply(function () {
	                            scope['cmFocused'] = true;
	                            scope['version'] = scope['version'] + 1;
	                            scope['fieldDirty'] = true;
	                            if (scope['onEditModeOn']) {
	                                scope['onEditModeOn']({ 'uniqueId': scope['uniqueId'] });
	                            }
	                        }); });
	                    };
	                    var anchorEl = el.find('div.value > textarea')[0];
	                    var actionClick = function (editor, callback) {
	                        cancelDeactivate();
	                        callback(editor);
	                        editor.codemirror.off('focus', focusAction);
	                        editor.codemirror.focus();
	                        editor.codemirror.on('focus', focusAction);
	                    };
	                    simplemde = new SimpleMDE({
	                        element: anchorEl,
	                        status: false,
	                        spellChecker: false,
	                        previewRender: mdService.compileMd,
	                        autoDownloadFontAwesome: false,
	                        toolbar: [{
	                                name: "bold",
	                                action: function (editor) { return actionClick(editor, SimpleMDE.toggleBold); },
	                                className: "fa fa-bold",
	                                title: "Bold",
	                            }, {
	                                name: "italic",
	                                action: function (editor) { return actionClick(editor, SimpleMDE.toggleItalic); },
	                                className: "fa fa-italic",
	                                title: "Italic"
	                            }, {
	                                name: "heading",
	                                action: function (editor) { return actionClick(editor, SimpleMDE.toggleHeadingSmaller); },
	                                className: "fa fa-header",
	                                title: "Heading"
	                            }, '|', {
	                                name: "code",
	                                action: function (editor) { return actionClick(editor, SimpleMDE.toggleCodeBlock); },
	                                className: "fa fa-code",
	                                title: "Code"
	                            }, {
	                                name: "quote",
	                                action: function (editor) { return actionClick(editor, SimpleMDE.toggleBlockquote); },
	                                className: "fa fa-quote-left",
	                                title: "Quote"
	                            }, {
	                                name: "unordered-list",
	                                action: function (editor) { return actionClick(editor, SimpleMDE.toggleUnorderedList); },
	                                className: "fa fa-list-ul",
	                                title: "Generic List"
	                            }, {
	                                name: "ordered-list",
	                                action: function (editor) { return actionClick(editor, SimpleMDE.toggleOrderedList); },
	                                className: "fa fa-list-ol",
	                                title: "Numbered List"
	                            }, {
	                                name: "clean-block",
	                                // replace by this action block if this PR gets merged.
	                                // https://github.com/NextStepWebs/simplemde-markdown-editor/pull/463
	                                // action: (editor) => actionClick(editor, SimpleMDE.cleanBlock),
	                                action: function (editor) { return $timeout(function () { return scope.$apply(function () {
	                                    cancelDeactivate();
	                                    var cm = editor.codemirror;
	                                    // split the selection in lines
	                                    var selections = cm.getSelection().split("\n");
	                                    var removeTags = function (selection) {
	                                        var html = marked(selection);
	                                        // create a div...
	                                        var tmp = document.createElement("DIV");
	                                        // .. with the new generated html code...
	                                        tmp.innerHTML = html;
	                                        // ... now read the text of the generated code.
	                                        // This way the browser does the job of removing the tags.
	                                        var result = selection;
	                                        if (tmp.textContent) {
	                                            result = tmp.textContent;
	                                        }
	                                        else if (tmp.innerText) {
	                                            result = tmp.innerText;
	                                        }
	                                        // removing trailing "new line"
	                                        return result.split("\n").join('');
	                                    };
	                                    var result = [];
	                                    for (var i = 0; i < selections.length; i++) {
	                                        result.push(removeTags(selections[i]));
	                                    }
	                                    // Add removed "new lines" back to the resulting string.
	                                    // Replace the selection with the new clean selection.
	                                    cm.replaceSelection(result.join("\n"));
	                                }); }); },
	                                className: "fa fa-eraser fa-clean-block",
	                                title: "Clean block"
	                            }, '|', {
	                                name: "side-by-side",
	                                action: function (editor) { return $timeout(function () { return scope.$apply(function () {
	                                    cancelDeactivate();
	                                    scope['sidebyside'] = !scope['sidebyside'];
	                                    var btn = angular.element(editor.toolbarElements["side-by-side"]);
	                                    if (scope['sidebyside']) {
	                                        btn.addClass('active');
	                                    }
	                                    else {
	                                        btn.removeClass('active');
	                                    }
	                                    if (editor.isPreviewActive()) {
	                                        SimpleMDE.togglePreview(editor);
	                                    }
	                                    editor.codemirror.focus();
	                                }); }); },
	                                className: "fa fa-columns no-disable no-mobile",
	                                title: "Toggle Side by Side"
	                            }, {
	                                name: "preview",
	                                action: function (editor) { return $timeout(function () { return scope.$apply(function () {
	                                    cancelDeactivate();
	                                    scope['sidebyside'] = false;
	                                    angular.element(editor.toolbarElements["side-by-side"]).removeClass('active');
	                                    SimpleMDE.togglePreview(editor);
	                                    if (!editor.isPreviewActive()) {
	                                        editor.codemirror.focus();
	                                    }
	                                }); }); },
	                                className: "fa fa-eye no-disable",
	                                title: "Toggle Preview"
	                            }, {
	                                name: "fullscreen",
	                                action: function (editor) { return $timeout(function () { return scope.$apply(function () {
	                                    cancelDeactivate();
	                                    scope['fullscreen'] = !scope['fullscreen'];
	                                    var btn = angular.element(editor.toolbarElements["fullscreen"]);
	                                    if (scope['fullscreen']) {
	                                        btn.addClass('active');
	                                        body.addClass('noscroll');
	                                    }
	                                    else {
	                                        btn.removeClass('active');
	                                        body.removeClass('noscroll');
	                                    }
	                                }); }); },
	                                className: "fa fa-arrows-alt no-disable no-mobile",
	                                title: "Toggle Fullscreen"
	                            }, {
	                                name: "guide",
	                                action: function (editor) { return $timeout(function () { return scope.$apply(function () {
	                                    scope['helpVisible'] = true;
	                                }); }); },
	                                className: "fa fa-question-circle",
	                                title: "Markdown Guide"
	                            }]
	                    });
	                    simplemde.codemirror.on('change', function () {
	                        scope['onChange'](simplemde.value());
	                    });
	                    simplemde.codemirror.on('focus', focusAction);
	                    simplemde.codemirror.on('blur', function () { return $timeout(function () {
	                        deactivate();
	                    }); });
	                    var disablePreview = function () {
	                        $timeout(function () { return scope.$apply(function () {
	                            scope['sidebyside'] = false;
	                            scope['fullscreen'] = false;
	                        }); });
	                        el.removeClass('active');
	                        angular.element(simplemde.toolbarElements["side-by-side"]).removeClass('active');
	                        angular.element(simplemde.toolbarElements["fullscreen"]).removeClass('active');
	                        if (simplemde.isPreviewActive()) {
	                            simplemde.togglePreview();
	                        }
	                    };
	                    scope.$on('fieldCanceled', disablePreview);
	                    scope.$watch('value', function () { return $timeout(function () {
	                        $log.debug("scope['fieldDirty'] = " + scope['fieldDirty'] + "; scope.value = " + scope['value']);
	                        if (!scope['fieldDirty']) {
	                            simplemde.value(scope['value'] ? scope['value'] : '');
	                        }
	                    }); });
	                    scope.$on('$destroy', function () {
	                        el.remove();
	                        body.removeClass('noscroll');
	                    });
	                    var activate = function () {
	                        cancelDeactivate();
	                        el.addClass('active');
	                        $timeout(function () { return simplemde.codemirror.focus(); });
	                    };
	                    el.on('click', activate);
	                    el.find('> div').on('focus', activate);
	                }); }
	            };
	        }]);
	})(_components_markdown || (_components_markdown = {}));


/***/ },
/* 20 */,
/* 21 */,
/* 22 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"markdown-help-content\"><div><i class=\"fa fa-times-circle fa-2x\" x-ng-click=\"close()\"></i><h1>Markdown Guide</h1>\n<h2>Emphasis</h2>\n<pre><code>**bold**\n*italics*\n~~strikethrough~~\n</code></pre>\n<h2>Headers</h2>\n<pre><code># Big header\n## Medium header\n### Small header\n#### Tiny header\n</code></pre>\n<h2>Lists</h2>\n<pre><code>    * Generic list item\n    * Generic list item\n    * Generic list item\n    1. Numbered list item\n    2. Numbered list item\n    3. Numbered list item\n</code></pre>\n<h2>Links</h2>\n<pre><code>    [Text to display](http://www.example.com)\n</code></pre>\n<h2>Quotes</h2>\n<pre><code>    &gt; This is a quote.\n    &gt; It can span multiple lines!\n</code></pre>\n<h2>Images</h2>\n<pre><code>    ![](http://www.example.com/image.jpg)\n</code></pre>\n<h2>Tables</h2>\n<pre><code>    | Column 1 | Column 2 | Column 3 |\n    | -------- | -------- | -------- |\n    | John     | Doe      | Male     |\n    | Mary     | Smith    | Female\n    | Column 1 | Column 2 | Column 3 |\n    | -------- | -------- | -------- |\n    | John | Doe | Male |\n    | Mary | Smith | Female\n</code></pre>\n<h2>Displaying code</h2>\n<pre><code>    \\`var example = &quot;hello!&quot;;\\`\n    \\```\n    var example = &quot;hello!&quot;;\n    alert(example);\n    \\```\n</code></pre>\n</div></div></div>";

/***/ },
/* 23 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\" ng-class=\"{'fullscreen': fullscreen}\"><div class=\"main\" ng-class=\"{'sidebyside': sidebyside}\"><div class=\"value\"><textarea ng-model=\"value\"></textarea></div><div class=\"preview\"><div class=\"empty\" x-ng-if=\"!preview &amp;&amp; placeholder\"><span>{{placeholder}}</span></div><div x-ng-bind-html=\"preview | tribeHtml\"></div><div class=\"edit-icon\"><i class=\"fa fa-pencil\"></i></div></div></div><div data-tribe-field-actions=\"data-tribe-field-actions\" data-version=\"version\" data-active=\"fieldDirty\" data-on-confirm=\"onCommit()\" data-on-cancel=\"onCancel()\"></div><div data-tribe-markdown-help=\"data-tribe-markdown-help\" data-visible=\"helpVisible\"></div></div>";

/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	angular.module('website-components-multiselect', [
	    'website-components-field-actions'
	])
	    .directive('tribeMultiselect', ['$window', '$timeout', function ($window, $timeout) {
	        return {
	            restrict: 'A',
	            scope: {
	                originalAvailableOptions: '=availableOptions',
	                originalSelectedOptions: '=selectedOptions',
	                originalGetOptionText: '=getOptionText',
	                newLabel: '@?',
	                autoShowOptions: '=?',
	                onEditModeOn: '&?',
	                onEditModeOff: '&?'
	            },
	            template: __webpack_require__(25),
	            controller: ['$log', '$scope', '$timeout', function ($log, $scope, $timeout) { return $timeout(function () {
	                    $scope['uniqueId'] = _.uniqueId('tribeMultiselect_');
	                    if ($scope['autoShowOptions'] === undefined) {
	                        $scope['autoShowOptions'] = true;
	                    }
	                    $scope['inputFocused'] = false;
	                    $scope.$watch('originalGetOptionText', function () {
	                        if ($scope.originalGetOptionText) {
	                            $scope.getOptionText = $scope.originalGetOptionText;
	                        }
	                        else {
	                            $scope.getOptionText = function (item) {
	                                if (!item || item.text === undefined) {
	                                    return item;
	                                }
	                                return item.text;
	                            };
	                        }
	                    });
	                    $scope.$watch('originalSelectedOptions', function () { return $timeout(function () { return $scope.$apply(function () {
	                        if (!$scope.originalSelectedOptions) {
	                            $scope['selectedOptions'] = [];
	                        }
	                        else {
	                            $scope['selectedOptions'] = _.clone($scope.originalSelectedOptions);
	                        }
	                    }); }); });
	                    $scope.$watch('originalAvailableOptions', function () {
	                        $scope.availableOptions = _.clone($scope.originalAvailableOptions);
	                    });
	                    $scope['fieldDirty'] = false;
	                    $scope['optionsActivated'] = false;
	                    $scope['optionsActivatedTopDown'] = 0;
	                    $scope['optionsActivatedBottomUp'] = 0;
	                    $scope['version'] = 0;
	                    $scope['selectedOption'] = null;
	                    $scope['inputText'] = '';
	                    $scope['fieldChanged'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['fieldDirty'] = true;
	                        $scope['version'] = $scope['version'] + 1;
	                        $scope['optionsActivated'] = false;
	                    }); }); };
	                    $scope['fieldCommitted'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['onCommit']();
	                        $scope.$broadcast('fieldCommitted');
	                    }); }); };
	                    $scope['onCommit'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        if ($scope['fieldDirty']) {
	                            $scope['fieldDirty'] = false;
	                            $scope['optionsActivated'] = false;
	                            $scope['originalSelectedOptions'] = _.clone($scope['selectedOptions']);
	                            $log.debug('field committed. values: ' + $scope['selectedOptions']);
	                            if ($scope['onEditModeOff']) {
	                                $scope['onEditModeOff']({ 'uniqueId': $scope['uniqueId'] });
	                            }
	                        }
	                    }); }); };
	                    $scope['fieldCanceled'] = function () {
	                        $scope['fieldDirty'] = false;
	                        $scope['selectedOptions'] = _.clone($scope['originalSelectedOptions']);
	                        $scope.$broadcast('fieldCanceled');
	                        if ($scope['onEditModeOff']) {
	                            $scope['onEditModeOff']({ 'uniqueId': $scope['uniqueId'] });
	                        }
	                    };
	                    $scope.onSelectTopDownOption = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['optionsActivatedTopDown'] = $scope['optionsActivatedTopDown'] + 1;
	                        $scope['optionsActivated'] = true;
	                    }); }); };
	                    $scope.onSelectBottomUpOption = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['optionsActivatedBottomUp'] = $scope['optionsActivatedBottomUp'] + 1;
	                        $scope['optionsActivated'] = true;
	                    }); }); };
	                    $scope.onOptionsDeactivated = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['optionsActivated'] = false;
	                    }); }); };
	                }); }],
	            link: function (scope, el) { return $timeout(function () {
	                var deactivatePromise = null;
	                var cancelDeactivate = function () {
	                    if (deactivatePromise) {
	                        $timeout.cancel(deactivatePromise);
	                    }
	                    deactivatePromise = null;
	                };
	                var deactivate = function () {
	                    cancelDeactivate();
	                    deactivatePromise = $timeout(function () {
	                        scope['fieldCommitted']();
	                        el.removeClass('active');
	                        scope.$apply(function () {
	                            scope['inputFocused'] = false;
	                            scope['optionsActivated'] = false;
	                        });
	                    }, 500);
	                };
	                el.on('click', function () { return el.find('input').focus(); });
	                el.find('> div').on('focus', function () { return el.find('input').focus(); });
	                var actiavionCb = function () {
	                    cancelDeactivate();
	                    el.addClass('active');
	                    $timeout(function () { return scope.$apply(function () {
	                        scope['fieldDirty'] = true;
	                        if (scope['onEditModeOn']) {
	                            scope['onEditModeOn']({ 'uniqueId': scope['uniqueId'] });
	                        }
	                        scope['inputFocused'] = true;
	                        if (scope['autoShowOptions']) {
	                            scope['optionsActivated'] = true;
	                        }
	                    }); });
	                };
	                var inputEl = el.find('input');
	                inputEl.on('click', actiavionCb);
	                inputEl.on('focus', actiavionCb);
	                inputEl.on('blur', deactivate);
	                scope.$on('fieldDirty', function () {
	                    if (scope['fieldDirty']) {
	                        cancelDeactivate();
	                        el.addClass('active');
	                    }
	                });
	                scope.$on('$destroy', function () { return el.remove(); });
	                scope.$on('fieldCanceled', function () { return $timeout(function () { return inputEl.blur(); }); });
	                scope.$on('fieldCommitted', function () { return $timeout(function () { return inputEl.blur(); }); });
	            }); }
	        };
	    }])
	    .directive('tribeMultiselectAvailable', ['$document', '$window', '$timeout', function ($document, $window, $timeout) {
	        return {
	            restrict: 'A',
	            scope: {
	                selectedOptions: '=',
	                originalAvailableOptions: '=availableOptions',
	                active: '=',
	                activeTopDown: '=',
	                activeBottomUp: '=',
	                onSelect: '&',
	                inputText: '=',
	                selectedItem: '=selectedOption',
	                newLabel: '@?',
	                getOptionText: '=',
	                version: '='
	            },
	            template: __webpack_require__(26),
	            controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                    $scope.availableOptions = [];
	                    $scope['showOptions'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['selectedItem'] = null;
	                        $scope.newOpt = null;
	                        $scope.availableOptions = _.clone($scope.originalAvailableOptions);
	                        for (var _i = 0, _a = $scope['selectedOptions']; _i < _a.length; _i++) {
	                            var opt = _a[_i];
	                            $scope.availableOptions = _.without($scope.availableOptions, opt);
	                        }
	                        if ($scope['inputText'].trim()) {
	                            $scope.availableOptions = _.filter($scope.availableOptions, function (opt) {
	                                return opt.toLowerCase().startsWith($scope['inputText'].toLowerCase());
	                            });
	                            $scope['selectedItem'] = _.find($scope.availableOptions, function (opt) { return opt.toLowerCase().startsWith($scope['inputText'].trim().toLowerCase()); });
	                            if (_.find($scope.availableOptions, function (opt) { return opt === $scope['inputText'].trim(); })) {
	                                $scope.newOpt = null;
	                            }
	                            else {
	                                $scope.newOpt = $scope['inputText'].trim();
	                            }
	                            if (!$scope['selectedItem']) {
	                                $scope['selectedItem'] = $scope.newOpt;
	                            }
	                        }
	                    }); }); };
	                    $scope.$watch('version', $timeout(function () { return $scope['showOptions'](); }));
	                    $scope['selectedItem'] = null;
	                    $scope['selectNext'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        var ordered = _.sortBy($scope.availableOptions, function (item) { return $scope.getOptionText(item).toLowerCase(); });
	                        if ($scope['selectedItem']) {
	                            var index = ordered.indexOf($scope['selectedItem']) + 1;
	                            if (index >= ordered.length) {
	                                if ($scope.newOpt) {
	                                    $scope['selectedItem'] = $scope.newOpt;
	                                }
	                                else {
	                                    $scope['selectedItem'] = ordered[0];
	                                }
	                            }
	                            else {
	                                $scope['selectedItem'] = ordered[index];
	                            }
	                        }
	                        else {
	                            $scope['selectedItem'] = _.first(ordered);
	                        }
	                    }); }); };
	                    $scope['selectPrevious'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        var ordered = _.sortBy($scope.availableOptions, function (item) { return $scope.getOptionText(item).toLowerCase(); });
	                        if ($scope['selectedItem']) {
	                            if ($scope.newOpt === $scope['selectedItem'] && ordered.length) {
	                                $scope['selectedItem'] = _.last(ordered);
	                            }
	                            else {
	                                var index = ordered.indexOf($scope['selectedItem']) - 1;
	                                if (index < 0) {
	                                    if ($scope.newOpt) {
	                                        $scope['selectedItem'] = $scope.newOpt;
	                                    }
	                                    else {
	                                        $scope['selectedItem'] = _.last(ordered);
	                                    }
	                                }
	                                else {
	                                    $scope['selectedItem'] = ordered[index];
	                                }
	                            }
	                        }
	                        else {
	                            if ($scope.newOpt) {
	                                $scope['selectedItem'] = $scope.newOpt;
	                            }
	                            else {
	                                $scope['selectedItem'] = _.last(ordered);
	                            }
	                        }
	                    }); }); };
	                    $scope.selectItem = function (opt) { return $timeout(function () { return $scope.$apply(function () {
	                        if (!$scope['selectedOptions'].find(function (selected) {
	                            return selected === opt;
	                        })) {
	                            $scope['selectedOptions'].push(opt);
	                        }
	                        $scope['inputText'] = '';
	                    }); }); };
	                    $scope.$watch('inputText', function () {
	                        $timeout(function () { return $scope.$apply(function () {
	                            if (!$scope['inputText']) {
	                                $scope['selectedItem'] = null;
	                                $scope['active'] = false;
	                            }
	                            else {
	                                $scope['selectedItem'] = _.find($scope.availableOptions, function (opt) { return opt.startsWith($scope['inputText']); });
	                                $scope['active'] = true;
	                                $scope['showOptions']();
	                            }
	                        }); });
	                    });
	                }],
	            link: function (scope, element) {
	                var floatingBody = angular.element(element.find('> div'));
	                floatingBody.detach();
	                var body = $document.find('body');
	                var adjustOffset = function () {
	                    var position = element.offset();
	                    floatingBody.offset(position);
	                };
	                scope.$watch('active', function () {
	                    if (scope['active']) {
	                        body.append(floatingBody);
	                        adjustOffset();
	                        scope['showOptions']();
	                        element.addClass('active');
	                    }
	                    else {
	                        $timeout(function () { return scope.$apply(function () {
	                            scope['selectedItem'] = null;
	                        }); });
	                        floatingBody.detach();
	                        element.removeClass('active');
	                    }
	                });
	                scope.$watch('activeTopDown', function () {
	                    if (scope['activeTopDown']) {
	                        scope['selectNext']();
	                    }
	                });
	                scope.$watch('activeBottomUp', function () {
	                    if (scope['activeBottomUp']) {
	                        scope['selectPrevious']();
	                    }
	                });
	                scope.$watch('version', function () { return adjustOffset(); });
	                var eWin = angular.element($window);
	                eWin.bind('resize', adjustOffset);
	                scope.$on('$destroy', function () {
	                    eWin.unbind('resize', adjustOffset);
	                    floatingBody.remove();
	                    element.remove();
	                });
	            }
	        };
	    }])
	    .directive('tribeMultiselectSelected', [function () {
	        return {
	            restrict: 'A',
	            scope: {
	                selectedOptions: '=',
	                onChange: '&',
	                onCommit: '&',
	                onCancel: '&',
	                onSelectTopDownOption: '&',
	                onSelectBottomUpOption: '&',
	                onOptionsDeactivated: '&',
	                selectedOption: '=',
	                inputText: '=',
	                autoShowOptions: '=',
	                activated: '='
	            },
	            template: __webpack_require__(27),
	            controller: ['$log', '$scope', '$timeout', function ($log, $scope, $timeout) {
	                    $scope['inputText'] = '';
	                    $scope.releaseEngaged = false;
	                    $scope['selectedItem'] = null;
	                    var selectOrDeleteLast = function () { return $timeout(function () { return $scope.$apply(function () {
	                        var ordered = _.sortBy($scope['selectedOptions'], function (item) { return item; });
	                        if ($scope['selectedItem']) {
	                            var selectedIndex = ordered.indexOf($scope['selectedItem']);
	                            $scope['selectedOptions'] = _.without($scope['selectedOptions'], $scope['selectedItem']);
	                            ordered = _.without(ordered, $scope['selectedItem']);
	                            if (ordered.length) {
	                                if (selectedIndex >= ordered.length) {
	                                    selectedIndex = ordered.length - 1;
	                                }
	                                $scope['selectedItem'] = ordered[selectedIndex];
	                            }
	                            else {
	                                $scope['selectedItem'] = null;
	                            }
	                            $scope.onChange();
	                        }
	                        else {
	                            $scope['selectedItem'] = _.last(ordered);
	                        }
	                    }); }); };
	                    var releaseSelection = function () { return $timeout(function () { return $scope.$apply(function () { return $scope['selectedItem'] = null; }); }); };
	                    var selectLeft = function () { return $timeout(function () { return $scope.$apply(function () {
	                        if (!$scope['selectedOptions'].length) {
	                            return;
	                        }
	                        if (!$scope['selectedItem']) {
	                            selectOrDeleteLast();
	                        }
	                        else {
	                            var ordered = _.sortBy($scope['selectedOptions'], function (item) { return item; });
	                            var next = ordered.indexOf($scope['selectedItem']) - 1;
	                            if (next === -1) {
	                                next = ordered.length - 1;
	                            }
	                            $scope['selectedItem'] = ordered[next];
	                        }
	                    }); }); };
	                    var selectRight = function () { return $timeout(function () { return $scope.$apply(function () {
	                        if (!$scope['selectedOptions'].length) {
	                            return;
	                        }
	                        var ordered = _.sortBy($scope['selectedOptions'], function (item) { return item; });
	                        if (!$scope['selectedItem']) {
	                            $scope['selectedItem'] = ordered[0];
	                        }
	                        else {
	                            var next = ordered.indexOf($scope['selectedItem']) + 1;
	                            if (next === ordered.length) {
	                                next = 0;
	                            }
	                            $scope['selectedItem'] = ordered[next];
	                        }
	                    }); }); };
	                    var addItem = function () {
	                        if ($scope['selectedOption']) {
	                            var existing = _.find($scope['selectedOptions'], function (selected) { return selected === $scope['selectedOption']; });
	                            if (!existing) {
	                                $scope['selectedOptions'].push($scope['selectedOption']);
	                            }
	                        }
	                        $scope['selectedOption'] = null;
	                        $scope['inputText'] = '';
	                    };
	                    $scope['addItem'] = addItem;
	                    $scope.keyEntered = function (event) { return $timeout(function () { return $scope.$apply(function () {
	                        if (event.keyCode === 13 /* Enter */) {
	                            var isCommitChanges = !$scope['inputText'] && !$scope['selectedOption'];
	                            $log.debug('enter key detected. commit values? ' + isCommitChanges);
	                            if (isCommitChanges) {
	                                $scope.onOptionsDeactivated();
	                                $scope['releaseEngaged'] = false;
	                                $scope['selectedItem'] = null;
	                                $scope['onCommit']();
	                            }
	                            else {
	                                addItem();
	                                releaseSelection();
	                                $scope.onOptionsDeactivated();
	                                $scope.onChange();
	                            }
	                        }
	                        else if (event.keyCode === 27 /* Escape */) {
	                            var isCancelChanges = !$scope['inputText'];
	                            $scope['inputText'] = '';
	                            releaseSelection();
	                            $scope.onOptionsDeactivated();
	                            if (isCancelChanges) {
	                                $scope.onCancel();
	                            }
	                        }
	                        else if (event.keyCode === 8 /* Backspace */) {
	                            if (!$scope['inputText']) {
	                                selectOrDeleteLast();
	                            }
	                        }
	                        else if (event.keyCode === 37 /* ArrowLeft */ && !$scope['inputText']) {
	                            selectLeft();
	                        }
	                        else if (event.keyCode === 39 /* ArrowRight */ && !$scope['inputText']) {
	                            selectRight();
	                        }
	                        else if (event.keyCode === 40 /* ArrowDown */) {
	                            $scope.onSelectTopDownOption();
	                        }
	                        else if (event.keyCode === 38 /* ArrowUp */) {
	                            $scope.onSelectBottomUpOption();
	                        }
	                        else {
	                            releaseSelection();
	                        }
	                    }); }); };
	                    $scope.releaseItem = function (item) {
	                        $scope['selectedOptions'] = _.without($scope['selectedOptions'], item);
	                        $scope.onChange();
	                    };
	                    $scope.$on('fieldCanceled', function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['inputText'] = '';
	                        $scope['releaseEngaged'] = false;
	                        $scope['selectedItem'] = null;
	                    }); }); });
	                }]
	        };
	    }]);


/***/ },
/* 25 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\"><div data-tribe-multiselect-selected=\"data-tribe-multiselect-selected\" data-selected-options=\"selectedOptions\" data-on-select-top-down-option=\"onSelectTopDownOption()\" data-on-select-bottom-up-option=\"onSelectBottomUpOption()\" data-on-options-deactivated=\"onOptionsDeactivated()\" data-on-commit=\"fieldCommitted()\" data-on-cancel=\"fieldCanceled()\" data-on-change=\"fieldChanged()\" data-selected-option=\"selectedOption\" data-input-text=\"inputText\"></div><div data-tribe-multiselect-available=\"data-tribe-multiselect-available\" data-active=\"optionsActivated\" data-active-top-down=\"optionsActivatedTopDown\" data-active-bottom-up=\"optionsActivatedBottomUp\" data-selected-options=\"selectedOptions\" data-selected-option=\"selectedOption\" data-available-options=\"availableOptions\" data-input-text=\"inputText\" data-new-label=\"{{newLabel}}\" data-get-option-text=\"getOptionText\" data-version=\"version\"></div><div data-tribe-field-actions=\"data-tribe-field-actions\" data-version=\"version\" data-active=\"fieldDirty\" data-on-confirm=\"fieldCommitted()\" data-on-cancel=\"fieldCanceled()\"></div></div>";

/***/ },
/* 26 */
/***/ function(module, exports) {

	module.exports = "<div class=\"tribe-data-tribe-multiselect-available-body floating-menu\"><div class=\"opts\"><div class=\"option\" x-ng-repeat=\"opt in availableOptions | orderBy:getOptionText\" x-ng-click=\"selectItem(opt)\" x-ng-class=\"{selected: opt === selectedItem}\"><span>{{opt}}</span></div></div><div class=\"new-opt\" x-ng-if=\"newOpt\" x-ng-class=\"{selected: newOpt === selectedItem}\"><span x-ng-if=\"newLabel\">{{newLabel}}:</span><span x-ng-if=\"!newLabel\">New:</span><span>{{newOpt}}</span></div></div>";

/***/ },
/* 27 */
/***/ function(module, exports) {

	module.exports = "<div><div><div class=\"items\" x-ng-repeat=\"opt in selectedOptions | orderBy\" ng-class=\"{selected: opt === selectedItem}\"><div><span class=\"opt\">{{opt}}</span><i class=\"fa fa-times remove\" x-ng-click=\"releaseItem(opt)\"></i></div></div><div class=\"text\"><input type=\"text\" x-ng-keyup=\"keyEntered($event);\" x-ng-blur=\"addItem()\" x-ng-model=\"inputText\"/></div></div><div class=\"edit-icon\"><i class=\"fa fa-pencil\"></i></div></div>";

/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	angular.module('website-components-singleselect', [
	    'website-components-field-actions'
	])
	    .directive('tribeSingleselect', ['$window', '$timeout', function ($window, $timeout) {
	        return {
	            restrict: 'A',
	            scope: {
	                editable: '@?',
	                originalAvailableOptions: '=availableOptions',
	                originalSelectedOption: '=selectedOption',
	                originalGetOptionText: '=getOptionText',
	                newLabel: '@?',
	                placeholder: '@?',
	                disableActions: '=?',
	                onEditModeOn: '&?',
	                onEditModeOff: '&?',
	                mandatory: '@?'
	            },
	            template: __webpack_require__(29),
	            controller: ['$scope', '$timeout', function ($scope, $timeout) { return $timeout(function () {
	                    $scope['uniqueId'] = _.uniqueId('tribeSingleselect_');
	                    if ($scope['disableActions'] === undefined) {
	                        $scope['disableActions'] = true;
	                    }
	                    $scope.$watch('originalGetOptionText', function () {
	                        if ($scope.originalGetOptionText) {
	                            $scope.getOptionText = $scope.originalGetOptionText;
	                        }
	                        else {
	                            $scope.getOptionText = function (item) {
	                                if (!item || item.text === undefined) {
	                                    return item;
	                                }
	                                return item.text;
	                            };
	                        }
	                    });
	                    $scope.getOptionValue = function (item) {
	                        if (!item || item.value === undefined) {
	                            return item;
	                        }
	                        return item.value;
	                    };
	                    if ($scope.editable === undefined) {
	                        $scope.editable = false;
	                    }
	                    else {
	                        $scope.editable = $scope.editable === 'true';
	                    }
	                    $scope['selectedItem'] = null;
	                    $scope['inputText'] = null;
	                    $scope['fieldDirty'] = false;
	                    $scope['optionsActivated'] = false;
	                    $scope['optionsActivatedTopDown'] = 0;
	                    $scope['optionsActivatedBottomUp'] = 0;
	                    $scope['version'] = 0;
	                    $scope.$watch('originalAvailableOptions', function () {
	                        $scope.availableOptions = _.clone($scope.originalAvailableOptions);
	                        $scope.$watch('originalSelectedOption', function () {
	                            var existing = _.find($scope.availableOptions, function (item) {
	                                var availValue = $scope.getOptionValue(item);
	                                return availValue === $scope['originalSelectedOption'];
	                            });
	                            if (existing) {
	                                $scope['inputText'] = $scope.getOptionText(_.clone(existing));
	                                $scope['selectedItem'] = _.clone(existing);
	                            }
	                            else {
	                                $scope['inputText'] = _.clone($scope.originalSelectedOption);
	                                $scope['selectedItem'] = _.clone($scope.originalSelectedOption);
	                            }
	                        });
	                    });
	                    $scope['onChange'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['optionsActivated'] = true;
	                        $scope['fieldDirty'] = true;
	                        $scope['version'] = $scope['version'] + 1;
	                    }); }); };
	                    $scope['onCancel'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['fieldDirty'] = false;
	                        $scope['optionsActivated'] = false;
	                        var existing = _.find($scope.availableOptions, function (item) {
	                            var availValue = $scope.getOptionValue(item);
	                            return availValue === $scope['originalSelectedOption'];
	                        });
	                        $scope['inputText'] = $scope.getOptionText(existing);
	                        $scope['selectedItem'] = _.clone(existing);
	                        $scope.$broadcast('fieldCanceled');
	                    }); }); };
	                    $scope['onCommit'] = function (revertIfNoMatch) { return $timeout(function () { return $scope.$apply(function () {
	                        if ($scope['selectedItem']) {
	                            $scope['fieldDirty'] = false;
	                            $scope['optionsActivated'] = false;
	                            $scope['originalSelectedOption'] = $scope.getOptionValue($scope['selectedItem']);
	                            $scope['inputText'] = $scope.getOptionText($scope['selectedItem']);
	                            $scope['activeBottomUp'] = _.clone($scope['originalSelectedOption']);
	                            $scope.$broadcast('fieldCommitted');
	                        }
	                        else if (revertIfNoMatch) {
	                            $scope['fieldDirty'] = false;
	                            $scope['optionsActivated'] = false;
	                            var existing = _.find($scope.availableOptions, function (item) {
	                                var availValue = $scope.getOptionValue(item);
	                                return availValue === $scope['originalSelectedOption'];
	                            });
	                            $scope['inputText'] = $scope.getOptionText(existing);
	                            $scope['selectedItem'] = _.clone(existing);
	                        }
	                        else {
	                            $scope['fieldDirty'] = false;
	                            $scope['optionsActivated'] = false;
	                            $scope['originalSelectedOption'] = null;
	                            $scope['inputText'] = '';
	                            $scope['activeBottomUp'] = null;
	                            $scope.$broadcast('fieldCommitted');
	                        }
	                    }); }); };
	                    $scope['onSelectTopDownOption'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['optionsActivatedTopDown'] = $scope['optionsActivatedTopDown'] + 1;
	                        $scope['optionsActivated'] = true;
	                    }); }); };
	                    $scope.onSelectBottomUpOption = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['optionsActivatedBottomUp'] = $scope['optionsActivatedBottomUp'] + 1;
	                        $scope['optionsActivated'] = true;
	                    }); }); };
	                }); }],
	            link: function (scope, el) { return $timeout(function () {
	                var deactivatePromise = null;
	                var cancelDeactivate = function () {
	                    if (deactivatePromise) {
	                        $timeout.cancel(deactivatePromise);
	                    }
	                    deactivatePromise = null;
	                };
	                var deactivate = function () {
	                    cancelDeactivate();
	                    deactivatePromise = $timeout(function () {
	                        el.removeClass('active');
	                        scope.$apply(function () { return scope['optionsActivated'] = false; });
	                        if (scope['fieldDirty']) {
	                            scope['onCommit']();
	                        }
	                        if (scope['onEditModeOff']) {
	                            scope['onEditModeOff']({ 'uniqueId': scope['uniqueId'] });
	                        }
	                    }, 500);
	                };
	                var inputField = el.find('input');
	                el.on('click', function () { return inputField.focus(); });
	                el.find('> div').on('focus', function () { return inputField.focus(); });
	                inputField.on('focus', function () {
	                    cancelDeactivate();
	                    el.addClass('active');
	                    if (scope['disableActions']) {
	                        scope['onChange']();
	                    }
	                    $timeout(function () { return scope.$apply(function () {
	                        scope['fieldDirty'] = true;
	                        scope['version'] = scope['version'] + 1;
	                        if (scope['onEditModeOn']) {
	                            scope['onEditModeOn']({ 'uniqueId': scope['uniqueId'] });
	                        }
	                    }); });
	                    inputField.select();
	                });
	                scope.$on('fieldCanceled', function () { return inputField.blur(); });
	                scope.$on('fieldCommitted', function () { return inputField.blur(); });
	                inputField.on('blur', deactivate);
	                scope.$on('fieldDirty', function () {
	                    if (scope['fieldDirty']) {
	                        cancelDeactivate();
	                        el.addClass('active');
	                    }
	                });
	                scope.$watch('inputText', function () {
	                    if (el.hasClass('active')) {
	                        scope['onChange']();
	                    }
	                });
	                scope.$on('$destroy', function () { return el.remove(); });
	            }); }
	        };
	    }])
	    .directive('tribeSingleselectAvailable', ['$document', '$window', function ($document, $window) {
	        return {
	            restrict: 'A',
	            scope: {
	                originalAvailableOptions: '=availableOptions',
	                active: '=',
	                activeTopDown: '=',
	                activeBottomUp: '=',
	                onSelect: '&',
	                inputText: '=',
	                selectedItem: '=',
	                version: '=',
	                newLabel: '@?',
	                editable: '=',
	                getOptionText: '='
	            },
	            template: __webpack_require__(30),
	            controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                    $scope['showOptions'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['selectedItem'] = null;
	                        $scope.newOpt = null;
	                        $scope.availableOptions = _.clone($scope.originalAvailableOptions);
	                        var text = $scope['inputText'] ? $scope['inputText'].trim() : '';
	                        $scope.availableOptions = _.sortBy(_.filter($scope.availableOptions, function (opt) {
	                            return $scope.getOptionText(opt).toLowerCase().startsWith(text.toLowerCase());
	                        }), function (item) { return $scope.getOptionText(item); });
	                        $scope['selectedItem'] = _.find($scope.availableOptions, function (opt) {
	                            if (text) {
	                                return $scope.getOptionText(opt).toLowerCase().startsWith(text.toLowerCase());
	                            }
	                            return false;
	                        });
	                        if ($scope.editable) {
	                            if (_.find($scope.availableOptions, function (opt) { return $scope.getOptionText(opt) === text; })) {
	                                $scope.newOpt = null;
	                            }
	                            else {
	                                $scope.newOpt = text;
	                            }
	                            if (!$scope['selectedItem']) {
	                                $scope['selectedItem'] = $scope.newOpt;
	                            }
	                        }
	                    }); }); };
	                    $scope.selectNext = function () { return $timeout(function () { return $scope.$apply(function () {
	                        var ordered = _.sortBy($scope.availableOptions, function (item) { return $scope.getOptionText(item).toLowerCase(); });
	                        if ($scope['selectedItem']) {
	                            var index = ordered.indexOf($scope['selectedItem']) + 1;
	                            if (index >= ordered.length) {
	                                if ($scope.newOpt) {
	                                    $scope['selectedItem'] = $scope.newOpt;
	                                }
	                                else {
	                                    $scope['selectedItem'] = ordered[0];
	                                }
	                            }
	                            else {
	                                $scope['selectedItem'] = ordered[index];
	                            }
	                        }
	                        else {
	                            $scope['selectedItem'] = _.first(ordered);
	                        }
	                    }); }); };
	                    $scope['selectPrevious'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        var ordered = _.sortBy($scope.availableOptions, function (item) { return $scope.getOptionText(item).toLowerCase(); });
	                        if ($scope['selectedItem']) {
	                            if ($scope.newOpt === $scope['selectedItem'] && ordered.length) {
	                                $scope['selectedItem'] = _.last(ordered);
	                            }
	                            else {
	                                var index = ordered.indexOf($scope['selectedItem']) - 1;
	                                if (index < 0) {
	                                    if ($scope.newOpt) {
	                                        $scope['selectedItem'] = $scope.newOpt;
	                                    }
	                                    else {
	                                        $scope['selectedItem'] = _.last(ordered);
	                                    }
	                                }
	                                else {
	                                    $scope['selectedItem'] = ordered[index];
	                                }
	                            }
	                        }
	                        else {
	                            if ($scope.newOpt) {
	                                $scope['selectedItem'] = $scope.newOpt;
	                            }
	                            else {
	                                $scope['selectedItem'] = _.last(ordered);
	                            }
	                        }
	                    }); }); };
	                    $scope.selectItem = function (opt) {
	                        $scope.selectedItem = opt;
	                        $scope['active'] = false;
	                        $scope['inputText'] = $scope.getOptionText(opt);
	                    };
	                }],
	            link: function (scope, element) {
	                var floatingBody = angular.element(element.find('> div'));
	                floatingBody.detach();
	                var body = $document.find('body');
	                var adjustOffset = function () {
	                    var position = element.offset();
	                    floatingBody.offset(position);
	                };
	                scope.$watch('active', function () {
	                    if (scope['active']) {
	                        body.append(floatingBody);
	                        adjustOffset();
	                        scope['showOptions']();
	                        element.addClass('active');
	                    }
	                    else {
	                        floatingBody.detach();
	                        element.removeClass('active');
	                    }
	                });
	                scope.$watch('activeTopDown', function () {
	                    if (scope['activeTopDown']) {
	                        scope['selectNext']();
	                    }
	                });
	                scope.$watch('activeBottomUp', function () {
	                    if (scope['activeBottomUp']) {
	                        scope['selectPrevious']();
	                    }
	                });
	                scope.$watch('version', function () {
	                    adjustOffset();
	                    if (scope['active']) {
	                        scope['showOptions']();
	                        element.addClass('active');
	                    }
	                });
	                var eWin = angular.element($window);
	                eWin.bind('resize', adjustOffset);
	                scope.$on('$destroy', function () {
	                    eWin.unbind('resize', adjustOffset);
	                    floatingBody.remove();
	                    element.remove();
	                });
	            }
	        };
	    }])
	    .directive('tribeSingleselectSelected', [function () {
	        return {
	            restrict: 'A',
	            scope: {
	                onChange: '&',
	                onCancel: '&',
	                onCommit: '&',
	                onSelectTopDownOption: '&',
	                onSelectBottomUpOption: '&',
	                inputText: '=',
	                placeholder: '=',
	                mandatory: '='
	            },
	            template: __webpack_require__(31),
	            controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                    $scope.keyEntered = function (event) { return $timeout(function () { return $scope.$apply(function () {
	                        if (event.keyCode === 27 /* Escape */) {
	                            $scope['onCancel']();
	                        }
	                        else if (event.keyCode === 40 /* ArrowDown */) {
	                            $scope['onSelectTopDownOption']();
	                        }
	                        else if (event.keyCode === 38 /* ArrowUp */) {
	                            $scope.onSelectBottomUpOption();
	                        }
	                        else if (event.keyCode === 13 /* Enter */) {
	                            $scope['onCommit']();
	                        }
	                        else if (event.keyCode === 9) {
	                        }
	                    }); }); };
	                }]
	        };
	    }]);


/***/ },
/* 29 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\"><div data-tribe-singleselect-selected=\"data-tribe-singleselect-selected\" data-on-select-top-down-option=\"onSelectTopDownOption()\" data-on-select-bottom-up-option=\"onSelectBottomUpOption()\" data-on-cancel=\"onCancel()\" data-on-commit=\"onCommit()\" data-on-change=\"onChange()\" data-input-text=\"inputText\" data-placeholder=\"placeholder\" data-mandatory=\"mandatory\"></div><div data-tribe-singleselect-available=\"data-tribe-singleselect-available\" data-active=\"optionsActivated\" data-active-top-down=\"optionsActivatedTopDown\" data-active-bottom-up=\"optionsActivatedBottomUp\" data-available-options=\"availableOptions\" data-input-text=\"inputText\" data-selected-item=\"selectedItem\" data-version=\"version\" data-new-label=\"{{newLabel}}\" data-editable=\"editable\" data-get-option-text=\"getOptionText\"></div><div data-tribe-field-actions=\"data-tribe-field-actions\" data-version=\"version\" data-active=\"fieldDirty &amp;&amp; !disableActions\" data-on-confirm=\"onCommit()\" data-on-cancel=\"onCancel()\"></div></div>";

/***/ },
/* 30 */
/***/ function(module, exports) {

	module.exports = "<div class=\"tribe-data-tribe-singleselect-available-body floating-menu\"><div class=\"opts\"><div class=\"option\" x-ng-repeat=\"opt in availableOptions | orderBy:getOptionText\" x-ng-click=\"selectItem(opt)\" x-ng-class=\"{selected: opt === selectedItem}\"><span>{{getOptionText(opt)}}</span></div></div><div class=\"new-opt\" x-ng-if=\"newOpt &amp;&amp; editable\" x-ng-class=\"{selected: newOpt === selectedItem}\"><span x-ng-if=\"newLabel\">{{newLabel}}:</span><span x-ng-if=\"!newLabel\">New:</span><span>{{inputText}}</span></div><div class=\"new-opt\" x-ng-if=\"!newOpt &amp;&amp; !editable &amp;&amp; !selectedItem &amp;&amp; inputText\"><span>No matches</span></div></div>";

/***/ },
/* 31 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"text\"><input type=\"text\" x-ng-keyup=\"keyEntered($event);\" x-ng-model=\"inputText\"/><span>{{inputText}}</span><span class=\"empty\" x-ng-if=\"!inputText\">{{placeholder !== null &&  placeholder !== undefined ? placeholder : ''}}</span><span class=\"empty mandatory\" x-ng-if=\"!inputText &amp;&amp; mandatory\">mandatory</span></div><div class=\"edit-icon\"><i class=\"fa fa-pencil\"></i></div></div>";

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	angular.module('website-components-text', [
	    'website-components-field-actions'
	])
	    .directive('tribeText', ['$window', '$timeout', function ($window, $timeout) {
	        return {
	            restrict: 'A',
	            scope: {
	                originalValue: '=value',
	                type: '@',
	                placeholder: '@',
	                regex: '@?',
	                regexTip: '@?',
	                onEditModeOn: '&?',
	                onEditModeOff: '&?',
	                mandatory: '@?'
	            },
	            template: __webpack_require__(33),
	            controller: ['$log', '$scope', function ($log, $scope) { return $timeout(function () {
	                    $scope['uniqueId'] = _.uniqueId('tribeText_');
	                    if (!$scope['regexTip']) {
	                        $scope['regexTip'] = 'Invalid Pattern';
	                    }
	                    var normalTitle = 'Click to edit';
	                    $scope['title'] = normalTitle;
	                    $scope.$watch('valid', function () { return $timeout(function () { return $scope.$apply(function () {
	                        if ($scope['valid'] === false) {
	                            $scope['title'] = 'Invalid pattern';
	                        }
	                        else {
	                            $scope['title'] = normalTitle;
	                        }
	                    }); }); });
	                    $scope['version'] = 0;
	                    $scope['fieldDirty'] = false;
	                    $scope.$watch('originalValue', function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['value'] = _.clone($scope['originalValue']);
	                    }); }); });
	                    $scope['onCommit'] = function () { return $timeout(function () { return $scope.$apply(function () {
	                        if ($scope['fieldDirty'] && ($scope['valid'] === true || $scope['valid'] === undefined)) {
	                            $scope['fieldDirty'] = false;
	                            $scope['originalValue'] = _.clone($scope['value']);
	                            $scope['title'] = normalTitle;
	                            $scope.$broadcast('fieldCommited');
	                        }
	                    }); }); };
	                    $scope.onCancel = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['fieldDirty'] = false;
	                        $scope['value'] = _.clone($scope['originalValue']);
	                        $scope['title'] = normalTitle;
	                        $scope['valid'] = true;
	                        $scope.$broadcast('fieldCanceled');
	                    }); }); };
	                    $scope.onChange = function () { return $timeout(function () { return $scope.$apply(function () {
	                        $scope['version'] = $scope['version'] + 1;
	                        if ($scope['originalValue'] !== $scope['value']) {
	                            $scope['fieldDirty'] = true;
	                        }
	                    }); }); };
	                    $scope.keyEntered = function (event) { return $timeout(function () { return $scope.$apply(function () {
	                        if (event.keyCode === 13 /* Enter */) {
	                            $scope['onCommit']();
	                        }
	                        else if (event.keyCode === 27 /* Escape */) {
	                            $scope.onCancel();
	                        }
	                        else {
	                            $scope.onChange();
	                        }
	                    }); }); };
	                    $scope.$watchGroup(['version', 'value'], function () { return $timeout(function () { return $scope.$apply(function () {
	                        if ($scope['regex'] !== undefined && $scope['regex'] !== null) {
	                            var value = $scope['value'];
	                            var valid = new RegExp($scope['regex'], 'g').test(value);
	                            $scope['valid'] = valid;
	                        }
	                    }); }); });
	                }); }],
	            link: function (scope, element) { return $timeout(function () {
	                var deactivatePromise = null;
	                var cancelDeactivate = function () {
	                    if (deactivatePromise) {
	                        $timeout.cancel(deactivatePromise);
	                    }
	                    deactivatePromise = null;
	                };
	                var input = element.find('input');
	                var deactivate = function () {
	                    cancelDeactivate();
	                    deactivatePromise = $timeout(function () {
	                        if (element.hasClass('invalid')) {
	                            scope['onCancel']();
	                        }
	                        else {
	                            scope['onCommit']();
	                        }
	                        element.removeClass('invalid');
	                        element.removeClass('active');
	                        if (scope['onEditModeOff']) {
	                            scope['onEditModeOff']({ 'uniqueId': scope['uniqueId'] });
	                        }
	                    }, 500);
	                };
	                scope.$on('fieldCanceled', function () { return input.blur(); });
	                scope.$on('fieldCommited', function () { return input.blur(); });
	                input.on('blur', function () { return deactivate(); });
	                input.on('focus', function () {
	                    cancelDeactivate();
	                    element.addClass('active');
	                    input.select();
	                    $timeout(function () { return scope.$apply(function () {
	                        scope['version'] = scope['version'] + 1;
	                        scope['fieldDirty'] = true;
	                        if (scope['onEditModeOn']) {
	                            scope['onEditModeOn']({ 'uniqueId': scope['uniqueId'] });
	                        }
	                    }); });
	                });
	                element.on('click', function () { return input.focus(); });
	                element.find('> div').on('focus', function () { return input.focus(); });
	                scope.$on('$destroy', function () { return element.remove(); });
	                scope.$watch('valid', function () {
	                    if (scope['valid']) {
	                        element.removeClass('invalid');
	                    }
	                    else {
	                        if (scope['regex'] !== undefined && scope['regex'] !== null) {
	                            element.addClass('invalid');
	                        }
	                    }
	                });
	            }); }
	        };
	    }]);


/***/ },
/* 33 */
/***/ function(module, exports) {

	module.exports = "<div tabindex=\"0\" x-ng-attr-title=\"{{mandatory &amp;&amp; !value ? '' : title}}\"><div><div class=\"text\"><input type=\"{{type ? type : 'text'}}\" x-ng-keyup=\"keyEntered($event);\" x-ng-model=\"value\"/><span x-ng-if=\"value\">{{value}}</span><span class=\"empty\" x-ng-if=\"!value\">{{placeholder ? placeholder : Empty}}</span><span class=\"empty mandatory\" x-ng-if=\"!value &amp;&amp; mandatory\">mandatory</span></div><div class=\"edit-icon\"><i class=\"fa fa-pencil\"></i></div></div><div data-tribe-field-actions=\"data-tribe-field-actions\" data-version=\"version\" data-active=\"fieldDirty\" data-on-confirm=\"onCommit()\" data-on-cancel=\"onCancel()\" data-valid-value=\"valid\"></div><div data-tribe-tip=\"data-tribe-tip\" data-message=\"{{regexTip}}\" data-visible=\"(valid === false)\"></div></div>";

/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	angular.module('website-components-tip', [])
	    .directive('tribeTip', ['$window', '$timeout', '$interval', '$document', function ($window, $timeout, $interval, $document) {
	        return {
	            restrict: 'A',
	            scope: {
	                message: '@',
	                visible: '='
	            },
	            template: __webpack_require__(35),
	            controller: ['$log', '$scope', function ($log, $scope) {
	                }],
	            link: function (scope, el) { return $timeout(function () {
	                var parent = angular.element(el.parent());
	                el.detach();
	                var body = $document.find('body');
	                body.append(el);
	                var adjust = function () {
	                    var parentPosition = parent.offset();
	                    el.offset({
	                        top: parentPosition.top + parent.height(),
	                        left: parentPosition.left + 40
	                    });
	                };
	                var adjustPromise = null;
	                scope.$watch('visible', function () {
	                    if (scope['visible']) {
	                        adjust();
	                        adjustPromise = $interval(adjust, 1000);
	                    }
	                    else {
	                        if (adjustPromise) {
	                            $interval.cancel(adjustPromise);
	                        }
	                        adjustPromise = null;
	                    }
	                });
	                scope.$on('$destroy', function () {
	                    if (adjustPromise) {
	                        $interval.cancel(adjustPromise);
	                    }
	                    el.remove();
	                });
	            }); }
	        };
	    }]);


/***/ },
/* 35 */
/***/ function(module, exports) {

	module.exports = "<div x-ng-if=\"visible\"><div class=\"arrow\"></div><div class=\"message\"><div x-ng-bind-html=\"message | tribeHtml\"></div></div></div>";

/***/ },
/* 36 */
/***/ function(module, exports) {

	"use strict";
	angular.module('tribe-alerts', [])
	    .factory('tribeErrorHandlerService', ['systemMessagesService', '$log', function (systemMessagesService, $log) {
	        return {
	            ensureErrorHandler: function (originalCallback) {
	                if (originalCallback) {
	                    return originalCallback;
	                }
	                return function (evn) {
	                    if (!evn.statusText || evn.statusText === '') {
	                        systemMessagesService.error('There is something wrong with your connection.');
	                        $log.error(evn);
	                    }
	                    systemMessagesService.error(evn.statusText);
	                };
	            }
	        };
	    }])
	    .factory('systemMessagesService', [function () {
	        var listeners = [];
	        var messages = [];
	        var addMessage = function (msgType, msgText, timeout) {
	            var msgObj = {
	                msgType: msgType,
	                msgText: msgText,
	                msgTimeout: timeout
	            };
	            triggerUpdateEvent(msgObj);
	        };
	        var triggerUpdateEvent = function (newMessage) {
	            if (newMessage) {
	                messages.push(newMessage);
	            }
	            var cloneMessages = _.clone(messages);
	            _.each(listeners, function (listener) {
	                listener.onMessage(cloneMessages, newMessage);
	            });
	        };
	        return {
	            addListener: function (listener) {
	                listeners = _.union([listener], listeners);
	            },
	            removeListener: function (listener) {
	                listeners = _.reject(listeners, function (item) {
	                    return item === listener;
	                });
	            },
	            getMessages: function () {
	                return _.clone(messages);
	            },
	            info: function (msg, timeout) {
	                addMessage('info', msg, timeout);
	            },
	            warn: function (msg, timeout) {
	                addMessage('warn', msg, timeout);
	            },
	            error: function (msg, timeout) {
	                addMessage('error', msg, timeout);
	            },
	            setMessageRead: function (msg) {
	                msg['read'] = true;
	                triggerUpdateEvent();
	            }
	        };
	    }])
	    .run(function () {
	    // placeholder
	});


/***/ },
/* 37 */
/***/ function(module, exports) {

	"use strict";
	var services;
	(function (services) {
	    angular.module('website-services', [
	        'ngRoute',
	        'ngResource',
	        'ngCookies',
	        'ngStorage',
	        'website-browser',
	        'tribe-alerts'
	    ])
	        .factory('tribeFilterService', ['$location',
	        function ($location) {
	            return {
	                filterByCategory: function (app, category) {
	                    $location.search({
	                        a: app,
	                        c: category
	                    });
	                    $location.path('/');
	                },
	                filterByRole: function (app, role) {
	                    $location.search({
	                        a: app,
	                        r: role
	                    });
	                    $location.path('/');
	                },
	                filterByTag: function (app, tag) {
	                    $location.search({
	                        a: app,
	                        t: tag
	                    });
	                    $location.path('/');
	                }
	            };
	        }
	    ])
	        .factory('tribeAuthorizationService', ['$http', '$localStorage', 'tribeHeaderProviderSelector',
	        function ($http, $localStorage, tribeHeaderProviderSelector) {
	            return {
	                getOauth2Status: function () {
	                    return $http.get('api/security/oauth2/status');
	                },
	                setCredentials: function (username, providerState) {
	                    if (!$localStorage.tribe) {
	                        $localStorage.tribe = {};
	                    }
	                    $localStorage.tribe.security = providerState;
	                    $localStorage.tribe.username = username;
	                },
	                getCredentials: function () {
	                    if (!$localStorage.tribe) {
	                        return "Guest";
	                    }
	                    else {
	                        return $localStorage.tribe.username;
	                    }
	                },
	                restoreSession: function () {
	                    var providerState = $localStorage.tribe ? $localStorage.tribe.security : undefined;
	                    if (providerState) {
	                        var provider = tribeHeaderProviderSelector.select($localStorage.tribe.security.type);
	                        provider.fromState($localStorage.tribe.security);
	                        return provider;
	                    }
	                    return undefined;
	                },
	                isConnected: function () {
	                    return $localStorage.tribe
	                        && $localStorage.tribe.security;
	                },
	                clearCredentials: function () {
	                    try {
	                        document.execCommand('ClearAuthenticationCache');
	                    }
	                    catch (e) {
	                    }
	                    $localStorage.tribe = {};
	                }
	            };
	        }
	    ])
	        .run(function () {
	        // placeholder
	    });
	})(services || (services = {}));


/***/ },
/* 38 */
/***/ function(module, exports) {

	"use strict";
	var services_browser;
	(function (services_browser) {
	    // wrapper to browser features. useful in unit tests
	    angular.module('website-browser', [])
	        .factory('Base64', [function () {
	            return Base64;
	        }])
	        .run(function () {
	        // placeholder
	    });
	})(services_browser || (services_browser = {}));


/***/ },
/* 39 */
/***/ function(module, exports) {

	"use strict";
	var services_endpoints;
	(function (services_endpoints) {
	    angular.module('website-services-endpoints', [
	        'ngRoute',
	        'ngResource',
	        'ngCookies',
	        'ngStorage',
	        'tribe-alerts'
	    ])
	        .factory('tribeLinkHeaderService', [
	        function () {
	            return {
	                /*index links for an easier access*/
	                parseLinkHeader: function (values) {
	                    return !values ? {} : values.reduce(function (m, l) { m[l['rel']] = l['href']; return m; }, {});
	                }
	            };
	        }
	    ])
	        .factory('tribeEndpointsService', [
	        '$location', '$resource', '$http', 'tribeErrorHandlerService',
	        function ($location, $resource, $http, tribeErrorHandlerService) {
	            var httpListCall = function (url, params, successCallback, errorCallback) {
	                $http({
	                    url: url,
	                    method: 'GET',
	                    params: params
	                }).then(successCallback, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	            };
	            return {
	                list: function () {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            var params = {};
	                            var rawParams = $location.search();
	                            _.each(rawParams, function (value, key) {
	                                if ('a' === key) {
	                                    params['app'] = value.split(',');
	                                }
	                                else if ('c' === key) {
	                                    params['category'] = value.split(',');
	                                }
	                                else if ('t' === key) {
	                                    params['tag'] = value.split(',');
	                                }
	                                else if ('r' === key) {
	                                    params['role'] = value.split(',');
	                                }
	                                else if ('q' === key) {
	                                    params['query'] = value;
	                                }
	                            });
	                            var removeSelected = function (list, qparam) {
	                                var param = rawParams[qparam];
	                                if (!param) {
	                                    return list;
	                                }
	                                param = param.split(',');
	                                return _.filter(list, function (entry) {
	                                    return !_.some(param, function (pEntry) {
	                                        return entry.text === pEntry;
	                                    });
	                                });
	                            };
	                            httpListCall('api/registry', params, function (rawData) {
	                                var data = rawData.data;
	                                var compiledResults = [];
	                                for (var _i = 0, _a = data.results; _i < _a.length; _i++) {
	                                    var rawEndpoint = _a[_i];
	                                    compiledResults.push(rawEndpoint);
	                                }
	                                successCallback({
	                                    total: data.total,
	                                    endpoints: compiledResults,
	                                    applications: removeSelected(data.applications, 'a'),
	                                    categories: removeSelected(data.categories, 'c'),
	                                    tags: removeSelected(data.tags, 't'),
	                                    roles: removeSelected(data.roles, 'r')
	                                });
	                            }, errorCallback);
	                        }
	                    };
	                },
	                getApplicationDetails: function (applicationLink) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.get(applicationLink)
	                                .then(function (data) {
	                                if (data && data.data && data.data.swagger) {
	                                    // we will have at most one result. only one application queried.
	                                    successCallback(data);
	                                }
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                getApplicationDetailsFromName: function (applicationName) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.get('api/ui/application/' + applicationName)
	                                .then(function (data) {
	                                if (data && data.data && data.data.swagger) {
	                                    // we will have at most one result. only one application queried.
	                                    successCallback(data);
	                                }
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                getDetailsFromMetadata: function (request) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            if (request && request.endpointPath) {
	                                var params = request.version ? { version: request.version } : {};
	                                $http.get("api/ui/endpoint/" + request.applicationName + "/" + (request.verb || '-') + "/" + request.endpointPath, { params: params })
	                                    .then(function (data) {
	                                    successCallback(data);
	                                }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                            }
	                            else {
	                                var newEntry = {};
	                                successCallback(newEntry);
	                            }
	                        }
	                    };
	                },
	                getHistory: function (url) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            if (url) {
	                                $http.get(url)
	                                    .then(function (data) {
	                                    successCallback(data);
	                                }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                            }
	                            else {
	                            }
	                        }
	                    };
	                },
	                getHistoricItem: function (historyItem) {
	                    return {
	                        promise: function () {
	                            return $http.get(historyItem.link + '&payload=true');
	                        },
	                        then: function (successCallback, errorCallback) {
	                            $http.get(historyItem.link)
	                                .then(function (data) {
	                                successCallback(data);
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                getSeeContent: function (aggregateId) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.get('api/id/registry/see/' + aggregateId)
	                                .then(function (data) {
	                                successCallback(data.data);
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                saveApplication: function (applicationLink, application) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.put(applicationLink, { swagger: application })
	                                .then(function (data) {
	                                if (data && data.data && data.data.swagger) {
	                                    successCallback(data);
	                                }
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                createApplication: function (applicationsLink, application) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.post(applicationsLink, { swagger: application })
	                                .then(function (data) {
	                                if (data && data.data && data.data.swagger) {
	                                    // we will have at most one result. only one application queried.
	                                    successCallback(data);
	                                }
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                saveEndpoint: function (endpointLink, endpoint) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.put(endpointLink, endpoint)
	                                .then(function (data) {
	                                if (data && data.data && data.data.operation) {
	                                    // we will have at most one result. only one application queried.
	                                    successCallback(data);
	                                }
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                createEndpoint: function (endpointsLink, endpoint) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.post(endpointsLink, endpoint)
	                                .then(function (data) {
	                                if (data && data.data && data.data.operation) {
	                                    // we will have at most one result. only one application queried.
	                                    successCallback(data);
	                                }
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                },
	                delete: function (endpointLink) {
	                    return {
	                        then: function (successCallback, errorCallback) {
	                            $http.delete(endpointLink).then(function (response) {
	                                successCallback(response);
	                            }, tribeErrorHandlerService.ensureErrorHandler(errorCallback));
	                        }
	                    };
	                }
	            };
	        }
	    ])
	        .run(function () {
	        // placeholder
	    });
	})(services_endpoints || (services_endpoints = {}));


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var Base64 = __webpack_require__(41).Base64;
	var BasicHeaderProvider = (function () {
	    function BasicHeaderProvider($http, $q) {
	        this.$http = $http;
	        this.$q = $q;
	    }
	    BasicHeaderProvider.prototype.login = function (username, password) {
	        var _this = this;
	        return this.$http.post('api/login', $.param({ username: username, password: password }), { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
	            .then(function (response) { return _this.token = 'Basic ' + Base64.encode(username + ':' + password); });
	    };
	    BasicHeaderProvider.prototype.logout = function () {
	        this.token = undefined;
	    };
	    BasicHeaderProvider.prototype.isValid = function () {
	        return !!this.token;
	    };
	    BasicHeaderProvider.prototype.getAuthorizationHeader = function () {
	        var deferred = this.$q.defer();
	        deferred.resolve(this.token);
	        return deferred.promise;
	    };
	    BasicHeaderProvider.prototype.getState = function () {
	        return { type: "Basic", token: this.token };
	    };
	    BasicHeaderProvider.prototype.fromState = function (state) {
	        // we could check and enforce the type of the state to Basic
	        this.token = state["token"];
	    };
	    return BasicHeaderProvider;
	}());
	var OAuth2HeaderProvider = (function () {
	    function OAuth2HeaderProvider($http, $q, $localStorage) {
	        this.$http = $http;
	        this.$q = $q;
	        this.$localStorage = $localStorage;
	        this.retry = 0;
	    }
	    OAuth2HeaderProvider.prototype.login = function (username, password) {
	        var _this = this;
	        // client_*  are owned by the server, don't put them here
	        var start = new Date().getTime();
	        return this.$http.post('api/security/oauth2', 'username=' + encodeURIComponent(username) + '&password=' + encodeURIComponent(password) + '&grant_type=password', { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
	            .then(function (response) { return _this.onLoad(response, start); });
	    };
	    OAuth2HeaderProvider.prototype.logout = function () {
	        if (!this.isLogged()) {
	            return;
	        }
	        this.token = undefined;
	    };
	    /**
	     * Build a promise returning the authentication header to set on the http request.
	     * Note that it automatically tries to get a refresh token respecting retry counter.
	     */
	    OAuth2HeaderProvider.prototype.getAuthorizationHeader = function () {
	        var _this = this;
	        if (!this.isValid()) {
	            this.retry++;
	            if (this.retry > 3) {
	                var deferred_1 = this.$q.defer();
	                deferred_1.reject('Retried the refresh flow but token is likely invalid or server is down');
	                return deferred_1.promise;
	            }
	            return this.refresh()
	                .then(function () { return _this.getAuthorizationHeader(); });
	        }
	        var deferred = this.$q.defer();
	        deferred.resolve('Bearer ' + this.token['access_token']);
	        return deferred.promise;
	    };
	    OAuth2HeaderProvider.prototype.isValid = function () {
	        return this.isLogged() && new Date().getTime() < this.expiration;
	    };
	    OAuth2HeaderProvider.prototype.isLogged = function () {
	        return !!this.token;
	    };
	    OAuth2HeaderProvider.prototype.getState = function () {
	        return { type: "OAuth2", token: this.token, expiration: this.expiration };
	    };
	    OAuth2HeaderProvider.prototype.fromState = function (state) {
	        this.token = state["token"];
	        this.expiration = state["expiration"];
	    };
	    OAuth2HeaderProvider.prototype.refresh = function () {
	        var _this = this;
	        var start = new Date().getTime();
	        return this.$http.post('api/security/oauth2', 'refresh_token=' + encodeURIComponent(this.token['refresh_token']) + '&grant_type=refresh_token', { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
	            .then(function (response) { return _this.onLoad(response, start); });
	    };
	    OAuth2HeaderProvider.prototype.onLoad = function (response, start) {
	        this.retry = 0;
	        this.token = response.data;
	        this.expiration = start + (1000 * (this.token['expires_in'] || 3600));
	        this.$localStorage.tribe.security = this.getState();
	    };
	    return OAuth2HeaderProvider;
	}());
	/**
	 * Intended to be used if the GUI exposes a selector for the auth type.
	 * This selector will accept 'Basic' and 'OAuth2' values.
	 */
	var HeaderProviderSelector = (function () {
	    function HeaderProviderSelector(oauth2, basic) {
	        this.oauth2 = oauth2;
	        this.basic = basic;
	    }
	    HeaderProviderSelector.prototype.select = function (type) {
	        switch (type) {
	            case 'Basic':
	                return this.basic;
	            case 'OAuth2':
	            default:
	                return this.oauth2;
	        }
	    };
	    return HeaderProviderSelector;
	}());
	// register them all as angular services
	angular.module('tribe-services-header-providers', ['website-browser'])
	    .service('tribeOauth2HeaderProvider', ['$http', '$q', '$localStorage', OAuth2HeaderProvider])
	    .service('tribeBasicHeaderProvider', ['$http', '$q', BasicHeaderProvider])
	    .service('tribeHeaderProviderSelector', ['tribeOauth2HeaderProvider', 'tribeBasicHeaderProvider', HeaderProviderSelector]);


/***/ },
/* 41 */,
/* 42 */,
/* 43 */,
/* 44 */,
/* 45 */,
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	angular.module('tribe-app', [
	    'website-services'
	])
	    .directive('app', [function () {
	        return {
	            restrict: 'A',
	            template: __webpack_require__(47),
	            transclude: true,
	            scope: {}
	        };
	    }])
	    .directive('appFooter', [function () {
	        return {
	            restrict: 'A',
	            scope: {},
	            template: __webpack_require__(48),
	            controller: ['$timeout', '$scope', function ($timeout, $scope) {
	                    $scope.now = Date.now();
	                }]
	        };
	    }])
	    .directive('appHeader', [function () {
	        return {
	            restrict: 'A',
	            scope: {},
	            template: __webpack_require__(49)
	        };
	    }])
	    .run(function () {
	    // placeholder
	});


/***/ },
/* 47 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"top-background\"></div><div data-app-header=\"data-app-header\"></div><section><div x-ng-transclude=\"x-ng-transclude\"></div></section></div>";

/***/ },
/* 48 */
/***/ function(module, exports) {

	module.exports = "<footer><span>Tomitribe © {{now | date:'yyyy'}}</span></footer>";

/***/ },
/* 49 */
/***/ function(module, exports) {

	module.exports = "<header><a href=\".\"><div class=\"img\" title=\"Tribestream API Registry\"></div></a><div><span>Tribestream API Registry</span></div><div><span app-logged-in=\"app-logged-in\">{{user}}</span><i class=\"fa fa-sign-out fa-lg\" app-logout=\"app-logout\" title=\"Sign out\"></i></div></header>";

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	angular.module('website-messages', [
	    'website-services',
	    'tribe-alerts'
	])
	    .directive('appNgClickConfirm', ['$document', '$parse', '$compile', function ($document, $parse, $compile) {
	        return {
	            restrict: 'A',
	            link: function (scope, el, attrs) {
	                var getMessage = function (attrKey, strDefault) {
	                    var msg = attrs[attrKey];
	                    if (!msg) {
	                        msg = strDefault;
	                    }
	                    return msg;
	                };
	                var appConfirmationTitle = getMessage('appConfirmationMessageTitle', '');
	                var appConfirmationMessage = getMessage('appConfirmationMessage', 'Do you confirm this action?');
	                var appConfirmationMessageYes = getMessage('appConfirmationMessageYes', 'yes');
	                var appConfirmationMessageNo = getMessage('appConfirmationMessageNo', 'no');
	                var html = $compile(['<i, data-app-ng-click-confirm-el ',
	                    'data-action="' + attrs['appNgClickConfirm'] + '" ',
	                    'data-title="' + appConfirmationTitle + '" ',
	                    'data-message="' + appConfirmationMessage + '" ',
	                    'data-yes="' + appConfirmationMessageYes + '" ',
	                    'data-no="' + appConfirmationMessageNo + '"',
	                    '></i>'].join(''))(scope.$new());
	                el.on('click', function () {
	                    var body = $document.find('body');
	                    body.append(html);
	                });
	                el.on('$destroy', function () {
	                    html.remove();
	                });
	            }
	        };
	    }])
	    .directive('appNgClickConfirmEl', [function () {
	        return {
	            restrict: 'A',
	            template: __webpack_require__(51),
	            controller: ['$timeout', '$element', '$scope', '$parse', function ($timeout, $element, $scope, $parse) {
	                    $scope.yesClick = function () {
	                        $timeout(function () {
	                            $element.detach();
	                            var fn = $parse($scope['action'], null, true);
	                            var callback = function () {
	                                fn($scope, { $event: event });
	                            };
	                            $scope.$apply(callback);
	                        });
	                    };
	                    $scope.noClick = function () {
	                        $element.detach();
	                    };
	                }],
	            link: function (scope, el, attrs) {
	                scope['action'] = attrs['action'];
	                scope['title'] = attrs['title'];
	                scope['message'] = attrs['message'];
	                scope['yes'] = attrs['yes'];
	                scope['no'] = attrs['no'];
	            }
	        };
	    }])
	    .directive('appClosableMessages', [function () {
	        return {
	            restrict: 'A',
	            scope: true,
	            template: __webpack_require__(52),
	            controller: ['$scope', '$timeout', 'systemMessagesService',
	                function ($scope, $timeout, systemMessagesService) {
	                    $scope.messages = systemMessagesService.getMessages();
	                    var me = this;
	                    me.onMessage = function (msgs) {
	                        $timeout(function () {
	                            $scope.messages = _.reject(msgs, function (msg) {
	                                return msg['read'];
	                            });
	                        });
	                    };
	                    systemMessagesService.addListener(me);
	                    me['disconnectListener'] = function () {
	                        systemMessagesService.removeListener(me);
	                    };
	                    me['setMessageRead'] = function (msg) {
	                        systemMessagesService['setMessageRead'](msg);
	                    };
	                }
	            ],
	            link: function (scope, el, attrs, controller) {
	                el.on('$destroy', function () {
	                    controller['disconnectListener']();
	                });
	            }
	        };
	    }])
	    .directive('appClosableMessage', ['$timeout', function ($timeout) {
	        return {
	            restrict: 'A',
	            scope: {
	                message: '='
	            },
	            require: '^appClosableMessages',
	            link: function (scope, el, attrs, controller) {
	                var removeTimer;
	                var setTimer = function () {
	                    // remove element after X seconds
	                    var timeoutValue = scope['message']['msgType'] === 'error' ? 10000 : 2000;
	                    if (scope['message']['msgTimeout']) {
	                        timeoutValue = scope['message']['msgTimeout'];
	                    }
	                    removeTimer = $timeout(function () {
	                        controller['setMessageRead'](scope['message']);
	                    }, timeoutValue);
	                };
	                setTimer();
	                el.on('$destroy', function () {
	                    $timeout.cancel(removeTimer);
	                });
	                el.on('mouseover', function () {
	                    $timeout.cancel(removeTimer);
	                });
	                el.on('mouseout', function () {
	                    setTimer();
	                });
	                el.on('click', function () {
	                    controller['setMessageRead'](scope['message']);
	                });
	            }
	        };
	    }])
	    .run(function () {
	    // placeholder
	});


/***/ },
/* 51 */
/***/ function(module, exports) {

	module.exports = "<div class=\"app-confirmation-message\"><div x-ng-show=\"title !== ''\"><h1>{{title}}</h1></div><div><p>{{message}}</p></div><div><button class=\"inverted\" x-ng-click=\"noClick()\">{{no}}</button><button x-ng-click=\"yesClick()\">{{yes}}</button></div></div>";

/***/ },
/* 52 */
/***/ function(module, exports) {

	module.exports = "<div><div x-ng-repeat=\"msg in messages\"><div><div x-ng-class=\"{'app-message-error': msg.msgType == 'error', 'app-message-warning': msg.msgType == 'warn'}\"><i class=\"fa fa-times-circle-o\" x-ng-show=\"msg.msgType == 'error'\"></i><i class=\"fa fa-exclamation-triangle\" x-ng-show=\"msg.msgType == 'warn'\"></i><i class=\"fa fa-check-square-o\" x-ng-show=\"msg.msgType == 'info'\"></i></div><h1 x-ng-show=\"msg.msgType == 'error'\">warning</h1><h1 x-ng-show=\"msg.msgType == 'warn'\">caution</h1><h1 x-ng-show=\"msg.msgType == 'info'\">successful</h1><p>{{msg.msgText}}</p></div><i class=\"fa fa-times-circle-o\" app-closable-message=\"app-closable-message\" message=\"msg\"></i></div></div>";

/***/ },
/* 53 */
/***/ function(module, exports) {

	"use strict";
	var CurrentAuthProvider = (function () {
	    function CurrentAuthProvider() {
	    }
	    CurrentAuthProvider.prototype.set = function (authenticationProvider) {
	        this.currentProvider = authenticationProvider;
	    };
	    CurrentAuthProvider.prototype.isActive = function () {
	        return !!this.currentProvider;
	    };
	    CurrentAuthProvider.prototype.get = function () {
	        return this.currentProvider;
	    };
	    CurrentAuthProvider.prototype.reset = function () {
	        this.currentProvider = null;
	    };
	    return CurrentAuthProvider;
	}());
	angular
	    .module('tribe-authentication', [
	    'website-services',
	    'tribe-alerts',
	    'tribe-services-header-providers'
	])
	    .service('currentAuthProvider', [CurrentAuthProvider])
	    .directive('appLogin', [function () {
	        return {
	            restrict: 'A',
	            scope: true,
	            controller: ['$scope', '$location', '$timeout', 'tribeAuthorizationService', 'systemMessagesService', 'tribeHeaderProviderSelector', 'currentAuthProvider',
	                function ($scope, $location, $timeout, authorization, systemMessagesService, tribeHeaderProviderSelector, currentAuthProvider) {
	                    var me = this;
	                    $scope.loginType = 'oauth';
	                    me.onMessage = function (msgs) {
	                        $scope.messages = msgs;
	                    };
	                    systemMessagesService.addListener(me);
	                    me['disconnectListener'] = function () {
	                        systemMessagesService.removeListener(me);
	                    };
	                    var redirect = function () {
	                        var path = authorization.targetPath;
	                        if (path && path !== "/login") {
	                            // in case we have a saved target url, use it instead of "/"
	                            delete authorization.targetPath;
	                            $location.path(path);
	                        }
	                        else {
	                            // redirect to home
	                            $location.path('/');
	                        }
	                    };
	                    authorization.getOauth2Status().then(function (response) {
	                        $timeout(function () {
	                            $scope.$apply(function () {
	                                $scope.oauth2Status = response.data;
	                            });
	                        });
	                    });
	                    $scope.login = function () {
	                        var headerProvider;
	                        if ($scope.loginType === 'oauth') {
	                            headerProvider = tribeHeaderProviderSelector.select('OAuth2');
	                        }
	                        else {
	                            headerProvider = tribeHeaderProviderSelector.select('Basic');
	                        }
	                        headerProvider.login($scope.username, $scope.password)
	                            .then(function () {
	                            authorization.setCredentials($scope.username, headerProvider.getState());
	                            currentAuthProvider.set(headerProvider);
	                            redirect();
	                        }, function (response) {
	                            if (response && response.data) {
	                                if (response.data.error_description) {
	                                    systemMessagesService.error('Login failed! ' + response.data.error_description);
	                                }
	                                else {
	                                    systemMessagesService.error('The server authentication failed with status ' + response.data.status);
	                                }
	                            }
	                            else {
	                                systemMessagesService.error('Login failed with an unknown reason!');
	                            }
	                        });
	                    };
	                }
	            ],
	            link: function (scope, el, attrs, controller) {
	                el.on('$destroy', function () {
	                    controller['disconnectListener']();
	                });
	            }
	        };
	    }])
	    .directive('appLogout', ['currentAuthProvider', function (currentAuthProvider) {
	        return {
	            restrict: 'A',
	            controller: ['$scope', '$window', '$location', 'tribeAuthorizationService',
	                function ($scope, $window, $location, authorization) {
	                    this['logout'] = function () {
	                        currentAuthProvider.reset();
	                        authorization.clearCredentials();
	                        $location.search({});
	                        $location.path('/login');
	                        $window.location.reload();
	                    };
	                }
	            ],
	            link: function (scope, el, attr, ctlr) {
	                el.on('click', function () {
	                    ctlr['logout']();
	                });
	            }
	        };
	    }])
	    .run(function () {
	    // placeholder
	});


/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var endpoints;
	(function (endpoints_1) {
	    var HistoryCommonController = __webpack_require__(55).controllerApplication;
	    angular.module('tribe-endpoints', [
	        'website-services'
	    ])
	        .directive('appSee', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(56),
	                scope: {
	                    aggregatedId: '='
	                },
	                controller: [
	                    '$timeout', '$scope', 'tribeEndpointsService',
	                    function ($timeout, $scope, srv) {
	                        $scope.$watch('aggregatedId', function () {
	                            if (!$scope['aggregatedId']) {
	                                return;
	                            }
	                            srv.getSeeContent($scope['aggregatedId']).then(function (data) {
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        $scope['see'] = data;
	                                    });
	                                });
	                            });
	                        });
	                    }
	                ]
	            };
	        }])
	        .directive('appApplicationDetails', ['$timeout', '$window', function ($timeout, $window) {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(57),
	                scope: {
	                    app: '=application'
	                },
	                controller: [
	                    '$timeout', '$scope', '$filter', '$location', 'tribeEndpointsService', 'tribeFilterService', 'tribeLinkHeaderService', 'systemMessagesService',
	                    function ($timeout, $scope, $filter, $location, srv, tribeFilterService, tribeLinkHeaderService, systemMessagesService) {
	                        if (!!$scope.app) {
	                            srv.getApplicationDetailsFromName($scope.app).then(function (response) {
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        var data = response.data;
	                                        $scope.swagger = data.swagger;
	                                        $scope.humanReadableName = data.humanReadableName;
	                                        var endpoints = [];
	                                        var links = tribeLinkHeaderService.parseLinkHeader(response['data']['swagger']['x-tribestream-api-registry']['links']);
	                                        $scope.applicationLink = links['self'];
	                                        $scope.applicationsLink = null;
	                                        $scope.historyLink = links['history'];
	                                        $scope.reloadHistory();
	                                        $scope.endpointsLink = links['endpoints'];
	                                        if (data.swagger.paths) {
	                                            for (var pathName in data.swagger.paths) {
	                                                var ops = data.swagger.paths[pathName];
	                                                for (var opname in ops) {
	                                                    if (opname.match('^x-.*')) {
	                                                        continue;
	                                                    }
	                                                    var link = links[opname.toUpperCase() + ' ' + pathName];
	                                                    var endpointId = link.substring(link.lastIndexOf('/') + 1);
	                                                    var operationObject = {
	                                                        path: pathName,
	                                                        operation: opname,
	                                                        summary: ops[opname].summary,
	                                                        description: ops[opname].description,
	                                                        id: endpointId,
	                                                        humanReadablePath: ops[opname]['x-tribestream-api-registry']['human-readable-path']
	                                                    };
	                                                    endpoints.push(operationObject);
	                                                }
	                                            }
	                                        }
	                                        $scope.endpoints = endpoints;
	                                        $scope.categories = data.categories;
	                                        $scope.tags = data.tags;
	                                        $scope.roles = data.roles;
	                                        $scope.applicationName = data.humanReadableName;
	                                    });
	                                });
	                            });
	                            $scope.filterByCategory = function (category) {
	                                tribeFilterService.filterByCategory($scope.details.name, category);
	                            };
	                            $scope.filterByRole = function (role) {
	                                tribeFilterService.filterByRole($scope.details.name, role);
	                            };
	                            $scope.filterByTag = function (tag) {
	                                tribeFilterService.filterByTag($scope.details.name, tag);
	                            };
	                        }
	                        else {
	                            // New application
	                            $scope.applicationLink = null;
	                            $scope.applicationsLink = 'api/application';
	                            $scope.historyLink = null;
	                            $scope.endpointsLink = null;
	                        }
	                        $scope.reloadHistory = function () {
	                            if ($scope.historyLink) {
	                                srv.getHistory($scope.historyLink).then(function (response) {
	                                    var links = tribeLinkHeaderService.parseLinkHeader(response['data']['links']);
	                                    for (var _i = 0, _a = response['data']['items']; _i < _a.length; _i++) {
	                                        var entry = _a[_i];
	                                        entry.link = links[("revision " + entry.revisionId)];
	                                    }
	                                    $timeout(function () { return $scope.$apply(function () { return $scope.history = response['data']['items']; }); });
	                                });
	                            }
	                        };
	                        $scope.save = function () {
	                            if ($scope.applicationLink) {
	                                srv.saveApplication($scope.applicationLink, $scope.swagger).then(function (saveResponse) {
	                                    systemMessagesService.info("Saved application details!");
	                                    $scope.reloadHistory();
	                                });
	                            }
	                            else {
	                                srv.createApplication($scope.applicationsLink, $scope.swagger).then(function (saveResponse) {
	                                    systemMessagesService.info("Created application details!");
	                                    var res = saveResponse.data;
	                                    $location.url("/application/" + res.humanReadableName + "?version=" + res.swagger.info.version);
	                                }, function (errorResponse) {
	                                    if (errorResponse['data'] && errorResponse['data']['key'] === 'duplicated.swagger.exception') {
	                                        systemMessagesService.error("There is an existing application with the same Name and\n                                  Version combination. Please try it again with new data.");
	                                    }
	                                    else {
	                                        systemMessagesService.error("Unable to create application.");
	                                    }
	                                });
	                            }
	                        };
	                        $scope.delete = function () {
	                            srv.delete($scope.applicationLink).then(function (response) {
	                                systemMessagesService.info("Deleted application!");
	                                $location.path("/");
	                            });
	                        };
	                        // Triggered by selecting one revision, will load it and show it
	                        $scope.showHistoricApplication = function (historyItem) {
	                            srv.getHistoricItem(historyItem).then(function (response) {
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        var detailsData = response.data;
	                                        var links = tribeLinkHeaderService.parseLinkHeader(response['data']['swagger']['x-tribestream-api-registry']['links']);
	                                        $scope.historyItem = historyItem;
	                                        $scope.swagger = detailsData.swagger;
	                                        $scope.humanReadableName = detailsData.humanReadableName;
	                                        $scope.endpoints = [];
	                                        var endpoints = $scope.endpoints;
	                                        if (detailsData.swagger.paths) {
	                                            for (var pathName in detailsData.swagger.paths) {
	                                                var ops = detailsData.swagger.paths[pathName];
	                                                for (var opname in ops) {
	                                                    if (opname.match('^x-.*')) {
	                                                        continue;
	                                                    }
	                                                    var operationObject = {
	                                                        path: pathName,
	                                                        operation: opname
	                                                    };
	                                                    endpoints.push(operationObject);
	                                                }
	                                            }
	                                        }
	                                    });
	                                });
	                            });
	                        };
	                    }
	                ],
	                link: function (scope, el) { return $timeout(function () {
	                    scope.$watch('historyLink', function () {
	                        if (!scope['historyLink']) {
	                            return;
	                        }
	                        el.find('div.history').on('click', function () {
	                            var winEl = angular.element($window);
	                            var calculateScroll = function () {
	                                var target = el.find('div[data-app-application-details-history]');
	                                return target.offset().top;
	                            };
	                            winEl.scrollTop(calculateScroll());
	                        });
	                    });
	                }); }
	            };
	        }])
	        .directive('appApplicationDetailsHistory', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(58),
	                scope: true,
	                controller: [
	                    '$scope', 'tribeEndpointsService', 'tribeFilterService', '$timeout', '$filter', '$log', 'systemMessagesService', 'tribeLinkHeaderService', '$q',
	                    HistoryCommonController
	                ]
	            };
	        }])
	        .directive('appEndpoints', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(59),
	                scope: {},
	                controller: [
	                    '$timeout', '$scope', 'tribeEndpointsService',
	                    function ($timeout, $scope, srv) {
	                        srv.list().then(function (data) {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    $scope.total = data.total;
	                                    $scope.endpoints = data.endpoints;
	                                    $scope.applications = data.applications;
	                                    $scope.categories = data.categories;
	                                    $scope.tags = data.tags;
	                                    $scope.roles = data.roles;
	                                });
	                            });
	                        });
	                    }
	                ]
	            };
	        }])
	        .directive('appEndpointsHeader', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(60),
	                scope: {
	                    total: '=',
	                    endpoints: '='
	                }
	            };
	        }])
	        .directive('appEndpointsHeaderCreateBtn', ['$document', '$timeout', function ($document, $timeout) {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(61),
	                scope: {
	                    endpoints: '='
	                },
	                controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                        $scope.$watch('endpoints', function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    $scope.applications = ($scope.endpoints || []).map(function (searchResult) {
	                                        return {
	                                            applicationId: searchResult.application.applicationId,
	                                            applicationName: searchResult.application.applicationName,
	                                            name: searchResult.application.application,
	                                            version: searchResult.application.applicationVersion,
	                                            endpoints: searchResult.endpoints
	                                        };
	                                    });
	                                });
	                            });
	                        });
	                    }],
	                link: function (scope, el) {
	                    var valueDiv = el.find('.button-applications');
	                    var clear = function () {
	                        valueDiv.removeClass('visible');
	                    };
	                    var elWin = angular.element($document);
	                    el.on('click', function () {
	                        if (valueDiv.hasClass('visible')) {
	                            valueDiv.removeClass('visible');
	                            elWin.off('click', clear);
	                        }
	                        else {
	                            valueDiv.addClass('visible');
	                            $timeout(function () { return elWin.one('click', clear); });
	                        }
	                    });
	                    scope.$on('$destroy', function () { return elWin.off('click', clear); });
	                }
	            };
	        }])
	        .directive('appEndpointsListApplication', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(62),
	                scope: {
	                    'application': '='
	                },
	                controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                        $scope.pageSize = 5;
	                        $scope.$watch('application', function () {
	                            if (!$scope['application']) {
	                                return;
	                            }
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    if ($scope['application'].endpoints) {
	                                        $scope.endpoints = $scope['application'].endpoints.slice(0, $scope.pageSize);
	                                        if ($scope.endpoints.length < $scope['application'].endpoints.length) {
	                                            $scope.showAll = true;
	                                        }
	                                    }
	                                    else {
	                                        $scope.endpoints = [];
	                                    }
	                                });
	                            });
	                        });
	                        $scope.showAllEndpoints = function () {
	                            $scope.endpoints = $scope['application'].endpoints;
	                            $scope.showAll = false;
	                        };
	                    }]
	            };
	        }])
	        .directive('appEndpointsList', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(63),
	                scope: {
	                    'total': '=',
	                    'endpoints': '='
	                },
	                controller: ['$timeout', '$scope',
	                    function ($timeout, $scope) {
	                        $scope.$watch('endpoints', function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    $scope.applications = ($scope.endpoints || []).map(function (searchResult) {
	                                        return {
	                                            applicationId: searchResult.application.applicationId,
	                                            applicationName: searchResult.application.applicationName,
	                                            name: searchResult.application.application,
	                                            version: searchResult.application.applicationVersion,
	                                            endpoints: searchResult.endpoints
	                                        };
	                                    });
	                                });
	                            });
	                        });
	                    }
	                ]
	            };
	        }])
	        .directive('appEndpointsListFilterEntries', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(64),
	                scope: {
	                    'key': '@',
	                    'list': '=',
	                    'title': '@'
	                },
	                controller: ['$scope', '$location', '$route',
	                    function ($scope, $location, $route) {
	                        $scope.removeFilter = function (entry) {
	                            var rawQuery = $location.search();
	                            var query = rawQuery[$scope.key];
	                            if (query) {
	                                query = query.split(',');
	                                query = _.filter(query, function (qEntry) {
	                                    return qEntry !== entry;
	                                });
	                                if (query.length) {
	                                    rawQuery[$scope.key] = query.join(',');
	                                }
	                                else {
	                                    delete rawQuery[$scope.key];
	                                }
	                                $location.search(rawQuery);
	                                $route.reload();
	                            }
	                        };
	                    }
	                ]
	            };
	        }])
	        .directive('appEndpointsFilterBubble', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(65),
	                scope: {
	                    'name': '=',
	                    'length': '=',
	                    'qfield': '='
	                },
	                controller: ['$location', '$route', '$scope', function ($location, $route, $scope) {
	                        this['updateQuery'] = function () {
	                            var values = $location.search();
	                            var currentQuery = [];
	                            if (values[$scope.qfield]) {
	                                currentQuery = values[$scope.qfield].split(',');
	                            }
	                            currentQuery.push($scope['name']);
	                            values[$scope.qfield] = _.uniq(currentQuery).join(',');
	                            $location.search(values);
	                            $route.reload();
	                        };
	                    }],
	                link: function (scope, el, attrs, controller) {
	                    el.on('click', function () {
	                        controller['updateQuery']();
	                    });
	                }
	            };
	        }])
	        .directive('appEndpointsFilter', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(66),
	                scope: {
	                    'title': '@',
	                    'list': '=',
	                    'qfield': '@'
	                }
	            };
	        }])
	        .directive('appEndpointsQueryInput', ['$timeout', function ($timeout) {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(67),
	                scope: {},
	                controller: [
	                    '$scope', '$location', '$route',
	                    function ($scope, $location, $route) {
	                        var currentQuery = $location.search().q;
	                        if (currentQuery) {
	                            $scope.value = currentQuery;
	                        }
	                        else {
	                            $scope.value = '';
	                        }
	                        this['updateQuery'] = function () {
	                            var values = $location.search();
	                            values.q = $scope.value.trim();
	                            if (values.q === '') {
	                                delete values.q;
	                            }
	                            $location.search(values);
	                            $route.reload();
	                        };
	                        this['clearQuery'] = function () {
	                            $scope.value = '';
	                            this['updateQuery']();
	                        };
	                        $scope['updateQuery'] = this['updateQuery'];
	                        $scope['clearQuery'] = this['clearQuery'];
	                    }
	                ],
	                link: function (scope, el, attrs, controller) {
	                    var keymap = {
	                        enter: 13,
	                        escape: 27
	                    };
	                    var update = function (event) {
	                        controller['updateQuery']();
	                        event.preventDefault();
	                    };
	                    var clear = function (event) {
	                        controller['clearQuery']();
	                        event.preventDefault();
	                    };
	                    el.find('input').bind("keydown keypress", function (event) {
	                        if (event.which === keymap["enter"]) {
	                            update(event);
	                        }
	                        else if (event.which === keymap["escape"]) {
	                            clear(event);
	                        }
	                    });
	                    $timeout(function () {
	                        el.find('input').focus();
	                    });
	                }
	            };
	        }])
	        .directive('appEndpointsSelectedFilter', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(68),
	                scope: {},
	                controller: ['$timeout', '$location', '$scope', function ($timeout, $location, $scope) {
	                        var params = $location.search();
	                        $timeout(function () {
	                            $scope.$apply(function () {
	                                $scope.choose = "";
	                                if (params.a) {
	                                    $scope.selectedApps = params.a.split(',');
	                                    if ($scope.choose.length > 0)
	                                        $scope.choose += ", ";
	                                    $scope.choose += "applications";
	                                }
	                                if (params.c) {
	                                    $scope.selectedCategories = params.c.split(',');
	                                    if ($scope.choose.length > 0)
	                                        $scope.choose += ", ";
	                                    $scope.choose += "categories";
	                                }
	                                if (params.t) {
	                                    $scope.selectedTags = params.t.split(',');
	                                    if ($scope.choose.length > 0)
	                                        $scope.choose += ", ";
	                                    $scope.choose += "tags";
	                                }
	                                if (params.r) {
	                                    $scope.selectedRoles = params.r.split(',');
	                                    if ($scope.choose.length > 0)
	                                        $scope.choose += ", ";
	                                    $scope.choose += "roles";
	                                }
	                            });
	                        });
	                    }]
	            };
	        }])
	        .run(function () {
	        // placeholder
	    });
	})(endpoints || (endpoints = {}));


/***/ },
/* 55 */
/***/ function(module, exports) {

	"use strict";
	var controller = function ($scope, srv, // this is tribeEndpointsService
	    tribeFilterService, // this is tribeFilterService
	    $timeout, $filter, $log, systemMessagesService, // this is systemMessagesService
	    tribeLinkHeaderService, // this is tribeLinkHeaderService
	    $q, savefunction) {
	    $scope.selected = [];
	    $scope.showDiff = false;
	    $scope.onHistorySelect = function (item) {
	        $scope.showDiff = false;
	        $scope.mergeWidget = undefined;
	        if (item.$ui && item.$ui.selected) {
	            $scope.selected.push(item);
	        }
	        else {
	            $scope.selected = $scope.selected.filter(function (i) { return i != item; });
	        }
	    };
	    $scope.saveMerge = function () {
	        // update new operation with the json content
	        $scope.ref.operation = JSON.parse($scope['valueA']);
	        savefunction();
	    };
	    $scope.doDiff = function () {
	        $scope.showDiff = !$scope.showDiff;
	        if ($scope.showDiff) {
	            $q.all($scope.selected.map(function (item) { return srv.getHistoricItem(item).promise(); }))
	                .then(function (results) {
	                $scope.ref = results[0]['data'];
	                $timeout(function () { return $scope.$apply(function () {
	                    $scope['valueA'] = JSON.stringify(JSON.parse(JSON.stringify(results[0]['data'])), undefined, 2);
	                    $scope['titleA'] = "Rev " + $scope.selected[0]['revisionId'] + " - " + $filter('date')($scope.selected[0]['timestamp'], 'medium');
	                    $scope['valueB'] = JSON.stringify(JSON.parse(JSON.stringify(results[1]['data'])), undefined, 2);
	                    $scope['titleB'] = "Rev " + $scope.selected[1]['revisionId'] + " - " + $filter('date')($scope.selected[1]['timestamp'], 'medium');
	                }); });
	            });
	        }
	    };
	};
	exports.controllerEndpoint = function ($scope, srv, tribeFilterService, $timeout, $filter, $log, systemMessagesService, tribeLinkHeaderService, $q) {
	    var savefunction = function () {
	        srv.saveEndpoint($scope.endpointLink, {
	            // Cannot simply send the endpoint object because it's polluted with errors and expectedValues
	            httpMethod: $scope.ref.httpMethod,
	            path: $scope.ref.path,
	            operation: $scope.ref.operation
	        }).then(function (saveResponse) {
	            $scope.updateEndpoint(saveResponse.data);
	            systemMessagesService.info("Saved details! " + saveResponse.status);
	        });
	    };
	    controller.apply({}, [$scope, srv, tribeFilterService, $timeout, $filter, $log, systemMessagesService, tribeLinkHeaderService, $q, savefunction]);
	};
	exports.controllerApplication = function ($scope, srv, tribeFilterService, $timeout, $filter, $log, systemMessagesService, tribeLinkHeaderService, $q) {
	    var savefunction = function () {
	        var historic = JSON.parse($scope['valueA']);
	        $scope.swagger.info.title = historic['swagger'].info.title;
	        $scope.swagger.info.version = historic['swagger'].info.version;
	        $scope.swagger.info.description = historic['swagger'].info.description;
	        srv.saveApplication($scope.applicationLink, $scope.swagger).then(function (saveResponse) {
	            systemMessagesService.info("Saved details! " + saveResponse.status);
	        });
	    };
	    controller.apply({}, [$scope, srv, tribeFilterService, $timeout, $filter, $log, systemMessagesService, tribeLinkHeaderService, $q, savefunction]);
	};


/***/ },
/* 56 */
/***/ function(module, exports) {

	module.exports = "<article><h1>{{see.title}}</h1><div x-ng-bind-html=\"see.content | tribeHtml\"></div></article>";

/***/ },
/* 57 */
/***/ function(module, exports) {

	module.exports = "<div><div><div class=\"header\"><div class=\"breadcrumb\"><a href=\".\"><i class=\"fa fa-home\"></i></a><i class=\"fa fa-chevron-right\"></i><a x-ng-if=\"applicationLink\" x-ng-href=\"application/{{applicationName}}?version={{swagger.info.version}}\">{{swagger.info.title}} {{swagger.info.version}}</a><i class=\"fa fa-chevron-right\"></i><span x-ng-if=\"historyItem\">Revision {{historyItem.revisionId}} by {{historyItem.username}} created on {{historyItem.timestamp | date:'medium'}}</span></div><div class=\"buttons\"><div class=\"save\" x-ng-disabled=\"!swagger.info.title || !swagger.info.version\" x-ng-click=\"!swagger.info.title || !swagger.info.version || save()\"><i class=\"fa fa-floppy-o\"></i><span>Save</span></div><div class=\"create-endpoint\" x-ng-if=\"endpointsLink\"><i class=\"fa fa-plus\"></i><a x-ng-href=\"endpoint/{{humanReadableName}}\"><span>Create Endpoint</span></a></div><div class=\"history\" x-ng-if=\"historyLink\"><i class=\"fa fa-history\"></i><span>Show History</span></div><div class=\"delete\" data-tribe-confirm-btn=\"data-tribe-confirm-btn\" data-callback=\"delete\" data-icon=\"trash\" data-message=\"Are you sure you want to delete this application?\" x-ng-if=\"applicationLink\" data-label=\"Delete Application\"></div></div></div><article class=\"content\"><div><h1><div data-tribe-text=\"data-tribe-text\" data-value=\"swagger.info.title\" data-placeholder=\"Application Name\" data-mandatory=\"true\"></div><div data-tribe-text=\"data-tribe-text\" data-value=\"swagger.info.version\" data-placeholder=\"Version\" data-mandatory=\"true\"></div></h1><div data-tribe-markdown=\"data-tribe-markdown\" data-value=\"swagger.info.description\" data-placeholder=\"Description\"></div><div class=\"see\" x-ng-if=\"details.sees.length\"><span>See:</span><div><p x-ng-repeat=\"see in details.sees | orderBy:['seeOrder', 'title']\"><a x-ng-if=\"see.href\" x-ng-href=\"{{see.href}}\" x-ng-bind-html=\"(see.title | tribeHtml) || (see.href | tribeHtml)\"></a><a x-ng-if=\"!see.href\" x-ng-href=\"see/{{ see.aggregatedId }}\" x-ng-bind-html=\"(see.title | tribeHtml) || (see.href | tribeHtml)\"></a></p></div></div></div><div><h2>Resource Information</h2><div><h3>Endpoints</h3><ul class=\"endpoint-info\"><li x-ng-repeat=\"endpoint in endpoints\"><a x-ng-href=\"endpoint/{{applicationName}}/{{endpoint.operation}}{{endpoint.path | pathencode}}?version={{swagger.info.version}}\"><span>{{endpoint.operation}}</span><span>{{endpoint.path}}</span><span>{{endpoint.summary}}</span></a></li></ul></div></div><div data-app-application-details-history=\"data-app-application-details-history\"></div></article></div><div data-app-footer=\"data-app-footer\"></div></div>";

/***/ },
/* 58 */
/***/ function(module, exports) {

	module.exports = "<div x-ng-if=\"historyLink\"><h2>History</h2><table><thead><tr><th>&nbsp;</th><th>Revision</th><th>Timestamp</th><th>Username</th><th></th></tr></thead><tbody><tr x-ng-repeat=\"historyItem in history\"><td><i data-tribe-checkbox=\"data-tribe-checkbox\" data-value=\"historyItem.$ui.selected\" data-change=\"onHistorySelect(historyItem)\"></i></td><td><span>{{historyItem.revisionId}}</span></td><td><span>{{historyItem.timestamp | date:'medium'}}</span></td><td><span>{{historyItem.username}}</span></td><td><i class=\"fa fa-history\" x-ng-click=\"showHistoricApplication(historyItem)\"></i></td></tr></tbody></table><button x-ng-click=\"doDiff()\" ng-disabled=\"selected.length !== 2 || showDiff\">Show Difference</button><div data-tribe-diff=\"data-tribe-diff\" x-ng-show=\"showDiff &amp;&amp; selected.length == 2\" data-value-a=\"valueA\" data-value-b=\"valueB\" data-title-a=\"titleA\" data-title-b=\"titleB\"></div><button x-ng-click=\"doDiff()\" x-ng-show=\"showDiff\">Hide Diff</button><button x-ng-click=\"saveMerge()\" x-ng-show=\"showDiff\">Save left pane as endpoint</button></div>";

/***/ },
/* 59 */
/***/ function(module, exports) {

	module.exports = "<div><div data-app-endpoints-header=\"data-app-endpoints-header\" data-endpoints=\"endpoints\" data-total=\"total\"></div><div class=\"body\"><div class=\"list\"><div></div><div data-app-endpoints-list=\"data-app-endpoints-list\" data-endpoints=\"endpoints\" data-total=\"total\"></div></div><div class=\"filters\"><div data-app-endpoints-selected-filter=\"data-app-endpoints-selected-filter\"></div><div data-app-endpoints-filter=\"data-app-endpoints-filter\" data-title=\"Categories\" data-list=\"categories\" data-qfield=\"c\"></div><div data-app-endpoints-filter=\"data-app-endpoints-filter\" data-title=\"Tags\" data-list=\"tags\" data-qfield=\"t\"></div><div data-app-endpoints-filter=\"data-app-endpoints-filter\" data-title=\"Roles\" data-list=\"roles\" data-qfield=\"r\"></div></div></div><div data-app-footer=\"data-app-footer\"></div></div>";

/***/ },
/* 60 */
/***/ function(module, exports) {

	module.exports = "<div><h1><div class=\"img\"></div><span>Services found</span><span>({{total}})</span></h1><div data-app-endpoints-query-input=\"data-app-endpoints-query-input\"></div><div data-app-endpoints-header-create-btn=\"data-app-endpoints-header-create-btn\" data-endpoints=\"endpoints\"></div></div>";

/***/ },
/* 61 */
/***/ function(module, exports) {

	module.exports = "<div><div><div><i class=\"fa fa-file-text\"></i><a x-ng-href=\"application\"><span>Create Application</span></a></div></div><div class=\"create-endpoint-btn\"><div><i class=\"fa fa-plus-square\"></i><span>Create Endpoint</span><i class=\"fa fa-caret-down\"></i></div><div class=\"button-applications\"><ul><li x-ng-repeat=\"app in applications | orderBy:'text'\"><a x-ng-href=\"endpoint/{{app.applicationName}}\">{{app.name}}</a></li></ul></div></div></div>";

/***/ },
/* 62 */
/***/ function(module, exports) {

	module.exports = "<div><h2><a x-ng-href=\"application/{{application.applicationName}}?version={{application.version}}\">{{application.name}} {{application.version}}</a><span>({{application.endpoints.length}})</span></h2><div x-ng-repeat=\"endpoint in application.endpoints\"><h3><i class=\"fa\" x-ng-class=\"{'fa-lock': endpoint.secured, 'fa-unlock': !endpoint.secured}\"></i><a x-ng-href=\"endpoint/{{application.applicationName}}/{{endpoint.httpMethod}}{{endpoint.path| pathencode}}?version={{endpoint.applicationVersion}}\">{{endpoint.httpMethod | uppercase}} {{endpoint.path}}</a><span>{{endpoint.description | tribeHtmlText}}</span></h3></div><div x-ng-if=\"showAll\"><span x-ng-click=\"showAllEndpoints();\">Show more {{application.endpoints.length - pageSize}} endpoints</span></div></div>";

/***/ },
/* 63 */
/***/ function(module, exports) {

	module.exports = "<div><div data-app-endpoints-list-application=\"data-app-endpoints-list-application\" x-ng-repeat=\"application in applications\" data-application=\"application\"></div></div>";

/***/ },
/* 64 */
/***/ function(module, exports) {

	module.exports = "<div x-ng-if=\"list\"><div x-ng-repeat=\"entry in list\" x-ng-click=\"removeFilter(entry)\" title=\"Click to remove filter\"><div><span>{{entry}}</span><i class=\"fa fa-times\"></i></div></div></div>";

/***/ },
/* 65 */
/***/ function(module, exports) {

	module.exports = "<div title=\"Click to add filter\"><div><span>{{name}}</span><span>({{length}})</span></div></div>";

/***/ },
/* 66 */
/***/ function(module, exports) {

	module.exports = "<div x-ng-show=\"list.length\"><h3><span>{{title}}</span><span>({{list.length}})</span></h3><div></div><div><i data-app-endpoints-filter-bubble=\"data-app-endpoints-filter-bubble\" x-ng-repeat=\"entry in list\" data-name=\"entry.text\" data-length=\"entry.weight\" data-qfield=\"qfield\"></i></div></div>";

/***/ },
/* 67 */
/***/ function(module, exports) {

	module.exports = "<div><input type=\"text\" placeholder=\"Query services...\" x-ng-model=\"value\" autofocus=\"autofocus\"/><button x-ng-click=\"updateQuery();\"><div><i class=\"fa fa-search\"></i></div></button></div>";

/***/ },
/* 68 */
/***/ function(module, exports) {

	module.exports = "<div x-ng-if=\"selectedApps.length || selectedCategories.length || selectedTags.length || selectedRoles.length\"><h1><i class=\"fa fa-tag\"></i><span>Selected {{choose}}</span><span>({{selectedApps.length + selectedCategories.length + selectedTags.length + selectedRoles.length}})</span></h1><div data-app-endpoints-list-filter-entries=\"data-app-endpoints-list-filter-entries\" data-title=\"Applications\" data-list=\"selectedApps\" data-key=\"a\"></div><div data-app-endpoints-list-filter-entries=\"data-app-endpoints-list-filter-entries\" data-title=\"Categories\" data-list=\"selectedCategories\" data-key=\"c\"></div><div data-app-endpoints-list-filter-entries=\"data-app-endpoints-list-filter-entries\" data-title=\"Tags\" data-list=\"selectedTags\" data-key=\"t\"></div><div data-app-endpoints-list-filter-entries=\"data-app-endpoints-list-filter-entries\" data-title=\"Roles\" data-list=\"selectedRoles\" data-key=\"r\"></div><div></div></div>";

/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var endpointdetails;
	(function (endpointdetails) {
	    var HistoryCommonController = __webpack_require__(55).controllerEndpoint;
	    angular.module('tribe-endpoints-details', [
	        'website-services',
	        'website-services-endpoints'
	    ])
	        .factory('appEndpointsDetailsHeaderService', [function ($location) {
	            return {
	                getBaseUrl: function (swagger) {
	                    var basePath = swagger.basePath === '/' ? '' : swagger.basePath;
	                    return swagger.host + basePath;
	                }
	            };
	        }])
	        .directive('appEndpointsDetailsHeader', ['$window', '$timeout', '$filter', function ($window, $timeout, $filter) {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(70),
	                scope: true,
	                controller: ['$scope', '$timeout', 'appEndpointsDetailsHeaderService', function ($scope, $timeout, srv) {
	                        $scope.regex = '^(\\/|(\\/{_*\\-*[a-zA-Z0-9_-]{1,}}|\\/_*\\-*[a-zA-Z0-9_-]{1,})*)$';
	                        $scope.regexTip = "\n                    <div class=\"endpoint-details-path-tip\">\n                        <p>To be considered valid, the path should follow these rules:</p>\n                        <ul>\n                            <li>Starts with a single \"&#47;\" </li>\n                            <li>Contains only alphanumeric, \"&#47;\", \"{\", \"}\", \"-\" and \"_\" characters </li>\n                            <li>Does not end with \"&#47;\" </li>\n                            <li>Does not contain multiple \"&#47;\" characters in a row. </li>\n                        </ul>\n                    </div>\n                ";
	                        $scope.toUppercase = function (item) {
	                            if (!item) {
	                                return null;
	                            }
	                            if (item.text) {
	                                return item.text.toUpperCase();
	                            }
	                            return item.toUpperCase();
	                        };
	                        $scope.$watch('application', function () {
	                            // Compute endpoint URL
	                            if ($scope.application && $scope.application.swagger && $scope.application.swagger.host && $scope.application.swagger.basePath) {
	                                $scope.$watch('endpoint.path', function () {
	                                    if ($scope['endpoint'] && $scope['endpoint'].path) {
	                                        $scope.resourceUrl = srv.getBaseUrl($scope.application.swagger, $scope['endpoint'].path) + $scope['endpoint'].path;
	                                    }
	                                });
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        if (!!$scope.endpoint.operation.schemes && $scope.endpoint.operation.schemes[0]) {
	                                            $scope.endpoint.endpointProtocol = $scope.endpoint.operation.schemes[0];
	                                        }
	                                        else if ($scope.application && $scope.application.swagger && $scope.application.swagger.schemes) {
	                                            $scope.endpoint.endpointProtocol = $scope.application.swagger.schemes[0];
	                                        }
	                                        else {
	                                            $scope.endpoint.endpointProtocol = 'http';
	                                        }
	                                        $scope.resourceUrl = srv.getBaseUrl($scope.application.swagger, $scope['endpoint'].path) + $scope['endpoint'].path;
	                                    });
	                                });
	                            }
	                        });
	                    }],
	                link: function (scope, el) {
	                    scope.$on('$destroy', function () { return el.remove(); });
	                }
	            };
	        }])
	        .factory('tribeEndpointDetailsTocService', [
	        function () {
	            var data = {
	                selectedAnchor: null,
	                anchors: []
	            };
	            return {
	                getData: function () {
	                    return data;
	                },
	                setAnchor: function (title, isSubmenu, el) {
	                    data.anchors.push({
	                        title: title,
	                        submenu: isSubmenu,
	                        el: el
	                    });
	                },
	                clearAnchors: function () {
	                    data.anchors = [];
	                }
	            };
	        }
	    ])
	        .directive('appEndpointsDetailsToc', ['tribeEndpointDetailsTocService', '$window', function (srv, $window) {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(71),
	                scope: {},
	                controller: ['tribeEndpointDetailsTocService', '$scope', '$document', function (srv, $scope, $document) {
	                        $scope.anchors = srv.getData().anchors;
	                        $scope.getIndex = function (anchor) {
	                            var tags = $document.find('article.app-ep-details-body *[app-endpoints-details-toc-anchor]');
	                            return tags.index(anchor.el);
	                        };
	                        this['clearAnchors'] = function () {
	                            srv['clearAnchors']();
	                        };
	                    }],
	                link: function (scope, el, attrs, controller) {
	                    el.find('div.collapse-icon').on('click', function () {
	                        el.toggleClass('collapsed');
	                    });
	                    el.find('li[data-app-endpoints-details-toc-item]').on('click', function () {
	                        el.removeClass('collapsed');
	                    });
	                    scope.$on('$destroy', function () {
	                        controller['clearAnchors']();
	                    });
	                }
	            };
	        }])
	        .directive('appEndpointsDetailsTocItem', ['$timeout', '$window', function ($timeout, $window) {
	            return {
	                restrict: 'A',
	                scope: {
	                    anchor: '=appEndpointsDetailsTocItem'
	                },
	                template: __webpack_require__(72),
	                controller: ['$scope', 'tribeEndpointDetailsTocService', function ($scope, srv) {
	                        $scope.tocData = srv.getData();
	                        this['selectMe'] = function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    $scope.tocData.selectedAnchor = $scope.anchor;
	                                });
	                            });
	                        };
	                    }],
	                link: function (scope, el, attrs, controller) {
	                    el.on('click', function () {
	                        controller['selectMe']();
	                        var winEl = angular.element('div[data-app-endpoints-details] > div');
	                        var calculateScroll = function () {
	                            var target = scope['anchor'].el;
	                            var elOffset = target.offset().top;
	                            var elHeight = target.height();
	                            var windowHeight = $(window).height();
	                            if (elHeight < windowHeight) {
	                                return elOffset - ((windowHeight / 2) - (elHeight / 2));
	                            }
	                            else {
	                                return elOffset;
	                            }
	                        };
	                        winEl.animate({
	                            scrollTop: calculateScroll()
	                        }, function () {
	                            scope['anchor'].el.focus();
	                            if (scope['anchor'].el.is(':focus')) {
	                                return;
	                            }
	                            scope['anchor'].el.find('*').each(function (kidindex, rawKid) {
	                                var kid = angular.element(rawKid);
	                                kid.focus();
	                                if (kid.is(':focus')) {
	                                    return false;
	                                }
	                            });
	                        });
	                    });
	                    scope.$watch('tocData.selectedAnchor', function () {
	                        var selected = scope.$eval('tocData.selectedAnchor');
	                        if (selected && selected === scope['anchor']) {
	                            el.find('h4').addClass('selected');
	                        }
	                        else {
	                            el.find('h4').removeClass('selected');
	                        }
	                    });
	                }
	            };
	        }])
	        .directive('appEndpointsDetailsTocAnchor', ['$timeout', function ($timeout) {
	            return {
	                restrict: 'A',
	                scope: {
	                    title: '@appEndpointsDetailsTocAnchor',
	                    submenu: '@'
	                },
	                controller: ['tribeEndpointDetailsTocService', '$scope', function (srv, $scope) {
	                        $scope.data = srv.getData();
	                        this['registerAnchor'] = function (el) {
	                            srv.setAnchor($scope.title, $scope.submenu, el);
	                        };
	                        this['setSelectedAnchor'] = function (el) {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    var anchors = $scope.data.anchors;
	                                    $scope['data'].selectedAnchor = anchors.find(function (item) {
	                                        return item.el === el;
	                                    });
	                                });
	                            });
	                        };
	                    }],
	                link: function (scope, el, attrs, controller) {
	                    $timeout(function () {
	                        controller['registerAnchor'](el);
	                        var callback = function () {
	                            controller['setSelectedAnchor'](el);
	                        };
	                        el.find('*').on('focus', callback);
	                        el.find('*').on('click', callback);
	                    });
	                }
	            };
	        }])
	        .directive('appEndpointsDetailsParameters', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(73),
	                scope: true,
	                controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                        $scope.$watch('endpoint.uri.path', function () {
	                            var path = $scope.$eval('endpoint.uri.path');
	                            if (!path) {
	                                return;
	                            }
	                            var params = path.match(/:[a-zA-Z0-9_]+/g);
	                            if (params) {
	                                params = _.map(params, function (value) {
	                                    return value.substring(1);
	                                });
	                            }
	                            if (!params) {
	                                params = [];
	                            }
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    $scope.pathParams = params;
	                                });
	                            });
	                        });
	                        $scope.removeParam = function (p) { return $timeout(function () { return $scope.$apply(function () {
	                            $scope['endpoint'].operation.parameters = _.without($scope['endpoint'].operation.parameters, p);
	                        }); }); };
	                        $scope.addParam = function () {
	                            var params = $scope.$eval('endpoint.operation.parameters');
	                            if (!params) {
	                                if (!$scope['endpoint'].operation) {
	                                    $scope['endpoint'].operation = {};
	                                }
	                                $scope['endpoint'].operation.parameters = [];
	                                params = $scope['endpoint'].operation.parameters;
	                            }
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    // add empry object
	                                    params.unshift({});
	                                    $scope.params = params;
	                                });
	                            });
	                        };
	                    }]
	            };
	        }])
	        .directive('appEndpointsDetailsResourceInformation', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(74),
	                scope: true,
	                controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                        $scope.requestFormatsOptions = [
	                            'text/plain', 'application/json', 'application/xml'
	                        ];
	                        $scope.responseFormatsOptions = [
	                            'text/plain', 'application/json', 'application/xml'
	                        ];
	                        $scope.statusOptions = ['In Design', 'In Development', 'Released', 'Deprecated', 'Deferred'];
	                        $scope.rateUnits = ['SECONDS', 'MINUTES', 'HOURS', 'DAYS'];
	                        $scope.$watch('endpoint', function () {
	                            if (!$scope['endpoint'] || !$scope['endpoint'].operation) {
	                                return;
	                            }
	                            $scope.addRate = function () {
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        if (!$scope['endpoint'].operation) {
	                                            return;
	                                        }
	                                        if (!$scope['endpoint'].operation['x-tribestream-api-registry']) {
	                                            $scope['endpoint'].operation['x-tribestream-api-registry'] = {};
	                                        }
	                                        if (!$scope['endpoint'].operation['x-tribestream-api-registry']['rates']) {
	                                            $scope['endpoint'].operation['x-tribestream-api-registry']['rates'] = [];
	                                        }
	                                        $scope['endpoint'].operation['x-tribestream-api-registry']['rates'].push({});
	                                    });
	                                });
	                            };
	                            $scope.removeRate = function (rate) {
	                                $timeout(function () {
	                                    $scope.$apply(function () {
	                                        if (!$scope['endpoint'].operation) {
	                                            return;
	                                        }
	                                        if (!$scope['endpoint'].operation['x-tribestream-api-registry']) {
	                                            return;
	                                        }
	                                        if (!$scope['endpoint'].operation['x-tribestream-api-registry']['rates']) {
	                                            return;
	                                        }
	                                        $scope['endpoint'].operation['x-tribestream-api-registry']['rates'] = _.without($scope['endpoint'].operation['x-tribestream-api-registry']['rates'], rate);
	                                    });
	                                });
	                            };
	                        });
	                        // set as empty list in case list is undefined
	                        var initList = function (path, name) {
	                            $scope.$watch(path, function () {
	                                var xapi = $scope.$eval(path);
	                                if (!xapi) {
	                                    return;
	                                }
	                                if (!xapi[name]) {
	                                    xapi[name] = [];
	                                }
	                            });
	                        };
	                        initList("endpoint.operation['x-tribestream-api-registry']", 'roles');
	                        initList("endpoint.operation['x-tribestream-api-registry']", 'categories');
	                        initList("endpoint.operation", 'tags');
	                    }],
	                link: function (scope, el) {
	                    scope.$on('$destroy', function () { return el.remove(); });
	                }
	            };
	        }])
	        .directive('appEndpointsDetailsResponseRequest', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(75),
	                scope: true,
	                controller: ['$scope', '$timeout', function ($scope, $timeout) {
	                        $scope.$watch('endpoint.operation', function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    // TODO: This MUST go somewhere else, both properties
	                                    if (!$scope['endpoint'].operation) {
	                                        $scope['endpoint'].operation = {};
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']) {
	                                        $scope['endpoint'].operation['x-tribestream-api-registry'] = {};
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']['response-codes']) {
	                                        $scope['endpoint'].operation['x-tribestream-api-registry']['response-codes'] = [];
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']['expected-values']) {
	                                        $scope['endpoint'].operation['x-tribestream-api-registry']['expected-values'] = [];
	                                    }
	                                });
	                            });
	                        });
	                        $scope.removeErrorCode = function (code) {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    if (!$scope['endpoint'].operation) {
	                                        return;
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']) {
	                                        return;
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']['response-codes']) {
	                                        return;
	                                    }
	                                    $scope['endpoint'].operation['x-tribestream-api-registry']['response-codes'] = _.without($scope['endpoint'].operation['x-tribestream-api-registry']['response-codes'], code);
	                                });
	                            });
	                        };
	                        $scope.addErrorCode = function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    if (!$scope['endpoint'].operation) {
	                                        $scope['endpoint'].operation = {};
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']) {
	                                        $scope['endpoint'].operation['x-tribestream-api-registry'] = {};
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']['response-codes']) {
	                                        $scope['endpoint'].operation['x-tribestream-api-registry']['response-codes'] = [];
	                                    }
	                                    $scope['endpoint'].operation['x-tribestream-api-registry']['response-codes'].push({
	                                        http_status: 0,
	                                        error_code: 0,
	                                        message: '',
	                                        description: ''
	                                    });
	                                });
	                            });
	                        };
	                        $scope.removeExpectedValue = function (value) {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    if (!$scope['endpoint'].operation) {
	                                        return;
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']) {
	                                        return;
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']['expected-values']) {
	                                        return;
	                                    }
	                                    $scope['endpoint'].operation['x-tribestream-api-registry']['expected-values'] = _.without($scope['endpoint'].operation['x-tribestream-api-registry']['expected-values'], value);
	                                });
	                            });
	                        };
	                        $scope.addExpectedValue = function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    if (!$scope['endpoint'].operation) {
	                                        $scope['endpoint'].operation = {};
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']) {
	                                        $scope['endpoint'].operation['x-tribestream-api-registry'] = {};
	                                    }
	                                    if (!$scope['endpoint'].operation['x-tribestream-api-registry']['expected-values']) {
	                                        $scope['endpoint'].operation['x-tribestream-api-registry']['expected-values'] = [];
	                                    }
	                                    $scope['endpoint'].operation['x-tribestream-api-registry']['expected-values'].push({
	                                        name: '',
	                                        values: ''
	                                    });
	                                });
	                            });
	                        };
	                    }],
	                link: function (scope, el) {
	                    scope.$on('$destroy', function () { return el.remove(); });
	                }
	            };
	        }])
	        .directive('appEndpointsDetailsSee', ['$timeout', function ($timeout) {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(76),
	                scope: {
	                    'endpoint': '=',
	                    'onEditModeOn': '&',
	                    'onEditModeOff': '&'
	                },
	                controller: ['$scope', function ($scope) {
	                        this['addLink'] = function () {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    $scope['endpoint'].operation['x-tribestream-api-registry'] = $scope['endpoint'].operation['x-tribestream-api-registry'] || {};
	                                    $scope['endpoint'].operation['x-tribestream-api-registry'].sees = $scope['endpoint'].operation['x-tribestream-api-registry'].sees || [];
	                                    $scope['endpoint'].operation['x-tribestream-api-registry'].sees.push({});
	                                });
	                            });
	                        };
	                        $scope.removeLink = function (link) {
	                            $timeout(function () {
	                                $scope.$apply(function () {
	                                    if (!$scope['endpoint'].operation
	                                        || !$scope['endpoint'].operation['x-tribestream-api-registry']
	                                        || !$scope['endpoint'].operation['x-tribestream-api-registry'].sees) {
	                                        return;
	                                    }
	                                    $scope['endpoint'].operation['x-tribestream-api-registry'].sees = _.without($scope['endpoint'].operation['x-tribestream-api-registry'].sees, link);
	                                });
	                            });
	                        };
	                    }],
	                link: function (scope, el, attrs, controller) {
	                    el.find('div.add-link').on('click', function () {
	                        controller['addLink']();
	                        $timeout(function () {
	                            var newItem = el.find('i[data-tribe-editable-text] > div').last();
	                            newItem.focus();
	                        }, 500); // TODO: please find a better way to do this after the meeting.
	                    });
	                }
	            };
	        }])
	        .directive('appEndpointsDetailsHistory', [function () {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(77),
	                scope: true,
	                controller: [
	                    '$scope', 'tribeEndpointsService', 'tribeFilterService', '$timeout', '$filter', '$log', 'systemMessagesService', 'tribeLinkHeaderService', '$q',
	                    HistoryCommonController
	                ]
	            };
	        }])
	        .directive('appEndpointsDetails', ['$window', '$timeout', function ($window, $timeout) {
	            return {
	                restrict: 'A',
	                template: __webpack_require__(78),
	                scope: {
	                    'requestMetadata': '='
	                },
	                controller: [
	                    '$scope', 'tribeEndpointsService', 'tribeFilterService', '$timeout', '$filter', '$log', '$location', '$route', 'systemMessagesService', 'tribeLinkHeaderService',
	                    function ($scope, srv, tribeFilterService, $timeout, $filter, $log, $location, $route, systemMessagesService, tribeLinkHeaderService) {
	                        $scope['onEditCount'] = {};
	                        $scope['onEditModeOn'] = function (uniqueId) { return $timeout(function () { return $scope.$apply(function () {
	                            $scope['onEditCount'][uniqueId] = {};
	                            $scope['isOnEdit'] = true;
	                            $log.info("New field on edit mode. " + uniqueId);
	                            $log.info($scope['onEditCount']);
	                        }); }); };
	                        $scope['onEditModeOff'] = function (uniqueId) { return $timeout(function () { return $scope.$apply(function () {
	                            delete $scope['onEditCount'][uniqueId];
	                            $scope['isOnEdit'] = !_.isEmpty($scope['onEditCount']);
	                            $log.info("Field out of edit mode. " + uniqueId + " -> onEditMode: " + $scope['isOnEdit']);
	                            $log.info($scope['onEditCount']);
	                        }); }); };
	                        $scope.updateEndpoint = function (e) { return $scope.endpoint = e; };
	                        $timeout(function () {
	                            $scope.$apply(function () {
	                                $scope.history = null;
	                                $scope['endpoint'] = {
	                                    httpMethod: "",
	                                    path: "",
	                                    operation: {}
	                                };
	                            });
	                        }).then(function () {
	                            if ($scope.requestMetadata.endpointPath) {
	                                srv.getDetailsFromMetadata($scope.requestMetadata)
	                                    .then(function (detailsResponse) {
	                                    $scope['applicationId'] = detailsResponse['data']['applicationId'];
	                                    $scope['endpointId'] = detailsResponse['data']['endpointId'];
	                                    if (detailsResponse['data']) {
	                                        var links = tribeLinkHeaderService.parseLinkHeader(detailsResponse['data']['operation']['x-tribestream-api-registry']['links']);
	                                        $scope.historyLink = links['history'];
	                                        $scope.reloadHistory();
	                                        $scope.applicationLink = links['application'];
	                                        $scope.endpointLink = links['self'];
	                                        $scope.endpointsLink = null;
	                                        $timeout(function () {
	                                            $scope.$apply(function () {
	                                                var detailsData = detailsResponse['data'];
	                                                $scope['endpoint']['httpMethod'] = detailsData['httpMethod'];
	                                                $scope['endpoint'].path = detailsData.path;
	                                                $scope['endpoint'].operation = detailsData.operation;
	                                            });
	                                        });
	                                    }
	                                    srv.getApplicationDetails($scope.applicationLink).then(function (applicationDetails) {
	                                        $timeout(function () {
	                                            $scope.$apply(function () {
	                                                if (!applicationDetails['data'] || !applicationDetails['data'].swagger) {
	                                                    $log.error("Got no application details!");
	                                                }
	                                                $scope.application = applicationDetails['data'];
	                                            });
	                                        });
	                                    });
	                                });
	                            }
	                            else {
	                                srv.getApplicationDetailsFromName($scope.requestMetadata.applicationName).then(function (response) {
	                                    $timeout(function () {
	                                        $scope.$apply(function () {
	                                            if (!response['data'] || !response['data'].swagger) {
	                                                $log.error("Got no application details!");
	                                            }
	                                            $scope.application = response['data'];
	                                            var links = tribeLinkHeaderService.parseLinkHeader(response['data']['swagger']['x-tribestream-api-registry']['links']);
	                                            $scope.applicationLink = links['self'];
	                                            $scope.endpointLink = null;
	                                            $scope.endpointsLink = links['endpoints'];
	                                            $scope.historyLink = null;
	                                        });
	                                    });
	                                });
	                            }
	                            var handleError = function (errorResponse) {
	                                if (errorResponse['data'] && errorResponse['data']['key'] === "duplicated.endpoint.exception") {
	                                    systemMessagesService.error("There is an existing endpoint with the same Verb and\n                        Path combination. Please try it again with new data.");
	                                }
	                                else {
	                                    systemMessagesService.error("Unable to create endpoint.");
	                                }
	                            };
	                            $scope.save = function () {
	                                if (!!$scope.endpoint.endpointProtocol) {
	                                    $scope.endpoint.operation.schemes = [$scope.endpoint.endpointProtocol];
	                                }
	                                if (!!$scope.endpoint.operation['x-tribestream-api-registry'] && !!$scope.endpoint.operation['x-tribestream-api-registry'].sees) {
	                                    $scope.endpoint.operation['x-tribestream-api-registry'].sees =
	                                        $scope.endpoint.operation['x-tribestream-api-registry'].sees.filter(function (v) { return !!v.href; });
	                                }
	                                var reload = function (resp) {
	                                    var res = resp.data;
	                                    var app = $scope['application'];
	                                    var appName = app['humanReadableName'];
	                                    var path = $filter('pathencode')(res.path);
	                                    $location.path("endpoint/" + appName + "/" + res.httpMethod + path);
	                                    // force page refresh
	                                    $route.reload();
	                                };
	                                if ($scope.endpointLink) {
	                                    srv.saveEndpoint($scope.endpointLink, {
	                                        // Cannot simply send the endpoint object because it's polluted with errors and expectedValues
	                                        httpMethod: $scope['endpoint']['httpMethod'],
	                                        path: $scope['endpoint'].path,
	                                        operation: $scope['endpoint'].operation
	                                    }).then(function (saveResponse) {
	                                        systemMessagesService.info("Saved endpoint details!");
	                                        reload(saveResponse);
	                                    }, handleError);
	                                }
	                                else {
	                                    srv.createEndpoint($scope.endpointsLink, {
	                                        // Cannot simply send the endpoint object because it's polluted with errors and expectedValues
	                                        httpMethod: $scope['endpoint']['httpMethod'],
	                                        path: $scope['endpoint'].path,
	                                        operation: $scope['endpoint'].operation
	                                    }).then(function (saveResponse) {
	                                        systemMessagesService.info("Created new endpoint! " + saveResponse.status);
	                                        reload(saveResponse);
	                                    }, handleError);
	                                }
	                            };
	                            $scope.delete = function () {
	                                srv.delete($scope.endpointLink).then(function (response) {
	                                    systemMessagesService.info("Deleted endpoint!");
	                                    $location.path("/application/" + $scope.requestMetadata.applicationName);
	                                });
	                            };
	                            $scope.reloadHistory = function () {
	                                if (!$scope.historyLink) {
	                                    return;
	                                }
	                                srv.getHistory($scope.historyLink).then(function (response) {
	                                    var links = tribeLinkHeaderService.parseLinkHeader(response['data']['links']);
	                                    for (var _i = 0, _a = response['data']['items']; _i < _a.length; _i++) {
	                                        var entry = _a[_i];
	                                        entry.link = links["revision " + entry.revisionId];
	                                    }
	                                    $timeout(function () {
	                                        $scope.$apply(function () {
	                                            $scope.history = response['data']['items'];
	                                        });
	                                    });
	                                });
	                            };
	                            // Triggered by selecting one revision, will load it and show it
	                            $scope.showHistoricEndpoint = function (historyItem) {
	                                srv.getHistoricItem(historyItem).then(function (response) {
	                                    $timeout(function () {
	                                        $scope.$apply(function () {
	                                            var detailsData = response['data'];
	                                            $scope['historyItem'] = historyItem;
	                                            $scope['endpoint']['httpMethod'] = detailsData['httpMethod'];
	                                            $scope['endpoint'].path = detailsData.path;
	                                            $scope['endpoint'].operation = detailsData.operation;
	                                        });
	                                    });
	                                });
	                            };
	                        });
	                    }],
	                link: function (scope, el) { return $timeout(function () {
	                    scope.$watch('historyLink', function () {
	                        if (!scope['historyLink']) {
	                            return;
	                        }
	                        el.find('div.history').on('click', function () {
	                            var winEl = angular.element($window);
	                            var calculateScroll = function () {
	                                var target = el.find('div[data-app-endpoints-details-history]');
	                                return target.offset().top;
	                            };
	                            winEl.scrollTop(calculateScroll());
	                        });
	                    });
	                }); }
	            };
	        }])
	        .directive('setClassWhenAtTop', ['$window', function ($window) {
	            function stickyNavLink(scope, element) {
	                var window = angular.element($window), size = element[0].clientHeight, top = 0, fixedClass = 'fixed-header';
	                function stickyNav() {
	                    if (!element.hasClass(fixedClass)) {
	                        if ($window.pageYOffset > top + size)
	                            element.addClass(fixedClass);
	                    }
	                    else if ($window.pageYOffset <= top + size) {
	                        element.removeClass(fixedClass);
	                    }
	                }
	                function resizeNav() {
	                    element.removeClass(fixedClass);
	                    top = element[0].getBoundingClientRect().top + $window.pageYOffset;
	                    size = element[0].clientHeight;
	                    stickyNav();
	                }
	                window.bind('resize', resizeNav);
	                window.bind('scroll', stickyNav);
	            }
	            return {
	                scope: {},
	                restrict: 'A',
	                link: stickyNavLink
	            };
	        }])
	        .run(function () {
	        // placeholder
	    });
	})(endpointdetails || (endpointdetails = {}));


/***/ },
/* 70 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"title\"><h1><div data-tribe-singleselect=\"data-tribe-singleselect\" data-placeholder=\"Verb\" data-disable-actions=\"true\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-available-options=\"[{text:'DELETE', value:'delete'}, {text:'HEAD', value:'head'}, {text:'GET', value:'get'}, {text:'OPTIONS', value:'options'}, {text:'POST', value:'post'}, {text:'PUT', value:'put'}, {text:'PATCH', value:'patch'}]\" data-selected-option=\"endpoint.httpMethod\" data-mandatory=\"true\"></div><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-regex=\"{{regex}}\" data-regex-tip=\"{{regexTip}}\" data-value=\"endpoint.path\" data-placeholder=\"Path\" data-mandatory=\"true\"></div></h1></div><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation.description\" data-placeholder=\"Description\"></div><div data-app-endpoints-details-see=\"data-app-endpoints-details-see\" data-endpoint=\"endpoint\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\"></div><div class=\"resourceUrl\" x-ng-if=\"resourceUrl\"><h2 app-endpoints-details-toc-anchor=\"Resource URL\">Resource URL</h2><div><i data-tribe-editable-option=\"data-tribe-editable-option\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.endpointProtocol\" data-options=\"['http', 'https']\"></i><span>://</span><a x-ng-href=\"{{ endpoint.endpointProtocol + '://' + resourceUrl}}\">{{resourceUrl}}</a></div></div></div>";

/***/ },
/* 71 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"content\"><div class=\"title\"><div><div><i class=\"fa fa-list\"></i></div><h3>Table of contents</h3></div><div></div></div><div class=\"body\"><ul><li x-ng-repeat=\"anchor in anchors| orderBy:getIndex\" data-app-endpoints-details-toc-item=\"anchor\"></li></ul></div></div><div class=\"collapse-icon\"><i class=\"fa fa-caret-left\"></i><i class=\"fa fa-bars\"></i><i class=\"fa fa-caret-right\"></i></div></div>";

/***/ },
/* 72 */
/***/ function(module, exports) {

	module.exports = "<div><h4 ng-hide=\"anchor.submenu\">{{anchor.title}}</h4><ul ng-show=\"anchor.submenu\"><div></div><li><h4>{{anchor.title}}</h4><div></div></li></ul></div>";

/***/ },
/* 73 */
/***/ function(module, exports) {

	module.exports = "<div><h2><span>Parameters</span><div class=\"add-param tribe-add-btn\" tabindex=\"0\" x-ng-click=\"addParam()\" app-endpoints-details-toc-anchor=\"Parameters\"><i class=\"fa fa-plus\"></i></div></h2><div class=\"app-epd-params\"><div ng-show=\"endpoint.operation.parameters.length\"><table><thead><tr><th>name</th><th>type</th><th>placement</th><th>required</th><th class=\"description\">description</th><th class=\"valid-values\">valid values</th><th></th></tr></thead><tbody><tr x-ng-repeat=\"param in endpoint.operation.parameters | orderBy:'param.name'\"><td><div data-tribe-singleselect=\"data-tribe-singleselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-editable=\"true\" data-selected-option=\"param.name\" data-placeholder=\"\" data-available-options=\"['Authorization', 'Date', 'Content-Type', 'Accept']\"></div></td><td><div data-tribe-singleselect=\"data-tribe-singleselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-selected-option=\"param.type\" data-placeholder=\"\" data-available-options=\"['integer', 'long', 'float', 'double', 'string', 'byte', 'binary', 'boolean', 'date', 'dateTime', 'password']\"></div></td><td><div data-tribe-singleselect=\"data-tribe-singleselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-selected-option=\"param.in\" data-placeholder=\"\" data-available-options=\"[{text:'Query', value:'query'}, {text:'Header', value:'header'}, {text:'Path', value:'path'}, {text:'Form data', value:'formData'}, {text:'Body', value:'body'}]\"></div></td><td><div data-tribe-singleselect=\"data-tribe-singleselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-selected-option=\"param.required\" data-placeholder=\"No\" data-available-options=\"[{text: 'Yes', value: true}, {text: 'No', value: false}]\"></div></td><td class=\"description\"><div><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"param.description\"></div></div></td><td class=\"valid-values\"><div><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"param['x-tribestream-api-registry']['valid-values']\"></div></div></td><td><div><i class=\"fa fa-trash-o\" x-ng-click=\"removeParam(param);\"></i></div></td></tr></tbody></table></div></div></div>";

/***/ },
/* 74 */
/***/ function(module, exports) {

	module.exports = "<div><h2 app-endpoints-details-toc-anchor=\"Resource Information\">Resource Information</h2><div><div><div data-submenu=\"true\" app-endpoints-details-toc-anchor=\"API Version\"><span>Endpoint Version</span><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation['x-tribestream-api-registry'].apiVersion\"></div></div><div data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Status\"><span>Status</span><div data-tribe-singleselect=\"data-tribe-singleselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-selected-option=\"endpoint.operation['x-tribestream-api-registry'].status\" data-available-options=\"statusOptions\"></div></div></div><div><div><span>Environment</span><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation['x-tribestream-api-registry'].environment\"></div></div></div><div><div data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Request formats\"><span>Request formats</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-auto-show-options=\"true\" data-available-options=\"requestFormatsOptions\" data-selected-options=\"endpoint.operation.consumes\"></div></div><div data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Response formats\"><span>Response formats</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-available-options=\"responseFormatsOptions\" data-selected-options=\"endpoint.operation.produces\"></div></div></div><div><div class=\"auth-method\" data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Authentication method\"><span>Authentication method</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-available-options=\"['basic', 'form', 'digest', 'HTTP Signatures', 'Bearer']\" data-selected-options=\"endpoint.operation['x-tribestream-api-registry']['auth-methods']\"></div></div><div data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Roles\"><span>Roles</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-selected-options=\"endpoint.operation['x-tribestream-api-registry'].roles\" data-available-options=\"[]\"></div></div></div><div><div data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Categories\"><span>Categories</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-selected-options=\"endpoint.operation['x-tribestream-api-registry'].categories\" data-available-options=\"[]\"></div></div><div data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Tags\"><span>Tags</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-selected-options=\"endpoint.operation.tags\" data-available-options=\"[]\"></div></div></div></div><div class=\"app-rates\" data-submenu=\"true\" app-endpoints-details-toc-anchor=\"Rates\"><div><span>Rate Limit</span><div class=\"tribe-add-btn\" x-ng-click=\"addRate()\" tabindex=\"0\"><i class=\"fa fa-plus\"></i></div></div><div class=\"rates\" x-ng-repeat=\"rl in endpoint.operation['x-tribestream-api-registry'].rates\"><i data-tribe-editable-number=\"data-tribe-editable-number\" data-placeholder=\"Limit\" data-value=\"rl.rateLimit\"></i><span>requests /</span><i data-tribe-editable-number=\"data-tribe-editable-number\" data-placeholder=\"Window\" data-value=\"rl.rateWindow\"></i><div data-tribe-singleselect=\"data-tribe-singleselect\" data-disable-actions=\"true\" data-placeholder=\"Time\" data-selected-option=\"rl.rateUnit\" data-available-options=\"rateUnits\"></div><i data-tribe-editable-text=\"data-tribe-editable-text\" data-placeholder=\"Description\" data-value=\"rl.description\"></i><div x-ng-click=\"removeRate(rl)\"><i class=\"fa fa-trash\"></i></div></div></div></div>";

/***/ },
/* 75 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"expected\"><h2>Expected values<div class=\"tribe-add-btn\" x-ng-click=\"addExpectedValue();\"><i class=\"fa fa-plus\"></i></div></h2><table x-ng-if=\"endpoint.operation['x-tribestream-api-registry']['expected-values'].length\"><thead><tr><th>Attribute</th><th>Data Type</th><th>Expected Values</th><th>Description</th><th></th></tr></thead><tbody><tr x-ng-repeat=\"val in endpoint.operation['x-tribestream-api-registry']['expected-values']\"><td><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.name\"></div></td><td><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.type\"></div></td><td><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.values\"></div></td><td><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.description\"></div></td><td><div x-ng-click=\"removeExpectedValue(val);\"><i class=\"fa fa-trash-o\"></i></div></td></tr></tbody></table></div><div class=\"values\"><h2>Response codes<div class=\"tribe-add-btn\" x-ng-click=\"addErrorCode();\" app-endpoints-details-toc-anchor=\"Response codes\"><i class=\"fa fa-plus\"></i></div></h2><table x-ng-if=\"endpoint.operation['x-tribestream-api-registry'] &amp;&amp; endpoint.operation['x-tribestream-api-registry']['response-codes'] &amp;&amp; endpoint.operation['x-tribestream-api-registry']['response-codes'].length\"><thead><tr><th>HTTP Status</th><th>Error Code</th><th>Message</th><th>Description</th><th></th></tr></thead><tbody><tr x-ng-repeat=\"val in endpoint.operation['x-tribestream-api-registry']['response-codes'] | orderBy:'http_status'\"><td><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.http_status\"></div></td><td><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.error_code\"></div></td><td><div data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.message\"></div></td><td><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"val.description\"></div></td><td><div x-ng-click=\"removeErrorCode(val);\"><i class=\"fa fa-trash-o\"></i></div></td></tr></tbody></table></div><div class=\"resp-body\"><h2>Response Body</h2><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation['x-tribestream-api-registry']['response-body']\"></div></div><div class=\"samples\"><h2>Samples</h2><h3>Request Headers</h3><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation['x-tribestream-api-registry']['request-parameters']\"></div><h3>Response Parameters</h3><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation['x-tribestream-api-registry']['response-parameters']\"></div><h3>Response Body</h3><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation['x-tribestream-api-registry']['example-response']\"></div><h3>Response Body Error</h3><div data-tribe-markdown=\"data-tribe-markdown\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-value=\"endpoint.operation['x-tribestream-api-registry']['example-error-response']\"></div></div></div>";

/***/ },
/* 76 */
/***/ function(module, exports) {

	module.exports = "<div><div><span>See also</span><div class=\"add-link tribe-add-btn\"><i class=\"fa fa-plus\"></i></div></div><ul><li x-ng-repeat=\"see in endpoint.operation['x-tribestream-api-registry'].sees | orderBy:['seeOrder', 'title']\"><a ng-if=\"see.href &amp;&amp; see.href.trim() !== ''\" ng-href=\"{{see.href}}\" target=\"_blank\"><i class=\"fa fa-link\"></i></a><i data-tribe-text=\"data-tribe-text\" data-on-edit-mode-on=\"onEditModeOn(uniqueId)\" data-on-edit-mode-off=\"onEditModeOff(uniqueId)\" data-placeholder=\"enter link here\" data-value=\"see.href\"></i><div x-ng-click=\"removeLink(see);\"><i class=\"fa fa-trash\"></i></div></li></ul></div>";

/***/ },
/* 77 */
/***/ function(module, exports) {

	module.exports = "<div x-ng-if=\"historyLink\"><h2>History</h2><table><thead><tr><th>&nbsp;</th><th>Revision</th><th>Timestamp</th><th>Username</th><th></th></tr></thead><tbody><tr x-ng-repeat=\"historyItem in history\"><td><i data-tribe-checkbox=\"data-tribe-checkbox\" data-value=\"historyItem.$ui.selected\" data-change=\"onHistorySelect(historyItem)\"></i></td><td><span>{{historyItem.revisionId}}</span></td><td><span>{{historyItem.timestamp | date:'medium'}}</span></td><td><span>{{historyItem.username}}</span></td><td><i class=\"fa fa-history\" x-ng-click=\"showHistoricEndpoint(historyItem)\"></i></td></tr></tbody></table><button x-ng-click=\"doDiff()\" ng-disabled=\"selected.length !== 2 || showDiff\">Show Difference</button><div data-tribe-diff=\"data-tribe-diff\" x-ng-show=\"showDiff &amp;&amp; selected.length == 2\" data-value-a=\"valueA\" data-value-b=\"valueB\" data-title-a=\"titleA\" data-title-b=\"titleB\"></div><button x-ng-click=\"doDiff()\" x-ng-show=\"showDiff\">Hide Diff</button><button x-ng-click=\"saveMerge()\" x-ng-show=\"showDiff\">Save left pane as endpoint</button></div>";

/***/ },
/* 78 */
/***/ function(module, exports) {

	module.exports = "<div><div class=\"header\" set-class-when-at-top=\"set-class-when-at-top\"><div class=\"breadcrumb\"><a href=\".\"><i class=\"fa fa-home\"></i></a><i class=\"fa fa-chevron-right\"></i><a x-ng-href=\"application/{{application.humanReadableName}}\">{{application.swagger.info.title}} {{application.swagger.info.version}}</a><i class=\"fa fa-chevron-right\"></i><span x-ng-if=\"historyItem\">Revision {{historyItem.revisionId}} by {{historyItem.username}} created on {{historyItem.timestamp | date:'medium'}}</span></div><div class=\"buttons\"><div class=\"save\" x-ng-disabled=\"isOnEdit || !endpoint.httpMethod || !endpoint.path || !endpoint.path.trim()\" x-ng-click=\"isOnEdit || !endpoint.httpMethod || !endpoint.path || !endpoint.path.trim() || save()\"><i class=\"fa fa-floppy-o\"></i><span>Save</span></div><div class=\"history\" x-ng-if=\"historyLink\"><i class=\"fa fa-history\"></i><span>Show History</span></div><div class=\"delete\" data-tribe-confirm-btn=\"data-tribe-confirm-btn\" data-callback=\"delete\" data-icon=\"trash\" data-message=\"Are you sure you want to delete this endpoint?\" x-ng-if=\"endpointLink\" data-label=\"Delete Endpoint\"></div></div></div><div><div><article class=\"app-ep-details-body\"><div data-app-endpoints-details-header=\"data-app-endpoints-details-header\"></div><div data-app-endpoints-details-resource-information=\"data-app-endpoints-details-resource-information\"></div><div data-app-endpoints-details-parameters=\"data-app-endpoints-details-parameters\"></div><div data-app-endpoints-details-response-request=\"data-app-endpoints-details-response-request\"></div><div data-app-endpoints-details-history=\"data-app-endpoints-details-history\"></div></article></div><div data-app-footer=\"data-app-footer\"></div></div></div>";

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(80);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(91)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../node_modules/css-loader/index.js!./../../node_modules/postcss-loader/index.js!./../../node_modules/sass-loader/index.js!./app.sass", function() {
				var newContent = require("!!./../../node_modules/css-loader/index.js!./../../node_modules/postcss-loader/index.js!./../../node_modules/sass-loader/index.js!./app.sass");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(81)();
	// imports
	
	
	// module
	exports.push([module.id, "/*! normalize.css v3.0.3 | MIT License | github.com/necolas/normalize.css */\n/**\n * 1. Set default font family to sans-serif.\n * 2. Prevent iOS and IE text size adjust after device orientation change,\n *    without disabling user zoom.\n */\nhtml {\n  font-family: sans-serif;\n  /* 1 */\n  -ms-text-size-adjust: 100%;\n  /* 2 */\n  -webkit-text-size-adjust: 100%;\n  /* 2 */ }\n\n/**\n * Remove default margin.\n */\nbody {\n  margin: 0; }\n\n/* HTML5 display definitions\n   ========================================================================== */\n/**\n * Correct `block` display not defined for any HTML5 element in IE 8/9.\n * Correct `block` display not defined for `details` or `summary` in IE 10/11\n * and Firefox.\n * Correct `block` display not defined for `main` in IE 11.\n */\narticle, aside, details, figcaption, figure, footer, header, hgroup, main, menu, nav, section, summary {\n  display: block; }\n\n/**\n * 1. Correct `inline-block` display not defined in IE 8/9.\n * 2. Normalize vertical alignment of `progress` in Chrome, Firefox, and Opera.\n */\naudio, canvas, progress, video {\n  display: inline-block;\n  /* 1 */\n  vertical-align: baseline;\n  /* 2 */ }\n\n/**\n * Prevent modern browsers from displaying `audio` without controls.\n * Remove excess height in iOS 5 devices.\n */\naudio:not([controls]) {\n  display: none;\n  height: 0; }\n\n/**\n * Address `[hidden]` styling not present in IE 8/9/10.\n * Hide the `template` element in IE 8/9/10/11, Safari, and Firefox < 22.\n */\n[hidden], template {\n  display: none; }\n\n/* Links\n   ========================================================================== */\n/**\n * Remove the gray background color from active links in IE 10.\n */\na {\n  background-color: transparent; }\n\n/**\n * Improve readability of focused elements when they are also in an\n * active/hover state.\n */\na:active, a:hover {\n  outline: 0; }\n\n/* Text-level semantics\n   ========================================================================== */\n/**\n * Address styling not present in IE 8/9/10/11, Safari, and Chrome.\n */\nabbr[title] {\n  border-bottom: 1px dotted; }\n\n/**\n * Address style set to `bolder` in Firefox 4+, Safari, and Chrome.\n */\nb, strong {\n  font-weight: bold; }\n\n/**\n * Address styling not present in Safari and Chrome.\n */\ndfn {\n  font-style: italic; }\n\n/**\n * Address variable `h1` font-size and margin within `section` and `article`\n * contexts in Firefox 4+, Safari, and Chrome.\n */\nh1 {\n  font-size: 2em;\n  margin: 0.67em 0; }\n\n/**\n * Address styling not present in IE 8/9.\n */\nmark {\n  background: #ff0;\n  color: #000; }\n\n/**\n * Address inconsistent and variable font size in all browsers.\n */\nsmall {\n  font-size: 80%; }\n\n/**\n * Prevent `sub` and `sup` affecting `line-height` in all browsers.\n */\nsub, sup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline; }\n\nsup {\n  top: -0.5em; }\n\nsub {\n  bottom: -0.25em; }\n\n/* Embedded content\n   ========================================================================== */\n/**\n * Remove border when inside `a` element in IE 8/9/10.\n */\nimg {\n  border: 0; }\n\n/**\n * Correct overflow not hidden in IE 9/10/11.\n */\nsvg:not(:root) {\n  overflow: hidden; }\n\n/* Grouping content\n   ========================================================================== */\n/**\n * Address margin not present in IE 8/9 and Safari.\n */\nfigure {\n  margin: 1em 40px; }\n\n/**\n * Address differences between Firefox and other browsers.\n */\nhr {\n  box-sizing: content-box;\n  height: 0; }\n\n/**\n * Contain overflow in all browsers.\n */\npre {\n  overflow: auto; }\n\n/**\n * Address odd `em`-unit font size rendering in all browsers.\n */\ncode, kbd, pre, samp {\n  font-family: monospace, monospace;\n  font-size: 1em; }\n\n/* Forms\n   ========================================================================== */\n/**\n * Known limitation: by default, Chrome and Safari on OS X allow very limited\n * styling of `select`, unless a `border` property is set.\n */\n/**\n * 1. Correct color not being inherited.\n *    Known issue: affects color of disabled elements.\n * 2. Correct font properties not being inherited.\n * 3. Address margins set differently in Firefox 4+, Safari, and Chrome.\n */\nbutton, input, optgroup, select, textarea {\n  color: inherit;\n  /* 1 */\n  font: inherit;\n  /* 2 */\n  margin: 0;\n  /* 3 */ }\n\n/**\n * Address `overflow` set to `hidden` in IE 8/9/10/11.\n */\nbutton {\n  overflow: visible; }\n\n/**\n * Address inconsistent `text-transform` inheritance for `button` and `select`.\n * All other form control elements do not inherit `text-transform` values.\n * Correct `button` style inheritance in Firefox, IE 8/9/10/11, and Opera.\n * Correct `select` style inheritance in Firefox.\n */\nbutton, select {\n  text-transform: none; }\n\n/**\n * 1. Avoid the WebKit bug in Android 4.0.* where (2) destroys native `audio`\n *    and `video` controls.\n * 2. Correct inability to style clickable `input` types in iOS.\n * 3. Improve usability and consistency of cursor style between image-type\n *    `input` and others.\n */\nbutton, html input[type=\"button\"], input[type=\"reset\"], input[type=\"submit\"] {\n  -webkit-appearance: button;\n  /* 2 */\n  cursor: pointer;\n  /* 3 */ }\n\n/**\n * Re-set default cursor for disabled elements.\n */\nbutton[disabled], html input[disabled] {\n  cursor: default; }\n\n/**\n * Remove inner padding and border in Firefox 4+.\n */\nbutton::-moz-focus-inner, input::-moz-focus-inner {\n  border: 0;\n  padding: 0; }\n\n/**\n * Address Firefox 4+ setting `line-height` on `input` using `!important` in\n * the UA stylesheet.\n */\ninput {\n  line-height: normal; }\n\n/**\n * It's recommended that you don't attempt to style these elements.\n * Firefox's implementation doesn't respect box-sizing, padding, or width.\n *\n * 1. Address box sizing set to `content-box` in IE 8/9/10.\n * 2. Remove excess padding in IE 8/9/10.\n */\ninput[type=\"checkbox\"], input[type=\"radio\"] {\n  box-sizing: border-box;\n  /* 1 */\n  padding: 0;\n  /* 2 */ }\n\n/**\n * Fix the cursor style for Chrome's increment/decrement buttons. For certain\n * `font-size` values of the `input`, it causes the cursor style of the\n * decrement button to change from `default` to `text`.\n */\ninput[type=\"number\"]::-webkit-inner-spin-button, input[type=\"number\"]::-webkit-outer-spin-button {\n  height: auto; }\n\n/**\n * 1. Address `appearance` set to `searchfield` in Safari and Chrome.\n * 2. Address `box-sizing` set to `border-box` in Safari and Chrome.\n */\ninput[type=\"search\"] {\n  -webkit-appearance: textfield;\n  /* 1 */\n  box-sizing: content-box;\n  /* 2 */ }\n\n/**\n * Remove inner padding and search cancel button in Safari and Chrome on OS X.\n * Safari (but not Chrome) clips the cancel button when the search input has\n * padding (and `textfield` appearance).\n */\ninput[type=\"search\"]::-webkit-search-cancel-button, input[type=\"search\"]::-webkit-search-decoration {\n  -webkit-appearance: none; }\n\n/**\n * Define consistent border, margin, and padding.\n */\nfieldset {\n  border: 1px solid #c0c0c0;\n  margin: 0 2px;\n  padding: 0.35em 0.625em 0.75em; }\n\n/**\n * 1. Correct `color` not being inherited in IE 8/9/10/11.\n * 2. Remove padding so people aren't caught out if they zero out fieldsets.\n */\nlegend {\n  border: 0;\n  /* 1 */\n  padding: 0;\n  /* 2 */ }\n\n/**\n * Remove default vertical scrollbar in IE 8/9/10/11.\n */\ntextarea {\n  overflow: auto; }\n\n/**\n * Don't inherit the `font-weight` (applied by a rule above).\n * NOTE: the default cannot safely be changed in Chrome and Safari on OS X.\n */\noptgroup {\n  font-weight: bold; }\n\n/* Tables\n   ========================================================================== */\n/**\n * Remove most spacing between table cells.\n */\ntable {\n  border-collapse: collapse;\n  border-spacing: 0; }\n\ntd, th {\n  padding: 0; }\n\nmeta.foundation-version {\n  font-family: \"1.2.0\"; }\n\nmeta.foundation-mq {\n  font-family: \"small=0&medium=40rem&large=75rem&xlarge=90rem&xxlarge=120rem\"; }\n\n/*\n  GLOBAL\n  ------\n\n  Global styles and settings for Foundation for Apps are stored here. This file must always\n  be imported, no matter what.\n\n  Includes:\n   -\n*/\nhtml, body {\n  height: 100%;\n  font-size: 100%; }\n\nhtml {\n  box-sizing: border-box; }\n\n*, *:before, *:after {\n  box-sizing: inherit; }\n\nbody {\n  background: #fff;\n  color: #222;\n  padding: 0;\n  margin: 0;\n  font-family: \"Helvetica Neue\", \"Helvetica\", Helvetica, Arial, sans-serif;\n  font-weight: normal;\n  font-style: normal;\n  line-height: 1;\n  position: relative;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale; }\n\nimg {\n  max-width: 100%;\n  height: auto;\n  -ms-interpolation-mode: bicubic;\n  display: inline-block;\n  vertical-align: middle; }\n\na, [ui-sref], [zf-open], [zf-close], [zf-toggle] {\n  cursor: pointer; }\n\n#map_canvas img, #map_canvas embed, #map_canvas object, .map_canvas img, .map_canvas embed, .map_canvas object {\n  max-width: none !important; }\n\n.padding {\n  padding: 1rem; }\n\n.iconic {\n  width: 1rem;\n  height: 1rem;\n  vertical-align: middle; }\n  a > .iconic {\n    margin-top: -2px;\n    margin-right: 0.25rem; }\n    a > .iconic * {\n      fill: #00558b;\n      stroke: #00558b; }\n      a > .iconic *.iconic-property-accent {\n        fill: #00558b;\n        stroke: #00558b; }\n\n.iconic * {\n  fill: #00558b;\n  stroke: #00558b; }\n  .iconic *.iconic-property-accent {\n    fill: #00558b;\n    stroke: #00558b; }\n\n.iconic-color-primary * {\n  fill: #00558b;\n  stroke: #00558b; }\n  .iconic-color-primary *.iconic-property-accent {\n    fill: #00558b;\n    stroke: #00558b; }\n\n.iconic-color-success * {\n  fill: #43AC6A;\n  stroke: #43AC6A; }\n  .iconic-color-success *.iconic-property-accent {\n    fill: #43AC6A;\n    stroke: #43AC6A; }\n\n.iconic-color-warning * {\n  fill: #F08A24;\n  stroke: #F08A24; }\n  .iconic-color-warning *.iconic-property-accent {\n    fill: #F08A24;\n    stroke: #F08A24; }\n\n.iconic-color-alert * {\n  fill: #F04124;\n  stroke: #F04124; }\n  .iconic-color-alert *.iconic-property-accent {\n    fill: #F04124;\n    stroke: #F04124; }\n\n.iconic-color-dark * {\n  fill: #232323;\n  stroke: #232323; }\n  .iconic-color-dark *.iconic-property-accent {\n    fill: #232323;\n    stroke: #232323; }\n\n.iconic-color-secondary * {\n  fill: #f1f1f1;\n  stroke: #f1f1f1; }\n  .iconic-color-secondary *.iconic-property-accent {\n    fill: #f1f1f1;\n    stroke: #f1f1f1; }\n\n/*\r\n  ACTION SHEET\r\n  ------------\r\n\r\n  A dropdown menu that sticks to the bottom of the screen on small devices, and becomes a dropdown menu on larger devices.\r\n*/\n/*\r\n  Styles for the list inside an action sheet.\r\n  Don't include this mixin if you want to build custom controls inside the sheet.\r\n*/\n/*\r\n  Styles for the action sheet container. Action sheets pin to the top or bottom of the screen.\r\n*/\n.action-sheet-container {\n  position: relative;\n  display: inline-block; }\n  .action-sheet-container .button, .action-sheet-container button {\n    margin-left: 0;\n    margin-right: 0; }\n\n.action-sheet {\n  position: fixed;\n  left: 0;\n  z-index: 1000;\n  width: 100%;\n  padding: 1rem;\n  background: white;\n  text-align: center;\n  -webkit-transition-property: -webkit-transform opacity;\n  transition-property: -webkit-transform opacity;\n  transition-property: transform opacity;\n  transition-property: transform opacity, -webkit-transform opacity;\n  -webkit-transition-duration: 0.25s;\n          transition-duration: 0.25s;\n  -webkit-transition-timing-function: ease-out;\n          transition-timing-function: ease-out;\n  box-shadow: 0 -3px 10px rgba(0, 0, 0, 0.25);\n  bottom: 0;\n  -webkit-transform: translateY(100%);\n          transform: translateY(100%); }\n  .action-sheet.is-active {\n    -webkit-transform: translateY(0%);\n            transform: translateY(0%); }\n  .action-sheet ul {\n    margin: -1rem;\n    margin-top: 0;\n    list-style-type: none;\n    -webkit-user-select: none;\n       -moz-user-select: none;\n        -ms-user-select: none;\n            user-select: none; }\n    .action-sheet ul:first-child {\n      margin-top: -1rem; }\n      .action-sheet ul:first-child li:first-child {\n        border-top: 0; }\n    .action-sheet ul a {\n      display: block;\n      padding: 0.8rem;\n      line-height: 1;\n      color: #000;\n      border-top: 1px solid #ccc; }\n      .action-sheet ul a:hover {\n        color: #000;\n        background: #f2f2f2; }\n    .action-sheet ul .alert > a {\n      color: #F04124; }\n    .action-sheet ul .disabled > a {\n      pointer-events: none;\n      color: #999; }\n  @media only screen and (min-width: 40em) {\n    .action-sheet {\n      /*\r\n    Core styles\r\n  */\n      position: absolute;\n      left: 50%;\n      width: 300px;\n      border-radius: 4px;\n      opacity: 0;\n      pointer-events: none;\n      /*\r\n    Menu shadow\r\n  */\n      box-shadow: 0 0 10px rgba(0, 0, 0, 0.25);\n      /*\r\n    Active state\r\n  */\n      /*\r\n    Menu tail\r\n  */\n      /*\r\n    Positioning\r\n  */\n      top: auto;\n      bottom: 0;\n      -webkit-transform: translateX(-50%) translateY(110%);\n              transform: translateX(-50%) translateY(110%); }\n      .action-sheet.is-active {\n        opacity: 1;\n        pointer-events: auto; }\n      .action-sheet::before, .action-sheet::after {\n        content: '';\n        position: absolute;\n        left: 50%;\n        display: block;\n        width: 0px;\n        height: 0px;\n        border-left: 10px solid transparent;\n        border-right: 10px solid transparent;\n        margin-left: -10px; }\n      .action-sheet.is-active {\n        -webkit-transform: translateX(-50%) translateY(100%);\n                transform: translateX(-50%) translateY(100%); }\n      .action-sheet::before, .action-sheet::after {\n        top: -10px;\n        bottom: auto;\n        border-top: 0;\n        border-bottom: 10px solid white; }\n      .action-sheet::before {\n        top: -12px;\n        border-bottom-color: rgba(0, 0, 0, 0.15); }\n      .action-sheet.top {\n        /*\r\n    Core styles\r\n  */\n        position: absolute;\n        left: 50%;\n        width: 300px;\n        border-radius: 4px;\n        opacity: 0;\n        pointer-events: none;\n        /*\r\n    Menu shadow\r\n  */\n        box-shadow: 0 0 10px rgba(0, 0, 0, 0.25);\n        /*\r\n    Active state\r\n  */\n        /*\r\n    Menu tail\r\n  */\n        /*\r\n    Positioning\r\n  */\n        top: 0;\n        bottom: auto;\n        -webkit-transform: translateX(-50%) translateY(-120%);\n                transform: translateX(-50%) translateY(-120%); }\n        .action-sheet.top.is-active {\n          opacity: 1;\n          pointer-events: auto; }\n        .action-sheet.top::before, .action-sheet.top::after {\n          content: '';\n          position: absolute;\n          left: 50%;\n          display: block;\n          width: 0px;\n          height: 0px;\n          border-left: 10px solid transparent;\n          border-right: 10px solid transparent;\n          margin-left: -10px; }\n        .action-sheet.top.is-active {\n          -webkit-transform: translateX(-50%) translateY(-110%);\n                  transform: translateX(-50%) translateY(-110%); }\n        .action-sheet.top::before, .action-sheet.top::after {\n          top: auto;\n          bottom: -10px;\n          border-top: 10px solid white;\n          border-bottom: 0; }\n        .action-sheet.top::before {\n          bottom: -12px;\n          border-top-color: rgba(0, 0, 0, 0.15); } }\n  .action-sheet.primary {\n    background: #00558b;\n    color: #fff;\n    border: 0; }\n    .action-sheet.primary::before {\n      display: none; }\n    .action-sheet.primary::before, .action-sheet.primary::after {\n      border-top-color: #00558b; }\n    .action-sheet.primary.top::before, .action-sheet.primary.top::after {\n      border-bottom-color: #00558b; }\n    .action-sheet.primary ul {\n      margin: -1rem;\n      margin-top: 0;\n      list-style-type: none;\n      -webkit-user-select: none;\n         -moz-user-select: none;\n          -ms-user-select: none;\n              user-select: none; }\n      .action-sheet.primary ul:first-child {\n        margin-top: -1rem; }\n        .action-sheet.primary ul:first-child li:first-child {\n          border-top: 0; }\n      .action-sheet.primary ul a {\n        display: block;\n        padding: 0.8rem;\n        line-height: 1;\n        color: #fff;\n        border-top: 1px solid #006cb0; }\n        .action-sheet.primary ul a:hover {\n          color: #fff;\n          background: #00609e; }\n      .action-sheet.primary ul .alert > a {\n        color: #F04124; }\n      .action-sheet.primary ul .disabled > a {\n        pointer-events: none;\n        color: #999; }\n  .action-sheet.dark {\n    background: #232323;\n    color: #fff;\n    border: 0; }\n    .action-sheet.dark::before {\n      display: none; }\n    .action-sheet.dark::before, .action-sheet.dark::after {\n      border-top-color: #232323; }\n    .action-sheet.dark.top::before, .action-sheet.dark.top::after {\n      border-bottom-color: #232323; }\n    .action-sheet.dark ul {\n      margin: -1rem;\n      margin-top: 0;\n      list-style-type: none;\n      -webkit-user-select: none;\n         -moz-user-select: none;\n          -ms-user-select: none;\n              user-select: none; }\n      .action-sheet.dark ul:first-child {\n        margin-top: -1rem; }\n        .action-sheet.dark ul:first-child li:first-child {\n          border-top: 0; }\n      .action-sheet.dark ul a {\n        display: block;\n        padding: 0.8rem;\n        line-height: 1;\n        color: #fff;\n        border-top: 1px solid #393939; }\n        .action-sheet.dark ul a:hover {\n          color: #fff;\n          background: #2e2e2e; }\n      .action-sheet.dark ul .alert > a {\n        color: #F04124; }\n      .action-sheet.dark ul .disabled > a {\n        pointer-events: none;\n        color: #999; }\n\n/*\r\n  BLOCK LIST\r\n  ----------\r\n\r\n  A generic list component that can accomodate a variety of styles and controls.\r\n\r\n  Features:\r\n   - Icons\r\n   - Labels\r\n   - Chevrons\r\n   - Text fields\r\n   - Dropdown menus\r\n   - Checkbox/radio inputs\r\n*/\n/*\r\n  Adds styles for a block list container.\r\n\r\n  $font-size: global font size for the list.\r\n  $full-bleed: when \"true\", the margins of the list invert to line it up with the edge of a padded element.\r\n*/\n.block-list {\n  margin-bottom: 1rem;\n  line-height: 1;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n      -ms-user-select: none;\n          user-select: none; }\n  .block-list, .block-list ul {\n    list-style-type: none; }\n  .block-list ul {\n    margin-left: 0; }\n\n/*\r\n  Styles block list headers on the selector you include this mixin in (normally a <header>).\r\n\r\n  $color - color of the header.\r\n  $font-size - font size of the header.\r\n  $offset - left margin to add to the header, to line it up with the list items.\r\n*/\n/*\r\n  Styles block list items on the selector you include this mixin in (normally an <li>).\r\n\r\n  $color - color of items.\r\n  $color-hover - color of items on hover.\r\n  $background - background of items.\r\n  $background-hover - background of items on hover.\r\n  $border - border between items.\r\n  $padding - padding on items.\r\n*/\n/*\r\n  Adds label styles to the class you include this mixin in.\r\n\r\n  $color - color of the label.\r\n  $left-class - extra class to flip the orientation of the label.\r\n  $left-padding - left padding to use for left-hand labels.\r\n*/\n/*\r\n  Adds support for chevrons, which appear on the right-hand side of the item.\r\n\r\n  $color - color of the chevron.\r\n  $padding - include the global padding of block list items here.\r\n*/\n/*\r\n  Adds icon styles. Call this mixin on a block list container.\r\n\r\n  $size - size of the icon as a percentage (decimal) of the list item's height.\r\n  $item-selector - overrides the 'li' selector used for list items.\r\n*/\n/*\r\n  Adds support for text fields, select menus, and checkbox/radio groups in block lists.\r\n\r\n  $color - color of select menu arrow.\r\n  $background-hover - color of select menu when hovered over.\r\n  $padding - include the global padding of block list items here.\r\n  $dropdown-class - class to use for list items that contain a dropdown.\r\n  $switch-class - class to use for switches inside list items.\r\n*/\n.block-list {\n  font-size: 1rem;\n  margin-left: -1rem;\n  margin-right: -1rem; }\n  .block-list input[type=\"text\"], .block-list input[type=\"password\"], .block-list input[type=\"date\"], .block-list input[type=\"datetime\"], .block-list input[type=\"datetime-local\"], .block-list input[type=\"month\"], .block-list input[type=\"week\"], .block-list input[type=\"email\"], .block-list input[type=\"number\"], .block-list input[type=\"search\"], .block-list input[type=\"tel\"], .block-list input[type=\"time\"], .block-list input[type=\"url\"], .block-list input[type=\"color\"], .block-list textarea {\n    overflow: visible;\n    box-sizing: border-box;\n    margin: 0;\n    border: 0;\n    height: 2.6rem;\n    padding: 0.6rem 1rem 0.6rem 1rem;\n    color: inherit;\n    font-size: 1rem;\n    -webkit-font-smoothing: antialiased;\n    vertical-align: middle; }\n    .block-list input[type=\"text\"]:hover, .block-list input[type=\"text\"]:focus, .block-list input[type=\"password\"]:hover, .block-list input[type=\"password\"]:focus, .block-list input[type=\"date\"]:hover, .block-list input[type=\"date\"]:focus, .block-list input[type=\"datetime\"]:hover, .block-list input[type=\"datetime\"]:focus, .block-list input[type=\"datetime-local\"]:hover, .block-list input[type=\"datetime-local\"]:focus, .block-list input[type=\"month\"]:hover, .block-list input[type=\"month\"]:focus, .block-list input[type=\"week\"]:hover, .block-list input[type=\"week\"]:focus, .block-list input[type=\"email\"]:hover, .block-list input[type=\"email\"]:focus, .block-list input[type=\"number\"]:hover, .block-list input[type=\"number\"]:focus, .block-list input[type=\"search\"]:hover, .block-list input[type=\"search\"]:focus, .block-list input[type=\"tel\"]:hover, .block-list input[type=\"tel\"]:focus, .block-list input[type=\"time\"]:hover, .block-list input[type=\"time\"]:focus, .block-list input[type=\"url\"]:hover, .block-list input[type=\"url\"]:focus, .block-list input[type=\"color\"]:hover, .block-list input[type=\"color\"]:focus, .block-list textarea:hover, .block-list textarea:focus {\n      border: 0; }\n  .block-list li > input[type=\"checkbox\"], .block-list li > input[type=\"radio\"] {\n    position: absolute;\n    left: -9999px; }\n    .block-list li > input[type=\"checkbox\"] + label, .block-list li > input[type=\"radio\"] + label {\n      display: block;\n      font-size: 1rem;\n      margin: 0; }\n    .block-list li > input[type=\"checkbox\"]:checked + label::before, .block-list li > input[type=\"radio\"]:checked + label::before {\n      background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\"><path fill=\"black\" d=\"M16 0c-8.837 0-16 7.163-16 16s7.163 16 16 16 16-7.163 16-16-7.163-16-16-16zm6.906 8.875l2.219 2.031-12.063 13.281-6.188-6.188 2.125-2.125 3.938 3.938 9.969-10.938z\"/></svg>');\n      content: '';\n      background-size: 100% 100%;\n      width: 1.5em;\n      height: 1.5em;\n      color: #00558b;\n      float: right;\n      pointer-events: none;\n      margin-top: -0.25em; }\n      @media screen and (min-width: 0\\0) {\n        .block-list li > input[type=\"checkbox\"]:checked + label::before, .block-list li > input[type=\"radio\"]:checked + label::before {\n          background-image: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAdlJREFUeNrMl0FugzAQRY3TRZeoFyhVL0BOkGTXJezaHZwguUnECaCrdFd6gqQnCN11Uyk5QekNOlONJWMVGMCgfGlkEIY3HnsG2xFM3d96PjQB2AJsWdPtAPYOln+dTwXnuw4DHEGzBvNFN6EDCTiS9XIAwB40acNoucKoxODIie0AwAOCu8KOSnIiNx/MakK+A7sW9oTferxx3fP3T1nURoBG/irGVahHwjHm/Ggx7E3TMVdrQmoP0gngghhpZQ3QvG/EdPLUelARWI8Aycjq9Md0qMIdbcNhjmOKLoY7quk3l1Rebeqg4AwFkmq7LWGOh1pmNY0etZAWSq0OX8HoS4JvWuCopbSY26EGR/CW86K0BF+pwkLwlPuyHJhOCl5oe4ZtF++vOqST+GdOYwO+71pN2VNAjmQGPCe42weuHDg0PI8olUwnYrXTGQJH9gxq8l1LKvrQx4O6/YY32Kp/ugb3ey7gZ4xAzuhYiYTxB/UHZFAuaREVXZ2g6yFlvEC2yoKEmbsRZYNgVLk2JeaOaG+xLHN+WCszDWMqLGOrJFa1DlApjSdwoHJGqGzLIb0+cas0wh5Bh780ngswx8GJD7h8sHg2wLA/mfDLPZpdxOF0quP5rwADAAFIzSRvu1m5AAAAAElFTkSuQmCC\"); } }\n  .block-list .with-dropdown {\n    color: inherit; }\n    .block-list .with-dropdown select {\n      -webkit-appearance: none;\n      -moz-appearance: none;\n      outline: 0;\n      background: 0;\n      border: 0;\n      height: auto;\n      padding: 0.8rem 1rem;\n      margin: 0;\n      font-size: 1em;\n      line-height: 1;\n      color: inherit;\n      background-color: transparent; }\n  .block-list .switch {\n    position: absolute;\n    top: 50%;\n    right: 1rem;\n    -webkit-transform: translateY(-50%);\n            transform: translateY(-50%); }\n  .block-list.with-icons li > a, .block-list.with-icons li > span, .block-list.with-icons li > label {\n    padding-left: 2.8rem; }\n  .block-list.with-icons li img, .block-list.with-icons li .iconic {\n    position: absolute;\n    top: 0.26rem;\n    left: 0.26rem;\n    width: 2.08rem;\n    height: 2.08rem;\n    border-radius: 8px;\n    pointer-events: none; }\n  .block-list header {\n    margin-top: 1em;\n    color: #666666;\n    font-weight: bold;\n    margin-bottom: 0.5em;\n    margin-left: 1rem;\n    font-size: 0.8em;\n    cursor: default;\n    text-transform: uppercase; }\n  .block-list li {\n    position: relative;\n    border-bottom: 1px solid #d0d0d0; }\n    .block-list li:first-child {\n      border-top: 1px solid #d0d0d0; }\n    .block-list li > a, .block-list li > span, .block-list li > label {\n      display: block;\n      padding: 0.8rem 1rem;\n      padding-left: 1rem;\n      color: #000;\n      line-height: 1; }\n    .block-list li > span {\n      cursor: default; }\n    .block-list li > a, .block-list li > label {\n      cursor: pointer; }\n      .block-list li > a:hover, .block-list li > label:hover {\n        color: #000; }\n    .block-list li > a:hover, .block-list li > label:hover, .block-list li select:hover {\n      background: #f4f4f4; }\n    .block-list li.caution > a, .block-list li.caution > a:hover {\n      color: #F04124; }\n    .block-list li.disabled > a {\n      cursor: default; }\n      .block-list li.disabled > a, .block-list li.disabled > a:hover {\n        color: #999; }\n      .block-list li.disabled > a:hover {\n        background: transparent; }\n    .block-list li.with-chevron::after {\n      content: '\\203A';\n      display: block;\n      position: absolute;\n      right: 1rem;\n      top: 50%;\n      -webkit-transform: translateY(-50%);\n              transform: translateY(-50%);\n      font-weight: bold;\n      color: #666666;\n      font-size: 2em; }\n    .block-list li.with-chevron .block-list-label {\n      padding-right: 1.5rem; }\n    .block-list li .block-list-label {\n      display: inline-block;\n      float: right;\n      padding: 0;\n      color: #999999;\n      pointer-events: none; }\n      .block-list li .block-list-label.left {\n        margin-left: 0.8rem;\n        float: none; }\n\n.button, button, .button-group > li > a, .button-group > li > label, .button-group > li > button {\n  display: inline-block;\n  border: 0;\n  text-align: center;\n  line-height: 1;\n  cursor: pointer;\n  -webkit-appearance: none;\n  -webkit-font-smoothing: antialiased;\n  -webkit-transition: background 0.25s ease-out;\n  transition: background 0.25s ease-out;\n  vertical-align: middle;\n  padding: 0.85em 1em;\n  margin: 0 1rem 1rem 0;\n  font-size: 0.9rem;\n  border-radius: 0; }\n\n.button, button {\n  font-size: 0.9rem;\n  display: inline-block;\n  width: auto;\n  margin: 0 1rem 1rem 0;\n  background: #00558b;\n  color: #fff; }\n  .button .iconic, button .iconic {\n    width: 1em;\n    height: 1em;\n    vertical-align: middle;\n    margin-right: 0.25em;\n    margin-top: -2px; }\n  .button:hover, button:hover, .button:focus, button:focus {\n    background: #004876;\n    color: #fff; }\n  .button .iconic *, button .iconic * {\n    fill: #fff;\n    stroke: #fff; }\n    .button .iconic *.iconic-property-accent, button .iconic *.iconic-property-accent {\n      fill: #fff;\n      stroke: #fff; }\n  .button.tiny, button.tiny {\n    font-size: 0.63rem; }\n    .button.tiny .iconic, button.tiny .iconic {\n      width: 1em;\n      height: 1em;\n      vertical-align: middle;\n      margin-right: 0.25em;\n      margin-top: -2px; }\n  .button.small, button.small {\n    font-size: 0.72rem; }\n    .button.small .iconic, button.small .iconic {\n      width: 1em;\n      height: 1em;\n      vertical-align: middle;\n      margin-right: 0.25em;\n      margin-top: -2px; }\n  .button.large, button.large {\n    font-size: 1.17rem; }\n    .button.large .iconic, button.large .iconic {\n      width: 1em;\n      height: 1em;\n      vertical-align: middle;\n      margin-right: 0.25em;\n      margin-top: -2px; }\n  .button.expand, button.expand {\n    display: block;\n    width: 100%;\n    margin-left: 0;\n    margin-right: 0; }\n  .button.secondary, button.secondary {\n    background: #f1f1f1;\n    color: #000; }\n    .button.secondary:hover, button.secondary:hover, .button.secondary:focus, button.secondary:focus {\n      background: #cdcdcd;\n      color: #000; }\n    .button.secondary .iconic *, button.secondary .iconic * {\n      fill: #000;\n      stroke: #000; }\n      .button.secondary .iconic *.iconic-property-accent, button.secondary .iconic *.iconic-property-accent {\n        fill: #000;\n        stroke: #000; }\n  .button.success, button.success {\n    background: #43AC6A;\n    color: #fff; }\n    .button.success:hover, button.success:hover, .button.success:focus, button.success:focus {\n      background: #39925a;\n      color: #fff; }\n    .button.success .iconic *, button.success .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button.success .iconic *.iconic-property-accent, button.success .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button.warning, button.warning {\n    background: #F08A24;\n    color: #fff; }\n    .button.warning:hover, button.warning:hover, .button.warning:focus, button.warning:focus {\n      background: #dc750f;\n      color: #fff; }\n    .button.warning .iconic *, button.warning .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button.warning .iconic *.iconic-property-accent, button.warning .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button.alert, button.alert {\n    background: #F04124;\n    color: #fff; }\n    .button.alert:hover, button.alert:hover, .button.alert:focus, button.alert:focus {\n      background: #dc2c0f;\n      color: #fff; }\n    .button.alert .iconic *, button.alert .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button.alert .iconic *.iconic-property-accent, button.alert .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button.info, button.info {\n    background: #A0D3E8;\n    color: #000; }\n    .button.info:hover, button.info:hover, .button.info:focus, button.info:focus {\n      background: #71bddd;\n      color: #000; }\n    .button.info .iconic *, button.info .iconic * {\n      fill: #000;\n      stroke: #000; }\n      .button.info .iconic *.iconic-property-accent, button.info .iconic *.iconic-property-accent {\n        fill: #000;\n        stroke: #000; }\n  .button.dark, button.dark {\n    background: #232323;\n    color: #fff; }\n    .button.dark:hover, button.dark:hover, .button.dark:focus, button.dark:focus {\n      background: #1e1e1e;\n      color: #fff; }\n    .button.dark .iconic *, button.dark .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button.dark .iconic *.iconic-property-accent, button.dark .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button.hollow, button.hollow {\n    border: 1px solid #00558b;\n    background: transparent;\n    color: #00558b; }\n    .button.hollow:hover, button.hollow:hover, .button.hollow:focus, button.hollow:focus {\n      border-color: #008ee8;\n      background: transparent;\n      color: #008ee8; }\n    .button.hollow .iconic *, button.hollow .iconic * {\n      fill: #00558b;\n      stroke: #00558b; }\n      .button.hollow .iconic *.iconic-property-accent, button.hollow .iconic *.iconic-property-accent {\n        fill: #00558b;\n        stroke: #00558b; }\n    .button.hollow:hover .iconic *, button.hollow:hover .iconic * {\n      fill: #008ee8;\n      stroke: #008ee8; }\n      .button.hollow:hover .iconic *.iconic-property-accent, button.hollow:hover .iconic *.iconic-property-accent {\n        fill: #008ee8;\n        stroke: #008ee8; }\n    .button.hollow.secondary, button.hollow.secondary {\n      border: 1px solid #f1f1f1;\n      background: transparent;\n      color: #f1f1f1; }\n      .button.hollow.secondary:hover, button.hollow.secondary:hover, .button.hollow.secondary:focus, button.hollow.secondary:focus {\n        border-color: whitesmoke;\n        background: transparent;\n        color: whitesmoke; }\n      .button.hollow.secondary .iconic *, button.hollow.secondary .iconic * {\n        fill: #f1f1f1;\n        stroke: #f1f1f1; }\n        .button.hollow.secondary .iconic *.iconic-property-accent, button.hollow.secondary .iconic *.iconic-property-accent {\n          fill: #f1f1f1;\n          stroke: #f1f1f1; }\n      .button.hollow.secondary:hover .iconic *, button.hollow.secondary:hover .iconic * {\n        fill: whitesmoke;\n        stroke: whitesmoke; }\n        .button.hollow.secondary:hover .iconic *.iconic-property-accent, button.hollow.secondary:hover .iconic *.iconic-property-accent {\n          fill: whitesmoke;\n          stroke: whitesmoke; }\n    .button.hollow.success, button.hollow.success {\n      border: 1px solid #43AC6A;\n      background: transparent;\n      color: #43AC6A; }\n      .button.hollow.success:hover, button.hollow.success:hover, .button.hollow.success:focus, button.hollow.success:focus {\n        border-color: #6dc68e;\n        background: transparent;\n        color: #6dc68e; }\n      .button.hollow.success .iconic *, button.hollow.success .iconic * {\n        fill: #43AC6A;\n        stroke: #43AC6A; }\n        .button.hollow.success .iconic *.iconic-property-accent, button.hollow.success .iconic *.iconic-property-accent {\n          fill: #43AC6A;\n          stroke: #43AC6A; }\n      .button.hollow.success:hover .iconic *, button.hollow.success:hover .iconic * {\n        fill: #6dc68e;\n        stroke: #6dc68e; }\n        .button.hollow.success:hover .iconic *.iconic-property-accent, button.hollow.success:hover .iconic *.iconic-property-accent {\n          fill: #6dc68e;\n          stroke: #6dc68e; }\n    .button.hollow.warning, button.hollow.warning {\n      border: 1px solid #F08A24;\n      background: transparent;\n      color: #F08A24; }\n      .button.hollow.warning:hover, button.hollow.warning:hover, .button.hollow.warning:focus, button.hollow.warning:focus {\n        border-color: #f4a75b;\n        background: transparent;\n        color: #f4a75b; }\n      .button.hollow.warning .iconic *, button.hollow.warning .iconic * {\n        fill: #F08A24;\n        stroke: #F08A24; }\n        .button.hollow.warning .iconic *.iconic-property-accent, button.hollow.warning .iconic *.iconic-property-accent {\n          fill: #F08A24;\n          stroke: #F08A24; }\n      .button.hollow.warning:hover .iconic *, button.hollow.warning:hover .iconic * {\n        fill: #f4a75b;\n        stroke: #f4a75b; }\n        .button.hollow.warning:hover .iconic *.iconic-property-accent, button.hollow.warning:hover .iconic *.iconic-property-accent {\n          fill: #f4a75b;\n          stroke: #f4a75b; }\n    .button.hollow.alert, button.hollow.alert {\n      border: 1px solid #F04124;\n      background: transparent;\n      color: #F04124; }\n      .button.hollow.alert:hover, button.hollow.alert:hover, .button.hollow.alert:focus, button.hollow.alert:focus {\n        border-color: #f4715b;\n        background: transparent;\n        color: #f4715b; }\n      .button.hollow.alert .iconic *, button.hollow.alert .iconic * {\n        fill: #F04124;\n        stroke: #F04124; }\n        .button.hollow.alert .iconic *.iconic-property-accent, button.hollow.alert .iconic *.iconic-property-accent {\n          fill: #F04124;\n          stroke: #F04124; }\n      .button.hollow.alert:hover .iconic *, button.hollow.alert:hover .iconic * {\n        fill: #f4715b;\n        stroke: #f4715b; }\n        .button.hollow.alert:hover .iconic *.iconic-property-accent, button.hollow.alert:hover .iconic *.iconic-property-accent {\n          fill: #f4715b;\n          stroke: #f4715b; }\n    .button.hollow.info, button.hollow.info {\n      border: 1px solid #A0D3E8;\n      background: transparent;\n      color: #A0D3E8; }\n      .button.hollow.info:hover, button.hollow.info:hover, .button.hollow.info:focus, button.hollow.info:focus {\n        border-color: #b8deee;\n        background: transparent;\n        color: #b8deee; }\n      .button.hollow.info .iconic *, button.hollow.info .iconic * {\n        fill: #A0D3E8;\n        stroke: #A0D3E8; }\n        .button.hollow.info .iconic *.iconic-property-accent, button.hollow.info .iconic *.iconic-property-accent {\n          fill: #A0D3E8;\n          stroke: #A0D3E8; }\n      .button.hollow.info:hover .iconic *, button.hollow.info:hover .iconic * {\n        fill: #b8deee;\n        stroke: #b8deee; }\n        .button.hollow.info:hover .iconic *.iconic-property-accent, button.hollow.info:hover .iconic *.iconic-property-accent {\n          fill: #b8deee;\n          stroke: #b8deee; }\n    .button.hollow.dark, button.hollow.dark {\n      border: 1px solid #232323;\n      background: transparent;\n      color: #232323; }\n      .button.hollow.dark:hover, button.hollow.dark:hover, .button.hollow.dark:focus, button.hollow.dark:focus {\n        border-color: #5a5a5a;\n        background: transparent;\n        color: #5a5a5a; }\n      .button.hollow.dark .iconic *, button.hollow.dark .iconic * {\n        fill: #232323;\n        stroke: #232323; }\n        .button.hollow.dark .iconic *.iconic-property-accent, button.hollow.dark .iconic *.iconic-property-accent {\n          fill: #232323;\n          stroke: #232323; }\n      .button.hollow.dark:hover .iconic *, button.hollow.dark:hover .iconic * {\n        fill: #5a5a5a;\n        stroke: #5a5a5a; }\n        .button.hollow.dark:hover .iconic *.iconic-property-accent, button.hollow.dark:hover .iconic *.iconic-property-accent {\n          fill: #5a5a5a;\n          stroke: #5a5a5a; }\n  .button.disabled, button.disabled {\n    opacity: 0.5;\n    cursor: default;\n    pointer-events: none; }\n\n.button-group {\n  margin: 0;\n  margin-bottom: 1rem;\n  list-style-type: none;\n  display: -webkit-inline-box;\n  display: -ms-inline-flexbox;\n  display: inline-flex;\n  border-radius: 0;\n  overflow: hidden;\n  font-size: 0.9rem; }\n  .button-group > li {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 auto;\n            flex: 0 0 auto; }\n    .button-group > li > a, .button-group > li > label, .button-group > li > button {\n      border-radius: 0;\n      font-size: inherit;\n      display: block;\n      margin: 0; }\n    .button-group > li > input + label {\n      margin-left: 0; }\n    .button-group > li:not(:last-child) > a, .button-group > li:not(:last-child) > label, .button-group > li:not(:last-child) > button {\n      border-right: 1px solid #004068; }\n  .button-group .iconic {\n    width: 1em;\n    height: 1em;\n    vertical-align: middle;\n    margin-right: 0.25em;\n    margin-top: -2px; }\n\n.button-group.segmented, .button-group.segmented.secondary, .button-group.segmented.success, .button-group.segmented.warning, .button-group.segmented.alert {\n  border: 1px solid #00558b;\n  -webkit-transition-property: background color;\n  transition-property: background color; }\n  .button-group.segmented > li > input[type=\"radio\"] {\n    position: absolute;\n    left: -9999px; }\n  .button-group.segmented > li > a, .button-group.segmented.secondary > li > a, .button-group.segmented.success > li > a, .button-group.segmented.warning > li > a, .button-group.segmented.alert > li > a, .button-group.segmented > li > label, .button-group.segmented.secondary > li > label, .button-group.segmented.success > li > label, .button-group.segmented.warning > li > label, .button-group.segmented.alert > li > label, .button-group.segmented > li > button, .button-group.segmented.secondary > li > button, .button-group.segmented.success > li > button, .button-group.segmented.warning > li > button, .button-group.segmented.alert > li > button {\n    margin-right: 0;\n    background: transparent; }\n\n.button-group {\n  display: -webkit-inline-box;\n  display: -ms-inline-flexbox;\n  display: inline-flex;\n  border-radius: 0; }\n  .button-group > li {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 auto;\n            flex: 0 0 auto; }\n  .button-group > li > a, .button-group > li > label, .button-group > li > button {\n    background: #00558b;\n    color: #fff;\n    border-color: #004876; }\n    .button-group > li > a:hover, .button-group > li > a:focus, .button-group > li > label:hover, .button-group > li > label:focus, .button-group > li > button:hover, .button-group > li > button:focus {\n      background: #004876;\n      color: #fff; }\n    .button-group > li > a .iconic *, .button-group > li > label .iconic *, .button-group > li > button .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group > li > a .iconic *.iconic-property-accent, .button-group > li > label .iconic *.iconic-property-accent, .button-group > li > button .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button-group > li.is-active > a, .button-group > li.is-active > label, .button-group > li.is-active > button {\n    background: #004876; }\n  .button-group.secondary > li > a, .button-group.secondary > li > label, .button-group.secondary > li > button {\n    background: #f1f1f1;\n    color: #000;\n    border-color: #cdcdcd; }\n    .button-group.secondary > li > a:hover, .button-group.secondary > li > a:focus, .button-group.secondary > li > label:hover, .button-group.secondary > li > label:focus, .button-group.secondary > li > button:hover, .button-group.secondary > li > button:focus {\n      background: #cdcdcd;\n      color: #000; }\n    .button-group.secondary > li > a .iconic *, .button-group.secondary > li > label .iconic *, .button-group.secondary > li > button .iconic * {\n      fill: #000;\n      stroke: #000; }\n      .button-group.secondary > li > a .iconic *.iconic-property-accent, .button-group.secondary > li > label .iconic *.iconic-property-accent, .button-group.secondary > li > button .iconic *.iconic-property-accent {\n        fill: #000;\n        stroke: #000; }\n  .button-group.secondary > li.is-active > a, .button-group.secondary > li.is-active > label, .button-group.secondary > li.is-active > button {\n    background: #cdcdcd; }\n  .button-group.success > li > a, .button-group.success > li > label, .button-group.success > li > button {\n    background: #43AC6A;\n    color: #fff;\n    border-color: #39925a; }\n    .button-group.success > li > a:hover, .button-group.success > li > a:focus, .button-group.success > li > label:hover, .button-group.success > li > label:focus, .button-group.success > li > button:hover, .button-group.success > li > button:focus {\n      background: #39925a;\n      color: #fff; }\n    .button-group.success > li > a .iconic *, .button-group.success > li > label .iconic *, .button-group.success > li > button .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group.success > li > a .iconic *.iconic-property-accent, .button-group.success > li > label .iconic *.iconic-property-accent, .button-group.success > li > button .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button-group.success > li.is-active > a, .button-group.success > li.is-active > label, .button-group.success > li.is-active > button {\n    background: #39925a; }\n  .button-group.warning > li > a, .button-group.warning > li > label, .button-group.warning > li > button {\n    background: #F08A24;\n    color: #fff;\n    border-color: #dc750f; }\n    .button-group.warning > li > a:hover, .button-group.warning > li > a:focus, .button-group.warning > li > label:hover, .button-group.warning > li > label:focus, .button-group.warning > li > button:hover, .button-group.warning > li > button:focus {\n      background: #dc750f;\n      color: #fff; }\n    .button-group.warning > li > a .iconic *, .button-group.warning > li > label .iconic *, .button-group.warning > li > button .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group.warning > li > a .iconic *.iconic-property-accent, .button-group.warning > li > label .iconic *.iconic-property-accent, .button-group.warning > li > button .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button-group.warning > li.is-active > a, .button-group.warning > li.is-active > label, .button-group.warning > li.is-active > button {\n    background: #dc750f; }\n  .button-group.alert > li > a, .button-group.alert > li > label, .button-group.alert > li > button {\n    background: #F04124;\n    color: #fff;\n    border-color: #dc2c0f; }\n    .button-group.alert > li > a:hover, .button-group.alert > li > a:focus, .button-group.alert > li > label:hover, .button-group.alert > li > label:focus, .button-group.alert > li > button:hover, .button-group.alert > li > button:focus {\n      background: #dc2c0f;\n      color: #fff; }\n    .button-group.alert > li > a .iconic *, .button-group.alert > li > label .iconic *, .button-group.alert > li > button .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group.alert > li > a .iconic *.iconic-property-accent, .button-group.alert > li > label .iconic *.iconic-property-accent, .button-group.alert > li > button .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button-group.alert > li.is-active > a, .button-group.alert > li.is-active > label, .button-group.alert > li.is-active > button {\n    background: #dc2c0f; }\n  .button-group > li.secondary > a, .button-group > li.secondary > label, .button-group > li.secondary > button {\n    background: #f1f1f1;\n    color: #000;\n    border-color: #f1f1f1; }\n    .button-group > li.secondary > a:hover, .button-group > li.secondary > a:focus, .button-group > li.secondary > label:hover, .button-group > li.secondary > label:focus, .button-group > li.secondary > button:hover, .button-group > li.secondary > button:focus {\n      background: #cdcdcd;\n      color: #000; }\n    .button-group > li.secondary > a:hover, .button-group > li.secondary > a:focus, .button-group > li.secondary > label:hover, .button-group > li.secondary > label:focus, .button-group > li.secondary > button:hover, .button-group > li.secondary > button:focus {\n      border-color: #b5b5b5; }\n    .button-group > li.secondary > a .iconic *, .button-group > li.secondary > label .iconic *, .button-group > li.secondary > button .iconic * {\n      fill: #000;\n      stroke: #000; }\n      .button-group > li.secondary > a .iconic *.iconic-property-accent, .button-group > li.secondary > label .iconic *.iconic-property-accent, .button-group > li.secondary > button .iconic *.iconic-property-accent {\n        fill: #000;\n        stroke: #000; }\n  .button-group > li.success > a, .button-group > li.success > label, .button-group > li.success > button {\n    background: #43AC6A;\n    color: #fff;\n    border-color: #43AC6A; }\n    .button-group > li.success > a:hover, .button-group > li.success > a:focus, .button-group > li.success > label:hover, .button-group > li.success > label:focus, .button-group > li.success > button:hover, .button-group > li.success > button:focus {\n      background: #39925a;\n      color: #fff; }\n    .button-group > li.success > a:hover, .button-group > li.success > a:focus, .button-group > li.success > label:hover, .button-group > li.success > label:focus, .button-group > li.success > button:hover, .button-group > li.success > button:focus {\n      border-color: #328150; }\n    .button-group > li.success > a .iconic *, .button-group > li.success > label .iconic *, .button-group > li.success > button .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group > li.success > a .iconic *.iconic-property-accent, .button-group > li.success > label .iconic *.iconic-property-accent, .button-group > li.success > button .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button-group > li.warning > a, .button-group > li.warning > label, .button-group > li.warning > button {\n    background: #F08A24;\n    color: #fff;\n    border-color: #F08A24; }\n    .button-group > li.warning > a:hover, .button-group > li.warning > a:focus, .button-group > li.warning > label:hover, .button-group > li.warning > label:focus, .button-group > li.warning > button:hover, .button-group > li.warning > button:focus {\n      background: #dc750f;\n      color: #fff; }\n    .button-group > li.warning > a:hover, .button-group > li.warning > a:focus, .button-group > li.warning > label:hover, .button-group > li.warning > label:focus, .button-group > li.warning > button:hover, .button-group > li.warning > button:focus {\n      border-color: #c2680d; }\n    .button-group > li.warning > a .iconic *, .button-group > li.warning > label .iconic *, .button-group > li.warning > button .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group > li.warning > a .iconic *.iconic-property-accent, .button-group > li.warning > label .iconic *.iconic-property-accent, .button-group > li.warning > button .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button-group > li.alert > a, .button-group > li.alert > label, .button-group > li.alert > button {\n    background: #F04124;\n    color: #fff;\n    border-color: #F04124; }\n    .button-group > li.alert > a:hover, .button-group > li.alert > a:focus, .button-group > li.alert > label:hover, .button-group > li.alert > label:focus, .button-group > li.alert > button:hover, .button-group > li.alert > button:focus {\n      background: #dc2c0f;\n      color: #fff; }\n    .button-group > li.alert > a:hover, .button-group > li.alert > a:focus, .button-group > li.alert > label:hover, .button-group > li.alert > label:focus, .button-group > li.alert > button:hover, .button-group > li.alert > button:focus {\n      border-color: #c2270d; }\n    .button-group > li.alert > a .iconic *, .button-group > li.alert > label .iconic *, .button-group > li.alert > button .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group > li.alert > a .iconic *.iconic-property-accent, .button-group > li.alert > label .iconic *.iconic-property-accent, .button-group > li.alert > button .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .button-group.segmented {\n    border-color: #00558b; }\n    .button-group.segmented > li > a, .button-group.segmented > li > label, .button-group.segmented > li > button {\n      border-color: #00558b;\n      color: #00558b; }\n      .button-group.segmented > li > a:hover, .button-group.segmented > li > label:hover, .button-group.segmented > li > button:hover {\n        background: rgba(0, 85, 139, 0.25);\n        color: #00558b; }\n      .button-group.segmented > li > a .iconic *, .button-group.segmented > li > label .iconic *, .button-group.segmented > li > button .iconic * {\n        fill: #00558b;\n        stroke: #00558b; }\n        .button-group.segmented > li > a .iconic *.iconic-property-accent, .button-group.segmented > li > label .iconic *.iconic-property-accent, .button-group.segmented > li > button .iconic *.iconic-property-accent {\n          fill: #00558b;\n          stroke: #00558b; }\n    .button-group.segmented > li.is-active > a, .button-group.segmented > li.is-active > a:hover, .button-group.segmented > li > input:checked + label, .button-group.segmented > li > input:checked + label:hover {\n      background: #00558b;\n      color: #fff; }\n    .button-group.segmented > li.is-active > a .iconic *, .button-group.segmented > li > input:checked + label .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .button-group.segmented > li.is-active > a .iconic *.iconic-property-accent, .button-group.segmented > li > input:checked + label .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n    .button-group.segmented.secondary {\n      border-color: #f1f1f1; }\n      .button-group.segmented.secondary > li > a, .button-group.segmented.secondary > li > label, .button-group.segmented.secondary > li > button {\n        border-color: #f1f1f1;\n        color: #f1f1f1; }\n        .button-group.segmented.secondary > li > a:hover, .button-group.segmented.secondary > li > label:hover, .button-group.segmented.secondary > li > button:hover {\n          background: rgba(241, 241, 241, 0.25);\n          color: #f1f1f1; }\n        .button-group.segmented.secondary > li > a .iconic *, .button-group.segmented.secondary > li > label .iconic *, .button-group.segmented.secondary > li > button .iconic * {\n          fill: #f1f1f1;\n          stroke: #f1f1f1; }\n          .button-group.segmented.secondary > li > a .iconic *.iconic-property-accent, .button-group.segmented.secondary > li > label .iconic *.iconic-property-accent, .button-group.segmented.secondary > li > button .iconic *.iconic-property-accent {\n            fill: #f1f1f1;\n            stroke: #f1f1f1; }\n      .button-group.segmented.secondary > li.is-active > a, .button-group.segmented.secondary > li.is-active > a:hover, .button-group.segmented.secondary > li > input:checked + label, .button-group.segmented.secondary > li > input:checked + label:hover {\n        background: #f1f1f1;\n        color: #000; }\n      .button-group.segmented.secondary > li.is-active > a .iconic *, .button-group.segmented.secondary > li > input:checked + label .iconic * {\n        fill: #000;\n        stroke: #000; }\n        .button-group.segmented.secondary > li.is-active > a .iconic *.iconic-property-accent, .button-group.segmented.secondary > li > input:checked + label .iconic *.iconic-property-accent {\n          fill: #000;\n          stroke: #000; }\n    .button-group.segmented.success {\n      border-color: #43AC6A; }\n      .button-group.segmented.success > li > a, .button-group.segmented.success > li > label, .button-group.segmented.success > li > button {\n        border-color: #43AC6A;\n        color: #43AC6A; }\n        .button-group.segmented.success > li > a:hover, .button-group.segmented.success > li > label:hover, .button-group.segmented.success > li > button:hover {\n          background: rgba(67, 172, 106, 0.25);\n          color: #43AC6A; }\n        .button-group.segmented.success > li > a .iconic *, .button-group.segmented.success > li > label .iconic *, .button-group.segmented.success > li > button .iconic * {\n          fill: #43AC6A;\n          stroke: #43AC6A; }\n          .button-group.segmented.success > li > a .iconic *.iconic-property-accent, .button-group.segmented.success > li > label .iconic *.iconic-property-accent, .button-group.segmented.success > li > button .iconic *.iconic-property-accent {\n            fill: #43AC6A;\n            stroke: #43AC6A; }\n      .button-group.segmented.success > li.is-active > a, .button-group.segmented.success > li.is-active > a:hover, .button-group.segmented.success > li > input:checked + label, .button-group.segmented.success > li > input:checked + label:hover {\n        background: #43AC6A;\n        color: #fff; }\n      .button-group.segmented.success > li.is-active > a .iconic *, .button-group.segmented.success > li > input:checked + label .iconic * {\n        fill: #fff;\n        stroke: #fff; }\n        .button-group.segmented.success > li.is-active > a .iconic *.iconic-property-accent, .button-group.segmented.success > li > input:checked + label .iconic *.iconic-property-accent {\n          fill: #fff;\n          stroke: #fff; }\n    .button-group.segmented.warning {\n      border-color: #F08A24; }\n      .button-group.segmented.warning > li > a, .button-group.segmented.warning > li > label, .button-group.segmented.warning > li > button {\n        border-color: #F08A24;\n        color: #F08A24; }\n        .button-group.segmented.warning > li > a:hover, .button-group.segmented.warning > li > label:hover, .button-group.segmented.warning > li > button:hover {\n          background: rgba(240, 138, 36, 0.25);\n          color: #F08A24; }\n        .button-group.segmented.warning > li > a .iconic *, .button-group.segmented.warning > li > label .iconic *, .button-group.segmented.warning > li > button .iconic * {\n          fill: #F08A24;\n          stroke: #F08A24; }\n          .button-group.segmented.warning > li > a .iconic *.iconic-property-accent, .button-group.segmented.warning > li > label .iconic *.iconic-property-accent, .button-group.segmented.warning > li > button .iconic *.iconic-property-accent {\n            fill: #F08A24;\n            stroke: #F08A24; }\n      .button-group.segmented.warning > li.is-active > a, .button-group.segmented.warning > li.is-active > a:hover, .button-group.segmented.warning > li > input:checked + label, .button-group.segmented.warning > li > input:checked + label:hover {\n        background: #F08A24;\n        color: #fff; }\n      .button-group.segmented.warning > li.is-active > a .iconic *, .button-group.segmented.warning > li > input:checked + label .iconic * {\n        fill: #fff;\n        stroke: #fff; }\n        .button-group.segmented.warning > li.is-active > a .iconic *.iconic-property-accent, .button-group.segmented.warning > li > input:checked + label .iconic *.iconic-property-accent {\n          fill: #fff;\n          stroke: #fff; }\n    .button-group.segmented.alert {\n      border-color: #F04124; }\n      .button-group.segmented.alert > li > a, .button-group.segmented.alert > li > label, .button-group.segmented.alert > li > button {\n        border-color: #F04124;\n        color: #F04124; }\n        .button-group.segmented.alert > li > a:hover, .button-group.segmented.alert > li > label:hover, .button-group.segmented.alert > li > button:hover {\n          background: rgba(240, 65, 36, 0.25);\n          color: #F04124; }\n        .button-group.segmented.alert > li > a .iconic *, .button-group.segmented.alert > li > label .iconic *, .button-group.segmented.alert > li > button .iconic * {\n          fill: #F04124;\n          stroke: #F04124; }\n          .button-group.segmented.alert > li > a .iconic *.iconic-property-accent, .button-group.segmented.alert > li > label .iconic *.iconic-property-accent, .button-group.segmented.alert > li > button .iconic *.iconic-property-accent {\n            fill: #F04124;\n            stroke: #F04124; }\n      .button-group.segmented.alert > li.is-active > a, .button-group.segmented.alert > li.is-active > a:hover, .button-group.segmented.alert > li > input:checked + label, .button-group.segmented.alert > li > input:checked + label:hover {\n        background: #F04124;\n        color: #fff; }\n      .button-group.segmented.alert > li.is-active > a .iconic *, .button-group.segmented.alert > li > input:checked + label .iconic * {\n        fill: #fff;\n        stroke: #fff; }\n        .button-group.segmented.alert > li.is-active > a .iconic *.iconic-property-accent, .button-group.segmented.alert > li > input:checked + label .iconic *.iconic-property-accent {\n          fill: #fff;\n          stroke: #fff; }\n  .button-group.tiny {\n    font-size: 0.63rem; }\n  .button-group.small {\n    font-size: 0.72rem; }\n  .button-group.large {\n    font-size: 1.17rem; }\n  .button-group.expand {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n    .button-group.expand > li {\n      -webkit-box-flex: 1;\n          -ms-flex: 1;\n              flex: 1; }\n      .button-group.expand > li > a, .button-group.expand > li > label, .button-group.expand > li > button {\n        display: block;\n        width: 100%;\n        margin-left: 0;\n        margin-right: 0; }\n  .button-group li.disabled > a, .button-group li.disabled > label, .button-group li.disabled > button {\n    opacity: 0.5;\n    cursor: default;\n    pointer-events: none; }\n\n/*\r\n  Cards\r\n\r\n  Structure:\r\n\r\n  titles\r\n  lists\r\n*/\n.card {\n  border: 1px solid #ededed;\n  margin-bottom: 0.5rem;\n  background: #fff;\n  color: #000;\n  border-radius: 4px;\n  box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);\n  overflow: hidden; }\n  .card h1, .card h2, .card h3, .card h4, .card h5, .card h6 {\n    color: inherit; }\n  .card ul {\n    margin-bottom: 0; }\n  .card img {\n    width: 100%; }\n  .card.primary {\n    border: 0;\n    margin-bottom: 0.5rem;\n    background: #00558b;\n    color: #fff;\n    border-radius: 4px;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);\n    overflow: hidden; }\n    .card.primary h1, .card.primary h2, .card.primary h3, .card.primary h4, .card.primary h5, .card.primary h6 {\n      color: inherit; }\n    .card.primary ul {\n      margin-bottom: 0; }\n    .card.primary img {\n      width: 100%; }\n    .card.primary .card-divider {\n      background: #0065a5;\n      padding: 1rem; }\n  .card.success {\n    border: 0;\n    margin-bottom: 0.5rem;\n    background: #43AC6A;\n    color: #fff;\n    border-radius: 4px;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);\n    overflow: hidden; }\n    .card.success h1, .card.success h2, .card.success h3, .card.success h4, .card.success h5, .card.success h6 {\n      color: inherit; }\n    .card.success ul {\n      margin-bottom: 0; }\n    .card.success img {\n      width: 100%; }\n    .card.success .card-divider {\n      background: #4ab873;\n      padding: 1rem; }\n  .card.warning {\n    border: 0;\n    margin-bottom: 0.5rem;\n    background: #F08A24;\n    color: #fff;\n    border-radius: 4px;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);\n    overflow: hidden; }\n    .card.warning h1, .card.warning h2, .card.warning h3, .card.warning h4, .card.warning h5, .card.warning h6 {\n      color: inherit; }\n    .card.warning ul {\n      margin-bottom: 0; }\n    .card.warning img {\n      width: 100%; }\n    .card.warning .card-divider {\n      background: #f19233;\n      padding: 1rem; }\n  .card.alert {\n    border: 0;\n    margin-bottom: 0.5rem;\n    background: #F04124;\n    color: #fff;\n    border-radius: 4px;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);\n    overflow: hidden; }\n    .card.alert h1, .card.alert h2, .card.alert h3, .card.alert h4, .card.alert h5, .card.alert h6 {\n      color: inherit; }\n    .card.alert ul {\n      margin-bottom: 0; }\n    .card.alert img {\n      width: 100%; }\n    .card.alert .card-divider {\n      background: #f14e33;\n      padding: 1rem; }\n  .card.dark {\n    border: 0;\n    margin-bottom: 0.5rem;\n    background: #232323;\n    color: #fff;\n    border-radius: 4px;\n    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);\n    overflow: hidden; }\n    .card.dark h1, .card.dark h2, .card.dark h3, .card.dark h4, .card.dark h5, .card.dark h6 {\n      color: inherit; }\n    .card.dark ul {\n      margin-bottom: 0; }\n    .card.dark img {\n      width: 100%; }\n    .card.dark .card-divider {\n      background: #323232;\n      padding: 1rem; }\n\n.card-divider {\n  background: #ededed;\n  padding: 1rem; }\n\n.card-section {\n  padding: 1rem; }\n\n/*\n  Odds and ends.\n*/\n.close-button {\n  position: absolute;\n  color: #999;\n  top: 1rem;\n  right: 1rem;\n  font-size: 2em;\n  line-height: 0.5;\n  cursor: pointer; }\n  .close-button:hover {\n    color: #333; }\n\n.thumbnail, ul.thumbnails > li img {\n  padding: 0.5rem;\n  box-shadow: 0 3px 15px rgba(0, 0, 0, 0.25); }\n\nul.thumbnails > li {\n  margin-bottom: 1rem; }\n  ul.thumbnails > li a {\n    display: block; }\n\n/*\n  FORMS\n  -----\n\n  Our form styles include basic resets for text fields, select menus, and so on, along with some of our own custom components.\n\n  Includes:\n   - Text fields\n   - Text areas\n   - Select menus\n   - Checkboxes and radio buttons\n   - Range slider\n   - Progress bars and meters\n*/\ninput[type=\"text\"], input[type=\"password\"], input[type=\"date\"], input[type=\"datetime\"], input[type=\"datetime-local\"], input[type=\"month\"], input[type=\"week\"], input[type=\"email\"], input[type=\"number\"], input[type=\"search\"], input[type=\"tel\"], input[type=\"time\"], input[type=\"url\"], input[type=\"color\"], textarea {\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  display: block;\n  width: 100%;\n  height: 2.4rem;\n  padding: 0.5rem;\n  margin: 0 0 1rem 0;\n  border: 1px solid #ccc;\n  border-radius: 0;\n  background: #fff;\n  color: #000;\n  font-size: 1rem;\n  -webkit-font-smoothing: antialiased;\n  vertical-align: middle; }\n  input[type=\"text\"]:hover, input[type=\"password\"]:hover, input[type=\"date\"]:hover, input[type=\"datetime\"]:hover, input[type=\"datetime-local\"]:hover, input[type=\"month\"]:hover, input[type=\"week\"]:hover, input[type=\"email\"]:hover, input[type=\"number\"]:hover, input[type=\"search\"]:hover, input[type=\"tel\"]:hover, input[type=\"time\"]:hover, input[type=\"url\"]:hover, input[type=\"color\"]:hover, textarea:hover {\n    border: 1px solid #bbb;\n    background: #fff;\n    color: #000; }\n  input[type=\"text\"]:focus, input[type=\"password\"]:focus, input[type=\"date\"]:focus, input[type=\"datetime\"]:focus, input[type=\"datetime-local\"]:focus, input[type=\"month\"]:focus, input[type=\"week\"]:focus, input[type=\"email\"]:focus, input[type=\"number\"]:focus, input[type=\"search\"]:focus, input[type=\"tel\"]:focus, input[type=\"time\"]:focus, input[type=\"url\"]:focus, input[type=\"color\"]:focus, textarea:focus {\n    outline: 0;\n    border: 1px solid #999;\n    background: #fff;\n    color: #000; }\n  label > input[type=\"text\"], label > input[type=\"password\"], label > input[type=\"date\"], label > input[type=\"datetime\"], label > input[type=\"datetime-local\"], label > input[type=\"month\"], label > input[type=\"week\"], label > input[type=\"email\"], label > input[type=\"number\"], label > input[type=\"search\"], label > input[type=\"tel\"], label > input[type=\"time\"], label > input[type=\"url\"], label > input[type=\"color\"], label > textarea {\n    margin-top: 0.5rem; }\n\ninput[type=\"search\"] {\n  box-sizing: border-box; }\n\ninput.disabled, input[disabled], input[readonly], fieldset[disabled] input, textarea.disabled, textarea[disabled], textarea[readonly], fieldset[disabled] textarea {\n  cursor: not-allowed; }\n  input.disabled, input.disabled:hover, input[disabled], input[disabled]:hover, input[readonly], input[readonly]:hover, fieldset[disabled] input, fieldset[disabled] input:hover, textarea.disabled, textarea.disabled:hover, textarea[disabled], textarea[disabled]:hover, textarea[readonly], textarea[readonly]:hover, fieldset[disabled] textarea, fieldset[disabled] textarea:hover {\n    background-color: #f2f2f2; }\n\nlabel {\n  display: block;\n  font-size: 0.9rem;\n  margin-bottom: 0.5rem;\n  color: #333; }\n  label > input, label > textarea {\n    margin-top: 0.5rem; }\n\ninput[type=\"checkbox\"], input[type=\"radio\"] {\n  width: 1rem;\n  height: 1rem; }\n  label > input[type=\"checkbox\"], label > input[type=\"radio\"] {\n    margin-right: 0.25rem; }\n  input[type=\"checkbox\"] + label, input[type=\"radio\"] + label {\n    display: inline-block;\n    margin-left: 0.5rem;\n    margin-right: 1rem;\n    margin-bottom: 0;\n    vertical-align: baseline; }\n\n.inline-label {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -ms-flex-flow: row nowrap;\n      flex-flow: row nowrap;\n  -webkit-box-align: stretch;\n      -ms-flex-align: stretch;\n          align-items: stretch;\n  margin-bottom: 1rem; }\n  label > .inline-label {\n    margin-top: 0.5rem; }\n  .inline-label > input, .inline-label > select {\n    -webkit-box-flex: 1;\n        -ms-flex: 1;\n            flex: 1;\n    margin: 0; }\n  .inline-label > .form-label {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 auto;\n            flex: 0 0 auto;\n    background: #eee;\n    color: #333;\n    border: 1px solid #ccc;\n    padding: 0 0.5rem;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    .inline-label > .form-label:first-child {\n      border-right: 0; }\n    .inline-label > .form-label:last-child {\n      border-left: 0; }\n  .inline-label > a, .inline-label > button, .inline-label > input[type=\"button\"], .inline-label > input[type=\"submit\"] {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 auto;\n            flex: 0 0 auto;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    padding-top: 0;\n    padding-bottom: 0;\n    margin: 0;\n    border-radius: 0; }\n\ntextarea {\n  height: auto;\n  width: 100%;\n  min-height: 50px; }\n\nselect {\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  display: block;\n  width: 100%;\n  height: 2.4rem;\n  padding: 0.5rem;\n  margin: 0 0 1rem 0;\n  font-size: 1rem;\n  color: #000;\n  border-radius: 0;\n  border: 1px solid #ccc;\n  background: #fafafa url(\"data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20version%3D%221.1%22%20width%3D%2232%22%20height%3D%2224%22%20viewBox%3D%220%200%2032%2024%22%3E%3Cpolygon%20points%3D%220%2C0%2032%2C0%2016%2C24%22%20style%3D%22fill%3A%20black%22%3E%3C/polygon%3E%3C/svg%3E\") right 10px center no-repeat;\n  background-size: 8px 8px;\n  padding-right: 1.625rem; }\n  select:hover {\n    background-color: #f0f0f0; }\n  select:focus {\n    outline: 0; }\n  select::-ms-expand {\n    display: none; }\n\ninput[type=\"range\"] {\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  display: block;\n  width: 100%;\n  height: auto;\n  cursor: pointer;\n  margin-top: 0.25rem;\n  margin-bottom: 0.25rem;\n  border: 0;\n  line-height: 1; }\n  input[type=\"range\"]:focus {\n    outline: 0; }\n  input[type=\"range\"]::-webkit-slider-runnable-track {\n    height: 1rem;\n    background: #ddd; }\n  input[type=\"range\"]::-webkit-slider-thumb {\n    -webkit-appearance: none;\n    background: #00558b;\n    width: 1.5rem;\n    height: 1.5rem;\n    margin-top: -0.25rem; }\n  input[type=\"range\"]::-moz-range-track {\n    -moz-appearance: none;\n    height: 1rem;\n    background: #ccc; }\n  input[type=\"range\"]::-moz-range-thumb {\n    -moz-appearance: none;\n    background: #00558b;\n    width: 1.5rem;\n    height: 1.5rem;\n    margin-top: -0.25rem; }\n  input[type=\"range\"]::-ms-track {\n    height: 1rem;\n    background: #ddd;\n    color: transparent;\n    border: 0;\n    overflow: visible;\n    border-top: 0.25rem solid #fff;\n    border-bottom: 0.25rem solid #fff; }\n  input[type=\"range\"]::-ms-thumb {\n    background: #00558b;\n    width: 1.5rem;\n    height: 1.5rem;\n    border: 0; }\n  input[type=\"range\"]::-ms-fill-lower, input[type=\"range\"]::-ms-fill-upper {\n    background: #ddd; }\n\noutput {\n  line-height: 1.5rem;\n  vertical-align: middle;\n  margin-left: 0.5em; }\n\ninput[type=\"number\"]::-webkit-outer-spin-button {\n  -webkit-appearance: none;\n  background: #00558b; }\n\nprogress, meter {\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  display: block;\n  width: 100%;\n  height: 1.5rem;\n  margin-bottom: 1rem;\n  background: #ccc;\n  border: 0; }\n\nprogress::-webkit-progress-bar {\n  background: #ccc; }\n\nprogress::-webkit-progress-value {\n  background: #00558b; }\n\nprogress::-moz-progress-bar {\n  background: #00558b; }\n\nprogress.high::-webkit-progress-value {\n  background: #43AC6A; }\n\nprogress.high::-moz-progress-bar {\n  background: #43AC6A; }\n\nprogress.medium::-webkit-progress-value {\n  background: #e7cf00; }\n\nprogress.medium::-moz-progress-bar {\n  background: #e7cf00; }\n\nprogress.low::-webkit-progress-value {\n  background: #F04124; }\n\nprogress.low::-moz-progress-bar {\n  background: #F04124; }\n\nmeter {\n  background: #ccc; }\n  meter::-webkit-meter-bar {\n    background: #ccc; }\n  meter::-webkit-meter-optimum-value {\n    background: #43AC6A; }\n  meter::-webkit-meter-suboptimum-value {\n    background: #e7cf00; }\n  meter::-webkit-meter-even-less-good-value {\n    background: #F04124; }\n  meter::-moz-meter-bar {\n    background: #00558b; }\n  meter:-moz-meter-optimum::-moz-meter-bar {\n    background: #43AC6A; }\n  meter:-moz-meter-sub-optimum::-moz-meter-bar {\n    background: #e7cf00; }\n  meter:-moz-meter-sub-sub-optimum::-moz-meter-bar {\n    background: #F04124; }\n\n/*\n  PANEL\n  -----\n\n  The friendly panel is an all-purpose container for hiding content off-screen.\n\n  Features:\n   - Position at top, right, bottom, or left\n   - Anchor to grid block or window\n   - Define max width or height\n   - Transform into grid block depending on screen size\n*/\n.panel {\n  position: absolute;\n  z-index: 100;\n  overflow-y: auto;\n  display: none; }\n  .is-active.panel {\n    display: block; }\n\n.panel {\n  /*\n    Basic styles\n  */\n  padding: 0;\n  background: #fff; }\n\n.panel-top {\n  /*\n    Direction\n  */\n  top: 0;\n  left: 0;\n  width: 100%;\n  /*\n    Sizing\n  */\n  height: 300px;\n  /*\n    Shadows\n  */ }\n  .panel-top.is-active {\n    box-shadow: 0 3px 10px rgba(0, 0, 0, 0.25); }\n\n.panel-right {\n  /*\n    Direction\n  */\n  top: 0;\n  right: 0;\n  height: 100%;\n  /*\n    Sizing\n  */\n  width: 100%;\n  /*\n    Shadows\n  */ }\n  @media only screen and (min-width: 18.75em) {\n    .panel-right {\n      width: 300px; } }\n  .panel-right.is-active {\n    box-shadow: -3px 0 10px rgba(0, 0, 0, 0.25); }\n\n.panel-bottom {\n  /*\n    Direction\n  */\n  bottom: 0;\n  left: 0;\n  width: 100%;\n  /*\n    Sizing\n  */\n  height: 300px;\n  /*\n    Shadows\n  */ }\n  .panel-bottom.is-active {\n    box-shadow: 2px -3px 10px rgba(0, 0, 0, 0.25); }\n\n.panel-left {\n  /*\n    Direction\n  */\n  top: 0;\n  left: 0;\n  height: 100%;\n  /*\n    Sizing\n  */\n  width: 100%;\n  /*\n    Shadows\n  */ }\n  @media only screen and (min-width: 18.75em) {\n    .panel-left {\n      width: 300px; } }\n  .panel-left.is-active {\n    box-shadow: 3px 0 10px rgba(0, 0, 0, 0.25); }\n\n.panel-fixed {\n  position: fixed; }\n\n/*\n  THE GRID\n  --------\n\n  Foundation's magical, flexbox-powered grid.\n\n  Features:\n   - Horizontal or vertical grids\n   - Auto-sizing or percentage width grid blocks\n   - Independently-scrollable blocks\n   - Column alignment\n   - Source ordering\n   - Offsets\n*/\n/*\n  Define the size of a grid block. Blocks are flex items. By default, they stretch to fill all available space, based on the size of sibling blocks. This is the \"expand\" behavior.\n\n  If set to \"shrink\", the block will contract and only fill as much space as it needs for its content.\n\n  If set to a number, the block will be given a percentage width, based on the total number of columns (12 by default). Percentage widths don't work if a block is inside a vertical grid.\n\n  @group grid\n\n  @param {number|string} $size - Sizing behavior of the block. Should be expand, shrink, or a number.\n\n  @output The flex-basis, flex-grow, and flex-shrink properties.\n*/\n/*\n  Set the orientation of blocks within this block. The grid is re-oriented by changing the flex direction of the block.\n\n  @group grid\n\n  @param {string} $orientation - Direction of the grid, either horizontal or vertical.\n\n  @output A flex-flow property to match the direction given.\n*/\n/*\n  Stretch a grid's child blocks across its cross-axis, making every column appear to have the same height.\n\n  @group grid\n\n  @param {bool} $stretch - Stretch blocks if true, or align blocks to top if false.\n\n  @output Sets align-items to \"stretch\" if $stretch is true, or \"flex-start\" (the default value) if false.\n*/\n/*\n  Set the alignment of blocks within a grid.\n\n  left: Items align to the left.\n  right: Items align to the right.\n  center: Items align to the center.\n  justify: Items are spaced equally apart so they occupy the space of the entire grid.\n  spaced: Items are given equal space to their left and right.\n\n  @group grid\n\n  @param {string} $align - Alignment to use.\n\n  @output An appropriate justify-content value.\n*/\n/*\n  Set the source order of a block. Items with lower numbers appear first. If multiple items have the same number, the one in the HTML first will appear first.\n\n  @group grid\n\n  @param {number} $order - Position in source order.\n\n  @output An order property.\n*/\n/*\n  Collapse a content block by removing the padding.\n\n  @group grid\n\n  @param {bool} $collapse - Collapses the block if true.\n\n  @output A padding value.\n\n  @todo No way to reverse collapse using this mixin. Solution:\n    - If true, add padding: 0;\n    - If false, add padding: 1rem;\n    - If null, add nothing, to cut down on CSS output\n    - Make null the default value\n*/\n/*\n  Constrain the size of a block to the size of the average grid row, and center-align it. This imitates the behavior of ordinary Foundation rows.\n\n  @group grid\n\n  @param {bool} $container - Adds container styles if true.\n\n  @output A maximum width and the good old margin: 0 auto for center alignment.\n*/\n/*\n  Add negative margins to a block, equal to the padding of a content block. This aligns the edges of a block nested inside a content block.\n\n  @group grid\n\n  @param {bool} $nest - Adds negative margins if true.\n\n  @output Negative margin values.\n*/\n/*\n  Offset a block by adding a left margin.\n\n  @group grid\n\n  @param {number | bool} $offset - If false, nothing is output. If a number, offsets the column by the specified number of columns.\n\n  @output A left margin based on the number of columns specified, and the global number of columns.\n*/\n/*\n  Resets styles set by panels. Use this when a panel transforms into a block on larger screens.\n\n  @group grid\n\n  @output Resets to transform, position, and a few visual styles.\n*/\n/*\n  Frames are containers that stretch to the full dimmensions of the browser window.\n*/\n/*\n  Groups are collections of content items. They're the \"rows\" of Foundation for Apps.\n*/\n/*\n  Blocks are containers for actual content. They're the \"columns\" of Foundation for Apps.\n*/\n.vertical.grid-frame, .vertical.grid-block, .vertical.small-grid-block, .vertical.medium-grid-block, .vertical.large-grid-block {\n  -ms-flex-flow: column nowrap;\n      flex-flow: column nowrap;\n  -webkit-box-align: stretch;\n      -ms-flex-align: stretch;\n              -ms-grid-row-align: stretch;\n          align-items: stretch; }\n\n.small-vertical.grid-frame, .small-vertical.grid-block, .small-vertical.small-grid-block, .small-vertical.medium-grid-block, .small-vertical.large-grid-block {\n  -ms-flex-flow: column nowrap;\n      flex-flow: column nowrap;\n  -webkit-box-align: stretch;\n      -ms-flex-align: stretch;\n              -ms-grid-row-align: stretch;\n          align-items: stretch; }\n\n.small-horizontal.grid-frame, .small-horizontal.grid-block, .small-horizontal.small-grid-block, .small-horizontal.medium-grid-block, .small-horizontal.large-grid-block {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap; }\n\n@media only screen and (min-width: 40em) {\n  .medium-vertical.grid-frame, .medium-vertical.grid-block, .medium-vertical.small-grid-block, .medium-vertical.medium-grid-block, .medium-vertical.large-grid-block {\n    -ms-flex-flow: column nowrap;\n        flex-flow: column nowrap;\n    -webkit-box-align: stretch;\n        -ms-flex-align: stretch;\n                -ms-grid-row-align: stretch;\n            align-items: stretch; }\n  .medium-horizontal.grid-frame, .medium-horizontal.grid-block, .medium-horizontal.small-grid-block, .medium-horizontal.medium-grid-block, .medium-horizontal.large-grid-block {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap; } }\n\n@media only screen and (min-width: 75em) {\n  .large-vertical.grid-frame, .large-vertical.grid-block, .large-vertical.small-grid-block, .large-vertical.medium-grid-block, .large-vertical.large-grid-block {\n    -ms-flex-flow: column nowrap;\n        flex-flow: column nowrap;\n    -webkit-box-align: stretch;\n        -ms-flex-align: stretch;\n                -ms-grid-row-align: stretch;\n            align-items: stretch; }\n  .large-horizontal.grid-frame, .large-horizontal.grid-block, .large-horizontal.small-grid-block, .large-horizontal.medium-grid-block, .large-horizontal.large-grid-block {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap; } }\n\n.align-right.grid-frame, .align-right.grid-block, .align-right.small-grid-block, .align-right.medium-grid-block, .align-right.large-grid-block {\n  -webkit-box-pack: end;\n      -ms-flex-pack: end;\n          justify-content: flex-end; }\n\n.align-center.grid-frame, .align-center.grid-block, .align-center.small-grid-block, .align-center.medium-grid-block, .align-center.large-grid-block {\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center; }\n\n.align-justify.grid-frame, .align-justify.grid-block, .align-justify.small-grid-block, .align-justify.medium-grid-block, .align-justify.large-grid-block {\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between; }\n\n.align-spaced.grid-frame, .align-spaced.grid-block, .align-spaced.small-grid-block, .align-spaced.medium-grid-block, .align-spaced.large-grid-block {\n  -ms-flex-pack: distribute;\n      justify-content: space-around; }\n\n.wrap.grid-frame, .wrap.grid-block, .wrap.small-grid-block, .wrap.medium-grid-block, .wrap.large-grid-block {\n  -ms-flex-wrap: wrap;\n      flex-wrap: wrap;\n  -webkit-box-align: start;\n      -ms-flex-align: start;\n              -ms-grid-row-align: flex-start;\n          align-items: flex-start; }\n\n.shrink.grid-block, .shrink.grid-content, .shrink.small-grid-block, .shrink.small-grid-content, .shrink.medium-grid-block, .shrink.medium-grid-content, .shrink.large-grid-block, .shrink.large-grid-content {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 auto;\n          flex: 0 0 auto;\n  overflow: visible; }\n\n.noscroll.grid-block, .noscroll.grid-content, .noscroll.small-grid-block, .noscroll.small-grid-content, .noscroll.medium-grid-block, .noscroll.medium-grid-content, .noscroll.large-grid-block, .noscroll.large-grid-content {\n  overflow: visible; }\n\n.grid-frame {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  height: 100vh;\n  position: relative;\n  overflow: hidden;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-box-flex: 1;\n      -ms-flex: 1 1 auto;\n          flex: 1 1 auto;\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  -ms-flex-wrap: nowrap;\n      flex-wrap: nowrap;\n  -webkit-box-align: stretch;\n      -ms-flex-align: stretch;\n          align-items: stretch;\n  -webkit-box-pack: start;\n      -ms-flex-pack: start;\n          justify-content: flex-start;\n  -webkit-box-ordinal-group: 1;\n      -ms-flex-order: 0;\n          order: 0; }\n\n.grid-block {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  height: auto;\n  position: relative;\n  overflow: hidden;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-box-flex: 1;\n      -ms-flex: 1 1 auto;\n          flex: 1 1 auto;\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  -ms-flex-wrap: nowrap;\n      flex-wrap: nowrap;\n  -webkit-box-align: stretch;\n      -ms-flex-align: stretch;\n          align-items: stretch;\n  -webkit-box-pack: start;\n      -ms-flex-pack: start;\n          justify-content: flex-start;\n  -webkit-box-ordinal-group: 1;\n      -ms-flex-order: 0;\n          order: 0;\n  overflow-y: auto;\n  -webkit-overflow-scrolling: touch;\n  -ms-overflow-style: -ms-autohiding-scrollbar; }\n\n.grid-content {\n  display: block;\n  padding: 0 1rem;\n  overflow-y: auto;\n  -webkit-overflow-scrolling: touch;\n  -ms-overflow-style: -ms-autohiding-scrollbar;\n  -webkit-box-flex: 1;\n      -ms-flex: 1 1 auto;\n          flex: 1 1 auto; }\n  .grid-content.collapse {\n    padding: 0; }\n  .grid-content .grid-block {\n    margin-left: -1rem;\n    margin-right: -1rem;\n    -ms-flex-wrap: wrap;\n        flex-wrap: wrap;\n    overflow: visible; }\n    .grid-content .grid-block.nowrap {\n      -ms-flex-wrap: nowrap;\n          flex-wrap: nowrap;\n      -webkit-box-align: stretch;\n          -ms-flex-align: stretch;\n                  -ms-grid-row-align: stretch;\n              align-items: stretch; }\n    .grid-content .grid-block .grid-content {\n      overflow: visible; }\n\n.grid-container {\n  max-width: 56.25rem;\n  margin: 0 auto; }\n  .grid-container.contain-left {\n    max-width: 56.25rem;\n    margin: 0 auto 0 0; }\n  .grid-container.contain-right {\n    max-width: 56.25rem;\n    margin: 0 0 0 auto; }\n\n.small-grid-block {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  height: auto;\n  position: relative;\n  overflow: hidden;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-box-flex: 1;\n      -ms-flex: 1 1 auto;\n          flex: 1 1 auto;\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  -ms-flex-wrap: nowrap;\n      flex-wrap: nowrap;\n  -webkit-box-align: stretch;\n      -ms-flex-align: stretch;\n          align-items: stretch;\n  -webkit-box-pack: start;\n      -ms-flex-pack: start;\n          justify-content: flex-start;\n  -webkit-box-ordinal-group: 1;\n      -ms-flex-order: 0;\n          order: 0;\n  overflow-y: auto;\n  -webkit-overflow-scrolling: touch;\n  -ms-overflow-style: -ms-autohiding-scrollbar; }\n  .small-grid-block.panel {\n    -webkit-transform: none;\n            transform: none;\n    position: relative;\n    width: auto;\n    height: auto;\n    z-index: auto;\n    box-shadow: none;\n    background: transparent;\n    top: auto;\n    right: auto;\n    bottom: auto;\n    left: auto; }\n\n.small-grid-content {\n  display: block;\n  padding: 0 1rem;\n  overflow-y: auto;\n  -webkit-overflow-scrolling: touch;\n  -ms-overflow-style: -ms-autohiding-scrollbar;\n  -webkit-box-flex: 1;\n      -ms-flex: 1 1 auto;\n          flex: 1 1 auto; }\n  .small-grid-content.panel {\n    -webkit-transform: none;\n            transform: none;\n    position: relative;\n    width: auto;\n    height: auto;\n    z-index: auto;\n    box-shadow: none;\n    background: transparent;\n    top: auto;\n    right: auto;\n    bottom: auto;\n    left: auto; }\n\n@media only screen and (min-width: 40em) {\n  .medium-grid-block {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    height: auto;\n    position: relative;\n    overflow: hidden;\n    -webkit-backface-visibility: hidden;\n            backface-visibility: hidden;\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 auto;\n            flex: 1 1 auto;\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    -ms-flex-wrap: nowrap;\n        flex-wrap: nowrap;\n    -webkit-box-align: stretch;\n        -ms-flex-align: stretch;\n            align-items: stretch;\n    -webkit-box-pack: start;\n        -ms-flex-pack: start;\n            justify-content: flex-start;\n    -webkit-box-ordinal-group: 1;\n        -ms-flex-order: 0;\n            order: 0;\n    overflow-y: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar; }\n    .medium-grid-block.panel {\n      -webkit-transform: none;\n              transform: none;\n      position: relative;\n      width: auto;\n      height: auto;\n      z-index: auto;\n      box-shadow: none;\n      background: transparent;\n      top: auto;\n      right: auto;\n      bottom: auto;\n      left: auto; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-grid-content {\n    display: block;\n    padding: 0 1rem;\n    overflow-y: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar;\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 auto;\n            flex: 1 1 auto; }\n    .medium-grid-content.panel {\n      -webkit-transform: none;\n              transform: none;\n      position: relative;\n      width: auto;\n      height: auto;\n      z-index: auto;\n      box-shadow: none;\n      background: transparent;\n      top: auto;\n      right: auto;\n      bottom: auto;\n      left: auto; } }\n\n@media only screen and (min-width: 75em) {\n  .large-grid-block {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    height: auto;\n    position: relative;\n    overflow: hidden;\n    -webkit-backface-visibility: hidden;\n            backface-visibility: hidden;\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 auto;\n            flex: 1 1 auto;\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    -ms-flex-wrap: nowrap;\n        flex-wrap: nowrap;\n    -webkit-box-align: stretch;\n        -ms-flex-align: stretch;\n            align-items: stretch;\n    -webkit-box-pack: start;\n        -ms-flex-pack: start;\n            justify-content: flex-start;\n    -webkit-box-ordinal-group: 1;\n        -ms-flex-order: 0;\n            order: 0;\n    overflow-y: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar; }\n    .large-grid-block.panel {\n      -webkit-transform: none;\n              transform: none;\n      position: relative;\n      width: auto;\n      height: auto;\n      z-index: auto;\n      box-shadow: none;\n      background: transparent;\n      top: auto;\n      right: auto;\n      bottom: auto;\n      left: auto; } }\n\n@media only screen and (min-width: 75em) {\n  .large-grid-content {\n    display: block;\n    padding: 0 1rem;\n    overflow-y: auto;\n    -webkit-overflow-scrolling: touch;\n    -ms-overflow-style: -ms-autohiding-scrollbar;\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 auto;\n            flex: 1 1 auto; }\n    .large-grid-content.panel {\n      -webkit-transform: none;\n              transform: none;\n      position: relative;\n      width: auto;\n      height: auto;\n      z-index: auto;\n      box-shadow: none;\n      background: transparent;\n      top: auto;\n      right: auto;\n      bottom: auto;\n      left: auto; } }\n\n.order-1 {\n  -webkit-box-ordinal-group: 2;\n      -ms-flex-order: 1;\n          order: 1; }\n\n.order-2 {\n  -webkit-box-ordinal-group: 3;\n      -ms-flex-order: 2;\n          order: 2; }\n\n.order-3 {\n  -webkit-box-ordinal-group: 4;\n      -ms-flex-order: 3;\n          order: 3; }\n\n.order-4 {\n  -webkit-box-ordinal-group: 5;\n      -ms-flex-order: 4;\n          order: 4; }\n\n.order-5 {\n  -webkit-box-ordinal-group: 6;\n      -ms-flex-order: 5;\n          order: 5; }\n\n.order-6 {\n  -webkit-box-ordinal-group: 7;\n      -ms-flex-order: 6;\n          order: 6; }\n\n.order-7 {\n  -webkit-box-ordinal-group: 8;\n      -ms-flex-order: 7;\n          order: 7; }\n\n.order-8 {\n  -webkit-box-ordinal-group: 9;\n      -ms-flex-order: 8;\n          order: 8; }\n\n.order-9 {\n  -webkit-box-ordinal-group: 10;\n      -ms-flex-order: 9;\n          order: 9; }\n\n.order-10 {\n  -webkit-box-ordinal-group: 11;\n      -ms-flex-order: 10;\n          order: 10; }\n\n.order-11 {\n  -webkit-box-ordinal-group: 12;\n      -ms-flex-order: 11;\n          order: 11; }\n\n.order-12 {\n  -webkit-box-ordinal-group: 13;\n      -ms-flex-order: 12;\n          order: 12; }\n\n.small-1 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 8.33333%;\n          flex: 0 0 8.33333%;\n  max-width: 8.33333%; }\n\n.small-order-1 {\n  -webkit-box-ordinal-group: 2;\n      -ms-flex-order: 1;\n          order: 1; }\n\n.small-offset-1 {\n  margin-left: 8.33333%; }\n\n.small-up-1 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-1 > li, .small-up-1 > div, .small-up-1 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 100%;\n            flex: 0 0 100%;\n    max-width: 100%; }\n\n.small-2 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 16.66667%;\n          flex: 0 0 16.66667%;\n  max-width: 16.66667%; }\n\n.small-order-2 {\n  -webkit-box-ordinal-group: 3;\n      -ms-flex-order: 2;\n          order: 2; }\n\n.small-offset-2 {\n  margin-left: 16.66667%; }\n\n.small-up-2 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-2 > li, .small-up-2 > div, .small-up-2 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 50%;\n            flex: 0 0 50%;\n    max-width: 50%; }\n\n.small-3 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 25%;\n          flex: 0 0 25%;\n  max-width: 25%; }\n\n.small-order-3 {\n  -webkit-box-ordinal-group: 4;\n      -ms-flex-order: 3;\n          order: 3; }\n\n.small-offset-3 {\n  margin-left: 25%; }\n\n.small-up-3 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-3 > li, .small-up-3 > div, .small-up-3 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 33.33333%;\n            flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n\n.small-4 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 33.33333%;\n          flex: 0 0 33.33333%;\n  max-width: 33.33333%; }\n\n.small-order-4 {\n  -webkit-box-ordinal-group: 5;\n      -ms-flex-order: 4;\n          order: 4; }\n\n.small-offset-4 {\n  margin-left: 33.33333%; }\n\n.small-up-4 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-4 > li, .small-up-4 > div, .small-up-4 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 25%;\n            flex: 0 0 25%;\n    max-width: 25%; }\n\n.small-5 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 41.66667%;\n          flex: 0 0 41.66667%;\n  max-width: 41.66667%; }\n\n.small-order-5 {\n  -webkit-box-ordinal-group: 6;\n      -ms-flex-order: 5;\n          order: 5; }\n\n.small-offset-5 {\n  margin-left: 41.66667%; }\n\n.small-up-5 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-5 > li, .small-up-5 > div, .small-up-5 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 20%;\n            flex: 0 0 20%;\n    max-width: 20%; }\n\n.small-6 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 50%;\n          flex: 0 0 50%;\n  max-width: 50%; }\n\n.small-order-6 {\n  -webkit-box-ordinal-group: 7;\n      -ms-flex-order: 6;\n          order: 6; }\n\n.small-offset-6 {\n  margin-left: 50%; }\n\n.small-up-6 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-6 > li, .small-up-6 > div, .small-up-6 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 16.66667%;\n            flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n\n.small-7 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 58.33333%;\n          flex: 0 0 58.33333%;\n  max-width: 58.33333%; }\n\n.small-order-7 {\n  -webkit-box-ordinal-group: 8;\n      -ms-flex-order: 7;\n          order: 7; }\n\n.small-offset-7 {\n  margin-left: 58.33333%; }\n\n.small-up-7 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-7 > li, .small-up-7 > div, .small-up-7 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 14.28571%;\n            flex: 0 0 14.28571%;\n    max-width: 14.28571%; }\n\n.small-8 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 66.66667%;\n          flex: 0 0 66.66667%;\n  max-width: 66.66667%; }\n\n.small-order-8 {\n  -webkit-box-ordinal-group: 9;\n      -ms-flex-order: 8;\n          order: 8; }\n\n.small-offset-8 {\n  margin-left: 66.66667%; }\n\n.small-up-8 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-8 > li, .small-up-8 > div, .small-up-8 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 12.5%;\n            flex: 0 0 12.5%;\n    max-width: 12.5%; }\n\n.small-9 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 75%;\n          flex: 0 0 75%;\n  max-width: 75%; }\n\n.small-order-9 {\n  -webkit-box-ordinal-group: 10;\n      -ms-flex-order: 9;\n          order: 9; }\n\n.small-offset-9 {\n  margin-left: 75%; }\n\n.small-up-9 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-9 > li, .small-up-9 > div, .small-up-9 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 11.11111%;\n            flex: 0 0 11.11111%;\n    max-width: 11.11111%; }\n\n.small-10 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 83.33333%;\n          flex: 0 0 83.33333%;\n  max-width: 83.33333%; }\n\n.small-order-10 {\n  -webkit-box-ordinal-group: 11;\n      -ms-flex-order: 10;\n          order: 10; }\n\n.small-offset-10 {\n  margin-left: 83.33333%; }\n\n.small-up-10 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-10 > li, .small-up-10 > div, .small-up-10 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 10%;\n            flex: 0 0 10%;\n    max-width: 10%; }\n\n.small-11 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 91.66667%;\n          flex: 0 0 91.66667%;\n  max-width: 91.66667%; }\n\n.small-order-11 {\n  -webkit-box-ordinal-group: 12;\n      -ms-flex-order: 11;\n          order: 11; }\n\n.small-offset-11 {\n  margin-left: 91.66667%; }\n\n.small-up-11 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-11 > li, .small-up-11 > div, .small-up-11 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 9.09091%;\n            flex: 0 0 9.09091%;\n    max-width: 9.09091%; }\n\n.small-12 {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 100%;\n          flex: 0 0 100%;\n  max-width: 100%; }\n\n.small-order-12 {\n  -webkit-box-ordinal-group: 13;\n      -ms-flex-order: 12;\n          order: 12; }\n\n.small-offset-12 {\n  margin-left: 100%; }\n\n.small-up-12 {\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap;\n  overflow: visible;\n  list-style-type: none; }\n  .small-up-12 > li, .small-up-12 > div, .small-up-12 > section {\n    padding: 0 1rem 1rem;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 8.33333%;\n            flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n\n@media only screen and (min-width: 40em) {\n  .medium-1 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 8.33333%;\n            flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n  .medium-order-1 {\n    -webkit-box-ordinal-group: 2;\n        -ms-flex-order: 1;\n            order: 1; }\n  .medium-offset-1 {\n    margin-left: 8.33333%; }\n  .medium-up-1 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-1 > li, .medium-up-1 > div, .medium-up-1 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 100%;\n              flex: 0 0 100%;\n      max-width: 100%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-2 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 16.66667%;\n            flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n  .medium-order-2 {\n    -webkit-box-ordinal-group: 3;\n        -ms-flex-order: 2;\n            order: 2; }\n  .medium-offset-2 {\n    margin-left: 16.66667%; }\n  .medium-up-2 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-2 > li, .medium-up-2 > div, .medium-up-2 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 50%;\n              flex: 0 0 50%;\n      max-width: 50%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-3 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 25%;\n            flex: 0 0 25%;\n    max-width: 25%; }\n  .medium-order-3 {\n    -webkit-box-ordinal-group: 4;\n        -ms-flex-order: 3;\n            order: 3; }\n  .medium-offset-3 {\n    margin-left: 25%; }\n  .medium-up-3 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-3 > li, .medium-up-3 > div, .medium-up-3 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 33.33333%;\n              flex: 0 0 33.33333%;\n      max-width: 33.33333%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-4 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 33.33333%;\n            flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n  .medium-order-4 {\n    -webkit-box-ordinal-group: 5;\n        -ms-flex-order: 4;\n            order: 4; }\n  .medium-offset-4 {\n    margin-left: 33.33333%; }\n  .medium-up-4 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-4 > li, .medium-up-4 > div, .medium-up-4 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 25%;\n              flex: 0 0 25%;\n      max-width: 25%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-5 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 41.66667%;\n            flex: 0 0 41.66667%;\n    max-width: 41.66667%; }\n  .medium-order-5 {\n    -webkit-box-ordinal-group: 6;\n        -ms-flex-order: 5;\n            order: 5; }\n  .medium-offset-5 {\n    margin-left: 41.66667%; }\n  .medium-up-5 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-5 > li, .medium-up-5 > div, .medium-up-5 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 20%;\n              flex: 0 0 20%;\n      max-width: 20%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-6 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 50%;\n            flex: 0 0 50%;\n    max-width: 50%; }\n  .medium-order-6 {\n    -webkit-box-ordinal-group: 7;\n        -ms-flex-order: 6;\n            order: 6; }\n  .medium-offset-6 {\n    margin-left: 50%; }\n  .medium-up-6 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-6 > li, .medium-up-6 > div, .medium-up-6 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 16.66667%;\n              flex: 0 0 16.66667%;\n      max-width: 16.66667%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-7 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 58.33333%;\n            flex: 0 0 58.33333%;\n    max-width: 58.33333%; }\n  .medium-order-7 {\n    -webkit-box-ordinal-group: 8;\n        -ms-flex-order: 7;\n            order: 7; }\n  .medium-offset-7 {\n    margin-left: 58.33333%; }\n  .medium-up-7 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-7 > li, .medium-up-7 > div, .medium-up-7 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 14.28571%;\n              flex: 0 0 14.28571%;\n      max-width: 14.28571%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-8 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 66.66667%;\n            flex: 0 0 66.66667%;\n    max-width: 66.66667%; }\n  .medium-order-8 {\n    -webkit-box-ordinal-group: 9;\n        -ms-flex-order: 8;\n            order: 8; }\n  .medium-offset-8 {\n    margin-left: 66.66667%; }\n  .medium-up-8 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-8 > li, .medium-up-8 > div, .medium-up-8 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 12.5%;\n              flex: 0 0 12.5%;\n      max-width: 12.5%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-9 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 75%;\n            flex: 0 0 75%;\n    max-width: 75%; }\n  .medium-order-9 {\n    -webkit-box-ordinal-group: 10;\n        -ms-flex-order: 9;\n            order: 9; }\n  .medium-offset-9 {\n    margin-left: 75%; }\n  .medium-up-9 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-9 > li, .medium-up-9 > div, .medium-up-9 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 11.11111%;\n              flex: 0 0 11.11111%;\n      max-width: 11.11111%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-10 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 83.33333%;\n            flex: 0 0 83.33333%;\n    max-width: 83.33333%; }\n  .medium-order-10 {\n    -webkit-box-ordinal-group: 11;\n        -ms-flex-order: 10;\n            order: 10; }\n  .medium-offset-10 {\n    margin-left: 83.33333%; }\n  .medium-up-10 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-10 > li, .medium-up-10 > div, .medium-up-10 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 10%;\n              flex: 0 0 10%;\n      max-width: 10%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-11 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 91.66667%;\n            flex: 0 0 91.66667%;\n    max-width: 91.66667%; }\n  .medium-order-11 {\n    -webkit-box-ordinal-group: 12;\n        -ms-flex-order: 11;\n            order: 11; }\n  .medium-offset-11 {\n    margin-left: 91.66667%; }\n  .medium-up-11 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-11 > li, .medium-up-11 > div, .medium-up-11 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 9.09091%;\n              flex: 0 0 9.09091%;\n      max-width: 9.09091%; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-12 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 100%;\n            flex: 0 0 100%;\n    max-width: 100%; }\n  .medium-order-12 {\n    -webkit-box-ordinal-group: 13;\n        -ms-flex-order: 12;\n            order: 12; }\n  .medium-offset-12 {\n    margin-left: 100%; }\n  .medium-up-12 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .medium-up-12 > li, .medium-up-12 > div, .medium-up-12 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 8.33333%;\n              flex: 0 0 8.33333%;\n      max-width: 8.33333%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-1 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 8.33333%;\n            flex: 0 0 8.33333%;\n    max-width: 8.33333%; }\n  .large-order-1 {\n    -webkit-box-ordinal-group: 2;\n        -ms-flex-order: 1;\n            order: 1; }\n  .large-offset-1 {\n    margin-left: 8.33333%; }\n  .large-up-1 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-1 > li, .large-up-1 > div, .large-up-1 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 100%;\n              flex: 0 0 100%;\n      max-width: 100%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-2 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 16.66667%;\n            flex: 0 0 16.66667%;\n    max-width: 16.66667%; }\n  .large-order-2 {\n    -webkit-box-ordinal-group: 3;\n        -ms-flex-order: 2;\n            order: 2; }\n  .large-offset-2 {\n    margin-left: 16.66667%; }\n  .large-up-2 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-2 > li, .large-up-2 > div, .large-up-2 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 50%;\n              flex: 0 0 50%;\n      max-width: 50%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-3 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 25%;\n            flex: 0 0 25%;\n    max-width: 25%; }\n  .large-order-3 {\n    -webkit-box-ordinal-group: 4;\n        -ms-flex-order: 3;\n            order: 3; }\n  .large-offset-3 {\n    margin-left: 25%; }\n  .large-up-3 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-3 > li, .large-up-3 > div, .large-up-3 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 33.33333%;\n              flex: 0 0 33.33333%;\n      max-width: 33.33333%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-4 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 33.33333%;\n            flex: 0 0 33.33333%;\n    max-width: 33.33333%; }\n  .large-order-4 {\n    -webkit-box-ordinal-group: 5;\n        -ms-flex-order: 4;\n            order: 4; }\n  .large-offset-4 {\n    margin-left: 33.33333%; }\n  .large-up-4 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-4 > li, .large-up-4 > div, .large-up-4 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 25%;\n              flex: 0 0 25%;\n      max-width: 25%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-5 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 41.66667%;\n            flex: 0 0 41.66667%;\n    max-width: 41.66667%; }\n  .large-order-5 {\n    -webkit-box-ordinal-group: 6;\n        -ms-flex-order: 5;\n            order: 5; }\n  .large-offset-5 {\n    margin-left: 41.66667%; }\n  .large-up-5 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-5 > li, .large-up-5 > div, .large-up-5 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 20%;\n              flex: 0 0 20%;\n      max-width: 20%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-6 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 50%;\n            flex: 0 0 50%;\n    max-width: 50%; }\n  .large-order-6 {\n    -webkit-box-ordinal-group: 7;\n        -ms-flex-order: 6;\n            order: 6; }\n  .large-offset-6 {\n    margin-left: 50%; }\n  .large-up-6 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-6 > li, .large-up-6 > div, .large-up-6 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 16.66667%;\n              flex: 0 0 16.66667%;\n      max-width: 16.66667%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-7 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 58.33333%;\n            flex: 0 0 58.33333%;\n    max-width: 58.33333%; }\n  .large-order-7 {\n    -webkit-box-ordinal-group: 8;\n        -ms-flex-order: 7;\n            order: 7; }\n  .large-offset-7 {\n    margin-left: 58.33333%; }\n  .large-up-7 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-7 > li, .large-up-7 > div, .large-up-7 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 14.28571%;\n              flex: 0 0 14.28571%;\n      max-width: 14.28571%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-8 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 66.66667%;\n            flex: 0 0 66.66667%;\n    max-width: 66.66667%; }\n  .large-order-8 {\n    -webkit-box-ordinal-group: 9;\n        -ms-flex-order: 8;\n            order: 8; }\n  .large-offset-8 {\n    margin-left: 66.66667%; }\n  .large-up-8 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-8 > li, .large-up-8 > div, .large-up-8 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 12.5%;\n              flex: 0 0 12.5%;\n      max-width: 12.5%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-9 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 75%;\n            flex: 0 0 75%;\n    max-width: 75%; }\n  .large-order-9 {\n    -webkit-box-ordinal-group: 10;\n        -ms-flex-order: 9;\n            order: 9; }\n  .large-offset-9 {\n    margin-left: 75%; }\n  .large-up-9 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-9 > li, .large-up-9 > div, .large-up-9 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 11.11111%;\n              flex: 0 0 11.11111%;\n      max-width: 11.11111%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-10 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 83.33333%;\n            flex: 0 0 83.33333%;\n    max-width: 83.33333%; }\n  .large-order-10 {\n    -webkit-box-ordinal-group: 11;\n        -ms-flex-order: 10;\n            order: 10; }\n  .large-offset-10 {\n    margin-left: 83.33333%; }\n  .large-up-10 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-10 > li, .large-up-10 > div, .large-up-10 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 10%;\n              flex: 0 0 10%;\n      max-width: 10%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-11 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 91.66667%;\n            flex: 0 0 91.66667%;\n    max-width: 91.66667%; }\n  .large-order-11 {\n    -webkit-box-ordinal-group: 12;\n        -ms-flex-order: 11;\n            order: 11; }\n  .large-offset-11 {\n    margin-left: 91.66667%; }\n  .large-up-11 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-11 > li, .large-up-11 > div, .large-up-11 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 9.09091%;\n              flex: 0 0 9.09091%;\n      max-width: 9.09091%; } }\n\n@media only screen and (min-width: 75em) {\n  .large-12 {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 100%;\n            flex: 0 0 100%;\n    max-width: 100%; }\n  .large-order-12 {\n    -webkit-box-ordinal-group: 13;\n        -ms-flex-order: 12;\n            order: 12; }\n  .large-offset-12 {\n    margin-left: 100%; }\n  .large-up-12 {\n    -ms-flex-flow: row wrap;\n        flex-flow: row wrap;\n    overflow: visible;\n    list-style-type: none; }\n    .large-up-12 > li, .large-up-12 > div, .large-up-12 > section {\n      padding: 0 1rem 1rem;\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 8.33333%;\n              flex: 0 0 8.33333%;\n      max-width: 8.33333%; } }\n\n.grid-content .modal .grid-block {\n  -ms-flex-wrap: nowrap;\n      flex-wrap: nowrap; }\n\n/*\r\n  TITLE BAR\r\n  ---------\r\n\r\n  A navigational component which can display the current screen the user is on, along with additional controls or menu items.\r\n\r\n  The title bar includes classes to create center, left, and right sections, which can be used in any combination. However, in the markup, the sections must come in this order:\r\n   - Center\r\n   - Left\r\n   - Right\r\n*/\n.title-bar {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 auto;\n          flex: 0 0 auto;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: start;\n      -ms-flex-pack: start;\n          justify-content: flex-start;\n  overflow: visible; }\n  .title-bar .title {\n    font-weight: bold; }\n  .title-bar .left, .title-bar .center, .title-bar .right {\n    display: block;\n    white-space: nowrap;\n    overflow: visible; }\n    .title-bar .left:first-child:last-child, .title-bar .center:first-child:last-child, .title-bar .right:first-child:last-child {\n      -webkit-box-flex: 1;\n          -ms-flex: 1;\n              flex: 1;\n      margin: 0; }\n  .title-bar .left {\n    -webkit-box-ordinal-group: 2;\n        -ms-flex-order: 1;\n            order: 1;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 25%;\n            flex: 0 0 25%; }\n  .title-bar .center {\n    -webkit-box-ordinal-group: 3;\n        -ms-flex-order: 2;\n            order: 2;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 50%;\n            flex: 0 0 50%;\n    text-align: center; }\n  .title-bar .right {\n    -webkit-box-ordinal-group: 4;\n        -ms-flex-order: 3;\n            order: 3;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 25%;\n            flex: 0 0 25%;\n    text-align: right; }\n  .title-bar .left:first-child {\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 auto;\n            flex: 1 1 auto; }\n  .title-bar .left:first-child + .right:last-child {\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 auto;\n            flex: 1 1 auto; }\n  .title-bar .center:first-child:not(:last-child) {\n    margin-left: 25%; }\n  .title-bar .center + .left {\n    margin-right: -25%; }\n\n.title-bar {\n  background: #eee;\n  color: #000;\n  padding: 1rem;\n  border-bottom: 1px solid #ccc; }\n  .title-bar.primary {\n    background: #00558b;\n    color: #fff;\n    padding: 1rem;\n    border-bottom: 1px solid #ccc; }\n    .title-bar.primary a, .title-bar.primary a:hover {\n      color: #fff; }\n    .title-bar.primary .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .title-bar.primary .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .title-bar.dark {\n    background: #232323;\n    color: #fff;\n    padding: 1rem;\n    border-bottom: 1px solid #ccc; }\n    .title-bar.dark a, .title-bar.dark a:hover {\n      color: #fff; }\n    .title-bar.dark .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .title-bar.dark .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n\n.title-bar-bottom {\n  border-bottom: 0;\n  border-top: 1px solid #ccc; }\n\n/*\r\n  Label\r\n*/\n.label {\n  line-height: 1;\n  white-space: nowrap;\n  display: inline-block;\n  cursor: default; }\n\n.label {\n  font-size: 0.8rem;\n  padding: 0.33333rem 0.5rem;\n  background: #00558b;\n  border-radius: 0;\n  color: #fff; }\n  .label.primary {\n    background: #00558b;\n    border-radius: 0;\n    color: #fff; }\n  .label.success {\n    background: #43AC6A;\n    border-radius: 0;\n    color: #fff; }\n  .label.warning {\n    background: #F08A24;\n    border-radius: 0;\n    color: #fff; }\n  .label.alert {\n    background: #F04124;\n    border-radius: 0;\n    color: #fff; }\n  .label.dark {\n    background: #232323;\n    border-radius: 0;\n    color: #fff; }\n\n/*\r\n  Badge\r\n*/\n.badge {\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  display: -webkit-inline-box;\n  display: -ms-inline-flexbox;\n  display: inline-flex;\n  border-radius: 1000px; }\n\n.badge {\n  font-size: 0.8em;\n  width: 1.5rem;\n  height: 1.5rem;\n  background: #00558b;\n  color: #fff; }\n  .badge.secondary {\n    background: #f1f1f1;\n    color: #000; }\n  .badge.primary {\n    background: #00558b;\n    color: #fff; }\n  .badge.success {\n    background: #43AC6A;\n    color: #fff; }\n  .badge.warning {\n    background: #F08A24;\n    color: #fff; }\n  .badge.alert {\n    background: #F04124;\n    color: #fff; }\n  .badge.dark {\n    background: #232323;\n    color: #fff; }\n\n.inline-list {\n  list-style-type: none;\n  text-align: left; }\n  .inline-list li, .inline-list dt, .inline-list dd {\n    display: inline-block;\n    margin-left: -2px;\n    margin-right: -2px; }\n  .inline-list li {\n    margin-right: 1rem;\n    margin-left: 0; }\n\n/*\n  MENU BAR\n  --------\n\n  A generic, flexible menu component.\n\n  Features:\n   - Orient horizontally and vertically\n     - Change orientation at certain breakpoints\n   - Items with icons above, below, or to the left or right\n   - Text labels for vertical menus and badges for horizontal menus\n*/\n.menu-bar {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: stretch;\n      -ms-flex-align: stretch;\n          align-items: stretch;\n  margin: 0;\n  list-style-type: none;\n  overflow-y: visible; }\n  .menu-bar > li {\n    -webkit-box-flex: 1;\n        -ms-flex: 1 0 0;\n            flex: 1 0 0;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: stretch;\n        -ms-flex-align: stretch;\n            align-items: stretch; }\n    .menu-bar > li > a {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -ms-flex-flow: column nowrap;\n          flex-flow: column nowrap;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      padding: 1rem;\n      font-size: 1rem;\n      line-height: 1; }\n\n/*\n  Set the alignment of menu items (li) within a menu-bar\n\n  left: Items align to the left.\n  right: Items align to the right.\n  center: Items align to the center.\n  justify: Items are spaced equally apart so they occupy the space of the entire grid.\n  spaced: Items are given equal space to their left and right.\n\n  @group menu-bar\n\n  @param {string} $align - Alignment to use.\n\n  @output An appropriate justify-content value.\n*/\n/*\n  CSS output\n*/\n.menu-bar {\n  background: #fff; }\n  .menu-bar > li > a {\n    color: #000; }\n    .menu-bar > li > a:hover {\n      background: #ededed;\n      color: #000; }\n  .menu-bar .is-active > a {\n    background: #ededed;\n    color: #000; }\n  .menu-bar .iconic * {\n    fill: #000;\n    stroke: #000; }\n    .menu-bar .iconic *.iconic-property-accent {\n      fill: #000;\n      stroke: #000; }\n  .menu-bar, .menu-bar.horizontal {\n    /*\n    Orientation\n  */\n    overflow-x: hidden;\n    -ms-flex-flow: row nowrap;\n        flex-flow: row nowrap;\n    /*\n    Stretch\n  */ }\n    .menu-bar > li > a, .menu-bar.horizontal > li > a {\n      -webkit-box-flex: 1;\n          -ms-flex: 1 0 0;\n              flex: 1 0 0; }\n    .menu-bar > li > a, .menu-bar.horizontal > li > a {\n      -ms-flex-flow: column nowrap;\n          flex-flow: column nowrap; }\n  .menu-bar.vertical {\n    /*\n    Orientation\n  */\n    -ms-flex-flow: column nowrap;\n        flex-flow: column nowrap;\n    /*\n    Stretch\n  */ }\n    .menu-bar.vertical > li {\n      -webkit-box-flex: 1;\n          -ms-flex: 1 0 auto;\n              flex: 1 0 auto; }\n    .menu-bar.vertical > li > a {\n      -ms-flex-flow: row nowrap;\n          flex-flow: row nowrap; }\n  .menu-bar.condense > li {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 auto;\n            flex: 0 0 auto; }\n  .menu-bar.align-right {\n    -webkit-box-pack: end;\n        -ms-flex-pack: end;\n            justify-content: flex-end; }\n  .menu-bar.align-center {\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center; }\n  .menu-bar.align-justify {\n    -webkit-box-pack: justify;\n        -ms-flex-pack: justify;\n            justify-content: space-between; }\n  .menu-bar.align-spaced {\n    -ms-flex-pack: distribute;\n        justify-content: space-around; }\n  .menu-bar.small-condense li {\n    -webkit-box-flex: 0;\n        -ms-flex: 0 0 auto;\n            flex: 0 0 auto; }\n  .menu-bar.small-expand li {\n    -webkit-box-flex: 1;\n        -ms-flex: 1 0 auto;\n            flex: 1 0 auto; }\n  .menu-bar.small-align-left {\n    -webkit-box-pack: start;\n        -ms-flex-pack: start;\n            justify-content: flex-start; }\n  .menu-bar.small-align-right {\n    -webkit-box-pack: end;\n        -ms-flex-pack: end;\n            justify-content: flex-end; }\n  .menu-bar.small-align-center {\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center; }\n  .menu-bar.small-align-justify {\n    -webkit-box-pack: justify;\n        -ms-flex-pack: justify;\n            justify-content: space-between; }\n  .menu-bar.small-align-spaced {\n    -ms-flex-pack: distribute;\n        justify-content: space-around; }\n  @media only screen and (min-width: 40em) {\n    .menu-bar.medium-condense li {\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 auto;\n              flex: 0 0 auto; }\n    .menu-bar.medium-expand li {\n      -webkit-box-flex: 1;\n          -ms-flex: 1 0 auto;\n              flex: 1 0 auto; }\n    .menu-bar.medium-align-left {\n      -webkit-box-pack: start;\n          -ms-flex-pack: start;\n              justify-content: flex-start; }\n    .menu-bar.medium-align-right {\n      -webkit-box-pack: end;\n          -ms-flex-pack: end;\n              justify-content: flex-end; }\n    .menu-bar.medium-align-center {\n      -webkit-box-pack: center;\n          -ms-flex-pack: center;\n              justify-content: center; }\n    .menu-bar.medium-align-justify {\n      -webkit-box-pack: justify;\n          -ms-flex-pack: justify;\n              justify-content: space-between; }\n    .menu-bar.medium-align-spaced {\n      -ms-flex-pack: distribute;\n          justify-content: space-around; } }\n  @media only screen and (min-width: 75em) {\n    .menu-bar.large-condense li {\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 auto;\n              flex: 0 0 auto; }\n    .menu-bar.large-expand li {\n      -webkit-box-flex: 1;\n          -ms-flex: 1 0 auto;\n              flex: 1 0 auto; }\n    .menu-bar.large-align-left {\n      -webkit-box-pack: start;\n          -ms-flex-pack: start;\n              justify-content: flex-start; }\n    .menu-bar.large-align-right {\n      -webkit-box-pack: end;\n          -ms-flex-pack: end;\n              justify-content: flex-end; }\n    .menu-bar.large-align-center {\n      -webkit-box-pack: center;\n          -ms-flex-pack: center;\n              justify-content: center; }\n    .menu-bar.large-align-justify {\n      -webkit-box-pack: justify;\n          -ms-flex-pack: justify;\n              justify-content: space-between; }\n    .menu-bar.large-align-spaced {\n      -ms-flex-pack: distribute;\n          justify-content: space-around; } }\n  .menu-bar.small-horizontal {\n    /*\n    Orientation\n  */\n    overflow-x: hidden;\n    -ms-flex-flow: row nowrap;\n        flex-flow: row nowrap;\n    /*\n    Stretch\n  */ }\n    .menu-bar.small-horizontal > li > a {\n      -webkit-box-flex: 1;\n          -ms-flex: 1 0 0;\n              flex: 1 0 0; }\n    .menu-bar.small-horizontal > li > a {\n      -ms-flex-flow: column nowrap;\n          flex-flow: column nowrap; }\n  .menu-bar.small-vertical {\n    /*\n    Orientation\n  */\n    -ms-flex-flow: column nowrap;\n        flex-flow: column nowrap;\n    /*\n    Stretch\n  */ }\n    .menu-bar.small-vertical > li {\n      -webkit-box-flex: 1;\n          -ms-flex: 1 0 auto;\n              flex: 1 0 auto; }\n    .menu-bar.small-vertical > li > a {\n      -ms-flex-flow: row nowrap;\n          flex-flow: row nowrap; }\n  @media only screen and (min-width: 40em) {\n    .menu-bar.medium-horizontal {\n      /*\n    Orientation\n  */\n      overflow-x: hidden;\n      -ms-flex-flow: row nowrap;\n          flex-flow: row nowrap;\n      /*\n    Stretch\n  */ }\n      .menu-bar.medium-horizontal > li > a {\n        -webkit-box-flex: 1;\n            -ms-flex: 1 0 0;\n                flex: 1 0 0; }\n      .menu-bar.medium-horizontal > li > a {\n        -ms-flex-flow: column nowrap;\n            flex-flow: column nowrap; }\n    .menu-bar.medium-vertical {\n      /*\n    Orientation\n  */\n      -ms-flex-flow: column nowrap;\n          flex-flow: column nowrap;\n      /*\n    Stretch\n  */ }\n      .menu-bar.medium-vertical > li {\n        -webkit-box-flex: 1;\n            -ms-flex: 1 0 auto;\n                flex: 1 0 auto; }\n      .menu-bar.medium-vertical > li > a {\n        -ms-flex-flow: row nowrap;\n            flex-flow: row nowrap; } }\n  @media only screen and (min-width: 75em) {\n    .menu-bar.large-horizontal {\n      /*\n    Orientation\n  */\n      overflow-x: hidden;\n      -ms-flex-flow: row nowrap;\n          flex-flow: row nowrap;\n      /*\n    Stretch\n  */ }\n      .menu-bar.large-horizontal > li > a {\n        -webkit-box-flex: 1;\n            -ms-flex: 1 0 0;\n                flex: 1 0 0; }\n      .menu-bar.large-horizontal > li > a {\n        -ms-flex-flow: column nowrap;\n            flex-flow: column nowrap; }\n    .menu-bar.large-vertical {\n      /*\n    Orientation\n  */\n      -ms-flex-flow: column nowrap;\n          flex-flow: column nowrap;\n      /*\n    Stretch\n  */ }\n      .menu-bar.large-vertical > li {\n        -webkit-box-flex: 1;\n            -ms-flex: 1 0 auto;\n                flex: 1 0 auto; }\n      .menu-bar.large-vertical > li > a {\n        -ms-flex-flow: row nowrap;\n            flex-flow: row nowrap; } }\n  .menu-bar > li > img, .menu-bar > li > .iconic, .menu-bar.icon-top > li > img, .menu-bar.icon-top > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar > li > img:first-child:last-child, .menu-bar > li > .iconic:first-child:last-child, .menu-bar.icon-top > li > img:first-child:last-child, .menu-bar.icon-top > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar > li > a, .menu-bar.icon-top > li > a {\n    -ms-flex-flow: column nowrap;\n        flex-flow: column nowrap; }\n    .menu-bar > li > a > img, .menu-bar > li > a > .iconic, .menu-bar.icon-top > li > a > img, .menu-bar.icon-top > li > a > .iconic {\n      margin: 0 0 1rem 0; }\n  .menu-bar.icon-right > li > img, .menu-bar.icon-right > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar.icon-right > li > img:first-child:last-child, .menu-bar.icon-right > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar.icon-right > li > a {\n    -ms-flex-flow: row-reverse nowrap;\n        flex-flow: row-reverse nowrap; }\n    .menu-bar.icon-right > li > a > img, .menu-bar.icon-right > li > a > .iconic {\n      margin: 0 0 0 1rem; }\n  .menu-bar.icon-bottom > li > img, .menu-bar.icon-bottom > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar.icon-bottom > li > img:first-child:last-child, .menu-bar.icon-bottom > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar.icon-bottom > li > a {\n    -ms-flex-flow: column-reverse nowrap;\n        flex-flow: column-reverse nowrap; }\n    .menu-bar.icon-bottom > li > a > img, .menu-bar.icon-bottom > li > a > .iconic {\n      margin: 1rem 0 0 0; }\n  .menu-bar.icon-left > li > img, .menu-bar.icon-left > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar.icon-left > li > img:first-child:last-child, .menu-bar.icon-left > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar.icon-left > li > a {\n    -ms-flex-flow: row nowrap;\n        flex-flow: row nowrap;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n                -ms-grid-row-align: center;\n            align-items: center; }\n    .menu-bar.icon-left > li > a > img, .menu-bar.icon-left > li > a > .iconic {\n      margin: 0 1rem 0 0; }\n  .menu-bar.small-icon-top > li > img, .menu-bar.small-icon-top > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar.small-icon-top > li > img:first-child:last-child, .menu-bar.small-icon-top > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar.small-icon-top > li > a {\n    -ms-flex-flow: column nowrap;\n        flex-flow: column nowrap; }\n    .menu-bar.small-icon-top > li > a > img, .menu-bar.small-icon-top > li > a > .iconic {\n      margin: 0 0 1rem 0; }\n  .menu-bar.small-icon-right > li > img, .menu-bar.small-icon-right > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar.small-icon-right > li > img:first-child:last-child, .menu-bar.small-icon-right > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar.small-icon-right > li > a {\n    -ms-flex-flow: row-reverse nowrap;\n        flex-flow: row-reverse nowrap; }\n    .menu-bar.small-icon-right > li > a > img, .menu-bar.small-icon-right > li > a > .iconic {\n      margin: 0 0 0 1rem; }\n  .menu-bar.small-icon-bottom > li > img, .menu-bar.small-icon-bottom > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar.small-icon-bottom > li > img:first-child:last-child, .menu-bar.small-icon-bottom > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar.small-icon-bottom > li > a {\n    -ms-flex-flow: column-reverse nowrap;\n        flex-flow: column-reverse nowrap; }\n    .menu-bar.small-icon-bottom > li > a > img, .menu-bar.small-icon-bottom > li > a > .iconic {\n      margin: 1rem 0 0 0; }\n  .menu-bar.small-icon-left > li > img, .menu-bar.small-icon-left > li > .iconic {\n    margin: 0;\n    width: 25px;\n    height: 25px; }\n    .menu-bar.small-icon-left > li > img:first-child:last-child, .menu-bar.small-icon-left > li > .iconic:first-child:last-child {\n      margin: 0; }\n  .menu-bar.small-icon-left > li > a {\n    -ms-flex-flow: row nowrap;\n        flex-flow: row nowrap;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n                -ms-grid-row-align: center;\n            align-items: center; }\n    .menu-bar.small-icon-left > li > a > img, .menu-bar.small-icon-left > li > a > .iconic {\n      margin: 0 1rem 0 0; }\n  @media only screen and (min-width: 40em) {\n    .menu-bar.medium-icon-top > li > img, .menu-bar.medium-icon-top > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.medium-icon-top > li > img:first-child:last-child, .menu-bar.medium-icon-top > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.medium-icon-top > li > a {\n      -ms-flex-flow: column nowrap;\n          flex-flow: column nowrap; }\n      .menu-bar.medium-icon-top > li > a > img, .menu-bar.medium-icon-top > li > a > .iconic {\n        margin: 0 0 1rem 0; } }\n  @media only screen and (min-width: 40em) {\n    .menu-bar.medium-icon-right > li > img, .menu-bar.medium-icon-right > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.medium-icon-right > li > img:first-child:last-child, .menu-bar.medium-icon-right > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.medium-icon-right > li > a {\n      -ms-flex-flow: row-reverse nowrap;\n          flex-flow: row-reverse nowrap; }\n      .menu-bar.medium-icon-right > li > a > img, .menu-bar.medium-icon-right > li > a > .iconic {\n        margin: 0 0 0 1rem; } }\n  @media only screen and (min-width: 40em) {\n    .menu-bar.medium-icon-bottom > li > img, .menu-bar.medium-icon-bottom > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.medium-icon-bottom > li > img:first-child:last-child, .menu-bar.medium-icon-bottom > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.medium-icon-bottom > li > a {\n      -ms-flex-flow: column-reverse nowrap;\n          flex-flow: column-reverse nowrap; }\n      .menu-bar.medium-icon-bottom > li > a > img, .menu-bar.medium-icon-bottom > li > a > .iconic {\n        margin: 1rem 0 0 0; } }\n  @media only screen and (min-width: 40em) {\n    .menu-bar.medium-icon-left > li > img, .menu-bar.medium-icon-left > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.medium-icon-left > li > img:first-child:last-child, .menu-bar.medium-icon-left > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.medium-icon-left > li > a {\n      -ms-flex-flow: row nowrap;\n          flex-flow: row nowrap;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n                  -ms-grid-row-align: center;\n              align-items: center; }\n      .menu-bar.medium-icon-left > li > a > img, .menu-bar.medium-icon-left > li > a > .iconic {\n        margin: 0 1rem 0 0; } }\n  @media only screen and (min-width: 75em) {\n    .menu-bar.large-icon-top > li > img, .menu-bar.large-icon-top > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.large-icon-top > li > img:first-child:last-child, .menu-bar.large-icon-top > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.large-icon-top > li > a {\n      -ms-flex-flow: column nowrap;\n          flex-flow: column nowrap; }\n      .menu-bar.large-icon-top > li > a > img, .menu-bar.large-icon-top > li > a > .iconic {\n        margin: 0 0 1rem 0; } }\n  @media only screen and (min-width: 75em) {\n    .menu-bar.large-icon-right > li > img, .menu-bar.large-icon-right > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.large-icon-right > li > img:first-child:last-child, .menu-bar.large-icon-right > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.large-icon-right > li > a {\n      -ms-flex-flow: row-reverse nowrap;\n          flex-flow: row-reverse nowrap; }\n      .menu-bar.large-icon-right > li > a > img, .menu-bar.large-icon-right > li > a > .iconic {\n        margin: 0 0 0 1rem; } }\n  @media only screen and (min-width: 75em) {\n    .menu-bar.large-icon-bottom > li > img, .menu-bar.large-icon-bottom > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.large-icon-bottom > li > img:first-child:last-child, .menu-bar.large-icon-bottom > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.large-icon-bottom > li > a {\n      -ms-flex-flow: column-reverse nowrap;\n          flex-flow: column-reverse nowrap; }\n      .menu-bar.large-icon-bottom > li > a > img, .menu-bar.large-icon-bottom > li > a > .iconic {\n        margin: 1rem 0 0 0; } }\n  @media only screen and (min-width: 75em) {\n    .menu-bar.large-icon-left > li > img, .menu-bar.large-icon-left > li > .iconic {\n      margin: 0;\n      width: 25px;\n      height: 25px; }\n      .menu-bar.large-icon-left > li > img:first-child:last-child, .menu-bar.large-icon-left > li > .iconic:first-child:last-child {\n        margin: 0; }\n    .menu-bar.large-icon-left > li > a {\n      -ms-flex-flow: row nowrap;\n          flex-flow: row nowrap;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n                  -ms-grid-row-align: center;\n              align-items: center; }\n      .menu-bar.large-icon-left > li > a > img, .menu-bar.large-icon-left > li > a > .iconic {\n        margin: 0 1rem 0 0; } }\n  .menu-bar.label-side > li {\n    position: relative; }\n    .menu-bar.label-side > li > a {\n      padding-right: 3.2rem; }\n  .menu-bar.label-side .menu-bar-label {\n    display: block;\n    font-size: 0.9rem;\n    width: 1.2rem;\n    height: 1.2rem;\n    line-height: 1.2rem;\n    text-align: center;\n    border-radius: 1000px;\n    background: red;\n    color: #fff;\n    position: absolute;\n    pointer-events: none;\n    right: 1rem;\n    top: 50%;\n    -webkit-transform: translateY(-50%);\n            transform: translateY(-50%); }\n  .menu-bar.label-corner > li {\n    position: relative; }\n    .menu-bar.label-corner > li > a {\n      padding-right: 3.2rem; }\n  .menu-bar.label-corner .menu-bar-label {\n    display: block;\n    font-size: 0.9rem;\n    width: 1.2rem;\n    height: 1.2rem;\n    line-height: 1.2rem;\n    text-align: center;\n    border-radius: 1000px;\n    background: red;\n    color: #fff;\n    position: absolute;\n    pointer-events: none;\n    right: 1rem;\n    top: 1rem; }\n  .menu-bar.primary {\n    background: #00558b; }\n    .menu-bar.primary > li > a {\n      color: #fff; }\n      .menu-bar.primary > li > a:hover {\n        background: #0065a5;\n        color: #fff; }\n    .menu-bar.primary .is-active > a {\n      background: #0065a5;\n      color: #fff; }\n    .menu-bar.primary .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .menu-bar.primary .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .menu-bar.dark {\n    background: #232323; }\n    .menu-bar.dark > li > a {\n      color: #fff; }\n      .menu-bar.dark > li > a:hover {\n        background: #323232;\n        color: #fff; }\n    .menu-bar.dark .is-active > a {\n      background: #323232;\n      color: #fff; }\n    .menu-bar.dark .iconic * {\n      fill: #fff;\n      stroke: #fff; }\n      .menu-bar.dark .iconic *.iconic-property-accent {\n        fill: #fff;\n        stroke: #fff; }\n  .menu-bar > li.title {\n    padding: 1rem;\n    cursor: default;\n    font-weight: bold; }\n\n.menu-group {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between;\n  -ms-flex-wrap: wrap;\n      flex-wrap: wrap; }\n  @media only screen and (min-width: 40em) {\n    .menu-group {\n      -ms-flex-wrap: nowrap;\n          flex-wrap: nowrap; } }\n  .menu-group > .menu-group-left, .menu-group > .menu-group-right {\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 100%;\n            flex: 1 1 100%; }\n    @media only screen and (min-width: 40em) {\n      .menu-group > .menu-group-left, .menu-group > .menu-group-right {\n        -webkit-box-flex: 0;\n            -ms-flex: 0 0 auto;\n                flex: 0 0 auto; } }\n  .menu-group .menu-bar {\n    margin: 0; }\n    .menu-group .menu-bar > li {\n      -webkit-box-flex: 0;\n          -ms-flex: 0 0 auto;\n              flex: 0 0 auto; }\n  .menu-group.primary {\n    background-color: #00558b; }\n    .menu-group.primary .menu-bar {\n      background: #00558b; }\n      .menu-group.primary .menu-bar > li > a {\n        color: #fff; }\n        .menu-group.primary .menu-bar > li > a:hover {\n          background: #0065a5;\n          color: #fff; }\n      .menu-group.primary .menu-bar .is-active > a {\n        background: #0065a5;\n        color: #fff; }\n      .menu-group.primary .menu-bar .iconic * {\n        fill: #fff;\n        stroke: #fff; }\n        .menu-group.primary .menu-bar .iconic *.iconic-property-accent {\n          fill: #fff;\n          stroke: #fff; }\n  .menu-group.dark {\n    background-color: #232323; }\n    .menu-group.dark .menu-bar {\n      background: #232323; }\n      .menu-group.dark .menu-bar > li > a {\n        color: #fff; }\n        .menu-group.dark .menu-bar > li > a:hover {\n          background: #323232;\n          color: #fff; }\n      .menu-group.dark .menu-bar .is-active > a {\n        background: #323232;\n        color: #fff; }\n      .menu-group.dark .menu-bar .iconic * {\n        fill: #fff;\n        stroke: #fff; }\n        .menu-group.dark .menu-bar .iconic *.iconic-property-accent {\n          fill: #fff;\n          stroke: #fff; }\n\n/*\r\n  MODAL\r\n  -----\r\n\r\n  The humble modal hides off-canvas until summoned with an fa-open directive. Modals appear over an overlay that darkens the rest of the page, and have a maxmimum width. You can construct a grid inside a modal, or attach panels to it.\r\n\r\n  Note that the modal overlay is hardcoded into the CSS, because whether or not you build your modal semantically, the overlay is always required and will always look the same.\r\n*/\n.modal {\n  position: relative;\n  z-index: 1001;\n  background: #fff;\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 auto;\n          flex: 0 0 auto;\n  width: 100%;\n  height: 100vh;\n  max-height: 100%;\n  overflow: hidden;\n  padding: 1rem; }\n  @media only screen and (min-width: 40em) {\n    .modal {\n      height: auto;\n      max-width: 600px; } }\n  .modal .grid-content, .modal .grid-block {\n    margin: 0; }\n  .modal .close-button, .modal [fa-close] {\n    z-index: 1001; }\n\n.modal {\n  max-width: 600px; }\n  .tiny > .modal {\n    max-width: 300px; }\n  .small > .modal {\n    max-width: 500px; }\n  .large > .modal {\n    max-width: 800px; }\n  .dialog > .modal {\n    height: auto; }\n  .collapse > .modal {\n    padding: 0; }\n\n.modal-overlay {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: 1000;\n  display: none;\n  background-color: rgba(51, 51, 51, 0.7);\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n              -ms-grid-row-align: center;\n          align-items: center;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-transform: translate3d(0, 0, 0); }\n  .modal-overlay.is-active {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n\n@-webkit-keyframes shake {\n  0%, 10%, 20%, 30%, 40%, 50%, 60%, 70%, 80%, 90% {\n    -webkit-transform: translateX(7%);\n            transform: translateX(7%); }\n  5%, 15%, 25%, 35%, 45%, 55%, 65%, 75%, 85%, 95% {\n    -webkit-transform: translateX(-7%);\n            transform: translateX(-7%); }\n  100% {\n    -webkit-transform: translateX(0);\n            transform: translateX(0); } }\n\n@keyframes shake {\n  0%, 10%, 20%, 30%, 40%, 50%, 60%, 70%, 80%, 90% {\n    -webkit-transform: translateX(7%);\n            transform: translateX(7%); }\n  5%, 15%, 25%, 35%, 45%, 55%, 65%, 75%, 85%, 95% {\n    -webkit-transform: translateX(-7%);\n            transform: translateX(-7%); }\n  100% {\n    -webkit-transform: translateX(0);\n            transform: translateX(0); } }\n\n@-webkit-keyframes spin-cw {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg); }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg); } }\n\n@keyframes spin-cw {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg); }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg); } }\n\n@-webkit-keyframes spin-ccw {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg); }\n  100% {\n    -webkit-transform: rotate(-360deg);\n            transform: rotate(-360deg); } }\n\n@keyframes spin-ccw {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg); }\n  100% {\n    -webkit-transform: rotate(-360deg);\n            transform: rotate(-360deg); } }\n\n@-webkit-keyframes wiggle {\n  40%, 50%, 60% {\n    -webkit-transform: rotate(7deg);\n            transform: rotate(7deg); }\n  35%, 45%, 55%, 65% {\n    -webkit-transform: rotate(-7deg);\n            transform: rotate(-7deg); }\n  0%, 30%, 70%, 100% {\n    -webkit-transform: rotate(0);\n            transform: rotate(0); } }\n\n@keyframes wiggle {\n  40%, 50%, 60% {\n    -webkit-transform: rotate(7deg);\n            transform: rotate(7deg); }\n  35%, 45%, 55%, 65% {\n    -webkit-transform: rotate(-7deg);\n            transform: rotate(-7deg); }\n  0%, 30%, 70%, 100% {\n    -webkit-transform: rotate(0);\n            transform: rotate(0); } }\n\n/*\r\n    Transitions\r\n  */\n.slideInUp.ng-enter, .slideInUp.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateY(100%);\n          transform: translateY(100%); }\n\n.slideInUp.ng-enter.ng-enter-active, .slideInUp.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideInRight.ng-enter, .slideInRight.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateX(-100%);\n          transform: translateX(-100%); }\n\n.slideInRight.ng-enter.ng-enter-active, .slideInRight.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideInDown.ng-enter, .slideInDown.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateY(-100%);\n          transform: translateY(-100%); }\n\n.slideInDown.ng-enter.ng-enter-active, .slideInDown.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideInLeft.ng-enter, .slideInLeft.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateX(100%);\n          transform: translateX(100%); }\n\n.slideInLeft.ng-enter.ng-enter-active, .slideInLeft.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideOutUp.ng-leave, .slideOutUp.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideOutUp.ng-leave.ng-leave-active, .slideOutUp.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: translateY(-100%);\n          transform: translateY(-100%); }\n\n.slideOutRight.ng-leave, .slideOutRight.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideOutRight.ng-leave.ng-leave-active, .slideOutRight.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: translateX(100%);\n          transform: translateX(100%); }\n\n.slideOutDown.ng-leave, .slideOutDown.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideOutDown.ng-leave.ng-leave-active, .slideOutDown.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: translateY(100%);\n          transform: translateY(100%); }\n\n.slideOutLeft.ng-leave, .slideOutLeft.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translateX(0) translateY(0);\n          transform: translateX(0) translateY(0); }\n\n.slideOutLeft.ng-leave.ng-leave-active, .slideOutLeft.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: translateX(-100%);\n          transform: translateX(-100%); }\n\n.fadeIn.ng-enter, .fadeIn.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity;\n  transition-property: opacity;\n  opacity: 0; }\n\n.fadeIn.ng-enter.ng-enter-active, .fadeIn.ng-hide-remove.ng-hide-remove-active {\n  opacity: 1; }\n\n.fadeOut.ng-leave, .fadeOut.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity;\n  transition-property: opacity;\n  opacity: 1; }\n\n.fadeOut.ng-leave.ng-leave-active, .fadeOut.ng-hide-add.ng-hide-add-active {\n  opacity: 0; }\n\n.hingeInFromTop.ng-enter, .hingeInFromTop.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: perspective(2000px) rotateX(-90deg);\n          transform: perspective(2000px) rotateX(-90deg);\n  -webkit-transform-origin: top;\n          transform-origin: top;\n  opacity: 0; }\n\n.hingeInFromTop.ng-enter.ng-enter-active, .hingeInFromTop.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  opacity: 1; }\n\n.hingeInFromRight.ng-enter, .hingeInFromRight.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: perspective(2000px) rotateY(-90deg);\n          transform: perspective(2000px) rotateY(-90deg);\n  -webkit-transform-origin: right;\n          transform-origin: right;\n  opacity: 0; }\n\n.hingeInFromRight.ng-enter.ng-enter-active, .hingeInFromRight.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  opacity: 1; }\n\n.hingeInFromBottom.ng-enter, .hingeInFromBottom.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: perspective(2000px) rotateX(90deg);\n          transform: perspective(2000px) rotateX(90deg);\n  -webkit-transform-origin: bottom;\n          transform-origin: bottom;\n  opacity: 0; }\n\n.hingeInFromBottom.ng-enter.ng-enter-active, .hingeInFromBottom.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  opacity: 1; }\n\n.hingeInFromLeft.ng-enter, .hingeInFromLeft.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: perspective(2000px) rotateY(90deg);\n          transform: perspective(2000px) rotateY(90deg);\n  -webkit-transform-origin: left;\n          transform-origin: left;\n  opacity: 0; }\n\n.hingeInFromLeft.ng-enter.ng-enter-active, .hingeInFromLeft.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  opacity: 1; }\n\n.hingeInFromMiddleX.ng-enter, .hingeInFromMiddleX.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: perspective(2000px) rotateX(-90deg);\n          transform: perspective(2000px) rotateX(-90deg);\n  -webkit-transform-origin: center;\n          transform-origin: center;\n  opacity: 0; }\n\n.hingeInFromMiddleX.ng-enter.ng-enter-active, .hingeInFromMiddleX.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  opacity: 1; }\n\n.hingeInFromMiddleY.ng-enter, .hingeInFromMiddleY.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: perspective(2000px) rotateY(-90deg);\n          transform: perspective(2000px) rotateY(-90deg);\n  -webkit-transform-origin: center;\n          transform-origin: center;\n  opacity: 0; }\n\n.hingeInFromMiddleY.ng-enter.ng-enter-active, .hingeInFromMiddleY.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  opacity: 1; }\n\n.hingeOutFromTop.ng-leave, .hingeOutFromTop.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  -webkit-transform-origin: top;\n          transform-origin: top;\n  opacity: 1; }\n\n.hingeOutFromTop.ng-leave.ng-leave-active, .hingeOutFromTop.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: perspective(2000px) rotateX(-90deg);\n          transform: perspective(2000px) rotateX(-90deg);\n  opacity: 0; }\n\n.hingeOutFromRight.ng-leave, .hingeOutFromRight.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  -webkit-transform-origin: right;\n          transform-origin: right;\n  opacity: 1; }\n\n.hingeOutFromRight.ng-leave.ng-leave-active, .hingeOutFromRight.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: perspective(2000px) rotateY(-90deg);\n          transform: perspective(2000px) rotateY(-90deg);\n  opacity: 0; }\n\n.hingeOutFromBottom.ng-leave, .hingeOutFromBottom.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  -webkit-transform-origin: bottom;\n          transform-origin: bottom;\n  opacity: 1; }\n\n.hingeOutFromBottom.ng-leave.ng-leave-active, .hingeOutFromBottom.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: perspective(2000px) rotateX(90deg);\n          transform: perspective(2000px) rotateX(90deg);\n  opacity: 0; }\n\n.hingeOutFromLeft.ng-leave, .hingeOutFromLeft.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  -webkit-transform-origin: left;\n          transform-origin: left;\n  opacity: 1; }\n\n.hingeOutFromLeft.ng-leave.ng-leave-active, .hingeOutFromLeft.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: perspective(2000px) rotateY(90deg);\n          transform: perspective(2000px) rotateY(90deg);\n  opacity: 0; }\n\n.hingeOutFromMiddleX.ng-leave, .hingeOutFromMiddleX.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  -webkit-transform-origin: center;\n          transform-origin: center;\n  opacity: 1; }\n\n.hingeOutFromMiddleX.ng-leave.ng-leave-active, .hingeOutFromMiddleX.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: perspective(2000px) rotateX(-90deg);\n          transform: perspective(2000px) rotateX(-90deg);\n  opacity: 0; }\n\n.hingeOutFromMiddleY.ng-leave, .hingeOutFromMiddleY.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0deg);\n          transform: rotate(0deg);\n  -webkit-transform-origin: center;\n          transform-origin: center;\n  opacity: 1; }\n\n.hingeOutFromMiddleY.ng-leave.ng-leave-active, .hingeOutFromMiddleY.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: perspective(2000px) rotateY(-90deg);\n          transform: perspective(2000px) rotateY(-90deg);\n  opacity: 0; }\n\n.zoomIn.ng-enter, .zoomIn.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: property, -webkit-transform;\n  transition-property: property, -webkit-transform;\n  transition-property: transform, property;\n  transition-property: transform, property, -webkit-transform;\n  -webkit-transform: scale(1.5);\n          transform: scale(1.5);\n  opacity: 0; }\n\n.zoomIn.ng-enter.ng-enter-active, .zoomIn.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: scale(1);\n          transform: scale(1);\n  opacity: 1; }\n\n.zoomOut.ng-leave, .zoomOut.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: property, -webkit-transform;\n  transition-property: property, -webkit-transform;\n  transition-property: transform, property;\n  transition-property: transform, property, -webkit-transform;\n  -webkit-transform: scale(0.5);\n          transform: scale(0.5);\n  opacity: 1; }\n\n.zoomOut.ng-leave.ng-leave-active, .zoomOut.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: scale(1);\n          transform: scale(1);\n  opacity: 0; }\n\n.spinIn.ng-enter, .spinIn.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(-270deg);\n          transform: rotate(-270deg);\n  opacity: 0; }\n\n.spinIn.ng-enter.ng-enter-active, .spinIn.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0);\n          transform: rotate(0);\n  opacity: 1; }\n\n.spinOut.ng-leave, .spinOut.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0);\n          transform: rotate(0);\n  opacity: 1; }\n\n.spinOut.ng-leave.ng-leave-active, .spinOut.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: rotate(270deg);\n          transform: rotate(270deg);\n  opacity: 0; }\n\n.spinInCCW.ng-enter, .spinInCCW.ng-hide-remove {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(270deg);\n          transform: rotate(270deg);\n  opacity: 0; }\n\n.spinInCCW.ng-enter.ng-enter-active, .spinInCCW.ng-hide-remove.ng-hide-remove-active {\n  -webkit-transform: rotate(0);\n          transform: rotate(0);\n  opacity: 1; }\n\n.spinOutCCW.ng-leave, .spinOutCCW.ng-hide-add {\n  -webkit-transition-duration: 500ms;\n          transition-duration: 500ms;\n  -webkit-transition-timing-function: ease;\n          transition-timing-function: ease;\n  -webkit-transition-delay: 0;\n          transition-delay: 0;\n  -webkit-transition-property: opacity, -webkit-transform;\n  transition-property: opacity, -webkit-transform;\n  transition-property: transform, opacity;\n  transition-property: transform, opacity, -webkit-transform;\n  -webkit-transform: rotate(0);\n          transform: rotate(0);\n  opacity: 1; }\n\n.spinOutCCW.ng-leave.ng-leave-active, .spinOutCCW.ng-hide-add.ng-hide-add-active {\n  -webkit-transform: rotate(-270deg);\n          transform: rotate(-270deg);\n  opacity: 0; }\n\n/*\r\n    Transition modifiers\r\n  */\n.slow {\n  -webkit-transition-duration: 750ms !important;\n          transition-duration: 750ms !important; }\n\n.fast {\n  -webkit-transition-duration: 250ms !important;\n          transition-duration: 250ms !important; }\n\n.linear {\n  -webkit-transition-timing-function: linear !important;\n          transition-timing-function: linear !important; }\n\n.ease {\n  -webkit-transition-timing-function: ease !important;\n          transition-timing-function: ease !important; }\n\n.easeIn {\n  -webkit-transition-timing-function: ease-in !important;\n          transition-timing-function: ease-in !important; }\n\n.easeOut {\n  -webkit-transition-timing-function: ease-out !important;\n          transition-timing-function: ease-out !important; }\n\n.easeInOut {\n  -webkit-transition-timing-function: ease-in-out !important;\n          transition-timing-function: ease-in-out !important; }\n\n.bounceIn {\n  -webkit-transition-timing-function: cubic-bezier(0.485, 0.155, 0.24, 1.245) !important;\n          transition-timing-function: cubic-bezier(0.485, 0.155, 0.24, 1.245) !important; }\n\n.bounceOut {\n  -webkit-transition-timing-function: cubic-bezier(0.485, 0.155, 0.515, 0.845) !important;\n          transition-timing-function: cubic-bezier(0.485, 0.155, 0.515, 0.845) !important; }\n\n.bounceInOut {\n  -webkit-transition-timing-function: cubic-bezier(0.76, -0.245, 0.24, 1.245) !important;\n          transition-timing-function: cubic-bezier(0.76, -0.245, 0.24, 1.245) !important; }\n\n.delay {\n  -webkit-transition-delay: 300ms !important;\n          transition-delay: 300ms !important; }\n\n.long-delay {\n  -webkit-transition-delay: 700ms !important;\n          transition-delay: 700ms !important; }\n\n/*\r\n    Animations\r\n  */\n.shake {\n  -webkit-animation-name: shake;\n          animation-name: shake;\n  -webkit-animation-duration: 500ms;\n          animation-duration: 500ms;\n  -webkit-animation-timing-function: ease;\n          animation-timing-function: ease;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translate3d(0, 0, 0);\n          transform: translate3d(0, 0, 0);\n  -webkit-animation-delay: 0;\n          animation-delay: 0; }\n\n.spin-cw {\n  -webkit-animation-name: spin-cw;\n          animation-name: spin-cw;\n  -webkit-animation-duration: 500ms;\n          animation-duration: 500ms;\n  -webkit-animation-timing-function: ease;\n          animation-timing-function: ease;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translate3d(0, 0, 0);\n          transform: translate3d(0, 0, 0);\n  -webkit-animation-delay: 0;\n          animation-delay: 0; }\n\n.spin-ccw {\n  -webkit-animation-name: spin-ccw;\n          animation-name: spin-ccw;\n  -webkit-animation-duration: 500ms;\n          animation-duration: 500ms;\n  -webkit-animation-timing-function: ease;\n          animation-timing-function: ease;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translate3d(0, 0, 0);\n          transform: translate3d(0, 0, 0);\n  -webkit-animation-delay: 0;\n          animation-delay: 0; }\n\n.wiggle {\n  -webkit-animation-name: wiggle;\n          animation-name: wiggle;\n  -webkit-animation-duration: 500ms;\n          animation-duration: 500ms;\n  -webkit-animation-timing-function: ease;\n          animation-timing-function: ease;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform: translate3d(0, 0, 0);\n          transform: translate3d(0, 0, 0);\n  -webkit-animation-delay: 0;\n          animation-delay: 0; }\n\n/*\r\n    Animation modifiers\r\n  */\n.shake.infinite, .spin-cw.infinite, .spin-ccw.infinite, .wiggle.infinite {\n  -webkit-animation-iteration-count: infinite;\n          animation-iteration-count: infinite; }\n\n.shake.linear, .spin-cw.linear, .spin-ccw.linear, .wiggle.linear {\n  -webkit-animation-timing-function: linear !important;\n          animation-timing-function: linear !important; }\n\n.shake.ease, .spin-cw.ease, .spin-ccw.ease, .wiggle.ease {\n  -webkit-animation-timing-function: ease !important;\n          animation-timing-function: ease !important; }\n\n.shake.easeIn, .spin-cw.easeIn, .spin-ccw.easeIn, .wiggle.easeIn {\n  -webkit-animation-timing-function: ease-in !important;\n          animation-timing-function: ease-in !important; }\n\n.shake.easeOut, .spin-cw.easeOut, .spin-ccw.easeOut, .wiggle.easeOut {\n  -webkit-animation-timing-function: ease-out !important;\n          animation-timing-function: ease-out !important; }\n\n.shake.easeInOut, .spin-cw.easeInOut, .spin-ccw.easeInOut, .wiggle.easeInOut {\n  -webkit-animation-timing-function: ease-in-out !important;\n          animation-timing-function: ease-in-out !important; }\n\n.shake.bounceIn, .spin-cw.bounceIn, .spin-ccw.bounceIn, .wiggle.bounceIn {\n  -webkit-animation-timing-function: cubic-bezier(0.485, 0.155, 0.24, 1.245) !important;\n          animation-timing-function: cubic-bezier(0.485, 0.155, 0.24, 1.245) !important; }\n\n.shake.bounceOut, .spin-cw.bounceOut, .spin-ccw.bounceOut, .wiggle.bounceOut {\n  -webkit-animation-timing-function: cubic-bezier(0.485, 0.155, 0.515, 0.845) !important;\n          animation-timing-function: cubic-bezier(0.485, 0.155, 0.515, 0.845) !important; }\n\n.shake.bounceInOut, .spin-cw.bounceInOut, .spin-ccw.bounceInOut, .wiggle.bounceInOut {\n  -webkit-animation-timing-function: cubic-bezier(0.76, -0.245, 0.24, 1.245) !important;\n          animation-timing-function: cubic-bezier(0.76, -0.245, 0.24, 1.245) !important; }\n\n.shake.slow, .spin-cw.slow, .spin-ccw.slow, .wiggle.slow {\n  -webkit-animation-duration: 750ms !important;\n          animation-duration: 750ms !important; }\n\n.shake.fast, .spin-cw.fast, .spin-ccw.fast, .wiggle.fast {\n  -webkit-animation-duration: 250ms !important;\n          animation-duration: 250ms !important; }\n\n.shake.delay, .spin-cw.delay, .spin-ccw.delay, .wiggle.delay {\n  -webkit-animation-delay: 300ms !important;\n          animation-delay: 300ms !important; }\n\n.shake.long-delay, .spin-cw.long-delay, .spin-ccw.long-delay, .wiggle.long-delay {\n  -webkit-animation-delay: 700ms !important;\n          animation-delay: 700ms !important; }\n\n.stagger {\n  -webkit-transition-delay: 150ms;\n          transition-delay: 150ms;\n  -webkit-transition-duration: 0;\n          transition-duration: 0; }\n\n.stort-stagger {\n  -webkit-transition-delay: 150ms;\n          transition-delay: 150ms;\n  -webkit-transition-duration: 0;\n          transition-duration: 0; }\n\n.long-stagger {\n  -webkit-transition-delay: 150ms;\n          transition-delay: 150ms;\n  -webkit-transition-duration: 0;\n          transition-duration: 0; }\n\n.position-absolute {\n  overflow: hidden;\n  position: relative; }\n\n[ui-view].ng-enter-active, [ui-view].ng-leave-active {\n  position: absolute !important;\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n  -webkit-transform-style: preserve-3d;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0; }\n\n/*\r\n  NOTIFICATION\r\n  ------------\r\n\r\n  An alert that pins to the corner of the screen when triggered by JavaScript. It can be set to disappear after a certain period of time, or to stay put until the user clicks on it. A custom action can be asigned to a notification as well.\r\n\r\n  Optionally, the notifications directive can also tap into the browser's native notification support, if it exists.\r\n*/\n.notification, .static-notification {\n  z-index: 1000;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  position: relative;\n  margin-top: .5rem;\n  margin-bottom: .5rem;\n  display: none; }\n  .notification h1, .static-notification h1 {\n    font-size: 1.25em;\n    margin: 0; }\n  .notification p, .static-notification p {\n    margin: 0; }\n  .is-active.notification, .is-active.static-notification {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n  .notification .close-button, .static-notification .close-button {\n    color: white; }\n\n.notification-container {\n  z-index: 3000;\n  position: fixed;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column; }\n\n/*\r\n  CSS Output\r\n*/\n.notification {\n  background: #00558b;\n  padding: 1rem;\n  border-radius: 4px; }\n  .notification, .notification h1, .notification h2, .notification h3, .notification h4, .notification h5, .notification h6 {\n    color: white; }\n  .notification.success {\n    background: #43AC6A;\n    padding: 1rem;\n    border-radius: 4px; }\n    .notification.success, .notification.success h1, .notification.success h2, .notification.success h3, .notification.success h4, .notification.success h5, .notification.success h6 {\n      color: white; }\n  .notification.warning {\n    background: #F08A24;\n    padding: 1rem;\n    border-radius: 4px; }\n    .notification.warning, .notification.warning h1, .notification.warning h2, .notification.warning h3, .notification.warning h4, .notification.warning h5, .notification.warning h6 {\n      color: white; }\n  .notification.alert {\n    background: #F04124;\n    padding: 1rem;\n    border-radius: 4px; }\n    .notification.alert, .notification.alert h1, .notification.alert h2, .notification.alert h3, .notification.alert h4, .notification.alert h5, .notification.alert h6 {\n      color: white; }\n  .notification.dark {\n    background: #232323;\n    padding: 1rem;\n    border-radius: 4px; }\n    .notification.dark, .notification.dark h1, .notification.dark h2, .notification.dark h3, .notification.dark h4, .notification.dark h5, .notification.dark h6 {\n      color: #fff; }\n\n.static-notification {\n  background: #00558b;\n  padding: 1rem;\n  border-radius: 4px;\n  position: fixed !important; }\n  .static-notification, .static-notification h1, .static-notification h2, .static-notification h3, .static-notification h4, .static-notification h5, .static-notification h6 {\n    color: white; }\n  .static-notification.top-right {\n    width: 25rem;\n    right: 1rem;\n    top: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .static-notification.top-right {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .static-notification.top-left {\n    width: 25rem;\n    left: 1rem;\n    top: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .static-notification.top-left {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .static-notification.top-middle {\n    width: 25rem;\n    left: 50%;\n    margin-left: -12.5rem;\n    top: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .static-notification.top-middle {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .static-notification.bottom-right {\n    width: 25rem;\n    right: 1rem;\n    top: auto;\n    bottom: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .static-notification.bottom-right {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .static-notification.bottom-left {\n    width: 25rem;\n    left: 1rem;\n    top: auto;\n    bottom: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .static-notification.bottom-left {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .static-notification.bottom-middle {\n    width: 25rem;\n    left: 50%;\n    margin-left: -12.5rem;\n    top: auto;\n    bottom: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .static-notification.bottom-middle {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .static-notification.success {\n    background: #43AC6A;\n    padding: 1rem;\n    border-radius: 4px; }\n    .static-notification.success, .static-notification.success h1, .static-notification.success h2, .static-notification.success h3, .static-notification.success h4, .static-notification.success h5, .static-notification.success h6 {\n      color: white; }\n  .static-notification.warning {\n    background: #F08A24;\n    padding: 1rem;\n    border-radius: 4px; }\n    .static-notification.warning, .static-notification.warning h1, .static-notification.warning h2, .static-notification.warning h3, .static-notification.warning h4, .static-notification.warning h5, .static-notification.warning h6 {\n      color: white; }\n  .static-notification.alert {\n    background: #F04124;\n    padding: 1rem;\n    border-radius: 4px; }\n    .static-notification.alert, .static-notification.alert h1, .static-notification.alert h2, .static-notification.alert h3, .static-notification.alert h4, .static-notification.alert h5, .static-notification.alert h6 {\n      color: white; }\n  .static-notification.dark {\n    background: #232323;\n    padding: 1rem;\n    border-radius: 4px; }\n    .static-notification.dark, .static-notification.dark h1, .static-notification.dark h2, .static-notification.dark h3, .static-notification.dark h4, .static-notification.dark h5, .static-notification.dark h6 {\n      color: #fff; }\n\n.notification-container {\n  width: 25rem;\n  right: 1rem;\n  top: 1rem; }\n  @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n    .notification-container {\n      width: auto;\n      left: 1rem;\n      right: 1rem;\n      margin-left: 0; } }\n  .notification-container.top-right {\n    width: 25rem;\n    right: 1rem;\n    top: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .notification-container.top-right {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .notification-container.top-left {\n    width: 25rem;\n    left: 1rem;\n    top: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .notification-container.top-left {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .notification-container.top-middle {\n    width: 25rem;\n    left: 50%;\n    margin-left: -12.5rem;\n    top: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .notification-container.top-middle {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .notification-container.bottom-right {\n    width: 25rem;\n    right: 1rem;\n    top: auto;\n    bottom: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .notification-container.bottom-right {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .notification-container.bottom-left {\n    width: 25rem;\n    left: 1rem;\n    top: auto;\n    bottom: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .notification-container.bottom-left {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n  .notification-container.bottom-middle {\n    width: 25rem;\n    left: 50%;\n    margin-left: -12.5rem;\n    top: auto;\n    bottom: 1rem; }\n    @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n      .notification-container.bottom-middle {\n        width: auto;\n        left: 1rem;\n        right: 1rem;\n        margin-left: 0; } }\n\n.notification-icon {\n  -webkit-box-flex: 0;\n      -ms-flex: 0 0 60px;\n          flex: 0 0 60px;\n  margin-right: 1rem;\n  -ms-flex-item-align: start;\n      align-self: flex-start; }\n  .notification-icon img {\n    width: 100%;\n    height: auto; }\n\n.notification-content {\n  -webkit-box-flex: 1;\n      -ms-flex: 1;\n          flex: 1; }\n\n/*\r\n\tOff-canvas menu\r\n  ---------------\r\n\r\n  A generic container that stays fixed to the left, top, right, or bottom of the screen, and is summoned when needed. When an off-canvas panel is open, the app frame shifts over to reveal the menu.\r\n*/\n.off-canvas {\n  position: fixed;\n  overflow: auto;\n  -webkit-overflow-scrolling: touch;\n  -webkit-transition: -webkit-transform 0.25s ease-out;\n  transition: -webkit-transform 0.25s ease-out;\n  transition: transform 0.25s ease-out;\n  transition: transform 0.25s ease-out, -webkit-transform 0.25s ease-out;\n  z-index: 2; }\n  .is-active.off-canvas {\n    -webkit-transform: translate(0, 0) !important;\n            transform: translate(0, 0) !important; }\n  .off-canvas ~ .grid-frame {\n    -webkit-transform: translate(0, 0, 0);\n            transform: translate(0, 0, 0);\n    -webkit-transition: -webkit-transform 0.25s ease-out;\n    transition: -webkit-transform 0.25s ease-out;\n    transition: transform 0.25s ease-out;\n    transition: transform 0.25s ease-out, -webkit-transform 0.25s ease-out;\n    -webkit-backface-visibility: hidden;\n            backface-visibility: hidden;\n    background: white; }\n\n.off-canvas {\n  /*\r\n    Get shadow values for later use\r\n  */\n  /*\r\n    Sizing\r\n  */\n  width: 250px;\n  height: 100%;\n  /*\r\n    Positioning\r\n  */\n  top: 0;\n  left: 0;\n  box-shadow: inset -3px 0 10px rgba(0, 0, 0, 0.25);\n  -webkit-transform: translateX(-100%);\n          transform: translateX(-100%);\n  background: #fff;\n  color: #000; }\n  .off-canvas.is-active ~ .grid-frame {\n    -webkit-transform: translateX(250px) !important;\n            transform: translateX(250px) !important; }\n  .off-canvas.top {\n    /*\r\n    Get shadow values for later use\r\n  */\n    /*\r\n    Sizing\r\n  */\n    height: 250px;\n    width: 100%;\n    /*\r\n    Positioning\r\n  */\n    top: 0;\n    left: 0;\n    -webkit-transform: translateY(-100%);\n            transform: translateY(-100%);\n    box-shadow: inset 0 -3px 10px rgba(0, 0, 0, 0.25); }\n    .off-canvas.top.is-active ~ .grid-frame {\n      -webkit-transform: translateY(250px) !important;\n              transform: translateY(250px) !important; }\n  .off-canvas.right {\n    /*\r\n    Get shadow values for later use\r\n  */\n    /*\r\n    Sizing\r\n  */\n    width: 250px;\n    height: 100%;\n    /*\r\n    Positioning\r\n  */\n    left: auto;\n    top: 0;\n    right: 0;\n    box-shadow: inset 3px 0 10px rgba(0, 0, 0, 0.25);\n    -webkit-transform: translateX(100%);\n            transform: translateX(100%); }\n    .off-canvas.right.is-active ~ .grid-frame {\n      -webkit-transform: translateX(-250px) !important;\n              transform: translateX(-250px) !important; }\n  .off-canvas.bottom {\n    /*\r\n    Get shadow values for later use\r\n  */\n    /*\r\n    Sizing\r\n  */\n    height: 250px;\n    width: 100%;\n    /*\r\n    Positioning\r\n  */\n    top: auto;\n    bottom: 0;\n    left: 0;\n    -webkit-transform: translateY(100%);\n            transform: translateY(100%);\n    box-shadow: inset 0 3px 10px rgba(0, 0, 0, 0.25); }\n    .off-canvas.bottom.is-active ~ .grid-frame {\n      -webkit-transform: translateY(-250px) !important;\n              transform: translateY(-250px) !important; }\n  .off-canvas.left {\n    /*\r\n    Get shadow values for later use\r\n  */\n    /*\r\n    Sizing\r\n  */\n    width: 250px;\n    height: 100%;\n    /*\r\n    Positioning\r\n  */\n    top: 0;\n    left: 0;\n    box-shadow: inset -3px 0 10px rgba(0, 0, 0, 0.25);\n    -webkit-transform: translateX(-100%);\n            transform: translateX(-100%); }\n    .off-canvas.left.is-active ~ .grid-frame {\n      -webkit-transform: translateX(250px) !important;\n              transform: translateX(250px) !important; }\n  .off-canvas.detached {\n    z-index: 0;\n    box-shadow: none; }\n    .off-canvas.detached, .off-canvas.detached.is-active {\n      -webkit-transform: none;\n              transform: none; }\n    .off-canvas.detached ~ .grid-frame {\n      z-index: 1;\n      box-shadow: 0 0 15px rgba(0, 0, 0, 0.5); }\n  .off-canvas.primary {\n    background: #00558b;\n    color: #fff; }\n  .off-canvas.dark {\n    background: #232323;\n    color: #fff; }\n\n/*\r\n  POPUP\r\n  -----\r\n\r\n  A floating container that can anchor to any other on-screen element, and contain any content, including grid blocks or panels.\r\n*/\n.popup {\n  position: absolute;\n  z-index: 1000;\n  opacity: 0;\n  overflow: hidden;\n  -webkit-transition: opacity 0.25s ease-out;\n  transition: opacity 0.25s ease-out;\n  pointer-events: none; }\n  .tether-enabled.popup {\n    opacity: 1;\n    pointer-events: auto; }\n\n.popup {\n  width: 18.75rem;\n  background: #fff;\n  border-radius: 0;\n  box-shadow: 0 0 10px rgba(0, 0, 0, 0.25);\n  border: 0; }\n  .popup.dark {\n    background: #232323;\n    border-radius: 0;\n    box-shadow: 0 0 10px rgba(0, 0, 0, 0.25);\n    border: 0; }\n  .popup.primary {\n    background: #00558b;\n    border-radius: 0;\n    box-shadow: 0 0 10px rgba(0, 0, 0, 0.25);\n    border: 0; }\n\n/*\r\n  SWITCH\r\n  ------\r\n*/\n.switch {\n  position: relative;\n  overflow: hidden;\n  display: inline-block; }\n  .switch > input {\n    position: absolute;\n    left: -9999px;\n    outline: none; }\n  .switch > label {\n    -ms-touch-action: manipulation;\n    touch-action: manipulation;\n    display: block;\n    width: 100%;\n    height: 100%;\n    cursor: pointer;\n    margin: 0; }\n    .switch > label::after {\n      content: '';\n      display: block;\n      position: absolute;\n      top: 0;\n      left: 0; }\n  .switch input + label {\n    margin-left: 0; }\n\n/*\r\n  Defines the dimmensions of the switch.\r\n\r\n  $width - width of the switch.\r\n  $height - height of the switch.\r\n*/\n.switch {\n  width: 3.125rem;\n  height: 2rem;\n  border-radius: 9999px; }\n  .switch > label::after {\n    width: 2rem;\n    height: 2rem; }\n  .switch input:checked + label::after {\n    left: 1.125rem; }\n  .switch > label {\n    background: #ccc; }\n    .switch > label::after {\n      background: white;\n      border-radius: 9999px;\n      -webkit-transition: left 0.15s ease-out;\n      transition: left 0.15s ease-out;\n      border: 4px solid #ccc; }\n  .switch input:checked + label {\n    background: #00558b;\n    margin: 0; }\n    .switch input:checked + label::after {\n      border-color: #00558b; }\n  .switch.small {\n    width: 2.5rem;\n    height: 1.625rem; }\n    .switch.small > label::after {\n      width: 1.625rem;\n      height: 1.625rem; }\n    .switch.small input:checked + label::after {\n      left: 0.875rem; }\n  .switch.large {\n    width: 3.75rem;\n    height: 2.375rem; }\n    .switch.large > label::after {\n      width: 2.375rem;\n      height: 2.375rem; }\n    .switch.large input:checked + label::after {\n      left: 1.375rem; }\n\n/*\r\n  TABS\r\n  ----\r\n*/\n.tabs {\n  /*\r\n\t\tContainer styles\r\n\t*/\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  background: transparent;\n  -ms-flex-flow: row wrap;\n      flex-flow: row wrap; }\n  .tabs.vertical {\n    /*\r\n\t\tContainer styles\r\n\t*/\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    background: transparent;\n    -ms-flex-flow: column nowrap;\n        flex-flow: column nowrap; }\n  .tabs .tab-item {\n    background: #f3f3f3;\n    padding: 1rem;\n    line-height: 1;\n    margin: 0;\n    -webkit-box-flex: 0;\n        -ms-flex: 0 1 auto;\n            flex: 0 1 auto;\n    cursor: pointer;\n    color: #000; }\n    .tabs .tab-item.is-active {\n      background: #ececec;\n      color: #000; }\n      .tabs .tab-item.is-active:hover {\n        background: #e7e7e7; }\n    .tabs .tab-item:hover {\n      background: #e7e7e7; }\n\n.tab-contents {\n  padding: 1rem; }\n  .tab-contents .tab-content {\n    display: none; }\n    .tab-contents .tab-content.is-active {\n      display: block; }\n\n/*\r\n  ACCORDION\r\n  ---------\r\n\r\n  The trusy accordion allows you to create a series of vertical tabs.\r\n*/\n.accordion {\n  border: 1px solid #cbcbcb; }\n\n.accordion-title {\n  padding: 1rem;\n  background: #f3f3f3;\n  color: #000;\n  line-height: 1;\n  cursor: pointer; }\n  .accordion-title:hover {\n    background: #e7e7e7; }\n  .is-active > .accordion-title {\n    background: #ececec;\n    color: #000; }\n\n.accordion-content {\n  padding: 1rem;\n  display: none; }\n  .is-active > .accordion-content {\n    display: block; }\n\n/*\r\n  TYPOGRAPHY\r\n  ----------\r\n\r\n  Includes typographic resets for many common elements, and a few helper classes.\r\n   - Headers\r\n   - Subheaders\r\n   - Lead paragraphs\r\n   - Ordered/unordered lists\r\n   - Code samples\r\n   - Anchors\r\n   - Dividers\r\n   - Blockquotes\r\n   - Acronyms\r\n*/\n/* Typography resets */\ndiv, dl, dt, dd, ul, ol, li, h1, h2, h3, h4, h5, h6, pre, form, p, blockquote, th, td {\n  margin: 0;\n  padding: 0; }\n\n/* Default Link Styles */\na {\n  color: #00558b;\n  text-decoration: none;\n  line-height: inherit; }\n  a[ui-sref] {\n    cursor: pointer; }\n  a:hover, a:focus {\n    color: #004978; }\n  a img {\n    border: none; }\n\n/* Default paragraph styles */\np {\n  font-family: inherit;\n  font-weight: normal;\n  font-size: 1rem;\n  line-height: 1.6;\n  margin-bottom: 1.25rem;\n  text-rendering: optimizeLegibility; }\n  p.lead {\n    font-size: 1.21875rem;\n    line-height: 1.6; }\n  p aside {\n    font-size: 0.875rem;\n    line-height: 1.35;\n    font-style: italic; }\n\n/* Default header styles */\nh1, h2, h3, h4, h5, h6 {\n  font-family: \"Helvetica Neue\", \"Helvetica\", Helvetica, Arial, sans-serif;\n  font-weight: normal;\n  font-style: normal;\n  color: #222;\n  text-rendering: optimizeLegibility;\n  margin-top: 0.2rem;\n  margin-bottom: 0.5rem;\n  line-height: 1.4; }\n  h1 small, h2 small, h3 small, h4 small, h5 small, h6 small {\n    font-size: 60%;\n    color: #6f6f6f;\n    line-height: 0; }\n\nh1 {\n  font-size: 2.125rem; }\n\nh2 {\n  font-size: 1.6875rem; }\n\nh3 {\n  font-size: 1.375rem; }\n\nh4 {\n  font-size: 1.125rem; }\n\nh5 {\n  font-size: 1.125rem; }\n\nh6 {\n  font-size: 1rem; }\n\n.subheader {\n  line-height: 1.4;\n  color: #6f6f6f;\n  font-weight: normal;\n  margin-top: 0.2rem;\n  margin-bottom: 0.5rem; }\n\nhr {\n  border: solid #ddd;\n  border-width: 1px 0 0;\n  clear: both;\n  margin: 1.25rem 0 1.1875rem;\n  height: 0; }\n\n/* Helpful Typography Defaults */\nem, i {\n  font-style: italic;\n  line-height: inherit; }\n\nstrong, b {\n  font-weight: bold;\n  line-height: inherit; }\n\nsmall {\n  font-size: 60%;\n  color: #6f6f6f;\n  line-height: inherit; }\n\ncode {\n  font-family: Consolas, \"Liberation Mono\", Courier, monospace;\n  font-weight: normal;\n  color: #464646;\n  background-color: #fbfbfb;\n  border-width: 1px;\n  border-style: solid;\n  border-color: #e2e2e2;\n  padding: 0.125rem 0.3125rem 0.0625rem; }\n\n/* Lists */\nul, ol, dl {\n  font-size: 1rem;\n  line-height: 1.6;\n  margin-bottom: 1.25rem;\n  list-style-position: outside;\n  font-family: inherit; }\n\n/* Lists */\nul, ol {\n  margin-left: 1.1rem; }\n  ul li ul, ul li ol, ol li ul, ol li ol {\n    margin-left: 1.25rem;\n    margin-bottom: 0; }\n\n/* Lists without bullets */\nul.no-bullet {\n  margin-left: 0; }\n  ul.no-bullet, ul.no-bullet li ul, ul.no-bullet li ol {\n    list-style-type: none; }\n\n/* Definition Lists */\ndl dt {\n  margin-bottom: 0.3rem;\n  font-weight: bold; }\n\ndl dd {\n  margin-bottom: 0.75rem; }\n\n/* Abbreviations */\nabbr, acronym {\n  text-transform: uppercase;\n  font-size: 90%;\n  color: #222;\n  border-bottom: 1px dotted #ddd;\n  cursor: help; }\n\nabbr {\n  text-transform: none; }\n\n/* Blockquotes */\nblockquote {\n  margin: 0 0 1.25rem;\n  padding: 0.5625rem 1.25rem 0 1.1875rem;\n  border-left: 1px solid #ddd; }\n  blockquote cite {\n    display: block;\n    font-size: 0.8125rem;\n    color: #555555; }\n    blockquote cite:before {\n      content: \"\\2014    \"; }\n    blockquote cite a, blockquote cite a:visited {\n      color: #555555; }\n\nblockquote, blockquote p {\n  line-height: 1.6;\n  color: #6f6f6f; }\n\n@media only screen and (min-width: 40em) {\n  h1, h2, h3, h4, h5, h6 {\n    line-height: 1.4; }\n  h1 {\n    font-size: 2.75rem; }\n  h2 {\n    font-size: 2.3125rem; }\n  h3 {\n    font-size: 1.6875rem; }\n  h4 {\n    font-size: 1.4375rem; }\n  h5 {\n    font-size: 1.125rem; }\n  h6 {\n    font-size: 1rem; } }\n\n/*\r\n  UTILITIES\r\n  ---------\r\n\r\n  Responsive helper classes to assist you in quickly doing basic formatting and layout.\r\n\r\n  Features:\r\n   - Vertical alignment\r\n   - Visibility\r\n   - Text alignment\r\n   - Floating\r\n*/\n.v-align {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between; }\n  .v-align .align-top {\n    -ms-flex-item-align: start;\n        align-self: flex-start; }\n  .v-align .align-center {\n    -ms-flex-item-align: center;\n        align-self: center; }\n  .v-align .align-bottom {\n    -ms-flex-item-align: end;\n        align-self: flex-end; }\n  .v-align .small-align-top {\n    -ms-flex-item-align: start;\n        align-self: flex-start; }\n  .v-align .small-align-center {\n    -ms-flex-item-align: center;\n        align-self: center; }\n  .v-align .small-align-bottom {\n    -ms-flex-item-align: end;\n        align-self: flex-end; }\n  @media only screen and (min-width: 40em) {\n    .v-align .medium-align-top {\n      -ms-flex-item-align: start;\n          align-self: flex-start; } }\n  @media only screen and (min-width: 40em) {\n    .v-align .medium-align-center {\n      -ms-flex-item-align: center;\n          align-self: center; } }\n  @media only screen and (min-width: 40em) {\n    .v-align .medium-align-bottom {\n      -ms-flex-item-align: end;\n          align-self: flex-end; } }\n  @media only screen and (min-width: 75em) {\n    .v-align .large-align-top {\n      -ms-flex-item-align: start;\n          align-self: flex-start; } }\n  @media only screen and (min-width: 75em) {\n    .v-align .large-align-center {\n      -ms-flex-item-align: center;\n          align-self: center; } }\n  @media only screen and (min-width: 75em) {\n    .v-align .large-align-bottom {\n      -ms-flex-item-align: end;\n          align-self: flex-end; } }\n\n.hide {\n  display: none !important; }\n\n.invisible {\n  visibility: hidden; }\n\n.hide-for-small:not(.ng-hide) {\n  display: block !important;\n  display: none !important; }\n\n.hide-for-small[class*=\"grid-block\"]:not(.ng-hide) {\n  display: -webkit-box !important;\n  display: -ms-flexbox !important;\n  display: flex !important;\n  display: none !important; }\n\n.show-for-small:not(.ng-hide) {\n  display: none !important;\n  display: block !important; }\n\n.show-for-small[class*=\"grid-block\"]:not(.ng-hide) {\n  display: none !important;\n  display: -webkit-box !important;\n  display: -ms-flexbox !important;\n  display: flex !important; }\n\n.hide-for-small-only:not(.ng-hide) {\n  display: block !important; }\n  @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n    .hide-for-small-only:not(.ng-hide) {\n      display: none !important; } }\n\n.hide-for-small-only[class*=\"grid-block\"]:not(.ng-hide) {\n  display: -webkit-box !important;\n  display: -ms-flexbox !important;\n  display: flex !important; }\n  @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n    .hide-for-small-only[class*=\"grid-block\"]:not(.ng-hide) {\n      display: none !important; } }\n\n.show-for-small-only:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n    .show-for-small-only:not(.ng-hide) {\n      display: block !important; } }\n\n.show-for-small-only[class*=\"grid-block\"]:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n    .show-for-small-only[class*=\"grid-block\"]:not(.ng-hide) {\n      display: -webkit-box !important;\n      display: -ms-flexbox !important;\n      display: flex !important; } }\n\n.hide-for-medium:not(.ng-hide) {\n  display: block !important; }\n  @media only screen and (min-width: 40em) {\n    .hide-for-medium:not(.ng-hide) {\n      display: none !important; } }\n\n.hide-for-medium[class*=\"grid-block\"]:not(.ng-hide) {\n  display: -webkit-box !important;\n  display: -ms-flexbox !important;\n  display: flex !important; }\n  @media only screen and (min-width: 40em) {\n    .hide-for-medium[class*=\"grid-block\"]:not(.ng-hide) {\n      display: none !important; } }\n\n.show-for-medium:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 40em) {\n    .show-for-medium:not(.ng-hide) {\n      display: block !important; } }\n\n.show-for-medium[class*=\"grid-block\"]:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 40em) {\n    .show-for-medium[class*=\"grid-block\"]:not(.ng-hide) {\n      display: -webkit-box !important;\n      display: -ms-flexbox !important;\n      display: flex !important; } }\n\n.hide-for-medium-only:not(.ng-hide) {\n  display: block !important; }\n  @media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n    .hide-for-medium-only:not(.ng-hide) {\n      display: none !important; } }\n\n.hide-for-medium-only[class*=\"grid-block\"]:not(.ng-hide) {\n  display: -webkit-box !important;\n  display: -ms-flexbox !important;\n  display: flex !important; }\n  @media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n    .hide-for-medium-only[class*=\"grid-block\"]:not(.ng-hide) {\n      display: none !important; } }\n\n.show-for-medium-only:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n    .show-for-medium-only:not(.ng-hide) {\n      display: block !important; } }\n\n.show-for-medium-only[class*=\"grid-block\"]:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n    .show-for-medium-only[class*=\"grid-block\"]:not(.ng-hide) {\n      display: -webkit-box !important;\n      display: -ms-flexbox !important;\n      display: flex !important; } }\n\n.hide-for-large:not(.ng-hide) {\n  display: block !important; }\n  @media only screen and (min-width: 75em) {\n    .hide-for-large:not(.ng-hide) {\n      display: none !important; } }\n\n.hide-for-large[class*=\"grid-block\"]:not(.ng-hide) {\n  display: -webkit-box !important;\n  display: -ms-flexbox !important;\n  display: flex !important; }\n  @media only screen and (min-width: 75em) {\n    .hide-for-large[class*=\"grid-block\"]:not(.ng-hide) {\n      display: none !important; } }\n\n.show-for-large:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 75em) {\n    .show-for-large:not(.ng-hide) {\n      display: block !important; } }\n\n.show-for-large[class*=\"grid-block\"]:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 75em) {\n    .show-for-large[class*=\"grid-block\"]:not(.ng-hide) {\n      display: -webkit-box !important;\n      display: -ms-flexbox !important;\n      display: flex !important; } }\n\n.hide-for-large-only:not(.ng-hide) {\n  display: block !important; }\n  @media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n    .hide-for-large-only:not(.ng-hide) {\n      display: none !important; } }\n\n.hide-for-large-only[class*=\"grid-block\"]:not(.ng-hide) {\n  display: -webkit-box !important;\n  display: -ms-flexbox !important;\n  display: flex !important; }\n  @media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n    .hide-for-large-only[class*=\"grid-block\"]:not(.ng-hide) {\n      display: none !important; } }\n\n.show-for-large-only:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n    .show-for-large-only:not(.ng-hide) {\n      display: block !important; } }\n\n.show-for-large-only[class*=\"grid-block\"]:not(.ng-hide) {\n  display: none !important; }\n  @media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n    .show-for-large-only[class*=\"grid-block\"]:not(.ng-hide) {\n      display: -webkit-box !important;\n      display: -ms-flexbox !important;\n      display: flex !important; } }\n\n@media only screen and (orientation: portrait) {\n  .hide-for-portrait {\n    display: none !important; }\n    .hide-for-portrait[class*=\"grid-block\"] {\n      display: -webkit-box !important;\n      display: -ms-flexbox !important;\n      display: flex !important; } }\n\n.show-for-portrait {\n  display: none !important; }\n  @media only screen and (orientation: portrait) {\n    .show-for-portrait {\n      display: block !important; }\n      .show-for-portrait[class*=\"grid-block\"] {\n        display: -webkit-box !important;\n        display: -ms-flexbox !important;\n        display: flex !important; } }\n\n@media only screen and (orientation: landscape) {\n  .hide-for-landscape {\n    display: none !important; }\n    .hide-for-landscape[class*=\"grid-block\"] {\n      display: -webkit-box !important;\n      display: -ms-flexbox !important;\n      display: flex !important; } }\n\n.show-for-landscape {\n  display: none !important; }\n  @media only screen and (orientation: landscape) {\n    .show-for-landscape {\n      display: block !important; }\n      .show-for-landscape[class*=\"grid-block\"] {\n        display: -webkit-box !important;\n        display: -ms-flexbox !important;\n        display: flex !important; } }\n\n/*\r\n    Text alignment\r\n  */\n.text-left {\n  text-align: left; }\n\n.small-text-left {\n  text-align: left; }\n\n@media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n  .small-only-text-left {\n    text-align: left; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-text-left {\n    text-align: left; } }\n\n@media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n  .medium-only-text-left {\n    text-align: left; } }\n\n@media only screen and (min-width: 75em) {\n  .large-text-left {\n    text-align: left; } }\n\n@media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n  .large-only-text-left {\n    text-align: left; } }\n\n.text-right {\n  text-align: right; }\n\n.small-text-right {\n  text-align: right; }\n\n@media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n  .small-only-text-right {\n    text-align: right; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-text-right {\n    text-align: right; } }\n\n@media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n  .medium-only-text-right {\n    text-align: right; } }\n\n@media only screen and (min-width: 75em) {\n  .large-text-right {\n    text-align: right; } }\n\n@media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n  .large-only-text-right {\n    text-align: right; } }\n\n.text-center {\n  text-align: center; }\n\n.small-text-center {\n  text-align: center; }\n\n@media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n  .small-only-text-center {\n    text-align: center; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-text-center {\n    text-align: center; } }\n\n@media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n  .medium-only-text-center {\n    text-align: center; } }\n\n@media only screen and (min-width: 75em) {\n  .large-text-center {\n    text-align: center; } }\n\n@media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n  .large-only-text-center {\n    text-align: center; } }\n\n.text-justify {\n  text-align: justify; }\n\n.small-text-justify {\n  text-align: justify; }\n\n@media only screen and (min-width: 0em) and (max-width: 39.9375rem) {\n  .small-only-text-justify {\n    text-align: justify; } }\n\n@media only screen and (min-width: 40em) {\n  .medium-text-justify {\n    text-align: justify; } }\n\n@media only screen and (min-width: 40em) and (max-width: 74.9375rem) {\n  .medium-only-text-justify {\n    text-align: justify; } }\n\n@media only screen and (min-width: 75em) {\n  .large-text-justify {\n    text-align: justify; } }\n\n@media only screen and (min-width: 75em) and (max-width: 89.9375rem) {\n  .large-only-text-justify {\n    text-align: justify; } }\n\n/*\r\n    Floating\r\n  */\n.clearfix:before, div.tribe-float:before, .clearfix:after, div.tribe-float:after {\n  content: \" \";\n  display: table; }\n\n.clearfix:after, div.tribe-float:after {\n  clear: both; }\n\n.float-left {\n  float: left; }\n\n.float-right {\n  float: right; }\n\n.float-none {\n  float: none; }\n\n* {\n  font-family: \"open sans\", \"Lato\", Helvetica, Arial, sans-serif;\n  color: #000000;\n  line-height: 1.7;\n  font-size: 12px; }\n\nh1, h2, h3, h4, h5, h6 {\n  font-family: \"open sans\", \"Montserrat\", Helvetica, Arial, sans-serif; }\n  h1 *, h2 *, h3 *, h4 *, h5 *, h6 * {\n    font-family: \"open sans\", \"Montserrat\", Helvetica, Arial, sans-serif; }\n\nhtml {\n  box-sizing: border-box; }\n\n*, *:before, *:after {\n  box-sizing: inherit; }\n\ndiv.app-loading {\n  width: 100%;\n  height: 100%;\n  background: url(" + __webpack_require__(82) + ") center no-repeat; }\n\ndiv[data-app] > div {\n  position: relative; }\n  div[data-app] > div > div.top-background {\n    position: absolute;\n    top: 0;\n    right: 0;\n    left: 0;\n    height: 250px;\n    z-index: -1000; }\n\na {\n  color: #E57125;\n  text-decoration: none; }\n  a:hover {\n    color: #E57125;\n    text-decoration: underline; }\n\n[x-ng-click]:hover, [ng-click]:hover {\n  cursor: pointer; }\n\n.floating-menu {\n  position: absolute;\n  z-index: 3000;\n  border: solid white 1px;\n  box-shadow: 0 2px 5px 3px #f2f4f5;\n  border-top-width: 0;\n  border-bottom-right-radius: 3px;\n  border-bottom-left-radius: 3px; }\n  .floating-menu > div {\n    padding: 5px 8px; }\n\n.noscroll {\n  overflow: hidden; }\n\ndiv.tribe-add-btn {\n  opacity: 0; }\n\na {\n  text-decoration: underline; }\n\nselect, input, select > option {\n  height: 34px !important; }\n\nselect[multiple] {\n  height: auto !important; }\n\nselect > option {\n  padding: 0.5rem; }\n\nselect > option, input {\n  font-size: 13px !important; }\n\nselect, input {\n  border-color: #e5e6e7 !important; }\n  select:focus, select:hover, input:focus, input:hover {\n    border-color: #E57125 !important;\n    background-color: transparent; }\n\ninput, select {\n  max-width: 600px;\n  color: #000000; }\n\nlabel {\n  font-size: 13px;\n  font-weight: bold;\n  color: #000000;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  margin-bottom: 5px; }\n  label > input {\n    width: auto; }\n  label input {\n    margin: 0 8px 0 0 !important; }\n\ndiv.CodeMirror {\n  border: solid #F5F5F5 1px; }\n\n*[flow-btn] > input {\n  width: 0;\n  top: 0;\n  left: 0; }\n\nselect {\n  font: inherit;\n  background: #ffffff url(\"data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20version%3D%221.1%22%20width%3D%2232%22%20height%3D%2224%22%20viewBox%3D%220%200%2032%2024%22%3E%3Cpolygon%20points%3D%220%2C0%2032%2C0%2016%2C24%22%20style%3D%22fill%3A%20#000%22%3E%3C/polygon%3E%3C/svg%3E\") right 8px center no-repeat;\n  background-size: 10px;\n  padding: 0;\n  margin: 0; }\n\nselect[multiple] {\n  height: auto; }\n\na.button {\n  text-decoration: none; }\n\n.button, button {\n  text-transform: capitalize;\n  margin: 0;\n  background-color: #3B5164 !important;\n  border: solid 1px #3B5164;\n  border-radius: 3px;\n  font-size: 12px;\n  font-weight: bold; }\n  .button:hover, button:hover, .button:focus, button:focus, .button:active, button:active {\n    background-color: #293846 !important;\n    border-color: #293846 !important; }\n  .button[disabled], button[disabled] {\n    background-color: #c0c0c0 !important;\n    border-color: #c0c0c0 !important; }\n    .button[disabled]:hover, button[disabled]:hover, .button[disabled]:focus, button[disabled]:focus, .button[disabled]:active, button[disabled]:active {\n      background-color: #c0c0c0 !important;\n      border-color: #c0c0c0 !important; }\n  .button.inverted, button.inverted {\n    background-color: #ffffff !important;\n    color: #cbd3da;\n    border: solid 1px #cbd3da; }\n    .button.inverted:hover, button.inverted:hover, .button.inverted:focus, button.inverted:focus, .button.inverted:active, button.inverted:active {\n      background-color: #ffffff !important;\n      color: #90a0af;\n      border-color: #90a0af; }\n  .button.orange, button.orange {\n    background-color: #E57125 !important;\n    border-color: #E57125 !important; }\n    .button.orange:hover, button.orange:hover, .button.orange:focus, button.orange:focus, .button.orange:active, button.orange:active {\n      background-color: #E57125 !important;\n      border-color: #E57125 !important; }\n\ntd ul.button-group {\n  margin-bottom: 0; }\n  td ul.button-group button, td ul.button-group a.button {\n    margin-left: 2px;\n    border-right: 1px solid transparent; }\n  td ul.button-group i {\n    color: #ffffff; }\n\ndiv.field-btn {\n  margin-bottom: 8px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  border: solid 1px #e5e6e7;\n  border-radius: 3px; }\n  div.field-btn > input {\n    margin: 0 !important;\n    border: 0;\n    border-right: solid 1px #e5e6e7; }\n  div.field-btn > button {\n    color: #1a1a1a;\n    background-color: #eaebec !important;\n    border-radius: 0;\n    border: 0; }\n    div.field-btn > button:hover {\n      border-color: transparent !important; }\n  div.field-btn > *[disabled]:first-child {\n    background-color: #ffffff; }\n  div.field-btn > * {\n    margin: 0; }\n    div.field-btn > *:first-child {\n      -webkit-box-flex: 1;\n          -ms-flex-positive: 1;\n              flex-grow: 1; }\n    div.field-btn > *:last-child {\n      -ms-flex-negative: 0;\n          flex-shrink: 0;\n      width: 70px;\n      border-bottom-left-radius: 0;\n      border-top-left-radius: 0; }\n\nselect, input {\n  padding-left: 8px;\n  padding-right: 8px; }\n\nspan.superscript {\n  vertical-align: super;\n  font-size: 60%; }\n\nem {\n  white-space: normal; }\n\n[data-tribe-editable-text], [data-tribe-editable-number] {\n  display: inline-block;\n  font-style: normal;\n  outline: #E57125; }\n  [data-tribe-editable-text] *, [data-tribe-editable-number] * {\n    outline: none; }\n  [data-tribe-editable-text] > div, [data-tribe-editable-number] > div {\n    display: inline-block;\n    border: solid transparent 1px; }\n    [data-tribe-editable-text] > div input, [data-tribe-editable-number] > div input {\n      -webkit-box-flex: 1;\n          -ms-flex-positive: 1;\n              flex-grow: 1;\n      width: 100%; }\n\n[data-tribe-editable-text] > div, [data-tribe-editable-number] > div {\n  max-width: 100%;\n  overflow: hidden; }\n  [data-tribe-editable-text] > div > span, [data-tribe-editable-number] > div > span {\n    white-space: nowrap;\n    margin-left: 5px; }\n    [data-tribe-editable-text] > div > span.empty, [data-tribe-editable-number] > div > span.empty {\n      font-style: italic;\n      font-size: 12px;\n      color: #a8a9aa !important; }\n  [data-tribe-editable-text] > div > input, [data-tribe-editable-number] > div > input {\n    display: none;\n    max-width: 100%;\n    margin: 0 0 0 5px !important;\n    padding: 0 !important;\n    border: 0 !important;\n    height: inherit !important; }\n    [data-tribe-editable-text] > div > input[type=number]::-webkit-inner-spin-button, [data-tribe-editable-text] > div > input[type=number]::-webkit-outer-spin-button, [data-tribe-editable-number] > div > input[type=number]::-webkit-inner-spin-button, [data-tribe-editable-number] > div > input[type=number]::-webkit-outer-spin-button {\n      -webkit-appearance: none; }\n\n[data-tribe-editable-text].edit > div > span, [data-tribe-editable-number].edit > div > span {\n  display: none; }\n\n[data-tribe-editable-text].edit > div > input, [data-tribe-editable-number].edit > div > input {\n  display: inherit; }\n\n[data-tribe-editable-text] > div, [data-tribe-editable-number] > div {\n  min-height: 40px;\n  position: relative;\n  min-width: 40px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n  [data-tribe-editable-text] > div > div, [data-tribe-editable-number] > div > div {\n    display: none;\n    position: absolute;\n    z-index: 1000;\n    right: 0;\n    top: -1px;\n    bottom: -1px;\n    width: 20px;\n    background-color: #eff0f1;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n                -ms-grid-row-align: center;\n            align-items: center; }\n    [data-tribe-editable-text] > div > div > i, [data-tribe-editable-number] > div > div > i {\n      line-height: .6; }\n\n[data-tribe-editable-text]:hover > div, [data-tribe-editable-text].empty > div, [data-tribe-editable-number]:hover > div, [data-tribe-editable-number].empty > div {\n  border-color: #f2f0f0; }\n\n[data-tribe-editable-text]:hover > div > div, [data-tribe-editable-number]:hover > div > div {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex; }\n\n[data-tribe-editable-text].edit, [data-tribe-editable-number].edit {\n  display: block; }\n  [data-tribe-editable-text].edit > div, [data-tribe-editable-number].edit > div {\n    border-color: #f2f0f0; }\n    [data-tribe-editable-text].edit > div > div, [data-tribe-editable-number].edit > div > div {\n      display: none; }\n\ni[data-tribe-editable-text] > div, i[data-tribe-editable-number] > div {\n  padding: 5px; }\n\ni[data-tribe-editable-option] {\n  font-style: normal; }\n  i[data-tribe-editable-option] span.empty {\n    font-style: italic !important;\n    font-size: 12px;\n    color: #a8a9aa !important;\n    font-weight: 600 !important; }\n  i[data-tribe-editable-option] > div {\n    outline: none;\n    display: inline-block; }\n  i[data-tribe-editable-option] .value {\n    padding: 5px 20px 5px 8px;\n    position: relative;\n    border: solid transparent 1px;\n    border-radius: 3px; }\n    i[data-tribe-editable-option] .value > div {\n      position: absolute;\n      top: 50%;\n      right: 5px;\n      -webkit-transform: translateY(-50%);\n              transform: translateY(-50%);\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-orient: vertical;\n      -webkit-box-direction: normal;\n          -ms-flex-direction: column;\n              flex-direction: column;\n      -webkit-box-pack: center;\n          -ms-flex-pack: center;\n              justify-content: center;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      margin: 0 0 0 5px; }\n      i[data-tribe-editable-option] .value > div > i {\n        height: 6px;\n        line-height: 6px;\n        opacity: 0;\n        color: #E57125; }\n  i[data-tribe-editable-option] .options {\n    display: none; }\n  i[data-tribe-editable-option]:hover {\n    cursor: pointer; }\n  i[data-tribe-editable-option]:hover .value, i[data-tribe-editable-option].visible .value {\n    border-color: #E57125; }\n    i[data-tribe-editable-option]:hover .value > div > i, i[data-tribe-editable-option].visible .value > div > i {\n      opacity: 1; }\n  i[data-tribe-editable-option].visible .value {\n    border-bottom-left-radius: 0; }\n\ni[data-tribe-editable-block], div[data-tribe-editable-block] {\n  font-style: normal; }\n  i[data-tribe-editable-block] > div, div[data-tribe-editable-block] > div {\n    min-height: 40px;\n    position: relative; }\n    i[data-tribe-editable-block] > div .icon, div[data-tribe-editable-block] > div .icon {\n      display: none;\n      position: absolute;\n      top: 0;\n      bottom: 0;\n      right: 0;\n      width: 20px;\n      background-color: #eff0f1; }\n      i[data-tribe-editable-block] > div .icon > div, div[data-tribe-editable-block] > div .icon > div {\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-orient: vertical;\n        -webkit-box-direction: normal;\n            -ms-flex-direction: column;\n                flex-direction: column;\n        -webkit-box-pack: center;\n            -ms-flex-pack: center;\n                justify-content: center;\n        -webkit-box-align: center;\n            -ms-flex-align: center;\n                align-items: center;\n        height: 100%; }\n    i[data-tribe-editable-block] > div .CodeMirror, div[data-tribe-editable-block] > div .CodeMirror {\n      min-height: 40px;\n      height: auto;\n      padding: 7px 10px;\n      border-color: transparent; }\n    i[data-tribe-editable-block] > div:hover .CodeMirror, div[data-tribe-editable-block] > div:hover .CodeMirror {\n      border-color: #f2f0f0; }\n    i[data-tribe-editable-block] > div:hover .icon, div[data-tribe-editable-block] > div:hover .icon {\n      display: block; }\n  i[data-tribe-editable-block].edit > div .CodeMirror, div[data-tribe-editable-block].edit > div .CodeMirror {\n    border-color: #f2f0f0; }\n  i[data-tribe-editable-block].edit > div .icon, div[data-tribe-editable-block].edit > div .icon {\n    display: none; }\n\ndiv[data-tribe-editable-md] strong {\n  font-weight: inherit !important; }\n\ndiv[data-tribe-editable-md] > div {\n  position: relative;\n  border: solid 1px #f2f0f0;\n  min-height: 32px;\n  padding: 5px; }\n  div[data-tribe-editable-md] > div .icon {\n    display: none;\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    right: 0;\n    width: 20px;\n    background-color: #eff0f1;\n    opacity: 1; }\n    div[data-tribe-editable-md] > div .icon > div {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-orient: vertical;\n      -webkit-box-direction: normal;\n          -ms-flex-direction: column;\n              flex-direction: column;\n      -webkit-box-pack: center;\n          -ms-flex-pack: center;\n              justify-content: center;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      height: 100%; }\n      div[data-tribe-editable-md] > div .icon > div > i {\n        color: #aaabac;\n        font-size: 9px !important; }\n  div[data-tribe-editable-md] > div .CodeMirror {\n    min-height: 30px;\n    height: auto;\n    border-color: transparent; }\n  div[data-tribe-editable-md] > div div.empty {\n    padding-left: 5px;\n    height: 30px;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column; }\n    div[data-tribe-editable-md] > div div.empty span {\n      font-style: italic;\n      color: #d9d4d7 !important;\n      font-weight: 600 !important; }\n  div[data-tribe-editable-md] > div div.dyn {\n    display: none; }\n\ndiv[data-tribe-editable-md].edit > div div.empty {\n  display: none; }\n\ndiv[data-tribe-editable-md].edit > div div.static {\n  display: none; }\n\ndiv[data-tribe-editable-md].edit > div div.dyn {\n  display: block; }\n\ndiv[data-tribe-editable-md]:hover > div {\n  border-color: #f2f0f0; }\n\ndiv[data-tribe-editable-md]:hover .icon {\n  display: block; }\n\ndiv[data-tribe-editable-md].edit > div {\n  border-color: #f2f0f0; }\n\ndiv[data-tribe-editable-md].edit .icon {\n  display: none; }\n\ni[data-tribe-editable-link], div[data-tribe-editable-link] {\n  font-style: normal; }\n  i[data-tribe-editable-link] > div, div[data-tribe-editable-link] > div {\n    border: solid transparent 1px;\n    padding: 8px;\n    opacity: 1 !important; }\n    i[data-tribe-editable-link] > div div.view, div[data-tribe-editable-link] > div div.view {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center; }\n      i[data-tribe-editable-link] > div div.view span.empty, div[data-tribe-editable-link] > div div.view span.empty {\n        font-style: italic;\n        font-size: 12px;\n        font-weight: 700 !important;\n        color: #a8a9aa !important; }\n      i[data-tribe-editable-link] > div div.view div.edit-trigger, div[data-tribe-editable-link] > div div.view div.edit-trigger {\n        margin-left: 10px;\n        opacity: 0;\n        -webkit-box-orient: vertical;\n        -webkit-box-direction: normal;\n            -ms-flex-direction: column;\n                flex-direction: column;\n        -webkit-box-pack: center;\n            -ms-flex-pack: center;\n                justify-content: center;\n        -webkit-box-align: center;\n            -ms-flex-align: center;\n                    -ms-grid-row-align: center;\n                align-items: center; }\n        i[data-tribe-editable-link] > div div.view div.edit-trigger:hover, div[data-tribe-editable-link] > div div.view div.edit-trigger:hover {\n          cursor: pointer; }\n        i[data-tribe-editable-link] > div div.view div.edit-trigger > i, div[data-tribe-editable-link] > div div.view div.edit-trigger > i {\n          font-size: 10px; }\n      i[data-tribe-editable-link] > div div.view:hover div.edit-trigger, div[data-tribe-editable-link] > div div.view:hover div.edit-trigger {\n        opacity: 1; }\n    i[data-tribe-editable-link] > div div.value, div[data-tribe-editable-link] > div div.value {\n      display: none; }\n      i[data-tribe-editable-link] > div div.value > i > div, div[data-tribe-editable-link] > div div.value > i > div {\n        min-width: 300px; }\n    i[data-tribe-editable-link] > div:hover, div[data-tribe-editable-link] > div:hover {\n      border-color: #f1eff0; }\n  i[data-tribe-editable-link].visible > div, div[data-tribe-editable-link].visible > div {\n    border-color: #f1eff0; }\n    i[data-tribe-editable-link].visible > div div.view div.edit-trigger, div[data-tribe-editable-link].visible > div div.view div.edit-trigger {\n      opacity: 1; }\n\n.editable-link-menu {\n  min-width: 300px;\n  background-color: #ffffff; }\n  .editable-link-menu > div {\n    width: 100%; }\n    .editable-link-menu > div:first-of-type {\n      padding-bottom: 0; }\n    .editable-link-menu > div:last-of-type {\n      padding-top: 0; }\n    .editable-link-menu > div > i {\n      width: 100%; }\n      .editable-link-menu > div > i > div {\n        width: 100%; }\n\ni[data-tribe-switch] span {\n  font-style: normal; }\n\ni[data-tribe-switch] > div {\n  height: 25px;\n  border-radius: 12.5px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n  i[data-tribe-switch] > div > input {\n    display: none; }\n    i[data-tribe-switch] > div > input:checked + span + div {\n      background-color: #f0ac80; }\n      i[data-tribe-switch] > div > input:checked + span + div > div {\n        left: 35px;\n        background-color: #E57125;\n        box-shadow: 0 0 3px 3px rgba(229, 113, 37, 0.5); }\n      i[data-tribe-switch] > div > input:checked + span + div + span {\n        color: #E57125; }\n  i[data-tribe-switch] > div > div {\n    position: relative;\n    border-radius: 12.5px;\n    background-color: #e5e5e5;\n    height: 100%;\n    width: 60px;\n    margin: 0 10px; }\n    i[data-tribe-switch] > div > div:hover {\n      cursor: pointer; }\n    i[data-tribe-switch] > div > div > div {\n      position: absolute;\n      left: 0;\n      -webkit-transition: left .15s ease-out;\n      transition: left .15s ease-out;\n      background-color: #f1eff0;\n      width: 25px;\n      height: 100%;\n      border-radius: 12.5px;\n      box-shadow: 0 0 3px 3px rgba(204, 204, 204, 0.5); }\n\ndiv[data-tribe-multiselect-selected] {\n  border: 0; }\n  div[data-tribe-multiselect-selected] > div {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    div[data-tribe-multiselect-selected] > div > div.edit-icon {\n      opacity: 0;\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-orient: vertical;\n      -webkit-box-direction: normal;\n          -ms-flex-direction: column;\n              flex-direction: column;\n      -webkit-box-pack: center;\n          -ms-flex-pack: center;\n              justify-content: center;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      padding: 0 5px;\n      border: 0;\n      border-left: solid #e5e6e7 1px;\n      background-color: #f5f5f5;\n      -ms-flex-item-align: stretch;\n          align-self: stretch; }\n    div[data-tribe-multiselect-selected] > div > div:first-of-type {\n      padding: 7px 2px 5px 2px;\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -ms-flex-wrap: wrap;\n          flex-wrap: wrap;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      -webkit-box-flex: 1;\n          -ms-flex-positive: 1;\n              flex-grow: 1; }\n      div[data-tribe-multiselect-selected] > div > div:first-of-type > div.text {\n        -webkit-box-flex: 1;\n            -ms-flex-positive: 1;\n                flex-grow: 1;\n        border: solid transparent 2px;\n        padding: 2px 5px 2px 0;\n        margin: 0 2px 0 0; }\n        div[data-tribe-multiselect-selected] > div > div:first-of-type > div.text > input {\n          margin: 0;\n          width: 1px;\n          border-width: 0;\n          padding: 0;\n          height: auto !important; }\n          div[data-tribe-multiselect-selected] > div > div:first-of-type > div.text > input:focus {\n            min-width: 10px;\n            width: 100%; }\n      div[data-tribe-multiselect-selected] > div > div:first-of-type > div.items {\n        display: inline-block;\n        border: solid #cccccc 1px;\n        border-radius: 3px;\n        background-color: #f5f5f5;\n        padding: 2px 5px;\n        margin: 0 2px 2px 0; }\n        div[data-tribe-multiselect-selected] > div > div:first-of-type > div.items > div > span {\n          margin-right: 5px; }\n        div[data-tribe-multiselect-selected] > div > div:first-of-type > div.items > div > i {\n          color: #707070; }\n\n[data-tribe-multiselect] {\n  display: inline-block;\n  border: solid transparent 1px; }\n  [data-tribe-multiselect] i.remove {\n    display: none; }\n  [data-tribe-multiselect].active {\n    display: block; }\n    [data-tribe-multiselect].active i.remove {\n      display: inline; }\n  [data-tribe-multiselect]:hover div.edit-icon {\n    opacity: 1; }\n  [data-tribe-multiselect].active div.edit-icon {\n    opacity: 0; }\n  [data-tribe-multiselect]:hover, [data-tribe-multiselect].active {\n    border-color: #e5e6e7; }\n\ndiv.tribe-data-tribe-multiselect-available-body {\n  min-width: 300px;\n  z-index: 4000; }\n  div.tribe-data-tribe-multiselect-available-body .opts {\n    padding: 0; }\n    div.tribe-data-tribe-multiselect-available-body .opts > div {\n      padding: 5px 8px; }\n    div.tribe-data-tribe-multiselect-available-body .opts .option {\n      background-color: #ffffff; }\n      div.tribe-data-tribe-multiselect-available-body .opts .option.selected, div.tribe-data-tribe-multiselect-available-body .opts .option:hover {\n        background-color: #f5f5f5; }\n  div.tribe-data-tribe-multiselect-available-body .new-opt {\n    border-top: dashed #e5e6e7 1px;\n    background-color: #ffffff; }\n    div.tribe-data-tribe-multiselect-available-body .new-opt.selected, div.tribe-data-tribe-multiselect-available-body .new-opt:hover {\n      background-color: #f5f5f5; }\n    div.tribe-data-tribe-multiselect-available-body .new-opt > span:first-of-type {\n      font-weight: 800;\n      margin-right: 5px; }\n\n[data-tribe-multiselect].active div.items.selected {\n  background-color: #E57125; }\n  [data-tribe-multiselect].active div.items.selected > div > span, [data-tribe-multiselect].active div.items.selected > div > i {\n    color: #ffffff; }\n\n[data-tribe-singleselect-selected] > div {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex; }\n  [data-tribe-singleselect-selected] > div div.text {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    width: 100%;\n    padding: 0 5px;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    [data-tribe-singleselect-selected] > div div.text span {\n      margin: 5px 0; }\n      [data-tribe-singleselect-selected] > div div.text span.empty {\n        font-style: italic;\n        color: #a8a9aa !important; }\n    [data-tribe-singleselect-selected] > div div.text input {\n      margin: 5px 0;\n      border: 0;\n      padding: 0;\n      height: 28px !important;\n      width: 1px;\n      max-width: 100%; }\n      [data-tribe-singleselect-selected] > div div.text input:hover, [data-tribe-singleselect-selected] > div div.text input:focus {\n        border: 0; }\n      [data-tribe-singleselect-selected] > div div.text input:focus {\n        min-width: 10px;\n        width: 100%; }\n  [data-tribe-singleselect-selected] > div div.edit-icon {\n    opacity: 0;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    padding: 0 5px;\n    border: 0;\n    border-left: solid #e5e6e7 1px;\n    background-color: #f5f5f5;\n    -ms-flex-item-align: stretch;\n        align-self: stretch; }\n\n[data-tribe-singleselect] {\n  display: inline-block; }\n  [data-tribe-singleselect] [data-tribe-singleselect-selected] .text {\n    overflow: hidden; }\n  [data-tribe-singleselect] > div {\n    border: solid transparent 1px; }\n  [data-tribe-singleselect].active {\n    display: block; }\n  [data-tribe-singleselect]:hover div.edit-icon {\n    opacity: 1; }\n  [data-tribe-singleselect].active [data-tribe-singleselect-selected] div.edit-icon {\n    opacity: 0; }\n  [data-tribe-singleselect].active [data-tribe-singleselect-selected] div.text input {\n    width: auto;\n    -webkit-box-flex: 1;\n        -ms-flex-positive: 1;\n            flex-grow: 1; }\n  [data-tribe-singleselect].active [data-tribe-singleselect-selected] div.text span {\n    display: none; }\n  [data-tribe-singleselect]:hover > div, [data-tribe-singleselect].active > div {\n    border-color: #e5e6e7; }\n\ndiv.tribe-data-tribe-singleselect-available-body {\n  min-width: 300px;\n  z-index: 4000; }\n  div.tribe-data-tribe-singleselect-available-body .opts {\n    padding: 0; }\n    div.tribe-data-tribe-singleselect-available-body .opts > div {\n      padding: 5px 8px; }\n    div.tribe-data-tribe-singleselect-available-body .opts .option {\n      background-color: #ffffff; }\n      div.tribe-data-tribe-singleselect-available-body .opts .option.selected, div.tribe-data-tribe-singleselect-available-body .opts .option:hover {\n        background-color: #f5f5f5; }\n  div.tribe-data-tribe-singleselect-available-body .new-opt {\n    border-top: dashed #e5e6e7 1px;\n    background-color: #ffffff; }\n    div.tribe-data-tribe-singleselect-available-body .new-opt.selected, div.tribe-data-tribe-singleselect-available-body .new-opt:hover {\n      background-color: #f5f5f5; }\n    div.tribe-data-tribe-singleselect-available-body .new-opt > span:first-of-type {\n      font-weight: 800;\n      margin-right: 5px; }\n\ndiv[data-tribe-markdown-help] > div > div.markdown-help-content {\n  display: none; }\n\ndiv.markdown-help-content {\n  position: fixed;\n  top: 0;\n  bottom: 0;\n  right: 0;\n  left: 0;\n  z-index: 3000;\n  background-color: rgba(0, 0, 0, 0.5); }\n  div.markdown-help-content > div {\n    position: fixed;\n    top: 40px;\n    bottom: 40px;\n    right: 40px;\n    left: 40px;\n    padding: 40px 50px 40px 50px;\n    overflow: auto;\n    background-color: white; }\n    div.markdown-help-content > div * {\n      font-family: \"open sans\", \"Montserrat\", Helvetica, Arial, sans-serif; }\n    div.markdown-help-content > div pre, div.markdown-help-content > div code {\n      font-family: Consolas, \"Liberation Mono\", Courier, monospace; }\n    div.markdown-help-content > div h1, div.markdown-help-content > div h2, div.markdown-help-content > div h3, div.markdown-help-content > div h4, div.markdown-help-content > div h5, div.markdown-help-content > div h6 {\n      margin-top: 10px; }\n      div.markdown-help-content > div h1:first-child, div.markdown-help-content > div h2:first-child, div.markdown-help-content > div h3:first-child, div.markdown-help-content > div h4:first-child, div.markdown-help-content > div h5:first-child, div.markdown-help-content > div h6:first-child {\n        margin-top: 10px; }\n    div.markdown-help-content > div p, div.markdown-help-content > div th, div.markdown-help-content > div td, div.markdown-help-content > div pre, div.markdown-help-content > div code {\n      font-size: 12px;\n      margin-bottom: 10px; }\n    div.markdown-help-content > div table {\n      width: 100%; }\n      div.markdown-help-content > div table th, div.markdown-help-content > div table td {\n        padding: 5px;\n        text-align: left; }\n    div.markdown-help-content > div pre {\n      padding: 10px; }\n    div.markdown-help-content > div code {\n      border: 0;\n      padding: 0;\n      background-color: transparent; }\n    div.markdown-help-content > div pre, div.markdown-help-content > div code {\n      max-width: 100%;\n      background-color: #eeeeee; }\n    div.markdown-help-content > div strong {\n      font-weight: bold; }\n    div.markdown-help-content > div > i.fa.fa-times-circle {\n      position: fixed;\n      top: 55px;\n      right: 65px;\n      font-family: FontAwesome; }\n\ndiv[data-tribe-markdown] {\n  display: inline-block; }\n  div[data-tribe-markdown] div.CodeMirror, div[data-tribe-markdown] div.CodeMirror-scroll {\n    min-height: 30px;\n    max-height: 300px; }\n  div[data-tribe-markdown] div.edit-icon {\n    opacity: 0;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    padding: 0 5px;\n    background-color: #f5f5f5;\n    -ms-flex-item-align: stretch;\n        align-self: stretch; }\n  div[data-tribe-markdown] div.preview {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n    div[data-tribe-markdown] div.preview > div:nth-of-type(1) {\n      padding: 10px;\n      min-height: 44px;\n      border: solid transparent 1px;\n      -webkit-box-flex: 1;\n          -ms-flex-positive: 1;\n              flex-grow: 1;\n      border-right: 0; }\n      div[data-tribe-markdown] div.preview > div:nth-of-type(1) > *:last-child {\n        margin-bottom: 0; }\n    div[data-tribe-markdown] div.preview:hover div.edit-icon {\n      border-left: solid #e5e6e7 1px;\n      opacity: 1; }\n  div[data-tribe-markdown] div.value {\n    display: none; }\n    div[data-tribe-markdown] div.value > div {\n      border-color: transparent; }\n    div[data-tribe-markdown] div.value div.editor-toolbar {\n      border-bottom: solid #e5e6e7 1px; }\n  div[data-tribe-markdown].active {\n    display: block; }\n    div[data-tribe-markdown].active div.preview {\n      display: none; }\n    div[data-tribe-markdown].active div.value {\n      display: block; }\n  div[data-tribe-markdown] div.main {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    border: solid transparent 1px; }\n    div[data-tribe-markdown] div.main:hover {\n      border-color: #e5e6e7; }\n    div[data-tribe-markdown] div.main > div {\n      -webkit-box-flex: 1;\n          -ms-flex-positive: 1;\n              flex-grow: 1;\n      width: 50%; }\n    div[data-tribe-markdown] div.main.sidebyside > div {\n      display: block; }\n  div[data-tribe-markdown].active div.preview:hover div.edit-icon {\n    opacity: 0; }\n  div[data-tribe-markdown].active div.main {\n    border-color: #e5e6e7; }\n    div[data-tribe-markdown].active div.main > div:last-of-type {\n      border-left: solid #e5e6e7 1px; }\n  div[data-tribe-markdown] div.preview > div.empty span {\n    font-style: italic;\n    color: #a8a9aa; }\n  div[data-tribe-markdown] div.preview > div[x-ng-bind-html], div[data-tribe-markdown] div.editor-preview {\n    max-width: 100%; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] *, div[data-tribe-markdown] div.editor-preview * {\n      font-family: \"open sans\", \"Montserrat\", Helvetica, Arial, sans-serif; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] pre, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] code, div[data-tribe-markdown] div.editor-preview pre, div[data-tribe-markdown] div.editor-preview code {\n      font-family: Consolas, \"Liberation Mono\", Courier, monospace; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h1, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h2, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h3, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h4, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h5, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h6, div[data-tribe-markdown] div.editor-preview h1, div[data-tribe-markdown] div.editor-preview h2, div[data-tribe-markdown] div.editor-preview h3, div[data-tribe-markdown] div.editor-preview h4, div[data-tribe-markdown] div.editor-preview h5, div[data-tribe-markdown] div.editor-preview h6 {\n      margin-top: 10px; }\n      div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h1:first-child, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h2:first-child, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h3:first-child, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h4:first-child, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h5:first-child, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] h6:first-child, div[data-tribe-markdown] div.editor-preview h1:first-child, div[data-tribe-markdown] div.editor-preview h2:first-child, div[data-tribe-markdown] div.editor-preview h3:first-child, div[data-tribe-markdown] div.editor-preview h4:first-child, div[data-tribe-markdown] div.editor-preview h5:first-child, div[data-tribe-markdown] div.editor-preview h6:first-child {\n        margin-top: 10px; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] p, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] th, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] td, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] pre, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] code, div[data-tribe-markdown] div.editor-preview p, div[data-tribe-markdown] div.editor-preview th, div[data-tribe-markdown] div.editor-preview td, div[data-tribe-markdown] div.editor-preview pre, div[data-tribe-markdown] div.editor-preview code {\n      font-size: 12px;\n      margin-bottom: 10px; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] table, div[data-tribe-markdown] div.editor-preview table {\n      width: 100%; }\n      div[data-tribe-markdown] div.preview > div[x-ng-bind-html] table th, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] table td, div[data-tribe-markdown] div.editor-preview table th, div[data-tribe-markdown] div.editor-preview table td {\n        padding: 5px;\n        text-align: left; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] pre, div[data-tribe-markdown] div.editor-preview pre {\n      padding: 10px; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] code, div[data-tribe-markdown] div.editor-preview code {\n      border: 0;\n      padding: 0;\n      background-color: transparent; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] pre, div[data-tribe-markdown] div.preview > div[x-ng-bind-html] code, div[data-tribe-markdown] div.editor-preview pre, div[data-tribe-markdown] div.editor-preview code {\n      max-width: 100%;\n      background-color: #eeeeee; }\n    div[data-tribe-markdown] div.preview > div[x-ng-bind-html] strong, div[data-tribe-markdown] div.editor-preview strong {\n      font-weight: bold; }\n  div[data-tribe-markdown] > div.fullscreen {\n    background-color: #ffffff;\n    position: fixed;\n    z-index: 4000;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    right: 0; }\n    div[data-tribe-markdown] > div.fullscreen div.main {\n      min-height: 100vh; }\n\n[data-tribe-text] {\n  display: inline-block;\n  border: solid transparent 1px;\n  font-style: normal; }\n  [data-tribe-text].invalid {\n    background: url(" + __webpack_require__(83) + ") bottom repeat-x; }\n  [data-tribe-text] div.edit-icon {\n    opacity: 0;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    padding: 0 5px;\n    border: 0;\n    border-left: solid #e5e6e7 1px;\n    background-color: #f5f5f5;\n    -ms-flex-item-align: stretch;\n        align-self: stretch; }\n  [data-tribe-text] div.text {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-flex: 1;\n        -ms-flex-positive: 1;\n            flex-grow: 1;\n    padding: 5px; }\n    [data-tribe-text] div.text span {\n      white-space: nowrap; }\n  [data-tribe-text] input {\n    max-width: 100%;\n    width: 1px;\n    opacity: 0;\n    margin: 0;\n    border: 0;\n    padding: 0; }\n    [data-tribe-text] input:hover, [data-tribe-text] input:active, [data-tribe-text] input:focus {\n      border: 0; }\n  [data-tribe-text] > div > div:first-of-type {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n  [data-tribe-text]:hover div.edit-icon {\n    opacity: 1; }\n  [data-tribe-text].active {\n    display: block; }\n    [data-tribe-text].active div.edit-icon {\n      opacity: 0; }\n    [data-tribe-text].active input {\n      width: 100%;\n      opacity: 1;\n      -webkit-box-flex: 1;\n          -ms-flex-positive: 1;\n              flex-grow: 1; }\n    [data-tribe-text].active span {\n      display: none; }\n  [data-tribe-text]:hover, [data-tribe-text].active {\n    border-color: #e5e6e7; }\n  [data-tribe-text] span.empty {\n    font-style: italic;\n    color: #a8a9aa !important; }\n\ndiv[zf-tabs] > div.tabs {\n  background-color: #f9f9f9;\n  border: 1px solid #efefef;\n  padding: 10px; }\n  div[zf-tabs] > div.tabs > div[zf-tab] {\n    border: 1px solid #e9e9e9;\n    border-radius: 5px;\n    background-color: #e7e7e7;\n    color: #c8c8c8;\n    padding: 8px 16px;\n    margin: 0 0 0 10px; }\n    div[zf-tabs] > div.tabs > div[zf-tab]:first-child {\n      margin: 0; }\n    div[zf-tabs] > div.tabs > div[zf-tab].is-active {\n      border: 1px solid #E57125;\n      background-color: #ffffff;\n      color: #000000; }\n\ndiv[zf-tabs] > div.tab-contents {\n  background-color: #ffffff;\n  border: 1px solid #efefef;\n  border-top: 0; }\n\ndiv.tribe-field-actions-body {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  border: solid #cccccc 1px;\n  background-color: #f0f0f0;\n  z-index: 2000; }\n  div.tribe-field-actions-body > div {\n    margin: 3px;\n    width: 22px;\n    height: 22px;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    border: solid #cbcbcb 1px;\n    background-color: #f5f5f5; }\n    div.tribe-field-actions-body > div i {\n      color: #777; }\n    div.tribe-field-actions-body > div:hover {\n      background-color: gainsboro;\n      cursor: pointer; }\n      div.tribe-field-actions-body > div:hover i {\n        color: inherit; }\n    div.tribe-field-actions-body > div.disabled {\n      display: none; }\n\ndiv[data-tribe-confirm-btn] {\n  display: inline-block; }\n  div[data-tribe-confirm-btn] .confirmation-popup {\n    background-color: rgba(0, 0, 0, 0.8);\n    position: fixed;\n    top: 0;\n    bottom: 0;\n    left: 0;\n    right: 0;\n    display: none;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n                -ms-grid-row-align: center;\n            align-items: center;\n    z-index: 1;\n    cursor: default; }\n    div[data-tribe-confirm-btn] .confirmation-popup > div {\n      max-width: 600px;\n      background-color: #ffffff; }\n      div[data-tribe-confirm-btn] .confirmation-popup > div > div {\n        padding: 20px 80px;\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-orient: vertical;\n        -webkit-box-direction: normal;\n            -ms-flex-direction: column;\n                flex-direction: column;\n        -webkit-box-align: center;\n            -ms-flex-align: center;\n                align-items: center; }\n      div[data-tribe-confirm-btn] .confirmation-popup > div > div:last-of-type button {\n        padding: 10px 40px; }\n        div[data-tribe-confirm-btn] .confirmation-popup > div > div:last-of-type button:first-of-type {\n          margin-right: 20px; }\n        div[data-tribe-confirm-btn] .confirmation-popup > div > div:last-of-type button.confirm {\n          background-color: #c51d1c !important;\n          border-color: #c51d1c !important; }\n      div[data-tribe-confirm-btn] .confirmation-popup > div > div:first-of-type {\n        border-bottom: solid #f9f9f9 1px;\n        margin-bottom: 5px; }\n        div[data-tribe-confirm-btn] .confirmation-popup > div > div:first-of-type i {\n          font-size: 40px;\n          color: #c51d1c; }\n        div[data-tribe-confirm-btn] .confirmation-popup > div > div:first-of-type p {\n          text-align: center;\n          text-transform: uppercase;\n          margin: 15px 0 0 0;\n          font-weight: 700; }\n  div[data-tribe-confirm-btn].visible .confirmation-popup {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n\ndiv[data-tribe-diff] .CodeMirror {\n  padding: 0; }\n\ni[data-tribe-checkbox] > div {\n  height: 20px;\n  width: 20px;\n  border: solid #464748 1px; }\n  i[data-tribe-checkbox] > div > div {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    width: 100%;\n    height: 100%; }\n  i[data-tribe-checkbox] > div > div.true {\n    background-color: #464748; }\n    i[data-tribe-checkbox] > div > div.true i {\n      color: #ffffff; }\n\n[data-tribe-tip] {\n  display: block;\n  position: absolute;\n  z-index: 4000; }\n  [data-tribe-tip] div.arrow {\n    width: 0;\n    height: 0;\n    border-left: 5px solid transparent;\n    border-right: 5px solid transparent;\n    border-bottom: 5px solid #E57125;\n    margin-left: 5px; }\n  [data-tribe-tip] div.message {\n    background-color: #E57125; }\n    [data-tribe-tip] div.message > div {\n      padding: 10px 15px; }\n    [data-tribe-tip] div.message * {\n      color: #ffffff; }\n\ndiv[data-app-header] > header {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex; }\n  div[data-app-header] > header > a {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    background-color: #e67125;\n    -ms-flex-negative: 0;\n        flex-shrink: 0;\n    width: 80px;\n    height: 55px; }\n    div[data-app-header] > header > a > div.img {\n      background: url(" + __webpack_require__(84) + ") center;\n      background-size: contain;\n      width: 25px;\n      height: 25px; }\n  div[data-app-header] > header > div:first-of-type {\n    background-color: #34373c;\n    -webkit-box-flex: 1;\n        -ms-flex-positive: 1;\n            flex-grow: 1;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    div[data-app-header] > header > div:first-of-type > span {\n      color: #ffffff;\n      text-transform: uppercase;\n      margin-left: 25px;\n      font-weight: 700; }\n  div[data-app-header] > header > div:last-of-type {\n    background-color: #1e2327;\n    -ms-flex-negative: 0;\n        flex-shrink: 0;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    padding: 0 25px; }\n    div[data-app-header] > header > div:last-of-type > span, div[data-app-header] > header > div:last-of-type > i {\n      color: #a6b9c7; }\n      div[data-app-header] > header > div:last-of-type > span:first-child, div[data-app-header] > header > div:last-of-type > i:first-child {\n        margin-left: 0; }\n\ndiv[data-app-footer] > footer {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  padding: 40px 20px; }\n\ndiv.app-login div[data-app-footer] {\n  margin-top: 20px; }\n  div.app-login div[data-app-footer] * {\n    color: #ffffff; }\n\nbody > i[data-app-ng-click-confirm-el] {\n  z-index: 3000;\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  background: rgba(0, 0, 0, 0.5); }\n  body > i[data-app-ng-click-confirm-el] > div.app-confirmation-message {\n    margin: 0 8px;\n    border: medium none;\n    border-top: 5px solid #e6e6e6;\n    border-radius: 0 0 3px 3px;\n    box-shadow: 0 0 3px rgba(86, 96, 117, 0.7);\n    background-color: #ffffff; }\n    body > i[data-app-ng-click-confirm-el] > div.app-confirmation-message > div {\n      padding: 16px 16px 0 16px;\n      margin-top: 20px; }\n      body > i[data-app-ng-click-confirm-el] > div.app-confirmation-message > div:first-child {\n        border-bottom: 2px solid #e6e6e6;\n        margin-top: 0;\n        padding-top: 6px; }\n        body > i[data-app-ng-click-confirm-el] > div.app-confirmation-message > div:first-child > h1 {\n          font-size: 20px;\n          color: #0d0d0d; }\n      body > i[data-app-ng-click-confirm-el] > div.app-confirmation-message > div:last-child {\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-pack: end;\n            -ms-flex-pack: end;\n                justify-content: flex-end;\n        padding-bottom: 16px; }\n        body > i[data-app-ng-click-confirm-el] > div.app-confirmation-message > div:last-child > button {\n          margin-left: 8px; }\n      body > i[data-app-ng-click-confirm-el] > div.app-confirmation-message > div p {\n        margin: 0; }\n\nbody div[data-app-closable-messages] > div {\n  position: fixed;\n  right: 8px;\n  bottom: 8px;\n  z-index: 3000;\n  width: 350px;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column; }\n  body div[data-app-closable-messages] > div > div {\n    position: relative; }\n    body div[data-app-closable-messages] > div > div > div {\n      border: medium none;\n      border-radius: 0;\n      box-shadow: 0 0 3px rgba(86, 96, 117, 0.7);\n      background-color: #ffffff; }\n      body div[data-app-closable-messages] > div > div > div > div {\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-pack: center;\n            -ms-flex-pack: center;\n                justify-content: center;\n        border-top: 5px solid #1AB06B; }\n        body div[data-app-closable-messages] > div > div > div > div > i {\n          font-size: 35px !important;\n          color: #1AB06B !important;\n          margin: 8px; }\n        body div[data-app-closable-messages] > div > div > div > div.app-message-error {\n          border-top: 5px solid #E87224; }\n          body div[data-app-closable-messages] > div > div > div > div.app-message-error > i {\n            color: #E87224 !important; }\n        body div[data-app-closable-messages] > div > div > div > div.app-message-warning {\n          border-top: 5px solid #F8AC59; }\n          body div[data-app-closable-messages] > div > div > div > div.app-message-warning > i {\n            color: #F8AC59 !important; }\n      body div[data-app-closable-messages] > div > div > div > h1 {\n        text-transform: uppercase;\n        text-align: center;\n        font-weight: bold;\n        font-size: 14px;\n        margin: 0; }\n      body div[data-app-closable-messages] > div > div > div > p {\n        text-align: center;\n        font-size: 12px;\n        padding: 8px 48px;\n        margin-bottom: 24px; }\n    body div[data-app-closable-messages] > div > div > i {\n      position: absolute;\n      font-size: 15px !important;\n      font-weight: 100;\n      top: 8px;\n      right: 8px;\n      color: #000000 !important; }\n      body div[data-app-closable-messages] > div > div > i:hover {\n        cursor: pointer; }\n  @media (max-width: 320px) {\n    body div[data-app-closable-messages] > div {\n      left: 8px;\n      width: auto; } }\n\ndiv[data-app-endpoints] > div div.body {\n  border-top: solid #ebebeb 1px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex; }\n  @media (max-width: 925px) {\n    div[data-app-endpoints] > div div.body {\n      -webkit-box-orient: vertical;\n      -webkit-box-direction: normal;\n          -ms-flex-direction: column;\n              flex-direction: column; } }\n  div[data-app-endpoints] > div div.body div.list {\n    position: relative;\n    -webkit-box-flex: 1;\n        -ms-flex-positive: 1;\n            flex-grow: 1; }\n    div[data-app-endpoints] > div div.body div.list > div:first-of-type {\n      position: absolute;\n      left: 0;\n      right: 0;\n      top: 0;\n      height: 20px;\n      background: -webkit-linear-gradient(#f9fbfa, #ffffff);\n      background: linear-gradient(#f9fbfa, #ffffff);\n      z-index: 1; }\n    div[data-app-endpoints] > div div.body div.list > div:last-of-type {\n      padding: 20px 60px; }\n      @media (max-width: 925px) {\n        div[data-app-endpoints] > div div.body div.list > div:last-of-type {\n          padding: 20px; } }\n  div[data-app-endpoints] > div div.body div.filters {\n    padding: 20px 20px 0 0;\n    border-left: solid #ebebeb 1px;\n    min-width: 400px; }\n    @media (max-width: 925px) {\n      div[data-app-endpoints] > div div.body div.filters {\n        min-width: inherit;\n        padding: 20px; } }\n\ndiv[data-app-endpoints-header] > div {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  margin: 20px 0; }\n  @media (max-width: 925px) {\n    div[data-app-endpoints-header] > div {\n      -webkit-box-orient: vertical;\n      -webkit-box-direction: normal;\n          -ms-flex-direction: column;\n              flex-direction: column;\n      -webkit-box-align: start;\n          -ms-flex-align: start;\n                  -ms-grid-row-align: flex-start;\n              align-items: flex-start; } }\n  div[data-app-endpoints-header] > div > h1 {\n    margin: 0 10px 0 20px;\n    -ms-flex-negative: 0;\n        flex-shrink: 0;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -ms-flex-wrap: wrap;\n        flex-wrap: wrap; }\n    @media (max-width: 925px) {\n      div[data-app-endpoints-header] > div > h1 {\n        margin: 0 10px 20px 20px; } }\n    div[data-app-endpoints-header] > div > h1 > div.img {\n      background: url(" + __webpack_require__(85) + ") center;\n      background-size: contain;\n      width: 35px;\n      height: 35px; }\n    div[data-app-endpoints-header] > div > h1 > span {\n      text-transform: uppercase;\n      font-size: 23px;\n      color: #000000; }\n      div[data-app-endpoints-header] > div > h1 > span:first-of-type {\n        font-weight: 700; }\n      div[data-app-endpoints-header] > div > h1 > span:last-of-type {\n        color: #cacaca;\n        margin-left: 5px;\n        font-weight: 600; }\n  div[data-app-endpoints-header] > div div[data-app-endpoints-query-input] {\n    -webkit-box-flex: 1;\n        -ms-flex-positive: 1;\n            flex-grow: 1; }\n    @media (max-width: 925px) {\n      div[data-app-endpoints-header] > div div[data-app-endpoints-query-input] {\n        margin-left: 20px;\n        margin-bottom: 20px;\n        -ms-flex-item-align: stretch;\n            align-self: stretch; } }\n    div[data-app-endpoints-header] > div div[data-app-endpoints-query-input] > div {\n      max-width: 400px; }\n\ndiv[data-app-endpoints-header-create-btn] {\n  margin-right: 20px;\n  font-style: normal; }\n  div[data-app-endpoints-header-create-btn] a {\n    text-decoration: none; }\n  div[data-app-endpoints-header-create-btn] > div {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-pack: end;\n        -ms-flex-pack: end;\n            justify-content: flex-end; }\n    div[data-app-endpoints-header-create-btn] > div > div > div {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      margin-left: 20px;\n      background-color: #f0f0f0;\n      padding: 5px 15px;\n      border: solid #464748 1px;\n      border-radius: 3px; }\n      div[data-app-endpoints-header-create-btn] > div > div > div i {\n        margin: 0 5px; }\n        div[data-app-endpoints-header-create-btn] > div > div > div i:first-child {\n          margin-left: 0; }\n      div[data-app-endpoints-header-create-btn] > div > div > div i.fa.fa-caret-down {\n        margin-left: 10px; }\n  div[data-app-endpoints-header-create-btn] .create-endpoint-btn {\n    position: relative; }\n    div[data-app-endpoints-header-create-btn] .create-endpoint-btn:hover {\n      cursor: pointer; }\n    div[data-app-endpoints-header-create-btn] .create-endpoint-btn .button-applications {\n      display: none;\n      border-top-left-radius: 0;\n      border-top-right-radius: 0;\n      position: absolute;\n      right: 0;\n      z-index: 3000;\n      -webkit-transform: translate(0, -1px);\n              transform: translate(0, -1px);\n      background-color: #ffffff;\n      margin: 0; }\n      div[data-app-endpoints-header-create-btn] .create-endpoint-btn .button-applications.visible {\n        display: block; }\n      div[data-app-endpoints-header-create-btn] .create-endpoint-btn .button-applications ul, div[data-app-endpoints-header-create-btn] .create-endpoint-btn .button-applications li {\n        margin: 0;\n        list-style: none; }\n      div[data-app-endpoints-header-create-btn] .create-endpoint-btn .button-applications li {\n        padding: 10px; }\n        div[data-app-endpoints-header-create-btn] .create-endpoint-btn .button-applications li a {\n          color: #000000;\n          white-space: nowrap; }\n\ndiv[data-app-endpoints-query-input] {\n  font-style: normal; }\n  div[data-app-endpoints-query-input] > div {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n    div[data-app-endpoints-query-input] > div > button {\n      font-size: 11px;\n      border-radius: 0 5px 5px 0 !important;\n      border-left-width: 0;\n      background-color: rgba(227, 227, 227, 0.2) !important;\n      border-color: #e3e3e3 !important;\n      padding: 0;\n      display: block; }\n      div[data-app-endpoints-query-input] > div > button:hover, div[data-app-endpoints-query-input] > div > button:focus, div[data-app-endpoints-query-input] > div > button:active {\n        background-color: rgba(227, 227, 227, 0.2) !important;\n        border-color: #e3e3e3 !important; }\n      div[data-app-endpoints-query-input] > div > button > div {\n        width: 100%;\n        height: 100%;\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-orient: vertical;\n        -webkit-box-direction: normal;\n            -ms-flex-direction: column;\n                flex-direction: column;\n        -webkit-box-pack: center;\n            -ms-flex-pack: center;\n                justify-content: center;\n        -webkit-box-align: center;\n            -ms-flex-align: center;\n                align-items: center; }\n        div[data-app-endpoints-query-input] > div > button > div > i {\n          color: #E57125 !important;\n          font-size: 20px;\n          margin: 0 8px; }\n    div[data-app-endpoints-query-input] > div > input {\n      display: inline;\n      margin: 0 !important;\n      color: #000000 !important;\n      background-color: rgba(227, 227, 227, 0.2) !important;\n      border-color: #e3e3e3 !important;\n      border-right: 0;\n      border-radius: 5px 0 0 5px !important; }\n      div[data-app-endpoints-query-input] > div > input::-webkit-input-placeholder {\n        color: #e3e3e3 !important; }\n      div[data-app-endpoints-query-input] > div > input::-moz-placeholder {\n        color: #e3e3e3 !important; }\n      div[data-app-endpoints-query-input] > div > input:-ms-input-placeholder {\n        color: #e3e3e3 !important; }\n      div[data-app-endpoints-query-input] > div > input::placeholder {\n        color: #e3e3e3 !important; }\n      div[data-app-endpoints-query-input] > div > input:hover, div[data-app-endpoints-query-input] > div > input:focus, div[data-app-endpoints-query-input] > div > input:active {\n        border-color: #e3e3e3 !important;\n        border-right: 0; }\n\ndiv[data-app-endpoints-list] a, div[data-app-endpoints-list] span[x-ng-click] {\n  color: #e87326;\n  text-decoration: none; }\n  div[data-app-endpoints-list] a:hover, div[data-app-endpoints-list] span[x-ng-click]:hover {\n    cursor: pointer;\n    text-decoration: underline;\n    color: #e87326; }\n\ndiv[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div {\n  margin: 0 0 30px 0; }\n  div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > h2 > a {\n    font-size: 22px; }\n  div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > h2 > span {\n    font-size: 22px !important;\n    color: #cccccc;\n    margin-left: 5px; }\n  div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div {\n    padding: 20px;\n    border-top: dashed #cccccc 1px;\n    overflow: hidden; }\n    div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > h3 > span {\n      font-size: 16px; }\n    div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > h3 > a {\n      font-size: 16px;\n      padding-left: 5px; }\n    div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > h3 > i.fa {\n      font-size: 12px; }\n    div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > h3 > i.fa-unlock {\n      color: #e87326; }\n    div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > h3 > i, div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > h3 > span {\n      color: #bbbbbb;\n      padding-left: 10px; }\n    div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > * {\n      margin-left: 10px; }\n      div[data-app-endpoints-list] > div > div[data-app-endpoints-list-application] > div > div > *:first-child {\n        margin-left: 0; }\n\ndiv[data-app-endpoints-list-filter-entries] > div {\n  max-width: 250px; }\n  div[data-app-endpoints-list-filter-entries] > div > div[x-ng-repeat] {\n    margin: 5px 5px 0 0;\n    display: inline-block;\n    background-color: transparent;\n    padding: 2px 6px;\n    border-radius: 5px;\n    border: solid #e6e6e6 1px; }\n    div[data-app-endpoints-list-filter-entries] > div > div[x-ng-repeat] > div {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center; }\n      div[data-app-endpoints-list-filter-entries] > div > div[x-ng-repeat] > div > i {\n        margin-left: 3px;\n        font-size: 7px; }\n      div[data-app-endpoints-list-filter-entries] > div > div[x-ng-repeat] > div > span {\n        font-size: 10px;\n        white-space: nowrap; }\n    div[data-app-endpoints-list-filter-entries] > div > div[x-ng-repeat]:hover {\n      cursor: pointer; }\n      div[data-app-endpoints-list-filter-entries] > div > div[x-ng-repeat]:hover > div > span, div[data-app-endpoints-list-filter-entries] > div > div[x-ng-repeat]:hover > div > i {\n        color: #E57125; }\n\ndiv[data-app-endpoints-filter] > div {\n  padding: 0 0 20px 20px; }\n  @media (max-width: 500px) {\n    div[data-app-endpoints-filter] > div {\n      padding-left: 0; } }\n  div[data-app-endpoints-filter] > div > div:first-of-type {\n    width: 80px;\n    height: 1px;\n    background-color: #E57125;\n    margin: 0 0 15px 0; }\n  div[data-app-endpoints-filter] > div > div:last-of-type {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -ms-flex-wrap: wrap;\n        flex-wrap: wrap; }\n    div[data-app-endpoints-filter] > div > div:last-of-type > i {\n      margin: 2px; }\n      div[data-app-endpoints-filter] > div > div:last-of-type > i > div {\n        margin: 0; }\n  div[data-app-endpoints-filter] > div > h1 {\n    margin: 0 0 5px 0;\n    line-height: .4; }\n    div[data-app-endpoints-filter] > div > h1 > span {\n      font-size: 18px;\n      font-weight: 600;\n      text-transform: uppercase; }\n      div[data-app-endpoints-filter] > div > h1 > span:first-of-type {\n        color: #000000;\n        margin-right: 5px; }\n\ni[data-app-endpoints-filter-bubble] {\n  font-style: normal; }\n  i[data-app-endpoints-filter-bubble] > div {\n    margin: 5px 0; }\n    i[data-app-endpoints-filter-bubble] > div:hover {\n      cursor: pointer; }\n    i[data-app-endpoints-filter-bubble] > div > div {\n      background-color: transparent;\n      padding: 3px 8px;\n      border-radius: 5px;\n      display: inline-block;\n      border: solid #e6e6e6 1px; }\n      i[data-app-endpoints-filter-bubble] > div > div > span {\n        white-space: nowrap;\n        font-size: 10px; }\n        i[data-app-endpoints-filter-bubble] > div > div > span:last-of-type {\n          margin-left: 2px;\n          font-size: 8px; }\n\ndiv[data-app-endpoints-details] p {\n  margin: 0; }\n\ndiv[data-app-endpoints-details] div[x-ng-click]:hover {\n  cursor: pointer; }\n\ndiv[data-app-endpoints-details] > div {\n  overflow: auto; }\n  div[data-app-endpoints-details] > div div.header {\n    border-bottom: solid #efefef 1px;\n    padding: 20px;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-pack: justify;\n        -ms-flex-pack: justify;\n            justify-content: space-between;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    div[data-app-endpoints-details] > div div.header.fixed-header {\n      background-color: #ffffff;\n      position: fixed;\n      top: 0;\n      width: 100%;\n      z-index: 1; }\n    div[data-app-endpoints-details] > div div.header .breadcrumb * {\n      margin: 0 10px 0 0;\n      color: #c1c2c4; }\n    div[data-app-endpoints-details] > div div.header .breadcrumb i.fa-home, div[data-app-endpoints-details] > div div.header .breadcrumb span, div[data-app-endpoints-details] > div div.header .breadcrumb a {\n      font-size: 12px; }\n    div[data-app-endpoints-details] > div div.header .breadcrumb i.fa-chevron-right {\n      font-size: 10px; }\n    div[data-app-endpoints-details] > div div.header .breadcrumb a i.fa-home, div[data-app-endpoints-details] > div div.header .breadcrumb a {\n      color: #E57125; }\n    div[data-app-endpoints-details] > div div.header .breadcrumb span, div[data-app-endpoints-details] > div div.header .breadcrumb a {\n      font-weight: 700 !important;\n      white-space: nowrap; }\n    div[data-app-endpoints-details] > div div.header .breadcrumb a {\n      text-decoration: none; }\n      div[data-app-endpoints-details] > div div.header .breadcrumb a:hover {\n        text-decoration: underline; }\n    div[data-app-endpoints-details] > div div.header .buttons {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex; }\n      div[data-app-endpoints-details] > div div.header .buttons > div {\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-align: center;\n            -ms-flex-align: center;\n                align-items: center;\n        margin-left: 20px;\n        background-color: #f0f0f0;\n        padding: 5px 15px;\n        border: solid #464748 1px;\n        border-radius: 3px; }\n        div[data-app-endpoints-details] > div div.header .buttons > div > *, div[data-app-endpoints-details] > div div.header .buttons > div > a > span, div[data-app-endpoints-details] > div div.header .buttons > div > div .trigger > * {\n          color: #464748;\n          text-decoration: none; }\n        div[data-app-endpoints-details] > div div.header .buttons > div > span, div[data-app-endpoints-details] > div div.header .buttons > div > a, div[data-app-endpoints-details] > div div.header .buttons > div > div .trigger > span, div[data-app-endpoints-details] > div div.header .buttons > div > div .trigger > a {\n          font-weight: 400; }\n        div[data-app-endpoints-details] > div div.header .buttons > div > i, div[data-app-endpoints-details] > div div.header .buttons > div > div .trigger > i {\n          margin-right: 5px;\n          font-size: 13px; }\n        div[data-app-endpoints-details] > div div.header .buttons > div:hover {\n          cursor: pointer; }\n        div[data-app-endpoints-details] > div div.header .buttons > div[disabled] > *, div[data-app-endpoints-details] > div div.header .buttons > div[disabled] > a > span, div[data-app-endpoints-details] > div div.header .buttons > div[disabled] > div .trigger > * {\n          color: #c6c7c7; }\n        div[data-app-endpoints-details] > div div.header .buttons > div[disabled]:hover {\n          cursor: default; }\n  div[data-app-endpoints-details] > div > div:last-of-type > div:first-of-type {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n    div[data-app-endpoints-details] > div > div:last-of-type > div:first-of-type > div {\n      -ms-flex-negative: 0;\n          flex-shrink: 0;\n      border-right: solid #efefef 1px; }\n    div[data-app-endpoints-details] > div > div:last-of-type > div:first-of-type > article {\n      -webkit-box-flex: 1;\n          -ms-flex-positive: 1;\n              flex-grow: 1;\n      background-color: #ffffff;\n      min-width: 500px;\n      padding: 0 40px; }\n\ndiv[data-app-endpoints-details-header] > div {\n  max-width: 100%;\n  margin-bottom: 20px;\n  padding-bottom: 20px;\n  border-bottom: dashed #e5e6e7 1px; }\n  div[data-app-endpoints-details-header] > div div[data-tribe-markdown] {\n    width: 100%; }\n  div[data-app-endpoints-details-header] > div a {\n    text-decoration: none; }\n    div[data-app-endpoints-details-header] > div a:hover {\n      text-decoration: underline; }\n  div[data-app-endpoints-details-header] > div div.title {\n    margin-bottom: 10px;\n    margin-top: 10px; }\n    div[data-app-endpoints-details-header] > div div.title > h1 {\n      -webkit-transform: translate(-10px, 0);\n              transform: translate(-10px, 0);\n      margin: 0;\n      padding: 0;\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center; }\n      div[data-app-endpoints-details-header] > div div.title > h1 > div[data-tribe-text].active {\n        -webkit-box-flex: 1;\n            -ms-flex-positive: 1;\n                flex-grow: 1; }\n      div[data-app-endpoints-details-header] > div div.title > h1 > div[data-tribe-text] > div input, div[data-app-endpoints-details-header] > div div.title > h1 > div[data-tribe-text] > div span {\n        color: #000000; }\n      div[data-app-endpoints-details-header] > div div.title > h1 > div[data-tribe-singleselect] input, div[data-app-endpoints-details-header] > div div.title > h1 > div[data-tribe-singleselect] span {\n        text-transform: capitalize;\n        font-style: normal;\n        color: #000000;\n        font-size: 25px !important; }\n        div[data-app-endpoints-details-header] > div div.title > h1 > div[data-tribe-singleselect] input.mandatory, div[data-app-endpoints-details-header] > div div.title > h1 > div[data-tribe-singleselect] span.mandatory {\n          vertical-align: super !important;\n          font-size: 9px !important;\n          margin-left: 2px;\n          -ms-flex-item-align: start;\n              align-self: flex-start; }\n      div[data-app-endpoints-details-header] > div div.title > h1 div.value span, div[data-app-endpoints-details-header] > div div.title > h1 a, div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text] input, div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text] span {\n        font-size: 25px !important;\n        font-weight: 600 !important;\n        margin-right: 5px;\n        max-width: none !important; }\n        div[data-app-endpoints-details-header] > div div.title > h1 div.value span.empty, div[data-app-endpoints-details-header] > div div.title > h1 a.empty, div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text] input.empty, div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text] span.empty {\n          font-weight: 700 !important;\n          margin-right: 0; }\n        div[data-app-endpoints-details-header] > div div.title > h1 div.value span:last-of-type, div[data-app-endpoints-details-header] > div div.title > h1 a:last-of-type, div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text] input:last-of-type, div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text] span:last-of-type {\n          margin-right: 0; }\n      div[data-app-endpoints-details-header] > div div.title > h1 div.value span {\n        margin-right: 5px !important;\n        color: #000000; }\n      div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-singleselect] {\n        margin-right: 5px; }\n        div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-singleselect].active input {\n          margin: 12px 0; }\n      div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text] span.mandatory {\n        vertical-align: super !important;\n        font-size: 9px !important;\n        margin-left: 2px;\n        -ms-flex-item-align: start;\n            align-self: flex-start; }\n      div[data-app-endpoints-details-header] > div div.title > h1 div[data-tribe-text].active input {\n        margin: 4px 0; }\n  div[data-app-endpoints-details-header] > div > h2 {\n    margin: 0;\n    text-transform: uppercase;\n    font-weight: 700 !important;\n    font-size: 18px;\n    color: #000000; }\n  div[data-app-endpoints-details-header] > div div.resourceUrl {\n    margin-top: 15px; }\n    div[data-app-endpoints-details-header] > div div.resourceUrl > div > i[data-tribe-editable-option].visible div.value {\n      padding-right: 20px; }\n    div[data-app-endpoints-details-header] > div div.resourceUrl > div > i[data-tribe-editable-option] div.value {\n      padding-right: 0; }\n      div[data-app-endpoints-details-header] > div div.resourceUrl > div > i[data-tribe-editable-option] div.value:hover {\n        padding-right: 20px; }\n    div[data-app-endpoints-details-header] > div div.resourceUrl > div > a {\n      display: inline-block;\n      color: #000000; }\n    div[data-app-endpoints-details-header] > div div.resourceUrl > h2 {\n      margin: 0;\n      text-transform: uppercase;\n      font-weight: 700 !important;\n      font-size: 18px;\n      color: #000000; }\n  div[data-app-endpoints-details-header] > div span.empty {\n    color: white;\n    font-weight: 700 !important;\n    font-style: italic !important; }\n\ndiv.endpoint-details-path-tip p {\n  margin: 0; }\n\ndiv.endpoint-details-path-tip ul, div.endpoint-details-path-tip li {\n  margin-bottom: 0; }\n\ndiv[data-app-endpoints-details-toc] > div {\n  position: relative;\n  width: 350px;\n  -webkit-transition: width .5s ease;\n  transition: width .5s ease;\n  height: 100%; }\n  div[data-app-endpoints-details-toc] > div > div.content {\n    padding: 40px;\n    position: absolute;\n    top: 0;\n    bottom: 0;\n    right: 0;\n    width: 350px; }\n    div[data-app-endpoints-details-toc] > div > div.content > div.body > ul {\n      margin: 20px 0 0 0; }\n    div[data-app-endpoints-details-toc] > div > div.content > div.body ul {\n      list-style: none; }\n    div[data-app-endpoints-details-toc] > div > div.content > div.title > div:first-of-type {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      margin: 0 0 10px 0; }\n      div[data-app-endpoints-details-toc] > div > div.content > div.title > div:first-of-type > div {\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-orient: vertical;\n        -webkit-box-direction: normal;\n            -ms-flex-direction: column;\n                flex-direction: column;\n        -webkit-box-pack: center;\n            -ms-flex-pack: center;\n                justify-content: center;\n        -webkit-box-align: center;\n            -ms-flex-align: center;\n                align-items: center;\n        width: 30px;\n        height: 30px;\n        border-radius: 15px;\n        background-color: #33383d; }\n        div[data-app-endpoints-details-toc] > div > div.content > div.title > div:first-of-type > div > i {\n          color: #ffffff; }\n      div[data-app-endpoints-details-toc] > div > div.content > div.title > div:first-of-type > h3 {\n        font-size: 14px;\n        margin: 0 0 0 10px;\n        text-transform: uppercase;\n        font-weight: 700 !important; }\n    div[data-app-endpoints-details-toc] > div > div.content > div.title > div:last-of-type {\n      background-color: #E57125;\n      height: 1px;\n      width: 70px; }\n  div[data-app-endpoints-details-toc] > div > div.collapse-icon {\n    position: absolute;\n    top: 10px;\n    right: 10px;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    div[data-app-endpoints-details-toc] > div > div.collapse-icon > i {\n      margin-left: 2px; }\n      div[data-app-endpoints-details-toc] > div > div.collapse-icon > i:last-of-type {\n        display: none; }\n    div[data-app-endpoints-details-toc] > div > div.collapse-icon:hover {\n      cursor: pointer; }\n\ndiv[data-app-endpoints-details-toc].collapsed > div {\n  width: 40px; }\n  div[data-app-endpoints-details-toc].collapsed > div > div.collapse-icon > i:first-of-type {\n    display: none; }\n  div[data-app-endpoints-details-toc].collapsed > div > div.collapse-icon > i:last-of-type {\n    display: block; }\n\nli[data-app-endpoints-details-toc-item] {\n  margin: 0; }\n  li[data-app-endpoints-details-toc-item] > div h4 {\n    padding: 15px 0;\n    margin: 0;\n    font-size: 12px;\n    text-decoration: none;\n    color: #000000;\n    text-transform: uppercase;\n    font-weight: 700 !important; }\n    li[data-app-endpoints-details-toc-item] > div h4.selected {\n      font-weight: 900 !important; }\n    li[data-app-endpoints-details-toc-item] > div h4:hover {\n      cursor: pointer; }\n  li[data-app-endpoints-details-toc-item] > div > ul {\n    margin: 0;\n    position: relative; }\n    li[data-app-endpoints-details-toc-item] > div > ul > div {\n      position: absolute;\n      left: 0;\n      top: 0;\n      bottom: 0;\n      width: 1px;\n      background-color: #E57125; }\n    li[data-app-endpoints-details-toc-item] > div > ul > li {\n      position: relative;\n      padding: 0 0 0 20px;\n      margin: 0; }\n      li[data-app-endpoints-details-toc-item] > div > ul > li > h4.selected + div {\n        position: absolute;\n        left: -5px;\n        top: 50%;\n        margin-top: -5px;\n        width: 10px;\n        height: 10px;\n        background-color: #E57125;\n        border: solid #ffffff 2px;\n        border-radius: 10px; }\n\ndiv[data-app-endpoints-details-parameters]:hover div.tribe-add-btn {\n  opacity: 1; }\n\ndiv[data-app-endpoints-details-parameters] [data-tribe-singleselect] {\n  display: block; }\n\ndiv[data-app-endpoints-details-parameters] > div {\n  max-width: 100%;\n  margin-bottom: 20px;\n  padding-bottom: 20px;\n  border-bottom: dashed #e5e6e7 1px; }\n  div[data-app-endpoints-details-parameters] > div > h2 {\n    margin-bottom: 10px;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    div[data-app-endpoints-details-parameters] > div > h2 > span {\n      font-size: 18px;\n      color: #000000;\n      font-weight: 700 !important;\n      text-transform: uppercase; }\n    div[data-app-endpoints-details-parameters] > div > h2 > div.add-param {\n      background-color: #d6d6d6;\n      padding: 0 5px;\n      margin-left: 10px; }\n      div[data-app-endpoints-details-parameters] > div > h2 > div.add-param > i {\n        color: #ffffff; }\n  div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div {\n    overflow: auto; }\n    div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table {\n      table-layout: fixed;\n      width: 100%; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table thead {\n        background-color: #f9f9f9; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th {\n        text-align: left;\n        background-color: #f8f9fa;\n        color: #000000;\n        padding: 15px 5px;\n        text-transform: uppercase;\n        font-size: 14px;\n        font-weight: 700 !important;\n        border: solid #eceff2 1px;\n        border-left: 0;\n        border-right: 0; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th:first-of-type {\n        padding: 15px 5px 15px 10px; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td:first-of-type {\n        padding-left: 10px; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td {\n        padding-top: 5px; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table tr {\n        border-top: solid #f2f4f5 1px; }\n        div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table tr:last-of-type {\n          border-bottom: solid #f2f4f5 1px; }\n    @media (max-width: 1000px) {\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table {\n        min-width: 800px; } }\n    div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td {\n      width: 120px;\n      max-width: 120px;\n      white-space: nowrap; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th > *, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td > * {\n        margin-left: 5px; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th:first-of-type > *, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td:first-of-type > * {\n        margin-left: 0; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th:last-of-type, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td:last-of-type {\n        width: 35px; }\n        div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th:last-of-type > div, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td:last-of-type > div {\n          display: none;\n          background-color: #d6d6d6;\n          border-radius: 3px;\n          -webkit-box-orient: vertical;\n          -webkit-box-direction: normal;\n              -ms-flex-direction: column;\n                  flex-direction: column;\n          -webkit-box-pack: center;\n              -ms-flex-pack: center;\n                  justify-content: center;\n          -webkit-box-align: center;\n              -ms-flex-align: center;\n                      -ms-grid-row-align: center;\n                  align-items: center;\n          padding: 5px; }\n          div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th:last-of-type > div:hover, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td:last-of-type > div:hover {\n            background-color: #414141; }\n          div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th:last-of-type > div > i, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td:last-of-type > div > i {\n            color: #ffffff;\n            font-size: 18px; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th.description, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th.valid-values, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td.description, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td.valid-values {\n        white-space: normal;\n        width: 100%; }\n        div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th.description > div, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table th.valid-values > div, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td.description > div, div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td.valid-values > div {\n          display: -webkit-box;\n          display: -ms-flexbox;\n          display: flex;\n          -webkit-box-orient: vertical;\n          -webkit-box-direction: normal;\n              -ms-flex-direction: column;\n                  flex-direction: column; }\n    div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table td > i > div {\n      width: 100%; }\n    div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table tr {\n      border-top: solid #f2f4f5 1px; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table tr:first-of-type {\n        border-color: transparent; }\n      div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table tr > td > div {\n        margin-bottom: 5px; }\n    div[data-app-endpoints-details-parameters] > div > div.app-epd-params > div > table tr:hover td:last-of-type > div {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex; }\n\ndiv[data-app-endpoints-details-resource-information] [data-tribe-editable-text] input, div[data-app-endpoints-details-resource-information] [data-tribe-editable-text] span, div[data-app-endpoints-details-resource-information] [data-tribe-editable-number] input, div[data-app-endpoints-details-resource-information] [data-tribe-editable-number] span {\n  margin-left: 0 !important; }\n\ndiv[data-app-endpoints-details-resource-information] > div {\n  max-width: 100%;\n  margin-bottom: 20px;\n  border-bottom: dashed #e5e6e7 1px; }\n  div[data-app-endpoints-details-resource-information] > div > h2 {\n    margin: 0 0 10px 0;\n    text-transform: uppercase;\n    font-weight: 700 !important;\n    font-size: 18px;\n    color: #000000; }\n  div[data-app-endpoints-details-resource-information] > div > div:first-of-type {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -ms-flex-wrap: wrap;\n        flex-wrap: wrap; }\n    div[data-app-endpoints-details-resource-information] > div > div:first-of-type > div {\n      width: 600px;\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex; }\n      @media (max-width: 700px) {\n        div[data-app-endpoints-details-resource-information] > div > div:first-of-type > div {\n          width: 100%;\n          display: block; } }\n      div[data-app-endpoints-details-resource-information] > div > div:first-of-type > div > div {\n        margin: 5px 10px 30px 0;\n        width: 300px;\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-orient: vertical;\n        -webkit-box-direction: normal;\n            -ms-flex-direction: column;\n                flex-direction: column; }\n        @media (max-width: 700px) {\n          div[data-app-endpoints-details-resource-information] > div > div:first-of-type > div > div {\n            width: 100%; } }\n        div[data-app-endpoints-details-resource-information] > div > div:first-of-type > div > div > span {\n          margin-bottom: 10px;\n          text-transform: uppercase;\n          font-weight: 700 !important;\n          font-size: 14px;\n          color: #000000; }\n        div[data-app-endpoints-details-resource-information] > div > div:first-of-type > div > div.auth-method > div > div > span {\n          text-transform: uppercase;\n          font-size: 13px;\n          font-weight: 500 !important; }\n  div[data-app-endpoints-details-resource-information] > div div.app-rates {\n    width: 100%;\n    margin-bottom: 30px; }\n    div[data-app-endpoints-details-resource-information] > div div.app-rates:hover div.tribe-add-btn {\n      opacity: 1; }\n    div[data-app-endpoints-details-resource-information] > div div.app-rates i[data-tribe-editable-text] > div:hover, div[data-app-endpoints-details-resource-information] > div div.app-rates i[data-tribe-editable-number] > div:hover, div[data-app-endpoints-details-resource-information] > div div.app-rates i[data-tribe-editable-option] > div:hover {\n      border-color: #f2f0f0; }\n    div[data-app-endpoints-details-resource-information] > div div.app-rates > div.rates {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      -ms-flex-wrap: wrap;\n          flex-wrap: wrap; }\n      div[data-app-endpoints-details-resource-information] > div div.app-rates > div.rates > * {\n        margin-left: 5px; }\n        div[data-app-endpoints-details-resource-information] > div div.app-rates > div.rates > *:first-child {\n          margin-left: 0; }\n      div[data-app-endpoints-details-resource-information] > div div.app-rates > div.rates > div:last-of-type {\n        display: -webkit-box;\n        display: -ms-flexbox;\n        display: flex;\n        -webkit-box-orient: vertical;\n        -webkit-box-direction: normal;\n            -ms-flex-direction: column;\n                flex-direction: column;\n        -webkit-box-align: center;\n            -ms-flex-align: center;\n                align-items: center;\n        -webkit-box-pack: center;\n            -ms-flex-pack: center;\n                justify-content: center;\n        background-color: #d6d6d6;\n        padding: 5px;\n        border-radius: 3px; }\n        div[data-app-endpoints-details-resource-information] > div div.app-rates > div.rates > div:last-of-type > i {\n          color: #ffffff;\n          margin: 0; }\n    div[data-app-endpoints-details-resource-information] > div div.app-rates > div:first-of-type {\n      margin-bottom: 10px;\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center; }\n      div[data-app-endpoints-details-resource-information] > div div.app-rates > div:first-of-type > span {\n        text-transform: uppercase;\n        font-weight: 700 !important;\n        font-size: 14px;\n        color: #000000; }\n      div[data-app-endpoints-details-resource-information] > div div.app-rates > div:first-of-type > div {\n        background-color: #d6d6d6;\n        padding: 0 5px;\n        margin-left: 10px; }\n        div[data-app-endpoints-details-resource-information] > div div.app-rates > div:first-of-type > div > i {\n          color: #ffffff; }\n\ndiv[data-app-endpoints-details-response-request] div[data-tribe-markdown] {\n  display: block; }\n\ndiv[data-app-endpoints-details-response-request] td {\n  padding-right: 5px; }\n  div[data-app-endpoints-details-response-request] td > div {\n    width: 100%; }\n\ndiv[data-app-endpoints-details-response-request] > div h2 {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center;\n  font-size: 18px;\n  color: #000000;\n  font-weight: 700 !important;\n  text-transform: uppercase; }\n  div[data-app-endpoints-details-response-request] > div h2 > div {\n    background-color: #d6d6d6;\n    padding: 0 5px;\n    margin-left: 10px; }\n    div[data-app-endpoints-details-response-request] > div h2 > div > i {\n      color: #ffffff; }\n\ndiv[data-app-endpoints-details-response-request] > div h3 {\n  font-size: 14px;\n  color: #000000;\n  font-weight: 700 !important;\n  text-transform: uppercase; }\n\ndiv[data-app-endpoints-details-response-request] > div h3 + div {\n  margin-bottom: 20px; }\n\ndiv[data-app-endpoints-details-response-request] > div div.resp-body > h2 {\n  margin: 10px 0 0 0; }\n\ndiv[data-app-endpoints-details-response-request] > div div.values, div[data-app-endpoints-details-response-request] > div div.expected {\n  margin-top: 10px;\n  padding-bottom: 20px;\n  border-bottom: dashed #e5e6e7 1px; }\n  div[data-app-endpoints-details-response-request] > div div.values > table, div[data-app-endpoints-details-response-request] > div div.expected > table {\n    table-layout: fixed;\n    width: 100%; }\n    div[data-app-endpoints-details-response-request] > div div.values > table thead, div[data-app-endpoints-details-response-request] > div div.expected > table thead {\n      background-color: #f9f9f9; }\n    div[data-app-endpoints-details-response-request] > div div.values > table th, div[data-app-endpoints-details-response-request] > div div.expected > table th {\n      text-align: left;\n      background-color: #f8f9fa;\n      color: #000000;\n      padding: 15px 5px;\n      text-transform: uppercase;\n      font-size: 14px;\n      font-weight: 700 !important;\n      border: solid #eceff2 1px;\n      border-left: 0;\n      border-right: 0; }\n    div[data-app-endpoints-details-response-request] > div div.values > table th:first-of-type, div[data-app-endpoints-details-response-request] > div div.expected > table th:first-of-type {\n      padding: 15px 5px 15px 10px; }\n    div[data-app-endpoints-details-response-request] > div div.values > table td:first-of-type, div[data-app-endpoints-details-response-request] > div div.expected > table td:first-of-type {\n      padding-left: 10px; }\n    div[data-app-endpoints-details-response-request] > div div.values > table td, div[data-app-endpoints-details-response-request] > div div.expected > table td {\n      padding-top: 5px; }\n    div[data-app-endpoints-details-response-request] > div div.values > table tr, div[data-app-endpoints-details-response-request] > div div.expected > table tr {\n      border-top: solid #f2f4f5 1px; }\n      div[data-app-endpoints-details-response-request] > div div.values > table tr:last-of-type, div[data-app-endpoints-details-response-request] > div div.expected > table tr:last-of-type {\n        border-bottom: solid #f2f4f5 1px; }\n  div[data-app-endpoints-details-response-request] > div div.values th:last-of-type, div[data-app-endpoints-details-response-request] > div div.values td:last-of-type, div[data-app-endpoints-details-response-request] > div div.expected th:last-of-type, div[data-app-endpoints-details-response-request] > div div.expected td:last-of-type {\n    width: 35px; }\n  div[data-app-endpoints-details-response-request] > div div.values td > i > div, div[data-app-endpoints-details-response-request] > div div.expected td > i > div {\n    width: 100%; }\n  div[data-app-endpoints-details-response-request] > div div.values td > i[data-tribe-editable-text] input, div[data-app-endpoints-details-response-request] > div div.expected td > i[data-tribe-editable-text] input {\n    width: 100%; }\n  div[data-app-endpoints-details-response-request] > div div.values td:last-of-type > div, div[data-app-endpoints-details-response-request] > div div.expected td:last-of-type > div {\n    display: none;\n    background-color: #d6d6d6;\n    height: 100%;\n    width: 100%;\n    margin: 0;\n    padding: 5px;\n    border-radius: 3px;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n                -ms-grid-row-align: center;\n            align-items: center; }\n    div[data-app-endpoints-details-response-request] > div div.values td:last-of-type > div > i, div[data-app-endpoints-details-response-request] > div div.expected td:last-of-type > div > i {\n      color: #ffffff;\n      font-size: 18px; }\n    div[data-app-endpoints-details-response-request] > div div.values td:last-of-type > div:hover, div[data-app-endpoints-details-response-request] > div div.expected td:last-of-type > div:hover {\n      background-color: #404142; }\n  div[data-app-endpoints-details-response-request] > div div.values tr, div[data-app-endpoints-details-response-request] > div div.expected tr {\n    border-top: solid #f2f4f5 1px; }\n    div[data-app-endpoints-details-response-request] > div div.values tr:first-of-type, div[data-app-endpoints-details-response-request] > div div.expected tr:first-of-type {\n      border-color: transparent; }\n    div[data-app-endpoints-details-response-request] > div div.values tr > td > div, div[data-app-endpoints-details-response-request] > div div.expected tr > td > div {\n      margin-bottom: 5px; }\n  div[data-app-endpoints-details-response-request] > div div.values tr:hover td:last-of-type > div, div[data-app-endpoints-details-response-request] > div div.expected tr:hover td:last-of-type > div {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    margin: 0 5px; }\n\ndiv[data-app-endpoints-details-response-request] > div div.expected td:first-of-type, div[data-app-endpoints-details-response-request] > div div.expected th:first-of-type {\n  width: 200px; }\n\ndiv[data-app-endpoints-details-response-request] > div div.values td:nth-of-type(1), div[data-app-endpoints-details-response-request] > div div.values td:nth-of-type(2), div[data-app-endpoints-details-response-request] > div div.values th:nth-of-type(1), div[data-app-endpoints-details-response-request] > div div.values th:nth-of-type(2) {\n  width: 130px; }\n\ndiv[data-app-endpoints-details-response-request] > div div.samples h2 {\n  margin: 20px 0 20px 0; }\n\ndiv[data-app-endpoints-details-response-request] > div div.expected:hover div.tribe-add-btn, div[data-app-endpoints-details-response-request] > div div.values:hover div.tribe-add-btn {\n  opacity: 1; }\n\ndiv[data-app-endpoints-details-see]:hover div.tribe-add-btn {\n  opacity: 1; }\n\ndiv[data-app-endpoints-details-see] > div {\n  max-width: 100%;\n  margin-top: 10px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-align: start;\n      -ms-flex-align: start;\n          align-items: flex-start; }\n  div[data-app-endpoints-details-see] > div > ul {\n    margin: 0;\n    list-style: none;\n    width: 100%; }\n    div[data-app-endpoints-details-see] > div > ul > li {\n      width: 100%; }\n    div[data-app-endpoints-details-see] > div > ul > li {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center; }\n      div[data-app-endpoints-details-see] > div > ul > li a {\n        text-decoration: none; }\n      div[data-app-endpoints-details-see] > div > ul > li i.fa.fa-link {\n        color: #E57125;\n        margin: 0 5px 0 0; }\n      div[data-app-endpoints-details-see] > div > ul > li i[data-tribe-editable-text].edit {\n        width: 100%; }\n        div[data-app-endpoints-details-see] > div > ul > li i[data-tribe-editable-text].edit > div {\n          width: 100%; }\n      div[data-app-endpoints-details-see] > div > ul > li > div {\n        display: none;\n        background-color: #d6d6d6;\n        padding: 0 5px;\n        margin-left: 10px; }\n        div[data-app-endpoints-details-see] > div > ul > li > div:hover {\n          cursor: pointer; }\n        div[data-app-endpoints-details-see] > div > ul > li > div > i {\n          color: #ffffff;\n          margin: 0;\n          font-size: 10px; }\n      div[data-app-endpoints-details-see] > div > ul > li:hover > div {\n        display: block; }\n  div[data-app-endpoints-details-see] > div > div {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center; }\n    div[data-app-endpoints-details-see] > div > div > span {\n      text-transform: uppercase;\n      font-weight: 700 !important;\n      font-size: 18px;\n      color: #000; }\n    div[data-app-endpoints-details-see] > div > div > div {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-orient: vertical;\n      -webkit-box-direction: normal;\n          -ms-flex-direction: column;\n              flex-direction: column;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      -webkit-box-pack: center;\n          -ms-flex-pack: center;\n              justify-content: center;\n      background-color: #d6d6d6;\n      padding: 5px;\n      margin-left: 10px; }\n      div[data-app-endpoints-details-see] > div > div > div:hover {\n        cursor: pointer; }\n      div[data-app-endpoints-details-see] > div > div > div > i {\n        color: #ffffff;\n        margin: 0;\n        font-size: 10px; }\n\ndiv[data-app-endpoints-details-history] {\n  margin-top: 20px; }\n  div[data-app-endpoints-details-history] > div > table {\n    table-layout: fixed;\n    width: 100%; }\n    div[data-app-endpoints-details-history] > div > table thead {\n      background-color: #f9f9f9; }\n    div[data-app-endpoints-details-history] > div > table th {\n      text-align: left;\n      background-color: #f8f9fa;\n      color: #000000;\n      padding: 15px 5px;\n      text-transform: uppercase;\n      font-size: 14px;\n      font-weight: 700 !important;\n      border: solid #eceff2 1px;\n      border-left: 0;\n      border-right: 0; }\n    div[data-app-endpoints-details-history] > div > table th:first-of-type {\n      padding: 15px 5px 15px 10px; }\n    div[data-app-endpoints-details-history] > div > table td:first-of-type {\n      padding-left: 10px; }\n    div[data-app-endpoints-details-history] > div > table td {\n      padding-top: 5px; }\n    div[data-app-endpoints-details-history] > div > table tr {\n      border-top: solid #f2f4f5 1px; }\n      div[data-app-endpoints-details-history] > div > table tr:last-of-type {\n        border-bottom: solid #f2f4f5 1px; }\n  div[data-app-endpoints-details-history] > div > table td {\n    padding: 20px 0; }\n    div[data-app-endpoints-details-history] > div > table td:last-of-type {\n      padding: 10px 0; }\n  div[data-app-endpoints-details-history] > div > table td:first-of-type, div[data-app-endpoints-details-history] > div > table th:first-of-type {\n    width: 40px; }\n  div[data-app-endpoints-details-history] > div > table td:last-of-type, div[data-app-endpoints-details-history] > div > table th:last-of-type {\n    width: 30px; }\n    div[data-app-endpoints-details-history] > div > table td:last-of-type i, div[data-app-endpoints-details-history] > div > table th:last-of-type i {\n      font-size: 18px; }\n  div[data-app-endpoints-details-history] > div button {\n    margin: 20px 10px 20px 0;\n    background-color: #f0f0f0 !important;\n    border: solid #464748 1px;\n    border-radius: 3px;\n    color: #000000; }\n    div[data-app-endpoints-details-history] > div button[disabled] {\n      color: #464748; }\n    div[data-app-endpoints-details-history] > div button:hover {\n      background-color: #f0f0f0 !important; }\n  div[data-app-endpoints-details-history] h3.diff-title {\n    margin: 0;\n    padding: 5px 8px;\n    text-align: center;\n    font-size: 12px; }\n\ndiv[data-app-application-details] div.header {\n  border-bottom: solid #efefef 1px;\n  padding: 20px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: justify;\n      -ms-flex-pack: justify;\n          justify-content: space-between;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n  div[data-app-application-details] div.header .breadcrumb * {\n    margin: 0 10px 0 0;\n    color: #c1c2c4; }\n  div[data-app-application-details] div.header .breadcrumb i.fa-home, div[data-app-application-details] div.header .breadcrumb span, div[data-app-application-details] div.header .breadcrumb a {\n    font-size: 12px; }\n  div[data-app-application-details] div.header .breadcrumb i.fa-chevron-right {\n    font-size: 10px; }\n  div[data-app-application-details] div.header .breadcrumb a i.fa-home, div[data-app-application-details] div.header .breadcrumb a {\n    color: #E57125; }\n  div[data-app-application-details] div.header .breadcrumb span, div[data-app-application-details] div.header .breadcrumb a {\n    font-weight: 700 !important;\n    white-space: nowrap; }\n  div[data-app-application-details] div.header .breadcrumb a {\n    text-decoration: none; }\n    div[data-app-application-details] div.header .breadcrumb a:hover {\n      text-decoration: underline; }\n  div[data-app-application-details] div.header .buttons {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n    div[data-app-application-details] div.header .buttons > div {\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center;\n      margin-left: 20px;\n      background-color: #f0f0f0;\n      padding: 5px 15px;\n      border: solid #464748 1px;\n      border-radius: 3px; }\n      div[data-app-application-details] div.header .buttons > div > *, div[data-app-application-details] div.header .buttons > div > a > span, div[data-app-application-details] div.header .buttons > div > div .trigger > * {\n        color: #464748;\n        text-decoration: none; }\n      div[data-app-application-details] div.header .buttons > div > span, div[data-app-application-details] div.header .buttons > div > a, div[data-app-application-details] div.header .buttons > div > div .trigger > span, div[data-app-application-details] div.header .buttons > div > div .trigger > a {\n        font-weight: 700; }\n      div[data-app-application-details] div.header .buttons > div > i, div[data-app-application-details] div.header .buttons > div > div .trigger > i {\n        margin-right: 5px;\n        font-size: 13px; }\n      div[data-app-application-details] div.header .buttons > div:hover {\n        cursor: pointer; }\n      div[data-app-application-details] div.header .buttons > div[disabled] > *, div[data-app-application-details] div.header .buttons > div[disabled] > a > span, div[data-app-application-details] div.header .buttons > div[disabled] > div .trigger > * {\n        color: #c6c7c7; }\n      div[data-app-application-details] div.header .buttons > div[disabled]:hover {\n        cursor: default; }\n\ndiv[data-app-application-details] article.content {\n  padding: 10px 40px 0 40px; }\n  div[data-app-application-details] article.content div[data-tribe-markdown] {\n    width: 100%; }\n  div[data-app-application-details] article.content > div:first-of-type > h1 {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-transform: translate(-10px, 0);\n            transform: translate(-10px, 0); }\n  div[data-app-application-details] article.content > div:first-of-type > div {\n    -webkit-transform: translate(-10px, 0);\n            transform: translate(-10px, 0); }\n  div[data-app-application-details] article.content > div:nth-of-type(1) h1, div[data-app-application-details] article.content > div:nth-of-type(2) h1 {\n    margin: 0 0 5px 0; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) h2, div[data-app-application-details] article.content > div:nth-of-type(1) h3, div[data-app-application-details] article.content > div:nth-of-type(2) h2, div[data-app-application-details] article.content > div:nth-of-type(2) h3 {\n    text-transform: uppercase;\n    margin: 15px 0; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) h1, div[data-app-application-details] article.content > div:nth-of-type(1) h1 input, div[data-app-application-details] article.content > div:nth-of-type(1) h1 span, div[data-app-application-details] article.content > div:nth-of-type(2) h1, div[data-app-application-details] article.content > div:nth-of-type(2) h1 input, div[data-app-application-details] article.content > div:nth-of-type(2) h1 span {\n    font-size: 25px !important;\n    font-weight: 700 !important; }\n    div[data-app-application-details] article.content > div:nth-of-type(1) h1.mandatory, div[data-app-application-details] article.content > div:nth-of-type(1) h1 input.mandatory, div[data-app-application-details] article.content > div:nth-of-type(1) h1 span.mandatory, div[data-app-application-details] article.content > div:nth-of-type(2) h1.mandatory, div[data-app-application-details] article.content > div:nth-of-type(2) h1 input.mandatory, div[data-app-application-details] article.content > div:nth-of-type(2) h1 span.mandatory {\n      vertical-align: super !important;\n      font-size: 9px !important;\n      margin-left: 2px;\n      -ms-flex-item-align: start;\n          align-self: flex-start; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) h2, div[data-app-application-details] article.content > div:nth-of-type(2) h2 {\n    font-size: 18px !important;\n    font-weight: 700 !important; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) h3, div[data-app-application-details] article.content > div:nth-of-type(2) h3 {\n    font-size: 14px !important;\n    font-weight: 700 !important; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) ul, div[data-app-application-details] article.content > div:nth-of-type(1) li, div[data-app-application-details] article.content > div:nth-of-type(2) ul, div[data-app-application-details] article.content > div:nth-of-type(2) li {\n    list-style: none;\n    margin: 0; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) ul, div[data-app-application-details] article.content > div:nth-of-type(2) ul {\n    margin-left: 10px; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) a, div[data-app-application-details] article.content > div:nth-of-type(2) a {\n    text-decoration: none; }\n    div[data-app-application-details] article.content > div:nth-of-type(1) a span:first-child, div[data-app-application-details] article.content > div:nth-of-type(2) a span:first-child {\n      text-transform: uppercase; }\n    div[data-app-application-details] article.content > div:nth-of-type(1) a span:last-child, div[data-app-application-details] article.content > div:nth-of-type(2) a span:last-child {\n      font-style: italic; }\n    div[data-app-application-details] article.content > div:nth-of-type(1) a:hover span, div[data-app-application-details] article.content > div:nth-of-type(2) a:hover span {\n      color: #E57125; }\n  div[data-app-application-details] article.content > div:nth-of-type(1) ul.endpoint-info li, div[data-app-application-details] article.content > div:nth-of-type(2) ul.endpoint-info li {\n    margin-bottom: 5px; }\n    div[data-app-application-details] article.content > div:nth-of-type(1) ul.endpoint-info li > a span, div[data-app-application-details] article.content > div:nth-of-type(2) ul.endpoint-info li > a span {\n      margin-right: 5px; }\n\ndiv[data-app-application-details-history] {\n  margin-top: 20px; }\n  div[data-app-application-details-history] > div > table {\n    table-layout: fixed;\n    width: 100%; }\n    div[data-app-application-details-history] > div > table thead {\n      background-color: #f9f9f9; }\n    div[data-app-application-details-history] > div > table th {\n      text-align: left;\n      background-color: #f8f9fa;\n      color: #000000;\n      padding: 15px 5px;\n      text-transform: uppercase;\n      font-size: 14px;\n      font-weight: 700 !important;\n      border: solid #eceff2 1px;\n      border-left: 0;\n      border-right: 0; }\n    div[data-app-application-details-history] > div > table th:first-of-type {\n      padding: 15px 5px 15px 10px; }\n    div[data-app-application-details-history] > div > table td:first-of-type {\n      padding-left: 10px; }\n    div[data-app-application-details-history] > div > table td {\n      padding-top: 5px; }\n    div[data-app-application-details-history] > div > table tr {\n      border-top: solid #f2f4f5 1px; }\n      div[data-app-application-details-history] > div > table tr:last-of-type {\n        border-bottom: solid #f2f4f5 1px; }\n  div[data-app-application-details-history] > div > table td {\n    padding: 20px 0; }\n    div[data-app-application-details-history] > div > table td:last-of-type {\n      padding: 10px 0; }\n  div[data-app-application-details-history] > div > table td:first-of-type, div[data-app-application-details-history] > div > table th:first-of-type {\n    width: 40px; }\n  div[data-app-application-details-history] > div > table td:last-of-type, div[data-app-application-details-history] > div > table th:last-of-type {\n    width: 30px; }\n    div[data-app-application-details-history] > div > table td:last-of-type i, div[data-app-application-details-history] > div > table th:last-of-type i {\n      font-size: 18px; }\n  div[data-app-application-details-history] > div button {\n    margin: 20px 10px 20px 0;\n    background-color: #f0f0f0 !important;\n    border: solid #464748 1px;\n    border-radius: 3px;\n    color: #000000; }\n    div[data-app-application-details-history] > div button[disabled] {\n      color: #464748; }\n    div[data-app-application-details-history] > div button:hover {\n      background-color: #f0f0f0 !important; }\n  div[data-app-application-details-history] h3.diff-title {\n    margin: 0;\n    padding: 5px 8px;\n    text-align: center;\n    font-size: 12px; }\n\ndiv[data-app-see] > article {\n  padding: 40px; }\n  div[data-app-see] > article h1, div[data-app-see] > article h2, div[data-app-see] > article h3, div[data-app-see] > article h4, div[data-app-see] > article p, div[data-app-see] > article code {\n    font-weight: 100; }\n  div[data-app-see] > article > div[x-ng-bind-html] pre {\n    border: 1px solid #ccc;\n    padding: 20px; }\n  div[data-app-see] > article > div[x-ng-bind-html] code {\n    border: 0;\n    background-color: #ffffff;\n    padding: 0;\n    font-family: \"open sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif; }\n\ndiv[data-app-endpoints-selected-filter] > div {\n  padding: 0 20px 20px 20px; }\n  @media (max-width: 500px) {\n    div[data-app-endpoints-selected-filter] > div {\n      padding-left: 0; } }\n  div[data-app-endpoints-selected-filter] > div > h1 {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    text-transform: uppercase; }\n    div[data-app-endpoints-selected-filter] > div > h1 > i, div[data-app-endpoints-selected-filter] > div > h1 > span {\n      font-size: 18px; }\n    div[data-app-endpoints-selected-filter] > div > h1 > span {\n      margin-left: 5px;\n      font-weight: 600;\n      white-space: nowrap; }\n    div[data-app-endpoints-selected-filter] > div > h1 > span:first-of-type {\n      color: #000000; }\n  div[data-app-endpoints-selected-filter] > div > div:last-of-type {\n    margin-top: 20px;\n    border-bottom: dashed #cccccc 1px; }\n\ndiv.app-login {\n  position: fixed;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-orient: vertical;\n  -webkit-box-direction: normal;\n      -ms-flex-direction: column;\n          flex-direction: column;\n  -webkit-box-pack: center;\n      -ms-flex-pack: center;\n          justify-content: center;\n  -webkit-box-align: center;\n      -ms-flex-align: center;\n          align-items: center; }\n  @media (max-height: 479px) {\n    div.app-login {\n      -ms-flex-pack: distribute;\n          justify-content: space-around; } }\n  div.app-login input, div.app-login select {\n    color: #ffffff !important;\n    background-color: rgba(255, 255, 255, 0.2) !important;\n    border-color: transparent !important; }\n    div.app-login input:hover, div.app-login input:focus, div.app-login input:active, div.app-login select:hover, div.app-login select:focus, div.app-login select:active {\n      border-color: #ffffff !important; }\n  div.app-login > div.background {\n    z-index: -1;\n    position: absolute;\n    left: 0;\n    right: 0;\n    bottom: 0;\n    top: 0;\n    background: url(" + __webpack_require__(86) + ") no-repeat center center fixed;\n    background-size: cover; }\n    @media (max-width: 1280px) {\n      div.app-login > div.background {\n        background-image: url(" + __webpack_require__(87) + "); } }\n    @media (max-width: 320px) and (max-height: 568px) {\n      div.app-login > div.background {\n        background-image: url(" + __webpack_require__(88) + "); } }\n    @media (max-height: 320px) and (max-width: 568px) {\n      div.app-login > div.background {\n        background-image: url(" + __webpack_require__(89) + "); } }\n  div.app-login div.oauth {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    margin-bottom: 16px; }\n    div.app-login div.oauth span {\n      color: #ffffff; }\n    div.app-login div.oauth > span {\n      margin-right: 20px;\n      font-weight: 600;\n      font-size: 16px; }\n  div.app-login > form {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    max-width: 450px; }\n    div.app-login > form > div.img {\n      background: url(" + __webpack_require__(90) + ") center no-repeat;\n      background-size: contain;\n      max-width: 600px;\n      width: 100%;\n      height: 100px;\n      margin: 0 0 20px 0; }\n    div.app-login > form > div.fields {\n      width: 100%;\n      display: -webkit-box;\n      display: -ms-flexbox;\n      display: flex;\n      -webkit-box-orient: vertical;\n      -webkit-box-direction: normal;\n          -ms-flex-direction: column;\n              flex-direction: column;\n      -webkit-box-align: center;\n          -ms-flex-align: center;\n              align-items: center; }\n      div.app-login > form > div.fields > div > button, div.app-login > form > div.fields > div > input {\n        width: 350px; }\n      @media (max-height: 479px) {\n        div.app-login > form > div.fields > div:last-of-type {\n          display: -webkit-box;\n          display: -ms-flexbox;\n          display: flex;\n          -webkit-box-pack: center;\n              -ms-flex-pack: center;\n                  justify-content: center;\n          -webkit-box-align: center;\n              -ms-flex-align: center;\n                  align-items: center;\n          width: 350px; }\n          div.app-login > form > div.fields > div:last-of-type > div {\n            -webkit-box-flex: 1;\n                -ms-flex-positive: 1;\n                    flex-grow: 1; }\n          div.app-login > form > div.fields > div:last-of-type > button {\n            width: 100px;\n            margin-left: 10px; }\n          div.app-login > form > div.fields > div:last-of-type > div {\n            margin: 0; } }\n    div.app-login > form > h1, div.app-login > form > h2, div.app-login > form > div > h3 {\n      text-align: center;\n      margin: 0;\n      color: #ffffff; }\n    div.app-login > form > h1 {\n      font-size: 18px;\n      font-weight: bold; }\n    div.app-login > form > h2 {\n      margin-bottom: 24px;\n      font-size: 16px; }\n    div.app-login > form > div[data-app-footer] {\n      margin-top: 20px; }\n      div.app-login > form > div[data-app-footer] > footer {\n        padding: 0; }\n\ndiv.components {\n  height: 100%;\n  width: 100%;\n  padding: 20px; }\n  div.components > div {\n    margin-top: 20px; }\n  div.components div.md-text {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex; }\n", ""]);
	
	// exports


/***/ },
/* 81 */,
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/loading_4c56b76c54d0910a34b7b085227d105b.gif";

/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/wavy_4e82f047f5a278c5436bac14622f11ee.gif";

/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/header_iii_631ff4026aea8142548d24baa48cf413.png";

/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/services-icon_5f288339c2eeeddbf26baa98ef7784df.png";

/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/login-background-1920X1200_c41b650ea26c672f8c68353b2e931941.jpg";

/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/login-background-1280x950_97a976bd02031f1a80cbd2a726505b7d.jpg";

/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/login-background-320x568_1d77e8b514255cc56be71c102605379d.jpg";

/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/login-background-568x320_540475e6e1159738fc022c4cca1d0998.jpg";

/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "assets/logo-header-login_7805972f9dbbd9b5bbd9f4367d003bb6.svg";

/***/ },
/* 91 */,
/* 92 */
/***/ function(module, exports) {

	module.exports = "<div data-app=\"data-app\"><div data-app-endpoints=\"data-app-endpoints\"></div></div>";

/***/ },
/* 93 */
/***/ function(module, exports) {

	module.exports = "<div class=\"components\"><div data-tribe-diff=\"data-tribe-diff\" data-value-a=\"'value a'\" data-value-b=\"'value b'\"></div><div data-tribe-singleselect=\"data-tribe-singleselect\" data-new-label=\"New Item\" data-editable=\"true\" data-selected-option=\"null\" data-placeholder=\"Nothing\" data-available-options=\"['aaaa', 'aaa', 'aa', 'bbb', 'ccc', 'ddd', 'eee', 'eeeee', 'fff', 'ggg', 'hhh']\"></div><div data-tribe-singleselect=\"data-tribe-singleselect\" data-new-label=\"New Item\" data-selected-option=\"'aaaa'\" data-available-options=\"['aaaa', 'aaa', 'aa', 'bbb', 'ccc', 'ddd', 'eee', 'eeeee', 'fff', 'ggg', 'hhh']\"></div><div><label>markdown</label><div data-tribe-markdown=\"data-tribe-markdown\" data-value=\"'lalala'\"></div></div><div><label>markdown and text</label><div class=\"md-text\"><div data-tribe-markdown=\"data-tribe-markdown\" data-value=\"'I am markdown'\"></div><div data-tribe-text=\"data-tribe-text\" data-value=\"'I am text'\"></div></div></div><div><div data-tribe-multiselect=\"data-tribe-multiselect\" data-selected-options=\"['bbb', 'ccc', 'aaa', 'eee', 'ddd']\" data-available-options=\"['ddd', 'aaa', 'bbb', 'ccc', 'eee', 'fff', 'eeeee', 'eeee', 'ee', 'e', 'ggg', 'hhh', 'a', 'aa', 'aab', 'aabb', 'aabbbbb', 'aabbbbbbb', 'aabbbbbbbbb']\"></div></div><div><div data-tribe-multiselect=\"data-tribe-multiselect\" data-new-label=\"New Item\" data-selected-options=\"['eee', 'bbb', 'aaa', 'ccc', 'ddd']\" data-available-options=\"['aaa', 'bbb', 'ccc', 'ddd', 'eee', 'eeeee', 'fff', 'ggg', 'hhh']\"></div></div><div><span>multi and single</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-new-label=\"New Item\" data-selected-options=\"['eee', 'bbb']\" data-available-options=\"['aaa', 'bbb', 'ccc', 'ddd', 'eee', 'eeeee', 'fff', 'ggg', 'hhh']\"></div><div data-tribe-singleselect=\"data-tribe-singleselect\" data-new-label=\"New Item\" data-editable=\"true\" data-selected-option=\"'aa'\" data-available-options=\"['aaaa', 'aaa', 'aa', 'bbb', 'ccc', 'ddd', 'eee', 'eeeee', 'fff', 'ggg', 'hhh']\"></div></div><div><span>multi and text</span><div data-tribe-multiselect=\"data-tribe-multiselect\" data-new-label=\"New Item\" data-selected-options=\"['eee', 'bbb']\" data-available-options=\"['aaa', 'bbb', 'ccc', 'ddd', 'eee', 'eeeee', 'fff', 'ggg', 'hhh']\"></div><div data-tribe-editable-text=\"data-tribe-editable-text\" data-value=\"''\"></div></div><div><div data-tribe-singleselect=\"data-tribe-singleselect\" data-new-label=\"New Item\" data-selected-option=\"'aa'\" data-available-options=\"['aaaa', 'aaa', 'aa', 'bbb', 'ccc', 'ddd', 'eee', 'eeeee', 'fff', 'ggg', 'hhh']\"></div></div><div><label>object non-editable</label><div data-tribe-singleselect=\"data-tribe-singleselect\" data-new-label=\"New Item\" data-selected-option=\"'a_a'\" data-available-options=\"[{text: 'aa', value: 'a_a'}, {text: 'aaa', value: 'a_a_a'}, {text: 'aaaa', value: 'a_a_a_a'}]\"></div></div><div><label>object editable</label><div data-tribe-singleselect=\"data-tribe-singleselect\" data-new-label=\"New Item\" data-editable=\"true\" data-selected-option=\"'a_a'\" data-available-options=\"[{text: 'aa', value: 'a_a'}, {text: 'aaa', value: 'a_a_a'}, {text: 'aaaa', value: 'a_a_a_a'}]\"></div></div><div><label>method</label><div data-tribe-singleselect=\"data-tribe-singleselect\" data-available-options=\"[{text:'DELETE', value:'delete'}, {text:'HEAD', value:'head'}, {text:'GET', value:'get'}, {text:'OPTIONS', value:'options'}, {text:'POST', value:'post'}, {text:'PUT', value:'put'}, {text:'PATCH', value:'patch'}]\" data-selected-option=\"'get'\" data-get-option-text=\"toUppercase\"></div></div><div><label>Auth methods</label><div data-tribe-multiselect=\"data-tribe-multiselect\" data-new-label=\"New Method\" data-selected-options=\"[]\" data-available-options=\"['basic', 'form', 'digest', 'HTTP Signatures', 'Bearer']\"></div></div><div><label>text component</label><div data-tribe-text=\"data-tribe-text\" data-value=\"'lalala'\"></div><div data-tribe-text=\"data-tribe-text\" data-type=\"number\" data-value=\"1\"></div></div></div>";

/***/ },
/* 94 */
/***/ function(module, exports) {

	module.exports = "<div data-app=\"data-app\"><div data-app-see=\"data-app-see\" data-aggregated-id=\"aggregatedId\"></div></div>";

/***/ },
/* 95 */
/***/ function(module, exports) {

	module.exports = "<div data-app=\"data-app\"><div data-app-application-details=\"data-app-application-details\" data-application=\"app\"></div></div>";

/***/ },
/* 96 */
/***/ function(module, exports) {

	module.exports = "<div data-app=\"data-app\"><div data-app-endpoints-details=\"data-app-endpoints-details\" data-request-metadata=\"requestMetadata\"></div></div>";

/***/ },
/* 97 */
/***/ function(module, exports) {

	module.exports = "<div class=\"app-login\" app-login=\"app-login\"><div class=\"background\"></div><form x-ng-submit=\"login()\"><div class=\"img\"></div><h1>Welcome to Registry.</h1><h2>Login to see it in action.</h2><div class=\"fields\"><div><input type=\"text\" placeholder=\"username\" x-ng-model=\"username\" name=\"username\" autofocus=\"autofocus\"/><input type=\"password\" placeholder=\"password\" x-ng-model=\"password\" name=\"password\"/></div><div><div class=\"oauth\"><select ng-model=\"loginType\"><option value=\"oauth\">Oauth Login</option><option value=\"basic\">Basic Login</option></select></div><button class=\"orange\" type=\"submit\">login</button></div></div><div data-app-footer=\"data-app-footer\"></div></form></div>";

/***/ },
/* 98 */
/***/ function(module, exports) {

	module.exports = "<p>page not found</p>";

/***/ }
]);