/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.elasticsearch;

import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.JsonObject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.tomitribe.tribestream.registryng.documentation.Description;

@ApplicationScoped
public class ElasticsearchClient {
    private static final Logger log = Logger.getLogger(ElasticsearchClient.class.getName());
    @Inject
    @Description(value="Elasticsearch base URL")
    @ConfigProperty(name="tribe.registry.elasticsearch.base", defaultValue="http://localhost:9200")
    private String base;
    @Inject
    @Description(value="Elasticsearch registry index")
    @ConfigProperty(name="tribe.registry.elasticsearch.index", defaultValue="tribestream-api-registry")
    private String index;
    @Inject
    @Description(value="Elasticsearch endpoint type")
    @ConfigProperty(name="tribe.registry.elasticsearch.type.endpoint", defaultValue="endpoint")
    private String endpointType;
    @Inject
    @Description(value="Elasticsearch JAX-RS client features, can be used to activate authentication or debugging using LoggingFeature for instance")
    @ConfigProperty(name="tribe.registry.elasticsearch.features")
    private String features;
    @Inject
    @Description(value="Elasticsearch client receive timeout")
    @ConfigProperty(name="tribe.registry.elasticsearch.timeout.receive", defaultValue="30000")
    private String receiveTimeout;
    @Inject
    @Description(value="Elasticsearch client connect timeout")
    @ConfigProperty(name="tribe.registry.elasticsearch.timeout.connect", defaultValue="30000")
    private String connectTimeout;
    private Client client;

    @PostConstruct
    private void init() {
        this.client = (Client)((Client)((Client)((Client)ClientBuilder.newClient().property("http.connection.timeout", (Object)this.connectTimeout)).property("http.receive.timeout", (Object)this.receiveTimeout)).property("jersey.config.client.connectTimeout", (Object)this.connectTimeout)).property("jersey.config.client.readTimeout", (Object)this.receiveTimeout);
        Optional.ofNullable(this.features).ifPresent(f -> Stream.of(f.split(",")).forEach(v -> {
            try {
                this.client.register(Thread.currentThread().getContextClassLoader().loadClass((String)v).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.warning("Can't activate debugging on Elasticsearch client: " + e.getMessage());
            }
        }));
    }

    public JsonObject create(JsonObject data) {
        return (JsonObject)this.client.target(this.base).path("{index}/{type}").resolveTemplate("index", (Object)this.index).resolveTemplate("type", (Object)this.endpointType).queryParam("refresh", new Object[]{"true"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE), JsonObject.class);
    }

    public JsonObject update(String id, JsonObject data) {
        return (JsonObject)this.client.target(this.base).path("{index}/{type}/{id}").resolveTemplate("index", (Object)this.index).resolveTemplate("type", (Object)this.endpointType).resolveTemplate("id", (Object)id).queryParam("refresh", new Object[]{"true"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)data, (MediaType)MediaType.APPLICATION_JSON_TYPE), JsonObject.class);
    }

    public void delete(String id) {
        try {
            this.client.target(this.base).path("{index}/{type}/{id}").resolveTemplate("index", (Object)this.index).resolveTemplate("type", (Object)this.endpointType).resolveTemplate("id", (Object)id).queryParam("refresh", new Object[]{"true"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(JsonObject.class);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public JsonObject find(String id) {
        return (JsonObject)this.client.target(this.base).path("{index}/{type}/{id}").resolveTemplate("index", (Object)this.index).resolveTemplate("type", (Object)this.endpointType).resolveTemplate("id", (Object)id).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JsonObject.class);
    }

    public JsonObject search(JsonObject query, long from, long size) {
        try {
            WebTarget target = this.client.target(this.base).path("{index}/_search").resolveTemplate("index", (Object)this.index);
            if (from >= 0L) {
                target = target.queryParam("from", new Object[]{from});
            }
            if (size > 0L) {
                target = target.queryParam("size", new Object[]{size});
            }
            Invocation.Builder builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            return query == null ? (JsonObject)builder.get(JsonObject.class) : (JsonObject)builder.post(Entity.entity((Object)query, (MediaType)MediaType.APPLICATION_JSON_TYPE), JsonObject.class);
        }
        catch (WebApplicationException wae) {
            log.log(Level.SEVERE, wae.getMessage() + ": " + Optional.ofNullable(wae.getResponse()).map(r -> (String)r.readEntity(String.class)).orElse("-"), wae);
            throw wae;
        }
    }

    @PreDestroy
    private void destroy() {
        this.client.close();
    }
}

