/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import io.swagger.models.Swagger;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.TransactionalException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.ApplicationWrapper;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.DuplicatedSwaggerException;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.resources.enricher.Linker;
import org.tomitribe.tribestream.registryng.resources.processor.ApplicationProcessor;

@Path(value="/application")
@ApplicationScoped
@Produces(value={"application/json"})
public class ApplicationResource {
    private final Repository repository;
    private final Linker linker;
    private final ApplicationProcessor processor;

    @Inject
    public ApplicationResource(Repository repository, Linker linker, ApplicationProcessor processor) {
        this.repository = repository;
        this.linker = linker;
        this.processor = processor;
    }

    @GET
    @Path(value="/")
    public Response getAllApplications(@Context UriInfo uriInfo) {
        return Response.status((Response.Status)Response.Status.OK).entity(this.repository.findAllApplicationsWithEndpoints().stream().map(p -> this.processor.toWrapper(p, null)).collect(Collectors.toList())).build();
    }

    @GET
    @Path(value="/{applicationId}")
    public Response getApplication(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId) {
        OpenApiDocument application = this.repository.findByApplicationIdWithEndpoints(applicationId);
        if (application == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)this.processor.toWrapper(application, this.linker.buildApplicationLinks(uriInfo, application))).build();
    }

    @POST
    @Path(value="/")
    public Response createService(@Context UriInfo uriInfo, ApplicationWrapper application) {
        Swagger swagger = application.getSwagger();
        this.validate(swagger);
        try {
            OpenApiDocument document = this.repository.insert(swagger);
            OpenApiDocument newDocument = this.repository.findByApplicationIdWithEndpoints(document.getId());
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.processor.toWrapper(newDocument, this.linker.buildApplicationLinks(uriInfo, newDocument))).build();
        }
        catch (TransactionalException e) {
            if (DuplicatedSwaggerException.class.isInstance(e.getCause())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"key\": \"duplicated.swagger.exception\"}").build();
            }
            throw e;
        }
    }

    private void validate(Swagger swagger) {
        if (swagger == null) {
            throw new WebApplicationException("Swagger document is null!", Response.Status.BAD_REQUEST);
        }
        if (!"2.0".equals(swagger.getSwagger())) {
            throw new WebApplicationException("Unsupported swagger version!", Response.Status.BAD_REQUEST);
        }
        if (swagger.getInfo() == null) {
            throw new WebApplicationException("Swagger document has no info property!", Response.Status.BAD_REQUEST);
        }
        if (swagger.getInfo().getTitle() == null) {
            throw new WebApplicationException("Swagger document has no title!", Response.Status.BAD_REQUEST);
        }
        if (swagger.getInfo().getTitle() == null) {
            throw new WebApplicationException("Swagger document has no version!", Response.Status.BAD_REQUEST);
        }
    }

    @PUT
    @Path(value="/{id}")
    public Response updateService(@Context UriInfo uriInfo, @PathParam(value="id") String applicationId, ApplicationWrapper application) {
        Swagger swagger = application.getSwagger();
        OpenApiDocument oldDocument = this.repository.findByApplicationIdWithEndpoints(applicationId);
        if (oldDocument == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.merge(oldDocument.getSwagger(), swagger);
        this.validate(oldDocument.getSwagger());
        oldDocument.setName(oldDocument.getSwagger().getInfo().getTitle());
        oldDocument.setVersion(oldDocument.getSwagger().getInfo().getVersion());
        oldDocument.updateHumanReadbleName();
        this.repository.update(oldDocument);
        OpenApiDocument updatedDocument = this.repository.findByApplicationIdWithEndpoints(applicationId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.processor.toWrapper(updatedDocument, this.linker.buildApplicationLinks(uriInfo, updatedDocument))).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteService(@Context UriInfo uriInfo, @PathParam(value="id") String applicationId) {
        if (!this.repository.deleteApplication(applicationId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private void merge(Swagger target, Swagger source) {
        if (source.getSwagger() != null) {
            target.setSwagger(source.getSwagger());
        }
        if (source.getInfo() != null) {
            target.setInfo(source.getInfo());
        }
        if (source.getHost() != null) {
            target.setHost(source.getHost());
        }
        if (source.getBasePath() != null) {
            target.setBasePath(source.getBasePath());
        }
        if (source.getSchemes() != null) {
            target.setSchemes(source.getSchemes());
        }
        if (source.getConsumes() != null) {
            target.setConsumes(source.getConsumes());
        }
        if (source.getProduces() != null) {
            target.setProduces(source.getProduces());
        }
        if (source.getDefinitions() != null) {
            target.setDefinitions(source.getDefinitions());
        }
        if (source.getParameters() != null) {
            target.setParameters(source.getParameters());
        }
        if (source.getResponses() != null) {
            target.setResponses(source.getResponses());
        }
        if (source.getSecurity() != null) {
            target.setSecurity(source.getSecurity());
        }
        if (source.getTags() != null) {
            target.setTags(source.getTags());
        }
        if (source.getVendorExtensions() != null) {
            if (target.getVendorExtensions() == null) {
                target.vendorExtension("skip", (Object)"force-init");
            }
            target.getVendorExtensions().clear();
            target.getVendorExtensions().putAll(source.getVendorExtensions());
        }
    }

    public ApplicationResource() {
        this.repository = null;
        this.linker = null;
        this.processor = null;
    }
}

