/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.tomitribe.tribestream.registryng.resources.Oauth2TokenResource;
import org.tomitribe.tribestream.registryng.security.oauth2.AccessTokenResponse;
import org.tomitribe.tribestream.registryng.security.oauth2.AccessTokenService;
import org.tomitribe.tribestream.registryng.security.oauth2.Oauth2Configuration;
import org.tomitribe.tribestream.registryng.service.serialization.CustomJacksonJaxbJsonProvider;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
@Path(value="security/oauth2")
@Consumes(value={"application/x-www-form-urlencoded"})
@Produces(value={"application/json"})
public class Oauth2TokenResource {
    private static final Logger LOG = Logger.getLogger(Oauth2TokenResource.class.getName());
    @Inject
    private Oauth2Configuration oauth2Config;
    @Inject
    private AccessTokenService accessTokenService;
    private JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(new HashMap());
    private volatile SSLContext sslContext;

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public Response getOauth2Status() {
        return Response.ok((Object)Oauth2Status.builder().enabled(this.oauth2Config.getAuthServerUrl() != null && this.oauth2Config.getAuthServerUrl().length() > 0).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public Response getToken(MultivaluedMap<String, String> formParameters) {
        if (this.oauth2Config.getAuthServerUrl() == null || this.oauth2Config.getAuthServerUrl().trim().length() == 0) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"No Oauth2 gateway configured").build();
        }
        try (Client client = null;){
            client = ClientBuilder.newBuilder().sslContext(this.getSslContext()).build();
            if (this.oauth2Config.getClientId() != null && this.oauth2Config.getClientId().length() > 0) {
                client.register((Object)new BasicAuthFilter(this, null));
            }
            client.register((Object)new CustomJacksonJaxbJsonProvider());
            WebTarget target = client.target(this.oauth2Config.getAuthServerUrl());
            Form form = new Form(formParameters);
            Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                AccessTokenResponse responsePayload = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
                this.accessTokenService.addAccessToken(responsePayload);
                Response response2 = Response.status((int)response.getStatus()).entity((Object)responsePayload).build();
                return response2;
            }
            String responsePayload = (String)response.readEntity(String.class);
            Response response3 = Response.status((int)response.getStatus()).entity((Object)responsePayload).build();
            return response3;
        }
    }

    private SSLContext getSslContext() throws GeneralSecurityException {
        if (this.sslContext == null) {
            SSLContext newSslContext = this.oauth2Config.getTlsProvider() != null ? SSLContext.getInstance(this.oauth2Config.getTlsProtocol(), this.oauth2Config.getTlsProvider()) : SSLContext.getInstance(this.oauth2Config.getTlsProtocol());
            KeyStore trustStore = this.oauth2Config.getTrustStoreFileName() != null && this.oauth2Config.getTrustStoreFileName().length() > 0 ? (this.oauth2Config.getTrustStoreType() == null ? (this.oauth2Config.getTlsProvider() == null ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance(KeyStore.getDefaultType(), this.oauth2Config.getTlsProvider())) : (this.oauth2Config.getTlsProvider() == null ? KeyStore.getInstance(this.oauth2Config.getTrustStoreType()) : KeyStore.getInstance(this.oauth2Config.getTrustStoreType(), this.oauth2Config.getTlsProvider()))) : null;
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init(trustStore);
            TrustManager[] tms = tmfactory.getTrustManagers();
            if (tms != null) {
                for (int i = 0; i < tms.length; ++i) {
                    TrustManager mgr = tms[i];
                    if (!X509TrustManager.class.isInstance(mgr)) continue;
                    X509TrustManager x509TrustManager = (X509TrustManager)X509TrustManager.class.cast(mgr);
                    tms[i] = new /* Unavailable Anonymous Inner Class!! */;
                }
            }
            newSslContext.init(null, tms, new SecureRandom());
            this.sslContext = newSslContext;
        }
        return this.sslContext;
    }

    static /* synthetic */ Oauth2Configuration access$100(Oauth2TokenResource x0) {
        return x0.oauth2Config;
    }
}

