/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources.processor;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.tomitribe.tribestream.registryng.domain.ApplicationWrapper;
import org.tomitribe.tribestream.registryng.domain.EntityLink;
import org.tomitribe.tribestream.registryng.domain.TribestreamOpenAPIExtension;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.Repository;

@ApplicationScoped
public class ApplicationProcessor {
    @Inject
    private TribestreamOpenAPIExtension extensions;

    public ApplicationWrapper toWrapper(OpenApiDocument application, EntityLink[] links) {
        Swagger reducedSwagger = this.shrinkSwagger(this.mergeSwagger(application.getSwagger(), application.getEndpoints()));
        if (links != null) {
            this.extensions.setLinks(reducedSwagger, links);
        }
        return new ApplicationWrapper(reducedSwagger, application.getHumanReadableName());
    }

    private Swagger shrinkSwagger(Swagger swagger) {
        Swagger applicationClone = Repository.createShallowCopy((Swagger)swagger);
        Map paths = applicationClone.getPaths();
        if (paths != null) {
            HashMap shrunkPaths = new HashMap();
            for (Map.Entry pathEntry : paths.entrySet()) {
                Path shrunkPath = new Path();
                shrunkPaths.put(pathEntry.getKey(), shrunkPath);
                for (Map.Entry httpMethodOperationEntry : ((Path)pathEntry.getValue()).getOperationMap().entrySet()) {
                    Operation shrunkOperation = new Operation();
                    shrunkOperation.setDescription(((Operation)httpMethodOperationEntry.getValue()).getDescription());
                    shrunkOperation.setSummary(((Operation)httpMethodOperationEntry.getValue()).getSummary());
                    shrunkPath.set(((HttpMethod)httpMethodOperationEntry.getKey()).name().toLowerCase(Locale.ENGLISH), shrunkOperation);
                    Optional.ofNullable(httpMethodOperationEntry.getValue()).ifPresent(o -> o.getVendorExtensions().forEach((arg_0, arg_1) -> ((Operation)shrunkOperation).setVendorExtension(arg_0, arg_1)));
                }
            }
            applicationClone.setPaths(shrunkPaths);
        }
        return applicationClone;
    }

    private Swagger mergeSwagger(Swagger swagger, Collection<Endpoint> endpoints) {
        Swagger result = Repository.createShallowCopy((Swagger)swagger);
        HashMap<String, Path> newPaths = new HashMap<String, Path>();
        if (endpoints != null) {
            for (Endpoint endpoint : endpoints) {
                Path newPath = (Path)newPaths.get(endpoint.getPath());
                if (newPath == null) {
                    newPath = new Path();
                    newPaths.put(endpoint.getPath(), newPath);
                }
                this.addHumanReadablePathIfMissing(endpoint);
                newPath.set(endpoint.getVerb().toLowerCase(Locale.ENGLISH), endpoint.getOperation());
            }
        }
        result.setPaths(newPaths);
        return result;
    }

    private void addHumanReadablePathIfMissing(Endpoint endpoint) {
        Operation operation = endpoint.getOperation();
        if (operation.getVendorExtensions().get("x-tribestream-api-registry") == null) {
            operation.setVendorExtension("x-tribestream-api-registry", new HashMap());
        }
        ((Map)Map.class.cast(operation.getVendorExtensions().get("x-tribestream-api-registry"))).put("human-readable-path", endpoint.getHumanReadablePath());
    }
}

