/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.security.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.tomitribe.tribestream.registryng.entities.AccessToken;
import org.tomitribe.tribestream.registryng.security.oauth2.AccessTokenResponse;
import org.tomitribe.tribestream.registryng.security.oauth2.InvalidTokenException;
import org.tomitribe.tribestream.registryng.security.oauth2.Oauth2Configuration;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class AccessTokenService {
    private static final Logger LOG = Logger.getLogger(AccessTokenService.class.getName());
    @PersistenceContext
    private EntityManager em;
    @Inject
    private Oauth2Configuration configuration;
    private final ObjectMapper mapper = new ObjectMapper();

    public void addAccessToken(AccessTokenResponse tokenResponse) {
        LOG.fine("Add new access token " + tokenResponse);
        AccessToken accessTokenEntity = new AccessToken();
        accessTokenEntity.setAccessToken(tokenResponse.getAccessToken());
        accessTokenEntity.setExpiryTimestamp(System.currentTimeMillis() + (long)(tokenResponse.getExpiresIn() * 1000));
        accessTokenEntity.setScope(tokenResponse.getScope());
        accessTokenEntity.setUsername(this.tryExtractingTheUser(tokenResponse.getAccessToken()));
        this.em.persist((Object)accessTokenEntity);
    }

    public AccessToken findToken(String accessToken) throws InvalidTokenException {
        AccessToken accessTokenEntity;
        List tokens = this.em.createNamedQuery("AccessToken.findByToken", AccessToken.class).setParameter("token", (Object)accessToken).getResultList();
        AccessToken accessToken2 = accessTokenEntity = tokens.isEmpty() ? null : (AccessToken)tokens.iterator().next();
        if (accessTokenEntity == null) {
            throw new InvalidTokenException("Could not find access token: " + accessToken);
        }
        if (accessTokenEntity.getExpiryTimestamp() < System.currentTimeMillis()) {
            throw new InvalidTokenException("Found expired access token! " + accessTokenEntity.getAccessToken());
        }
        return accessTokenEntity;
    }

    public void deleteToken(String accessToken) {
        this.em.remove(this.em.createNamedQuery("AccessToken.findByToken", AccessToken.class).setParameter("token", (Object)accessToken).getSingleResult());
    }

    @Schedule(minute="*", hour="*")
    public void timedDeleteExpiredTokens() {
        LOG.fine("Delete expired tokens");
        int deletedTokens = this.deleteExpiredTokens();
        if (deletedTokens > 0) {
            LOG.info("Purged " + deletedTokens + " expired tokens");
        }
    }

    public int deleteExpiredTokens() {
        return this.em.createNamedQuery("AccessToken.deleteExpiredTokens").setParameter("now", (Object)System.currentTimeMillis()).executeUpdate();
    }

    private String tryExtractingTheUser(String accessToken) {
        try {
            String[] segments = accessToken.split("\\.");
            if (segments.length != 3) {
                return null;
            }
            JsonNode node = this.mapper.readTree(Base64.getUrlDecoder().decode(segments[1]));
            for (String part : this.configuration.getJwtUsernameAttribute().split("\\/")) {
                if ((node = node.get(part)) != null) continue;
                return null;
            }
            return Optional.ofNullable(node).filter(n -> n.getNodeType() == JsonNodeType.STRING).map(JsonNode::textValue).orElse(null);
        }
        catch (IOException | RuntimeException re) {
            return null;
        }
    }
}

