/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import java.beans.ConstructorProperties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.EndpointWrapper;
import org.tomitribe.tribestream.registryng.domain.EntityLink;
import org.tomitribe.tribestream.registryng.domain.TribestreamOpenAPIExtension;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.resources.enricher.Linker;

@Path(value="/application/{applicationId}/endpoint")
@ApplicationScoped
@Produces(value={"application/json"})
public class EndpointResource {
    private final Repository repository;
    private final Linker linker;
    private final TribestreamOpenAPIExtension extensions;

    @GET
    @Path(value="/{endpointId}")
    public Response getEndpoint(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="endpointId") String endpointId) {
        Endpoint endpoint = this.repository.findEndpointById(endpointId);
        if (endpoint == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!applicationId.equals(endpoint.getApplication().getId())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        EndpointWrapper endpointWrapper = this.toEndpointWrapper(endpoint, this.linker.buildEndpointLinks(uriInfo, applicationId, endpoint.getId()));
        return Response.ok().entity((Object)endpointWrapper).build();
    }

    @DELETE
    @Path(value="/{endpointId}")
    public Response removeEndpoint(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="endpointId") String endpointId) {
        Endpoint endpoint = this.repository.findEndpointById(endpointId);
        if (endpoint == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.repository.deleteEndpoint(applicationId, endpointId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="/")
    public Response createService(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, EndpointWrapper endpointWrapper) {
        Endpoint endpoint = new Endpoint();
        endpoint.setVerb(endpointWrapper.getHttpMethod().toUpperCase());
        endpoint.setPath(endpointWrapper.getPath());
        endpoint.setOperation(endpointWrapper.getOperation());
        this.validate(endpoint);
        Endpoint document = this.repository.insert(endpoint, applicationId);
        Endpoint newDocument = this.repository.findEndpointById(document.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)this.toEndpointWrapper(newDocument, this.linker.buildEndpointLinks(uriInfo, applicationId, newDocument.getId()))).build();
    }

    @PUT
    @Path(value="/{endpointId}")
    public Response updateService(@Context UriInfo uriInfo, @PathParam(value="applicationId") String applicationId, @PathParam(value="endpointId") String endpointId, EndpointWrapper endpointWrapper) {
        Endpoint oldEndpoint = this.repository.findEndpointById(endpointId);
        if (oldEndpoint == null || !applicationId.equals(oldEndpoint.getApplication().getId())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.merge(oldEndpoint, endpointWrapper);
        this.validate(oldEndpoint);
        this.repository.update(oldEndpoint);
        Endpoint updatedDocument = this.repository.findEndpointById(endpointId);
        EndpointWrapper newEndpointWrapper = this.toEndpointWrapper(updatedDocument, this.linker.buildEndpointLinks(uriInfo, applicationId, endpointId));
        return Response.ok().entity((Object)newEndpointWrapper).build();
    }

    private EndpointWrapper toEndpointWrapper(Endpoint e, EntityLink[] entityLinks) {
        Operation operation = e.getOperation();
        if (entityLinks != null) {
            this.extensions.setLinks(operation, entityLinks);
        }
        return new EndpointWrapper(e.getApplication().getId(), e.getId(), e.getHumanReadablePath(), e.getVerb(), e.getPath(), operation, null);
    }

    private void validate(Endpoint endpoint) {
        try {
            HttpMethod.valueOf((String)endpoint.getVerb().toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new WebApplicationException(String.format("Verb %s is not supported!", endpoint.getVerb()), Response.Status.BAD_REQUEST);
        }
        if (endpoint.getPath().contains(" ")) {
            throw new WebApplicationException(String.format("Path %s is invalid!", endpoint.getPath()), Response.Status.BAD_REQUEST);
        }
    }

    private void merge(Endpoint target, EndpointWrapper source) {
        if (source.getPath() != null) {
            target.setPath(source.getPath());
        }
        if (source.getHttpMethod() != null) {
            target.setVerb(source.getHttpMethod());
        }
        this.merge(target.getOperation(), source.getOperation());
    }

    private void merge(Operation target, Operation source) {
        if (source.getSummary() != null) {
            target.setSummary(source.getSummary());
        }
        if (source.getDescription() != null) {
            target.setDescription(source.getDescription());
        }
        if (source.getOperationId() != null) {
            target.setOperationId(source.getOperationId());
        }
        if (source.getResponses() != null) {
            target.setResponses(source.getResponses());
        }
        if (source.getSchemes() != null) {
            target.setSchemes(source.getSchemes());
        }
        if (source.getConsumes() != null) {
            target.setConsumes(source.getConsumes());
        }
        if (source.getProduces() != null) {
            target.setProduces(source.getProduces());
        }
        if (source.getSecurity() != null) {
            target.setSecurity(source.getSecurity());
        }
        if (source.getParameters() != null) {
            target.setParameters(source.getParameters());
        }
        if (source.getResponses() != null) {
            target.setResponses(source.getResponses());
        }
        if (source.getSecurity() != null) {
            target.setSecurity(source.getSecurity());
        }
        if (source.getTags() != null) {
            target.setTags(source.getTags());
        }
        if (source.isDeprecated() != null) {
            target.setDeprecated(source.isDeprecated());
        }
        if (source.getExternalDocs() != null) {
            target.setExternalDocs(target.getExternalDocs());
        }
        if (source.getVendorExtensions() != null) {
            target.getVendorExtensions().clear();
            target.getVendorExtensions().putAll(source.getVendorExtensions());
        }
    }

    public EndpointResource() {
        this.repository = null;
        this.linker = null;
        this.extensions = null;
    }

    @ConstructorProperties(value={"repository", "linker", "extensions"})
    @Inject
    public EndpointResource(Repository repository, Linker linker, TribestreamOpenAPIExtension extensions) {
        this.repository = repository;
        this.linker = linker;
        this.extensions = extensions;
    }
}

