/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import io.swagger.models.Operation;
import java.beans.ConstructorProperties;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.EndpointWrapper;
import org.tomitribe.tribestream.registryng.domain.TribestreamOpenAPIExtension;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.resources.enricher.Linker;
import org.tomitribe.tribestream.registryng.resources.processor.ApplicationProcessor;

@Path(value="ui")
@Produces(value={"application/json"})
@Transactional
@ApplicationScoped
public class HumanReadableResource {
    private final Repository repository;
    private final Linker linker;
    private final ApplicationProcessor processor;
    private final TribestreamOpenAPIExtension extensions;

    @GET
    @Path(value="endpoint/{applicationName}/{method}/{path: .+}")
    public Response getEndpointHumanReadablePath(@QueryParam(value="version") String version, @PathParam(value="applicationName") String appName, @PathParam(value="method") String method, @PathParam(value="path") String path, @Context UriInfo info) {
        return Optional.ofNullable(this.repository.findEndpointFromHumanReadableMeta(appName, method, path, version)).map(e -> new EndpointWrapper(e.getApplication().getId(), e.getId(), e.getHumanReadablePath(), e.getVerb(), e.getPath(), e.getOperation(), null)).map(w -> {
            Operation operation = w.getOperation();
            this.extensions.setLinks(operation, this.linker.buildEndpointLinks(info, w.getApplicationId(), w.getEndpointId()));
            return w;
        }).map(w -> Response.ok((Object)w).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @GET
    @Path(value="application/{applicationName}")
    public Response getApplicationHumanReadablePath(@QueryParam(value="version") String version, @PathParam(value="applicationName") String appName, @Context UriInfo info) {
        return Optional.ofNullable(this.repository.findApplicationFromHumanReadableMetadata(appName, version)).map(d -> Response.ok((Object)this.processor.toWrapper(d, this.linker.buildApplicationLinks(info, d))).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    public HumanReadableResource() {
        this.repository = null;
        this.linker = null;
        this.processor = null;
        this.extensions = null;
    }

    @ConstructorProperties(value={"repository", "linker", "processor", "extensions"})
    @Inject
    public HumanReadableResource(Repository repository, Linker linker, ApplicationProcessor processor, TribestreamOpenAPIExtension extensions) {
        this.repository = repository;
        this.linker = linker;
        this.processor = processor;
        this.extensions = extensions;
    }
}

