/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.tomitribe.tribestream.registryng.security.PrincipalDto;

@Path(value="login")
@ApplicationScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LoginResource {
    private static final Logger LOGGER = Logger.getLogger(LoginResource.class.getName());
    @Context
    private SecurityContext securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    public Response authenticate(@FormParam(value="username") String username, @FormParam(value="password") String password, @Context HttpServletRequest request) {
        if (username == null || username.trim().isEmpty()) {
            throw new NullPointerException("`username` is required.");
        }
        if (password == null || password.trim().isEmpty()) {
            throw new NullPointerException("`password` is required.");
        }
        try {
            request.login(username, password);
            LOGGER.log(Level.INFO, () -> String.format("Successful login of user '%s'", username));
            Response response = Response.ok((Object)this.principalToDto(request.getUserPrincipal())).build();
            return response;
        }
        catch (ServletException e) {
            LOGGER.log(Level.SEVERE, e, () -> String.format("Login failed for user %s", username));
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            return response;
        }
        finally {
            try {
                request.logout();
            }
            catch (ServletException e) {
                LOGGER.log(Level.WARNING, e, () -> String.format("Unexpected exception during login of user %s", username));
            }
        }
    }

    @GET
    @RolesAllowed(value={"tribe-console"})
    public PrincipalDto getAuthenticatedPrincipal(@Context HttpServletRequest request) {
        return this.principalToDto(request.getUserPrincipal());
    }

    private PrincipalDto principalToDto(Principal userPrincipal) {
        return new PrincipalDto(userPrincipal.getName());
    }
}

