/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.service.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import org.tomitribe.tribestream.registryng.domain.CloudItem;
import org.tomitribe.tribestream.registryng.domain.SearchPage;
import org.tomitribe.tribestream.registryng.domain.search.ApplicationSearchResult;
import org.tomitribe.tribestream.registryng.domain.search.EndpointSearchResult;
import org.tomitribe.tribestream.registryng.domain.search.SearchResult;
import org.tomitribe.tribestream.registryng.elasticsearch.ElasticsearchClient;
import org.tomitribe.tribestream.registryng.entities.Endpoint;
import org.tomitribe.tribestream.registryng.entities.OpenApiDocument;
import org.tomitribe.tribestream.registryng.repository.Repository;
import org.tomitribe.tribestream.registryng.service.search.SearchRequest;

@ApplicationScoped
public class SearchEngine {
    private static final Logger LOGGER = Logger.getLogger(SearchEngine.class.getName());
    private static final String APPLICATION_ID_FIELD = "applicationId";
    private static final String APPLICATION_HUMAN_READABLE_NAME = "applicationHumanReadableName";
    private static final String APPLICATION_NAME = "applicationName";
    private static final String APPLICATION_VERSION = "applicationVersion";
    private static final String ENDPOINT_ID_FIELD = "endpointId";
    private static final String ENDPOINT_HUMAN_READABLE_NAME = "endpointHumanReadableName";
    private static final String VERB = "verb";
    private static final String HTTP_METHOD = "httpMethod";
    private static final String PATH = "path";
    private static final String DOC = "doc";
    private static final String SUMMARY = "summary";
    private final JsonBuilderFactory jsonFactory = Json.createBuilderFactory(Collections.emptyMap());
    @Inject
    private ElasticsearchClient elasticsearch;
    @Inject
    private Repository repository;

    public SearchPage search(SearchRequest request) {
        ArrayList allEndpointsSearchResults;
        boolean showAll;
        int pageSize = request.getCount();
        JsonObjectBuilder aggs = this.jsonFactory.createObjectBuilder().add("tags", this.term("tag")).add("categories", this.term("category")).add("roles", this.term("role")).add("applications", this.term(APPLICATION_NAME));
        JsonObjectBuilder query = this.jsonFactory.createObjectBuilder().add("aggs", aggs);
        if (request.getQuery() != null && !"*".equals(request.getQuery()) && !request.getQuery().isEmpty() || request.getCategories() != null && !request.getCategories().isEmpty() || request.getTags() != null && !request.getTags().isEmpty() || request.getRoles() != null && !request.getRoles().isEmpty() || request.getApps() != null && !request.getApps().isEmpty()) {
            JsonArrayBuilder must = this.jsonFactory.createArrayBuilder();
            Optional.ofNullable(request.getQuery()).filter(q -> !q.isEmpty() && !"*".equals(q)).ifPresent(q -> must.add(this.jsonFactory.createObjectBuilder().add("query_string", this.jsonFactory.createObjectBuilder().add("query", q))));
            this.addDrillDown(request.getCategories(), must, new String[]{"category"});
            this.addDrillDown(request.getTags(), must, new String[]{"tag"});
            this.addDrillDown(request.getRoles(), must, new String[]{"role"});
            this.addDrillDown(request.getApps(), must, new String[]{"context", APPLICATION_NAME});
            query.add("query", this.jsonFactory.createObjectBuilder().add("bool", this.jsonFactory.createObjectBuilder().add("must", must)));
            showAll = false;
        } else {
            showAll = true;
        }
        JsonObject object = this.elasticsearch.search(query.build(), (long)(request.getPage() * pageSize), (long)pageSize);
        JsonObject hits = object.getJsonObject("hits");
        JsonObject aggregations = object.getJsonObject("aggregations");
        int total = hits.getInt("total");
        List<Object> list = allEndpointsSearchResults = total == 0 ? new ArrayList() : hits.getJsonArray("hits").stream().map(json -> ((JsonObject)JsonObject.class.cast(json)).getJsonObject("_source")).map(source -> new EndpointSearchResult(this.getString(source, APPLICATION_ID_FIELD), this.getString(source, ENDPOINT_ID_FIELD), this.getString(source, APPLICATION_HUMAN_READABLE_NAME), this.getString(source, ENDPOINT_HUMAN_READABLE_NAME), this.getString(source, APPLICATION_NAME), this.getString(source, APPLICATION_VERSION), this.getString(source, VERB), this.getString(source, PATH), this.getString(source, SUMMARY), this.getStrings(source, "category"), this.getStrings(source, "tag"), this.getStrings(source, "role"), this.getDouble(source, "_score"), null)).collect(Collectors.toList());
        Stream<ApplicationSearchResult> applicationSearchResults = showAll ? this.repository.findAllApplicationsMetadata().stream().map(openApiDocument -> new ApplicationSearchResult(openApiDocument.getId(), openApiDocument.getHumanReadableName(), openApiDocument.getName(), openApiDocument.getVersion(), null)) : (total > 0 ? allEndpointsSearchResults.stream().map(searchResult -> new ApplicationSearchResult(searchResult.getApplicationId(), searchResult.getApplicationName(), searchResult.getApplication(), searchResult.getApplicationVersion(), null)).distinct() : Stream.empty());
        List searchResults = applicationSearchResults.map(applicationSearchResult -> new SearchResult(applicationSearchResult, allEndpointsSearchResults.stream().filter(endpointSearchResult -> endpointSearchResult.getApplicationId().equals(applicationSearchResult.getApplicationId())).collect(Collectors.toList()))).collect(Collectors.toList());
        return new SearchPage(searchResults, total, request.getPage(), (Collection)this.aggregationToSet(aggregations, "applications", (Collection)request.getApps()), (Collection)this.aggregationToSet(aggregations, "categories", (Collection)request.getCategories()), (Collection)this.aggregationToSet(aggregations, "tags", (Collection)request.getTags()), (Collection)this.aggregationToSet(aggregations, "roles", (Collection)request.getRoles()));
    }

    public void indexEndpoint(Endpoint endpoint) {
        LOGGER.info(() -> String.format("Indexing %s %s", endpoint.getVerb(), endpoint.getPath()));
        String webCtx = endpoint.getApplication().getSwagger().getBasePath();
        JsonObject document = this.createDocument(endpoint, webCtx);
        String elasticsearchId = endpoint.getElasticsearchId();
        if (elasticsearchId != null) {
            this.elasticsearch.update(elasticsearchId, document);
        } else {
            endpoint.setElasticsearchId(this.elasticsearch.create(document).getString("_id"));
        }
    }

    public void deleteEndpoint(Endpoint endpoint) {
        LOGGER.info(() -> String.format("Deleting Index %s %s", endpoint.getVerb(), endpoint.getPath()));
        Optional.ofNullable(endpoint.getElasticsearchId()).ifPresent(arg_0 -> ((ElasticsearchClient)this.elasticsearch).delete(arg_0));
    }

    private JsonObject createDocument(Endpoint endpoint, String webCtx) {
        String doc;
        String defaultDoc;
        OpenApiDocument application = endpoint.getApplication();
        JsonObjectBuilder eDoc = this.jsonFactory.createObjectBuilder();
        eDoc.add(APPLICATION_ID_FIELD, application.getId());
        eDoc.add(ENDPOINT_ID_FIELD, endpoint.getId());
        eDoc.add(APPLICATION_NAME, endpoint.getApplication().getSwagger().getInfo().getTitle());
        eDoc.add(APPLICATION_HUMAN_READABLE_NAME, endpoint.getApplication().getHumanReadableName());
        eDoc.add(APPLICATION_VERSION, endpoint.getApplication().getSwagger().getInfo().getVersion());
        if (webCtx != null && !webCtx.isEmpty()) {
            eDoc.add("context", webCtx);
        }
        if (application.getSwagger().getHost() != null) {
            eDoc.add("host", application.getSwagger().getHost());
        }
        if ((defaultDoc = application.getSwagger().getInfo().getDescription()) != null && !defaultDoc.isEmpty()) {
            eDoc.add("applicationDoc", defaultDoc);
        }
        eDoc.add(ENDPOINT_HUMAN_READABLE_NAME, endpoint.getHumanReadablePath());
        eDoc.add(PATH, endpoint.getPath());
        eDoc.add(HTTP_METHOD, endpoint.getVerb());
        eDoc.add(VERB, endpoint.getVerb());
        List categories = this.getExtensionProperty(endpoint, "categories", Collections::emptyList);
        JsonArrayBuilder arrayBuilder = this.jsonFactory.createArrayBuilder();
        categories.forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        eDoc.add("category", arrayBuilder);
        if (endpoint.getOperation().getTags() != null) {
            arrayBuilder = this.jsonFactory.createArrayBuilder();
            endpoint.getOperation().getTags().forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
            eDoc.add("tag", arrayBuilder);
        }
        List roles = this.getExtensionProperty(endpoint, "roles", Collections::emptyList);
        JsonArrayBuilder arrayBuilder2 = this.jsonFactory.createArrayBuilder();
        roles.forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder2).add(arg_0));
        eDoc.add("role", arrayBuilder2);
        String summary = endpoint.getOperation().getSummary();
        if (summary != null && !summary.isEmpty()) {
            eDoc.add(SUMMARY, summary);
        }
        if ((doc = endpoint.getOperation().getDescription()) != null && !doc.isEmpty()) {
            eDoc.add(DOC, doc);
        }
        return eDoc.build();
    }

    private <T> List<T> getExtensionProperty(Endpoint endpoint, String extensionPropertyName, Supplier<List<T>> defaultSupplier) {
        return Optional.ofNullable(endpoint.getOperation().getVendorExtensions()).map(vendorExtensions -> (Map)vendorExtensions.get("x-tribestream-api-registry")).map(tapirExtension -> tapirExtension.get(extensionPropertyName)).orElseGet(defaultSupplier);
    }

    private Set<String> getStrings(JsonObject object, String key) {
        return object.containsKey((Object)key) ? object.getJsonArray(key).getValuesAs(JsonString.class).stream().map(JsonString::getString).collect(Collectors.toSet()) : new HashSet<String>();
    }

    private double getDouble(JsonObject object, String key) {
        return object.containsKey((Object)key) ? object.getJsonNumber(key).doubleValue() : 0.0;
    }

    private String getString(JsonObject object, String key) {
        return object.containsKey((Object)key) ? object.getString(key) : null;
    }

    private void addDrillDown(List<String> values, JsonArrayBuilder builder, String ... names) {
        Optional.ofNullable(values).filter(c -> !c.isEmpty()).ifPresent(c -> c.forEach(it -> builder.add(this.jsonFactory.createObjectBuilder().add("term", names.length == 1 ? this.jsonFactory.createObjectBuilder().add(names[0], it) : this.jsonFactory.createObjectBuilder().add("bool", this.jsonFactory.createObjectBuilder().add("should", Stream.of(names).map(n -> this.jsonFactory.createObjectBuilder().add("match", this.jsonFactory.createObjectBuilder().add(n, it))).collect(() -> ((JsonBuilderFactory)this.jsonFactory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::add)))))));
    }

    private JsonObjectBuilder term(String term) {
        return this.jsonFactory.createObjectBuilder().add("terms", this.jsonFactory.createObjectBuilder().add("field", term));
    }

    private Set<CloudItem> aggregationToSet(JsonObject aggregations, String key, Collection<String> filtered) {
        return aggregations.getJsonObject(key).getJsonArray("buckets").stream().map(json -> {
            JsonObject o = (JsonObject)JsonObject.class.cast(json);
            return new CloudItem(o.getString("key"), o.getInt("doc_count"));
        }).filter(o -> filtered == null || !filtered.contains(o.getText())).collect(Collectors.toSet());
    }
}

