/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.entities;

import java.util.Date;
import org.hibernate.envers.RevisionType;
import org.tomitribe.tribestream.registryng.entities.Revision;

public class HistoryEntry<T> {
    private final T historicObject;
    private final Revision revision;
    private final RevisionType revisionType;

    public HistoryEntry(Object[] auditQueryResult) {
        this.historicObject = auditQueryResult[0];
        this.revision = (Revision)auditQueryResult[1];
        this.revisionType = (RevisionType)auditQueryResult[2];
    }

    public HistoryEntry(T historicObject, Revision revision, RevisionType revisionType) {
        this.historicObject = historicObject;
        this.revision = revision;
        this.revisionType = revisionType;
    }

    public T getHistoricObject() {
        return (T)this.historicObject;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public RevisionType getRevisionType() {
        return this.revisionType;
    }

    public String toString() {
        return String.format("HistoryEntry[object=%s, revType=%s, revId=%d, timestamp=%s, user=%s]", this.historicObject, this.revisionType, this.revision.getId(), new Date(this.revision.getTimestamp()), this.revision.getUsername());
    }
}

