/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.tribestream.registryng.resources;

import java.beans.ConstructorProperties;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.tomitribe.tribestream.registryng.domain.SearchPage;
import org.tomitribe.tribestream.registryng.service.search.SearchEngine;
import org.tomitribe.tribestream.registryng.service.search.SearchRequest;

@Path(value="registry")
@ApplicationScoped
@Produces(value={"application/json"})
public class RegistryResource {
    private final SearchEngine searchEngine;

    @GET
    public SearchPage getSearchPage(@Context UriInfo uriInfo, @Context HttpHeaders headers, @QueryParam(value="query") @DefaultValue(value="*") String query, @QueryParam(value="tag") List<String> tags, @QueryParam(value="category") List<String> categories, @QueryParam(value="role") List<String> roles, @QueryParam(value="app") List<String> apps, @QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="count") @DefaultValue(value="100") int count) {
        SearchPage searchPage = this.searchEngine.search(new SearchRequest(query, tags, categories, roles, apps, page, count));
        searchPage.getResults().forEach(searchResult -> {
            searchResult.getApplication().setLink(uriInfo.getBaseUriBuilder().path("/application/{applicationId}").resolveTemplate("applicationId", (Object)searchResult.getApplication().getApplicationId()).build(new Object[0]).toASCIIString());
            searchResult.getEndpoints().forEach(endpoint -> endpoint.setLink(uriInfo.getBaseUriBuilder().path("/application/{applicationId}/endpoint/{endpointId}").resolveTemplate("applicationId", (Object)endpoint.getApplicationId()).resolveTemplate("endpointId", (Object)endpoint.getEndpointId()).build(new Object[0]).toASCIIString()));
        });
        return searchPage;
    }

    public RegistryResource() {
        this.searchEngine = null;
    }

    @ConstructorProperties(value={"searchEngine"})
    @Inject
    public RegistryResource(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }
}

