/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.OutputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class RDFWriterBuilder {
    private DatasetGraph dataset = null;
    private Graph graph = null;
    private Context context = null;
    private Lang lang = null;
    private RDFFormat format = null;
    private String baseURI = null;

    RDFWriterBuilder() {
    }

    public RDFWriterBuilder source(Graph graph) {
        this.dataset = null;
        this.graph = graph;
        return this;
    }

    public RDFWriterBuilder source(DatasetGraph dataset) {
        this.graph = null;
        this.dataset = dataset;
        return this;
    }

    public RDFWriterBuilder context(Context context) {
        if (context != null) {
            context = context.copy();
        }
        this.context = context;
        return this;
    }

    public RDFWriterBuilder lang(Lang lang) {
        this.format = null;
        this.lang = lang;
        return this;
    }

    public RDFWriterBuilder format(RDFFormat format) {
        this.lang = null;
        this.format = format;
        return this;
    }

    public RDFWriterBuilder base(String baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    public RDFWriterBuilder clone() {
        RDFWriterBuilder clone = new RDFWriterBuilder();
        clone.dataset = this.dataset;
        clone.graph = this.graph;
        clone.context = this.context;
        clone.lang = this.lang;
        clone.format = this.format;
        clone.baseURI = this.baseURI;
        return clone;
    }

    public RDFWriter build() {
        if (this.context == null) {
            this.context = RIOT.getContext().copy();
        }
        if (this.dataset == null && this.graph == null) {
            throw new RiotException("No source to be written");
        }
        return new RDFWriter(this.dataset, this.graph, this.format, this.lang, this.baseURI, this.context);
    }

    public void output(OutputStream outputStream) {
        this.build().output(outputStream);
    }

    public void output(String filename) {
        this.build().output(filename);
    }

    public String asString() {
        return this.build().asString();
    }
}

