/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetChanges;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMonitor;
import org.apache.jena.sparql.core.DatasetGraphTrackActive;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.util.Context;

public class DatasetGraphWithLock
extends DatasetGraphTrackActive
implements Sync {
    private final ThreadLocal<Boolean> writeTxn = ThreadLocal.withInitial(() -> false);
    private final DatasetGraph dsg;
    private final TransactionalLock transactional;
    private final DatasetChanges dsChanges;
    private final boolean abortSupported;

    public DatasetGraphWithLock(DatasetGraph dsg) {
        this(dsg, false);
    }

    public DatasetGraphWithLock(DatasetGraph dsg, boolean abortSupported) {
        this.dsg = dsg;
        this.dsChanges = DatasetGraphWithLock.findDatasetChanges(dsg);
        this.transactional = TransactionalLock.create(dsg.getLock());
        this.abortSupported = abortSupported;
    }

    private static DatasetChanges findDatasetChanges(DatasetGraph dataset) {
        while (!(dataset instanceof DatasetGraphMonitor)) {
            if (!(dataset instanceof DatasetGraphWrapper)) {
                return null;
            }
            dataset = ((DatasetGraphWrapper)dataset).getWrapped();
        }
        return ((DatasetGraphMonitor)dataset).getMonitor();
    }

    @Override
    protected DatasetGraph get() {
        return this.dsg;
    }

    @Override
    protected void checkActive() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction");
        }
    }

    @Override
    protected void checkNotActive() {
        if (this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction");
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.transactional.isInTransaction();
    }

    protected boolean isTransactionType(ReadWrite readWriteType) {
        return this.transactional.isTransactionType(readWriteType);
    }

    @Override
    protected void _begin(ReadWrite readWrite) {
        this.transactional.begin(readWrite);
        this.writeTxn.set(readWrite.equals((Object)ReadWrite.WRITE));
        if (this.dsChanges != null) {
            this.dsChanges.start();
        }
    }

    @Override
    protected void _commit() {
        if (this.writeTxn.get().booleanValue()) {
            this.sync();
        }
        this.transactional.commit();
        this._end();
    }

    @Override
    protected void _abort() {
        if (this.writeTxn.get().booleanValue() && !this.supportsTransactionAbort()) {
            this._end();
            throw new JenaTransactionException("Can't abort a write lock-transaction");
        }
        this.transactional.abort();
        this._end();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return this.abortSupported;
    }

    @Override
    protected void _end() {
        if (this.dsChanges != null) {
            this.dsChanges.finish();
        }
        this.transactional.end();
        this.writeTxn.remove();
    }

    @Override
    protected void _close() {
        if (this.get() != null) {
            this.get().close();
        }
    }

    @Override
    public Context getContext() {
        return this.get().getContext();
    }

    @Override
    public void sync() {
        SystemARQ.sync(this.get());
    }

    @Override
    public String toString() {
        try {
            return this.get().toString();
        }
        catch (Exception ex) {
            return Lib.className((Object)this);
        }
    }
}

