/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.serializer;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.serializer.TriplesListBlock;
import org.apache.jena.vocabulary.RDF;

class FmtEltLib {
    static Node rdfFirst = RDF.Nodes.first;
    static Node rdfRest = RDF.Nodes.rest;
    static Node rdfNil = RDF.Nodes.nil;

    FmtEltLib() {
    }

    static TriplesListBlock createTriplesListBlock(BasicPattern bgp) {
        TriplesListBlock tlb = new TriplesListBlock();
        List<Triple> triples = bgp.getList();
        for (int idx = 0; idx < triples.size(); ++idx) {
            Triple t2;
            Triple t = triples.get(idx);
            if (idx == triples.size() - 1) break;
            if (!FmtEltLib.matches(t, Node.ANY, rdfFirst, Node.ANY)) continue;
            Node consCell = t.getSubject();
            int numTriples = FmtEltLib.collectList(consCell, idx, triples, tlb);
            if (numTriples > 0) {
                idx = idx + numTriples - 1;
                continue;
            }
            ++idx;
            while (idx < triples.size() && !FmtEltLib.matches(t2 = triples.get(idx), Node.ANY, rdfRest, rdfNil)) {
                ++idx;
            }
        }
        return tlb;
    }

    private static Node nullAsAny(Node n) {
        return n == null ? Node.ANY : n;
    }

    static boolean matches(Triple t, Node s, Node p, Node o) {
        s = FmtEltLib.nullAsAny(s);
        p = FmtEltLib.nullAsAny(p);
        o = FmtEltLib.nullAsAny(o);
        if (s != Node.ANY && !Objects.equals(s, t.getSubject())) {
            return false;
        }
        if (p != Node.ANY && !Objects.equals(p, t.getPredicate())) {
            return false;
        }
        return o == Node.ANY || Objects.equals(o, t.getObject());
    }

    static int collectList(Node consCell, int idx, List<Triple> triples, TriplesListBlock tlb) {
        LinkedHashSet<Triple> listTriples = new LinkedHashSet<Triple>();
        TriplesListBlock block1 = FmtEltLib.collectList1(consCell, idx, triples, listTriples, tlb);
        if (block1 == null) {
            return -1;
        }
        int inCount = FmtEltLib.count(triples, Node.ANY, Node.ANY, consCell);
        int outCount = FmtEltLib.count(triples, consCell, Node.ANY, Node.ANY);
        if (inCount == 0 && outCount == 2) {
            return -1;
        }
        int numTriples = block1.triplesInLists.size();
        tlb.merge(block1);
        return numTriples;
    }

    static TriplesListBlock collectList1(Node consCell, int idx, List<Triple> triples, Set<Triple> triplesInList, TriplesListBlock tlb) {
        TriplesListBlock thisList = new TriplesListBlock();
        ArrayList<Node> elts = new ArrayList<Node>();
        thisList.listElementsMap.put(consCell, elts);
        while (idx + 1 < triples.size()) {
            Triple t1 = triples.get(idx);
            consCell = t1.getSubject();
            Triple t2 = triples.get(idx + 1);
            if (!FmtEltLib.matches(t1, consCell, rdfFirst, Node.ANY)) {
                return null;
            }
            boolean ListsInLists = true;
            if (rdfFirst.equals((Object)t2.getPredicate()) && t1.getObject().equals((Object)t2.getSubject())) {
                int numProcessed = FmtEltLib.collectList(t2.getSubject(), idx + 1, triples, thisList);
                if (numProcessed < 0) {
                    return null;
                }
                t2 = triples.get((idx += numProcessed) + 1);
            }
            if (!FmtEltLib.matches(t2, consCell, rdfRest, Node.ANY)) {
                return null;
            }
            int outCount = FmtEltLib.count(triples, consCell, Node.ANY, Node.ANY);
            if (outCount != 2 && outCount == 3 && !elts.isEmpty()) {
                return null;
            }
            int inCount = FmtEltLib.count(triples, Node.ANY, Node.ANY, consCell);
            if (inCount != 1 && outCount == 0 && !elts.isEmpty()) {
                return null;
            }
            Node elt = t1.getObject();
            thisList.triplesInLists.add(t1);
            thisList.triplesInLists.add(t2);
            elts.add(elt);
            if (FmtEltLib.matches(t2, Node.ANY, Node.ANY, rdfNil)) {
                return thisList;
            }
            idx += 2;
        }
        return null;
    }

    static int count(List<Triple> triples, Node s, Node p, Node o) {
        int count = 0;
        for (Triple t : triples) {
            if (!FmtEltLib.matches(t, s, p, o)) continue;
            ++count;
        }
        return count;
    }
}

